/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.CloudConfiguration;
import com.android.tools.idea.run.CloudConfigurationCoordinator;
import com.android.tools.idea.run.CloudConfigurationProvider;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import org.jdesktop.swingx.combobox.ListComboBoxModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.AndroidRunConfigurationBase;
import org.jetbrains.annotations.NotNull;

public class CloudConfigurationComboBox
extends ComboboxWithBrowseButton {
    private final CloudConfiguration.Kind myConfigurationKind;
    private AndroidRunConfigurationBase myCurrentAndroidConfiguration;
    private Module myCurrentModule;
    private AndroidFacet myCurrentFacet;
    private List<? extends CloudConfiguration> myTestingConfigurations;
    private ActionListener myActionListener;
    private final CloudConfigurationProvider myConfigurationProvider;
    private static Map<CloudConfiguration.Kind, CloudConfiguration> myLastChosenCloudConfigurationPerKind = Maps.newHashMapWithExpectedSize((int)5);
    private static Map<AndroidRunConfigurationBase, Map<Pair<CloudConfiguration.Kind, Module>, CloudConfiguration>> myMatrixConfigurationByAndroidConfigurationAndModuleCache = Maps.newHashMapWithExpectedSize((int)5);

    public CloudConfigurationComboBox(@NotNull CloudConfiguration.Kind configurationKind) {
        if (configurationKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationKind", "com/android/tools/idea/run/CloudConfigurationComboBox", "<init>"));
        }
        this.myConfigurationKind = configurationKind;
        this.myConfigurationProvider = CloudConfigurationProvider.getCloudConfigurationProvider();
        this.setMinimumSize(new Dimension(JBUI.scale((int)100), this.getMinimumSize().height));
        this.getComboBox().setRenderer(new TestConfigurationRenderer());
        this.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = CloudConfigurationComboBox.this.getComboBox().getSelectedItem();
                if (item instanceof CloudConfiguration) {
                    CloudConfiguration cloudConfiguration = (CloudConfiguration)item;
                    myLastChosenCloudConfigurationPerKind.put(CloudConfigurationComboBox.this.myConfigurationKind, cloudConfiguration);
                    if (CloudConfigurationComboBox.this.myCurrentAndroidConfiguration != null && CloudConfigurationComboBox.this.myCurrentModule != null) {
                        Map matrixConfigurationByModuleCache = (Map)myMatrixConfigurationByAndroidConfigurationAndModuleCache.get((Object)CloudConfigurationComboBox.this.myCurrentAndroidConfiguration);
                        if (matrixConfigurationByModuleCache == null) {
                            matrixConfigurationByModuleCache = Maps.newHashMapWithExpectedSize((int)5);
                            myMatrixConfigurationByAndroidConfigurationAndModuleCache.put(CloudConfigurationComboBox.this.myCurrentAndroidConfiguration, matrixConfigurationByModuleCache);
                        }
                        matrixConfigurationByModuleCache.put(Pair.create((Object)((Object)CloudConfigurationComboBox.this.myConfigurationKind), (Object)CloudConfigurationComboBox.this.myCurrentModule), cloudConfiguration);
                    }
                }
            }
        });
        CloudConfigurationCoordinator.getInstance(this.myConfigurationKind).addComboBox(this);
    }

    public void setFacet(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/CloudConfigurationComboBox", "setFacet"));
        }
        if (!CloudConfigurationProvider.isEnabled()) {
            return;
        }
        this.myCurrentFacet = facet;
        this.myCurrentModule = this.myCurrentFacet.getModule();
        this.myTestingConfigurations = this.myConfigurationProvider.getCloudConfigurations(this.myCurrentFacet, this.myConfigurationKind);
        this.removeActionListener(this.myActionListener);
        this.myActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudConfiguration selectedConfig = CloudConfigurationComboBox.this.myConfigurationProvider.openMatrixConfigurationDialog(CloudConfigurationComboBox.this.myCurrentFacet, (CloudConfiguration)CloudConfigurationComboBox.this.getComboBox().getSelectedItem(), CloudConfigurationComboBox.this.myConfigurationKind);
                List<? extends CloudConfiguration> cloudConfigurations = CloudConfigurationComboBox.this.myConfigurationProvider.getCloudConfigurations(CloudConfigurationComboBox.this.myCurrentFacet, CloudConfigurationComboBox.this.myConfigurationKind);
                CloudConfigurationCoordinator.getInstance(CloudConfigurationComboBox.this.myConfigurationKind).updateComboBoxesWithNewCloudConfigurations(cloudConfigurations, CloudConfigurationComboBox.this.myCurrentModule);
                if (cloudConfigurations.isEmpty() || selectedConfig != null) {
                    CloudConfigurationComboBox.this.getComboBox().setSelectedItem(selectedConfig);
                }
                CloudConfigurationComboBox.this.getComboBox().updateUI();
            }
        };
        this.addActionListener(this.myActionListener);
        this.updateContent();
    }

    public void setConfiguration(@NotNull AndroidRunConfigurationBase configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/run/CloudConfigurationComboBox", "setConfiguration"));
        }
        this.myCurrentAndroidConfiguration = configuration;
    }

    public void dispose() {
        CloudConfigurationCoordinator.getInstance(this.myConfigurationKind).removeComboBox(this);
        super.dispose();
    }

    public void selectConfiguration(int id) {
        if (this.myTestingConfigurations != null) {
            for (CloudConfiguration cloudConfiguration : this.myTestingConfigurations) {
                if (cloudConfiguration.getId() != id) continue;
                this.getComboBox().setSelectedItem(cloudConfiguration);
                return;
            }
        }
    }

    private void updateContent() {
        if (this.myCurrentModule == null || this.myCurrentModule.isDisposed()) {
            return;
        }
        this.getComboBox().setModel(new ListComboBoxModel(this.myTestingConfigurations));
        if (this.myCurrentAndroidConfiguration == null) {
            CloudConfiguration cloudConfiguration = myLastChosenCloudConfigurationPerKind.get((Object)this.myConfigurationKind);
            if (cloudConfiguration != null && this.myTestingConfigurations.contains(cloudConfiguration)) {
                this.getComboBox().setSelectedItem(cloudConfiguration);
            }
        } else {
            CloudConfiguration selectedConfig;
            Map<Pair<CloudConfiguration.Kind, Module>, CloudConfiguration> matrixConfigurationByModuleCache = myMatrixConfigurationByAndroidConfigurationAndModuleCache.get((Object)this.myCurrentAndroidConfiguration);
            if (matrixConfigurationByModuleCache != null && (selectedConfig = matrixConfigurationByModuleCache.get(Pair.create((Object)((Object)this.myConfigurationKind), (Object)this.myCurrentModule))) != null && this.myTestingConfigurations.contains(selectedConfig)) {
                this.getComboBox().setSelectedItem(selectedConfig);
            }
        }
    }

    public void updateCloudConfigurations(List<? extends CloudConfiguration> cloudConfigurations, Module module) {
        if (this.myCurrentFacet != null && this.myCurrentModule.equals(module)) {
            this.myTestingConfigurations = cloudConfigurations;
            int selectedConfigurationId = -1;
            Object selectedItem = this.getComboBox().getSelectedItem();
            if (selectedItem != null) {
                selectedConfigurationId = ((CloudConfiguration)selectedItem).getId();
            }
            this.updateContent();
            this.selectConfiguration(selectedConfigurationId);
        }
    }

    private static class TestConfigurationRenderer
    extends ColoredListCellRenderer {
        private TestConfigurationRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value == null) {
                this.append("[none]", SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else if (value instanceof CloudConfiguration) {
                CloudConfiguration config = (CloudConfiguration)value;
                this.append(config.getDisplayName(), config.getDeviceConfigurationCount() < 1 ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.setIcon(config.getIcon());
            }
        }
    }
}

