/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.CloudConfiguration;
import com.android.tools.idea.run.CloudConfigurationComboBox;
import com.android.tools.idea.run.CloudConfigurationProvider;
import com.android.tools.idea.run.CloudProjectIdLabel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchCloudDeviceDialog
extends DialogWrapper {
    private final Project myProject;
    private JPanel myPanel;
    private CloudConfigurationComboBox myCloudConfigurationCombo;
    private ActionButton myCloudProjectIdUpdateButton;
    private CloudProjectIdLabel myCloudProjectIdLabel;
    private final CloudConfigurationProvider myCloudConfigurationProvider;

    public LaunchCloudDeviceDialog(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/LaunchCloudDeviceDialog", "<init>"));
        }
        super(facet.getModule().getProject(), true, DialogWrapper.IdeModalityType.PROJECT);
        this.$$$setupUI$$$();
        this.myProject = facet.getModule().getProject();
        this.myCloudConfigurationProvider = CloudConfigurationProvider.getCloudConfigurationProvider();
        this.setTitle("Launch Cloud Device");
        this.init();
        this.myCloudConfigurationCombo.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchCloudDeviceDialog.this.updateOkButton();
            }
        });
        this.myCloudProjectIdLabel.restoreChosenProjectId();
        this.myCloudConfigurationCombo.setFacet(facet);
        this.updateOkButton();
    }

    private void updateOkButton() {
        this.getOKAction().setEnabled(this.isValidGoogleCloudSelection());
    }

    private boolean isValidGoogleCloudSelection() {
        CloudConfiguration selection = (CloudConfiguration)this.myCloudConfigurationCombo.getComboBox().getSelectedItem();
        return selection != null && selection.getDeviceConfigurationCount() > 0 && this.myCloudProjectIdLabel.isProjectSpecified();
    }

    public int getSelectedMatrixConfigurationId() {
        CloudConfiguration selection = (CloudConfiguration)this.myCloudConfigurationCombo.getComboBox().getSelectedItem();
        if (selection == null) {
            return -1;
        }
        return selection.getId();
    }

    public String getChosenCloudProjectId() {
        return this.myCloudProjectIdLabel.getText();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private void createUIComponents() {
        this.myCloudProjectIdLabel = new CloudProjectIdLabel(CloudConfiguration.Kind.SINGLE_DEVICE);
        AnAction action = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                if (LaunchCloudDeviceDialog.this.myCloudConfigurationProvider == null) {
                    return;
                }
                String selectedProjectId = LaunchCloudDeviceDialog.this.myCloudConfigurationProvider.openCloudProjectConfigurationDialog(LaunchCloudDeviceDialog.this.myProject, LaunchCloudDeviceDialog.this.myCloudProjectIdLabel.getText());
                if (selectedProjectId != null) {
                    LaunchCloudDeviceDialog.this.myCloudProjectIdLabel.updateCloudProjectId(selectedProjectId);
                    LaunchCloudDeviceDialog.this.updateOkButton();
                }
            }

            public void update(AnActionEvent event) {
                Presentation presentation = event.getPresentation();
                presentation.setIcon(AllIcons.General.Settings);
            }
        };
        this.myCloudProjectIdUpdateButton = new ActionButton(action, new PresentationFactory().getPresentation(action), "MyPlace", (Dimension)JBUI.size((int)25, (int)25));
        this.myCloudConfigurationCombo = new CloudConfigurationComboBox(CloudConfiguration.Kind.SINGLE_DEVICE);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myCloudConfigurationCombo);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setPreferredSize(new Dimension(500, 75));
        jPanel.setMinimumSize(new Dimension(500, 75));
        JLabel jLabel = new JLabel();
        jLabel.setText("Device Configuration");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        CloudConfigurationComboBox cloudConfigurationComboBox = this.myCloudConfigurationCombo;
        jPanel.add((Component)((Object)cloudConfigurationComboBox), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Google Cloud project:");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1, 5, 5));
        jPanel2.add((Component)jPanel3, "West");
        CloudProjectIdLabel cloudProjectIdLabel = this.myCloudProjectIdLabel;
        Component component = jPanel3.add((Component)((Object)cloudProjectIdLabel));
        ActionButton actionButton = this.myCloudProjectIdUpdateButton;
        Component component2 = jPanel3.add((Component)actionButton);
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

