/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.utils.SdkUtils;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioTemplateLoader
implements TemplateLoader {
    private File myTemplateFolder;

    public StudioTemplateLoader(@NotNull File folder) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/android/tools/idea/templates/StudioTemplateLoader", "<init>"));
        }
        this.myTemplateFolder = folder;
    }

    public void setTemplateFolder(@NotNull File folder) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/android/tools/idea/templates/StudioTemplateLoader", "setTemplateFolder"));
        }
        this.myTemplateFolder = folder;
    }

    @NotNull
    public File getTemplateFolder() {
        File file = this.myTemplateFolder;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/StudioTemplateLoader", "getTemplateFolder"));
        }
        return file;
    }

    @NotNull
    public File getSourceFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/StudioTemplateLoader", "getSourceFile"));
        }
        if (file.isAbsolute()) {
            File file2 = file;
            if (file2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/StudioTemplateLoader", "getSourceFile"));
            }
            return file2;
        }
        file = new File(this.myTemplateFolder, file.getPath());
        File file3 = file.getCanonicalFile();
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/StudioTemplateLoader", "getSourceFile"));
        }
        return file3;
    }

    @NotNull
    public Reader getReader(@NotNull Object templateSource, @NotNull String encoding) throws IOException {
        if (templateSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateSource", "com/android/tools/idea/templates/StudioTemplateLoader", "getReader"));
        }
        if (encoding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "com/android/tools/idea/templates/StudioTemplateLoader", "getReader"));
        }
        InputStream stream = (InputStream)templateSource;
        InputStreamReader inputStreamReader = new InputStreamReader(stream, encoding);
        if (inputStreamReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/StudioTemplateLoader", "getReader"));
        }
        return inputStreamReader;
    }

    public long getLastModified(Object templateSource) {
        return -1L;
    }

    @Nullable
    public Object findTemplateSource(@NotNull String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/templates/StudioTemplateLoader", "findTemplateSource"));
        }
        File file = new File(this.myTemplateFolder, name);
        if (file.exists()) {
            return SdkUtils.fileToUrl((File)file).openStream();
        }
        return null;
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        ((InputStream)templateSource).close();
    }
}

