/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.GradleFileMerger;
import com.android.tools.idea.templates.RecipeMergeUtils;
import com.android.tools.idea.templates.StudioTemplateLoader;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.Recipe;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.NotNull;

public final class RecipeContext {
    private static final Logger LOG = Logger.getInstance(RecipeContext.class);
    private static final String GRADLE_PROJECT_SETTINGS_FILE = "settings.gradle";
    @NotNull
    private final Project myProject;
    @NotNull
    private final StudioTemplateLoader myLoader;
    @NotNull
    private final Configuration myFreemarker;
    @NotNull
    private final Map<String, Object> myParamMap;
    @NotNull
    private final File myOutputRoot;
    @NotNull
    private final File myModuleRoot;
    private final boolean mySyncGradleIfNeeded;
    private boolean myNeedsGradleSync;

    public RecipeContext(@NotNull Project project, @NotNull StudioTemplateLoader loader, @NotNull Configuration freemarker, @NotNull Map<String, Object> paramMap, @NotNull File outputRoot, @NotNull File moduleRoot, boolean syncGradleIfNeeded) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/recipe/RecipeContext", "<init>"));
        }
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "com/android/tools/idea/templates/recipe/RecipeContext", "<init>"));
        }
        if (freemarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "freemarker", "com/android/tools/idea/templates/recipe/RecipeContext", "<init>"));
        }
        if (paramMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramMap", "com/android/tools/idea/templates/recipe/RecipeContext", "<init>"));
        }
        if (outputRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputRoot", "com/android/tools/idea/templates/recipe/RecipeContext", "<init>"));
        }
        if (moduleRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRoot", "com/android/tools/idea/templates/recipe/RecipeContext", "<init>"));
        }
        this.myProject = project;
        this.myLoader = loader;
        this.myFreemarker = freemarker;
        this.myParamMap = paramMap;
        this.myOutputRoot = outputRoot;
        this.myModuleRoot = moduleRoot;
        this.mySyncGradleIfNeeded = syncGradleIfNeeded;
    }

    public RecipeContext(@NotNull Module module, @NotNull StudioTemplateLoader loader, @NotNull Configuration freemarker, @NotNull Map<String, Object> paramMap, boolean syncGradleIfNeeded) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/templates/recipe/RecipeContext", "<init>"));
        }
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "com/android/tools/idea/templates/recipe/RecipeContext", "<init>"));
        }
        if (freemarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "freemarker", "com/android/tools/idea/templates/recipe/RecipeContext", "<init>"));
        }
        if (paramMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramMap", "com/android/tools/idea/templates/recipe/RecipeContext", "<init>"));
        }
        File moduleRoot = new File(module.getModuleFilePath()).getParentFile();
        this.myProject = module.getProject();
        this.myLoader = loader;
        this.myFreemarker = freemarker;
        this.myParamMap = paramMap;
        this.myOutputRoot = moduleRoot;
        this.myModuleRoot = moduleRoot;
        this.mySyncGradleIfNeeded = syncGradleIfNeeded;
    }

    public void addDependency(@NotNull String mavenUrl) {
        if (mavenUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenUrl", "com/android/tools/idea/templates/recipe/RecipeContext", "addDependency"));
        }
        List dependencyList = (List)this.myParamMap.get("dependencyList");
        dependencyList.add(mavenUrl);
    }

    public void copy(@NotNull File from, @NotNull File to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/templates/recipe/RecipeContext", "copy"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/RecipeContext", "copy"));
        }
        try {
            this.copyTemplateResource(from, to);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void instantiate(@NotNull File from, @NotNull File to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/templates/recipe/RecipeContext", "instantiate"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/RecipeContext", "instantiate"));
        }
        try {
            boolean isDirectory;
            boolean bl = isDirectory = from.getName().indexOf(46) == -1;
            if (isDirectory) {
                this.copyTemplateResource(from, to);
            } else {
                String contents = FreemarkerUtils.processFreemarkerTemplate(this.myFreemarker, this.myParamMap, from, null);
                contents = this.format(contents, to);
                File targetFile = this.getTargetFile(to);
                VfsUtil.createDirectories((String)targetFile.getParentFile().getAbsolutePath());
                TemplateUtils.writeFile(this, contents, targetFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (FreemarkerUtils.TemplateProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void merge(@NotNull File from, @NotNull File to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/templates/recipe/RecipeContext", "merge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/RecipeContext", "merge"));
        }
        try {
            String contents;
            String sourceText;
            String targetText = null;
            to = this.getTargetFile(to);
            if (!TemplateUtils.hasExtension(to, ".xml") && !TemplateUtils.hasExtension(to, ".gradle")) {
                throw new RuntimeException("Only XML or Gradle files can be merged at this point: " + to);
            }
            if (to.exists()) {
                targetText = Files.toString((File)to, (Charset)Charsets.UTF_8);
            } else if (to.getParentFile() != null) {
                TemplateUtils.checkedCreateDirectoryIfMissing(to.getParentFile());
            }
            if (targetText == null) {
                boolean instantiate = TemplateUtils.hasExtension(from, ".ftl");
                if (instantiate) {
                    this.instantiate(from, to);
                } else {
                    this.copyTemplateResource(from, to);
                }
                return;
            }
            if (TemplateUtils.hasExtension(from, ".ftl")) {
                sourceText = FreemarkerUtils.processFreemarkerTemplate(this.myFreemarker, this.myParamMap, from, null);
            } else {
                sourceText = TemplateUtils.readTextFile(from = this.myLoader.getSourceFile(from));
                if (sourceText == null) {
                    return;
                }
            }
            if (to.getName().equals(GRADLE_PROJECT_SETTINGS_FILE)) {
                contents = RecipeMergeUtils.mergeGradleSettingsFile(sourceText, targetText);
                this.myNeedsGradleSync = true;
            } else if (to.getName().equals("build.gradle")) {
                String compileSdkVersion = (String)this.myParamMap.get("buildApiString");
                contents = GradleFileMerger.mergeGradleFiles(sourceText, targetText, this.myProject, compileSdkVersion);
                this.myNeedsGradleSync = true;
            } else if (TemplateUtils.hasExtension(to, ".xml")) {
                contents = RecipeMergeUtils.mergeXml(this.myProject, sourceText, targetText, to);
            } else {
                throw new RuntimeException("Only XML or Gradle settings files can be merged at this point: " + to);
            }
            TemplateUtils.writeFile(this, contents, to);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
        catch (FreemarkerUtils.TemplateProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void mkDir(@NotNull File at) {
        if (at == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "at", "com/android/tools/idea/templates/recipe/RecipeContext", "mkDir"));
        }
        try {
            TemplateUtils.checkedCreateDirectoryIfMissing(this.getTargetFile(at));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void open(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/RecipeContext", "open"));
        }
    }

    public void execute(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/RecipeContext", "execute"));
        }
        try {
            FreemarkerUtils.processFreemarkerTemplate(this.myFreemarker, this.myParamMap, file, new FreemarkerUtils.TemplatePostProcessor(){

                @Override
                public void process(@NotNull String xml) throws FreemarkerUtils.TemplateProcessingException {
                    if (xml == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xml", "com/android/tools/idea/templates/recipe/RecipeContext$1", "process"));
                    }
                    try {
                        xml = XmlUtils.stripBom((String)xml);
                        Recipe recipe = Recipe.parse(new StringReader(xml));
                        RecipeContext context = new RecipeContext(RecipeContext.this.myProject, RecipeContext.this.myLoader, RecipeContext.this.myFreemarker, RecipeContext.this.myParamMap, RecipeContext.this.myOutputRoot, RecipeContext.this.myModuleRoot, false);
                        recipe.execute(context);
                    }
                    catch (JAXBException ex) {
                        throw new FreemarkerUtils.TemplateProcessingException((Exception)((Object)ex));
                    }
                }
            });
        }
        catch (FreemarkerUtils.TemplateProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateAndSyncGradle() {
        List dependencyList;
        Object maybeDependencyList;
        if (this.myParamMap.containsKey("dependencyList") && (maybeDependencyList = this.myParamMap.get("dependencyList")) instanceof List && !(dependencyList = (List)maybeDependencyList).isEmpty()) {
            try {
                this.mergeDependenciesIntoGradle();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.myNeedsGradleSync && this.mySyncGradleIfNeeded && !this.myProject.isDefault() && Projects.isBuildWithGradle(this.myProject)) {
            GradleProjectImporter.getInstance().requestProjectSync(this.myProject, null);
        }
    }

    @NotNull
    public File getTargetFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/RecipeContext", "getTargetFile"));
        }
        if (file.isAbsolute()) {
            File file2 = file;
            if (file2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/recipe/RecipeContext", "getTargetFile"));
            }
            return file2;
        }
        File file3 = new File(this.myOutputRoot, file.getPath());
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/recipe/RecipeContext", "getTargetFile"));
        }
        return file3;
    }

    private void mergeDependenciesIntoGradle() throws Exception {
        File gradleBuildFile = GradleUtil.getGradleBuildFilePath(this.myModuleRoot);
        String templateRoot = TemplateManager.getTemplateRootFolder().getPath();
        File gradleTemplate = new File(templateRoot, FileUtil.join((String[])new String[]{"gradle", "utils", "dependencies.gradle.ftl"}));
        String contents = FreemarkerUtils.processFreemarkerTemplate(this.myFreemarker, this.myParamMap, gradleTemplate, null);
        String destinationContents = null;
        if (gradleBuildFile.exists()) {
            destinationContents = TemplateUtils.readTextFile(gradleBuildFile);
        }
        if (destinationContents == null) {
            destinationContents = "";
        }
        String compileSdkVersion = (String)this.myParamMap.get("buildApiString");
        String result = GradleFileMerger.mergeGradleFiles(contents, destinationContents, this.myProject, compileSdkVersion);
        TemplateUtils.writeFile(this, result, gradleBuildFile);
        this.myNeedsGradleSync = true;
    }

    private void copyDirectory(final @NotNull VirtualFile src, final @NotNull VirtualFile dest) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/android/tools/idea/templates/recipe/RecipeContext", "copyDirectory"));
        }
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/templates/recipe/RecipeContext", "copyDirectory"));
        }
        final File destinationFile = VfsUtilCore.virtualToIoFile((VirtualFile)dest);
        VfsUtilCore.visitChildrenRecursively((VirtualFile)src, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/recipe/RecipeContext$2", "visitFile"));
                }
                try {
                    return RecipeContext.this.copyFile(file, src, destinationFile, dest);
                }
                catch (IOException e) {
                    throw new VirtualFileVisitor.VisitorException((Throwable)e);
                }
            }
        }, IOException.class);
    }

    private String format(@NotNull String contents, File to) {
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/android/tools/idea/templates/recipe/RecipeContext", "format"));
        }
        FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(to.getName());
        PsiFile file = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(to.getName(), type, (CharSequence)StringUtil.convertLineSeparators((String)contents));
        CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)file);
        return file.getText();
    }

    private void copyTemplateResource(@NotNull File from, @NotNull File to) throws IOException {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/templates/recipe/RecipeContext", "copyTemplateResource"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/recipe/RecipeContext", "copyTemplateResource"));
        }
        from = this.myLoader.getSourceFile(from);
        to = this.getTargetFile(to);
        VirtualFile sourceFile = VfsUtil.findFileByIoFile((File)from, (boolean)true);
        assert (sourceFile != null) : from;
        sourceFile.refresh(false, false);
        File destPath = from.isDirectory() ? to : to.getParentFile();
        VirtualFile destFolder = TemplateUtils.checkedCreateDirectoryIfMissing(destPath);
        if (from.isDirectory()) {
            this.copyDirectory(sourceFile, destFolder);
        } else {
            Document document = FileDocumentManager.getInstance().getDocument(sourceFile);
            if (document != null) {
                TemplateUtils.writeFile(this, document.getText(), to);
            } else {
                VfsUtilCore.copyFile((Object)this, (VirtualFile)sourceFile, (VirtualFile)destFolder, (String)to.getName());
            }
        }
    }

    private boolean copyFile(VirtualFile file, VirtualFile src, File destinationFile, VirtualFile dest) throws IOException {
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)src, (char)File.separatorChar);
        if (relativePath == null) {
            LOG.error(file.getPath() + " is not a child of " + src, (Throwable)new Exception());
            return false;
        }
        if (file.isDirectory()) {
            TemplateUtils.checkedCreateDirectoryIfMissing(new File(destinationFile, relativePath));
        } else {
            File target;
            VirtualFile targetDir = dest;
            if (relativePath.indexOf(File.separatorChar) > 0) {
                String directories = relativePath.substring(0, relativePath.lastIndexOf(File.separatorChar));
                File newParent = new File(destinationFile, directories);
                targetDir = TemplateUtils.checkedCreateDirectoryIfMissing(newParent);
            }
            if ((target = new File(destinationFile, relativePath)).exists()) {
                LOG.warn("Target file already exists, skipping the copy of: " + target.getPath());
            } else {
                VfsUtilCore.copyFile((Object)this, (VirtualFile)file, (VirtualFile)targetDir);
            }
        }
        return true;
    }
}

