/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.util;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public class GraphicsUtil {
    private static final int BACKGROUND_CELL_SIZE = 4;

    public static void paintCheckeredBackground(Graphics g, Color backgroundColor, Color checkeredColor, Shape clip, int cellSize) {
        Shape savedClip = g.getClip();
        ((Graphics2D)g).clip(clip);
        Rectangle rect = clip.getBounds();
        g.setColor(backgroundColor);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        g.setColor(checkeredColor);
        int dy = 0;
        while (dy * cellSize < rect.height) {
            int dx = dy % 2;
            while (dx * cellSize < rect.width) {
                g.fillRect(rect.x + dx * cellSize, rect.y + dy * cellSize, cellSize, cellSize);
                dx += 2;
            }
            ++dy;
        }
        g.setClip(savedClip);
    }

    public static void paintCheckeredBackground(Graphics g, Shape clip) {
        GraphicsUtil.paintCheckeredBackground(g, Color.LIGHT_GRAY, Color.GRAY, clip, 4);
    }

    public static void drawCenteredString(Graphics g, Rectangle rect, String str, boolean horzCentered, boolean vertCentered) {
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int textWidth = fm.stringWidth(str);
        int x = horzCentered ? Math.max(rect.x, rect.x + (rect.width - textWidth) / 2) : rect.x;
        int y = vertCentered ? Math.max(rect.y, rect.y + rect.height / 2 + fm.getAscent() * 2 / 5) : rect.y;
        g.drawString(str, x, y);
    }

    public static void drawCenteredString(Graphics g, Rectangle rect, String str) {
        GraphicsUtil.drawCenteredString(g, rect, str, true, true);
    }
}

