/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.SdkConstants;
import com.android.builder.model.SourceProvider;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.avdmanager.EmulatorRunner;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.FileResourceRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.ModuleResourceRepository;
import com.android.tools.idea.rendering.ProjectResourceRepository;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.ResourceFolderRegistry;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.android.tools.idea.templates.TemplateManager;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.android.facet.AndroidResourceFilesListener;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.AvdsNotSupportedException;
import org.jetbrains.android.facet.ClassMapConstructor;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.sdk.AvdManagerLog;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidFacet
extends Facet<AndroidFacetConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.facet.AndroidFacet");
    public static final FacetTypeId<AndroidFacet> ID = new FacetTypeId("android");
    public static final String NAME = "Android";
    private static final Object APP_RESOURCES_LOCK = new Object();
    private static final Object PROJECT_RESOURCES_LOCK = new Object();
    private static final Object MODULE_RESOURCES_LOCK = new Object();
    private static boolean ourDynamicTemplateMenuCreated;
    private AvdManager myAvdManager;
    private AndroidSdkData mySdkData;
    private boolean myDataBindingEnabled;
    private SystemResourceManager myPublicSystemResourceManager;
    private SystemResourceManager myFullSystemResourceManager;
    private LocalResourceManager myLocalResourceManager;
    private final Map<String, Map<String, SmartPsiElementPointer<PsiClass>>> myInitialClassMaps;
    private PsiClass myLightRClass;
    private Map<String, CachedValue<Map<String, PsiClass>>> myClassMaps;
    private final Object myClassMapLock;
    private final Set<AndroidAutogeneratorMode> myDirtyModes;
    private final Map<AndroidAutogeneratorMode, Set<String>> myAutogeneratedFiles;
    private volatile boolean myAutogenerationEnabled;
    private ConfigurationManager myConfigurationManager;
    private LocalResourceRepository myModuleResources;
    private AppResourceRepository myAppResources;
    private ProjectResourceRepository myProjectResources;
    private AndroidModel myAndroidModel;
    private final ResourceFolderManager myFolderManager;
    private SourceProvider myMainSourceSet;
    private IdeaSourceProvider myMainIdeaSourceSet;
    private final AndroidModuleInfo myAndroidModuleInfo;
    private RenderService myRenderService;
    private DataBindingUtil.LightBrClass myLightBrClass;

    public AndroidFacet(@NotNull Module module, String name, @NotNull AndroidFacetConfiguration configuration) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/facet/AndroidFacet", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/android/facet/AndroidFacet", "<init>"));
        }
        super((FacetType)AndroidFacet.getFacetType(), module, name, (FacetConfiguration)configuration, null);
        this.myAvdManager = null;
        this.myDataBindingEnabled = false;
        this.myInitialClassMaps = Maps.newHashMap();
        this.myClassMaps = Maps.newHashMap();
        this.myClassMapLock = new Object();
        this.myDirtyModes = EnumSet.noneOf(AndroidAutogeneratorMode.class);
        this.myAutogeneratedFiles = Maps.newHashMap();
        this.myAutogenerationEnabled = false;
        this.myFolderManager = new ResourceFolderManager(this);
        this.myAndroidModuleInfo = AndroidModuleInfo.create(this);
        configuration.setFacet(this);
    }

    public boolean isAutogenerationEnabled() {
        return this.myAutogenerationEnabled;
    }

    public boolean requiresAndroidModel() {
        return !this.getProperties().ALLOW_USER_CONFIGURATION;
    }

    @Nullable
    public AndroidModel getAndroidModel() {
        return this.myAndroidModel;
    }

    public void setAndroidModel(@Nullable AndroidModel androidModel) {
        this.myAndroidModel = androidModel;
        DataBindingUtil.onIdeaProjectSet(this);
    }

    public boolean isLibraryProject() {
        return this.getProperties().LIBRARY_PROJECT;
    }

    public void setLibraryProject(boolean library) {
        this.getProperties().LIBRARY_PROJECT = library;
    }

    @NotNull
    public SourceProvider getMainSourceProvider() {
        if (this.myAndroidModel != null) {
            SourceProvider sourceProvider = this.myAndroidModel.getDefaultSourceProvider();
            if (sourceProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getMainSourceProvider"));
            }
            return sourceProvider;
        }
        if (this.myMainSourceSet == null) {
            this.myMainSourceSet = new LegacySourceProvider();
        }
        SourceProvider sourceProvider = this.myMainSourceSet;
        if (sourceProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getMainSourceProvider"));
        }
        return sourceProvider;
    }

    @NotNull
    public IdeaSourceProvider getMainIdeaSourceProvider() {
        if (!this.requiresAndroidModel()) {
            if (this.myMainIdeaSourceSet == null) {
                this.myMainIdeaSourceSet = IdeaSourceProvider.create(this);
            }
        } else {
            SourceProvider mainSourceSet = this.getMainSourceProvider();
            if (this.myMainIdeaSourceSet == null || mainSourceSet != this.myMainSourceSet) {
                this.myMainIdeaSourceSet = IdeaSourceProvider.create(mainSourceSet);
            }
        }
        IdeaSourceProvider ideaSourceProvider = this.myMainIdeaSourceSet;
        if (ideaSourceProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getMainIdeaSourceProvider"));
        }
        return ideaSourceProvider;
    }

    public ResourceFolderManager getResourceFolderManager() {
        return this.myFolderManager;
    }

    @NotNull
    public List<VirtualFile> getAllResourceDirectories() {
        List<VirtualFile> list = this.myFolderManager.getFolders();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getAllResourceDirectories"));
        }
        return list;
    }

    @Deprecated
    @Nullable
    public VirtualFile getPrimaryResourceDir() {
        List<VirtualFile> dirs = this.getAllResourceDirectories();
        if (!dirs.isEmpty()) {
            return dirs.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGeneratedFileRemoved(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/android/facet/AndroidFacet", "isGeneratedFileRemoved"));
        }
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        synchronized (map) {
            Set<String> filePaths = this.myAutogeneratedFiles.get((Object)mode);
            if (filePaths != null) {
                for (String path : filePaths) {
                    VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
                    if (file != null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAutogeneratedFiles(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/android/facet/AndroidFacet", "clearAutogeneratedFiles"));
        }
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        synchronized (map) {
            Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
            if (set != null) {
                set.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileAutogenerated(@NotNull AndroidAutogeneratorMode mode, @NotNull VirtualFile file) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/android/facet/AndroidFacet", "markFileAutogenerated"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/facet/AndroidFacet", "markFileAutogenerated"));
        }
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        synchronized (map) {
            HashSet set = this.myAutogeneratedFiles.get((Object)mode);
            if (set == null) {
                set = Sets.newHashSet();
                this.myAutogeneratedFiles.put(mode, set);
            }
            set.add(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Set<String> getAutogeneratedFiles(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/android/facet/AndroidFacet", "getAutogeneratedFiles"));
        }
        Map<AndroidAutogeneratorMode, Set<String>> map = this.myAutogeneratedFiles;
        // MONITORENTER : map
        Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
        HashSet hashSet = set != null ? Sets.newHashSet(set) : Collections.emptySet();
        // MONITOREXIT : map
        if (hashSet != null) return hashSet;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getAutogeneratedFiles"));
    }

    private void activateSourceAutogenerating() {
        this.myAutogenerationEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearClassMaps() {
        Object object = this.myClassMapLock;
        synchronized (object) {
            this.myInitialClassMaps.clear();
        }
    }

    public void androidPlatformChanged() {
        this.myAvdManager = null;
        this.myLocalResourceManager = null;
        this.myPublicSystemResourceManager = null;
        this.clearClassMaps();
    }

    @NotNull
    public AvdInfo[] getAllAvds() {
        AvdManager manager = this.getAvdManagerSilently();
        if (manager != null && this.reloadAvds(manager)) {
            AvdInfo[] avdInfoArray = manager.getAllAvds();
            if (avdInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getAllAvds"));
            }
            return avdInfoArray;
        }
        AvdInfo[] avdInfoArray = new AvdInfo[]{};
        if (avdInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getAllAvds"));
        }
        return avdInfoArray;
    }

    private boolean reloadAvds(AvdManager manager) {
        try {
            MessageBuildingSdkLog log = new MessageBuildingSdkLog();
            manager.reloadAvds((ILogger)log);
            if (!log.getErrorMessage().isEmpty()) {
                String message = AndroidBundle.message("cant.load.avds.error.prefix", new Object[0]) + ' ' + log.getErrorMessage();
                Messages.showErrorDialog((Project)this.getModule().getProject(), (String)message, (String)CommonBundle.getErrorTitle());
            }
            return true;
        }
        catch (AndroidLocation.AndroidLocationException e) {
            Messages.showErrorDialog((Project)this.getModule().getProject(), (String)AndroidBundle.message("cant.load.avds.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return false;
        }
    }

    @NotNull
    public AvdInfo[] getValidCompatibleAvds() {
        AvdManager manager = this.getAvdManagerSilently();
        ArrayList result = Lists.newArrayList();
        if (manager != null && this.reloadAvds(manager)) {
            this.addCompatibleAvds(result, manager.getValidAvds());
        }
        AvdInfo[] avdInfoArray = result.toArray(new AvdInfo[result.size()]);
        if (avdInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getValidCompatibleAvds"));
        }
        return avdInfoArray;
    }

    @NotNull
    private AvdInfo[] addCompatibleAvds(@NotNull List<AvdInfo> to, @NotNull AvdInfo[] from) {
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/android/facet/AndroidFacet", "addCompatibleAvds"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/android/facet/AndroidFacet", "addCompatibleAvds"));
        }
        AndroidVersion minSdk = AndroidModuleInfo.get(this).getRuntimeMinSdkVersion();
        AndroidPlatform platform = ((AndroidFacetConfiguration)this.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            LOG.error("Android Platform not set for module: " + this.getModule().getName());
            AvdInfo[] avdInfoArray = new AvdInfo[]{};
            if (avdInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "addCompatibleAvds"));
            }
            return avdInfoArray;
        }
        for (AvdInfo avd : from) {
            IAndroidTarget avdTarget = avd.getTarget();
            if (avdTarget != null && LaunchCompatibility.canRunOnAvd(minSdk, platform.getTarget(), avdTarget).isCompatible() == ThreeState.NO) continue;
            to.add(avd);
        }
        AvdInfo[] avdInfoArray = to.toArray(new AvdInfo[to.size()]);
        if (avdInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "addCompatibleAvds"));
        }
        return avdInfoArray;
    }

    @Nullable
    public AvdManager getAvdManagerSilently() {
        try {
            return this.getAvdManager(new AvdManagerLog());
        }
        catch (AvdsNotSupportedException avdsNotSupportedException) {
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public AvdManager getAvdManager(ILogger log) throws AvdsNotSupportedException, AndroidLocation.AndroidLocationException {
        if (this.myAvdManager == null) {
            AndroidSdkData sdkData = this.getSdkData();
            if (sdkData != null) {
                this.myAvdManager = AvdManager.getInstance((LocalSdk)sdkData.getLocalSdk(), (ILogger)log);
            } else {
                throw new AvdsNotSupportedException();
            }
        }
        AvdManager avdManager = this.myAvdManager;
        if (avdManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getAvdManager"));
        }
        return avdManager;
    }

    @Nullable
    public AndroidSdkData getSdkData() {
        if (this.mySdkData == null) {
            AndroidPlatform platform = ((AndroidFacetConfiguration)this.getConfiguration()).getAndroidPlatform();
            this.mySdkData = platform != null ? platform.getSdkData() : null;
        }
        return this.mySdkData;
    }

    @Nullable
    public IAndroidTarget getTargetFromHashString(@NotNull String hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "org/jetbrains/android/facet/AndroidFacet", "getTargetFromHashString"));
        }
        AndroidSdkData sdkData = this.getSdkData();
        return sdkData != null ? sdkData.getLocalSdk().getTargetFromHashString(hash) : null;
    }

    public void launchEmulator(@Nullable String avdName, @NotNull String commands) {
        if (commands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "org/jetbrains/android/facet/AndroidFacet", "launchEmulator"));
        }
        File sdkLocation = null;
        if (Projects.requiresAndroidModel(this.getModule().getProject()) && AndroidStudioInitializer.isAndroidStudio()) {
            sdkLocation = IdeSdks.getAndroidSdkPath();
        } else {
            AndroidPlatform platform = ((AndroidFacetConfiguration)this.getConfiguration()).getAndroidPlatform();
            if (platform != null) {
                sdkLocation = platform.getSdkData().getLocation();
            }
        }
        if (sdkLocation != null) {
            String[] params;
            File emulatorPath = new File(sdkLocation, AndroidCommonUtils.toolPath((String)SdkConstants.FN_EMULATOR));
            GeneralCommandLine commandLine = new GeneralCommandLine();
            commandLine.setExePath(emulatorPath.getPath());
            if (avdName != null) {
                commandLine.addParameter("-avd");
                commandLine.addParameter(avdName);
            }
            for (String s : params = ParametersList.parse((String)commands)) {
                if (s.isEmpty()) continue;
                commandLine.addParameter(s);
            }
            AvdManager manager = this.getAvdManagerSilently();
            AvdInfo info = manager == null ? null : manager.getAvd(avdName, true);
            final EmulatorRunner runner = new EmulatorRunner(this.getModule().getProject(), "AVD: " + avdName, commandLine, info);
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        runner.start();
                    }
                    catch (ExecutionException e) {
                        Logger.getInstance(this.getClass()).error("Unexpected error while launching AVD", (Throwable)e);
                    }
                }
            });
        }
    }

    public static void createDynamicTemplateMenu() {
        if (ourDynamicTemplateMenuCreated) {
            return;
        }
        ourDynamicTemplateMenuCreated = true;
        DefaultActionGroup newGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("NewGroup");
        newGroup.addSeparator();
        ActionGroup menu = TemplateManager.getInstance().getTemplateCreationMenu(null);
        if (menu != null) {
            newGroup.add((AnAction)menu, new Constraints(Anchor.AFTER, "NewFromTemplate"));
        }
    }

    public void initFacet() {
        StartupManager.getInstance((Project)this.getModule().getProject()).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                AndroidResourceFilesListener.notifyFacetInitialized(AndroidFacet.this);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    return;
                }
                AndroidFacet.this.addResourceFolderToSdkRootsIfNecessary();
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        Module module = AndroidFacet.this.getModule();
                        Project project = module.getProject();
                        if (project.isDisposed()) {
                            return;
                        }
                        AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.AAPT);
                        AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.AIDL);
                        AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.RENDERSCRIPT);
                        AndroidCompileUtil.generate(module, AndroidAutogeneratorMode.BUILDCONFIG);
                        AndroidFacet.this.activateSourceAutogenerating();
                    }
                });
            }
        });
        this.getModule().getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){
            private Sdk myPrevSdk;

            public void rootsChanged(ModuleRootEvent event) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (AndroidFacet.this.isDisposed()) {
                            return;
                        }
                        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)AndroidFacet.this.getModule());
                        Sdk newSdk = rootManager.getSdk();
                        if (newSdk != null && newSdk.getSdkType() instanceof AndroidSdkType && !newSdk.equals(myPrevSdk)) {
                            AndroidFacet.this.androidPlatformChanged();
                            Set set = AndroidFacet.this.myDirtyModes;
                            synchronized (set) {
                                AndroidFacet.this.myDirtyModes.addAll(Arrays.asList(AndroidAutogeneratorMode.values()));
                            }
                        } else {
                            AndroidFacet.this.clearClassMaps();
                        }
                        myPrevSdk = newSdk;
                    }
                });
            }
        });
        AndroidFacet.createDynamicTemplateMenu();
    }

    private void addResourceFolderToSdkRootsIfNecessary() {
        Sdk sdk = ModuleRootManager.getInstance((Module)this.getModule()).getSdk();
        if (sdk == null || !AndroidSdkUtils.isAndroidSdk(sdk)) {
            return;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(sdk);
        if (platform == null) {
            return;
        }
        String resFolderPath = platform.getTarget().getPath(11);
        if (resFolderPath == null) {
            return;
        }
        ArrayList filesToAdd = Lists.newArrayList();
        VirtualFile resFolder = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)resFolderPath));
        if (resFolder != null) {
            filesToAdd.add(resFolder);
        }
        if (platform.needToAddAnnotationsJarToClasspath()) {
            String sdkHomePath = FileUtil.toSystemIndependentName((String)platform.getSdkData().getLocation().getPath());
            VirtualFile annotationsJar = JarFileSystem.getInstance().findFileByPath(sdkHomePath + "/tools/support/annotations.jar" + "!/");
            if (annotationsJar != null) {
                filesToAdd.add(annotationsJar);
            }
        }
        AndroidFacet.addFilesToSdkIfNecessary(sdk, filesToAdd);
    }

    private static void addFilesToSdkIfNecessary(@NotNull Sdk sdk, @NotNull Collection<VirtualFile> files) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/android/facet/AndroidFacet", "addFilesToSdkIfNecessary"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/android/facet/AndroidFacet", "addFilesToSdkIfNecessary"));
        }
        ArrayList newFiles = Lists.newArrayList(files);
        newFiles.removeAll(Arrays.asList(sdk.getRootProvider().getFiles(OrderRootType.CLASSES)));
        if (newFiles.size() > 0) {
            SdkModificator modificator = sdk.getSdkModificator();
            for (VirtualFile file : newFiles) {
                modificator.addRoot(file, OrderRootType.CLASSES);
            }
            modificator.commitChanges();
        }
    }

    public void disposeFacet() {
        if (this.myConfigurationManager != null) {
            Disposer.dispose((Disposable)this.myConfigurationManager);
        }
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/facet/AndroidFacet", "getInstance"));
        }
        return (AndroidFacet)FacetManager.getInstance((Module)module).getFacetByType(ID);
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull ConvertContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/facet/AndroidFacet", "getInstance"));
        }
        Module module = context.getModule();
        return module != null ? AndroidFacet.getInstance(module) : null;
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/facet/AndroidFacet", "getInstance"));
        }
        Module module = AndroidPsiUtils.getModuleSafely(element);
        return module != null && !module.isDisposed() ? AndroidFacet.getInstance(module) : null;
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/facet/AndroidFacet", "getInstance"));
        }
        Module module = element.getModule();
        return module != null ? AndroidFacet.getInstance(module) : null;
    }

    @Nullable
    public ResourceManager getResourceManager(@Nullable String resourcePackage) {
        return this.getResourceManager(resourcePackage, null);
    }

    @Nullable
    public ResourceManager getResourceManager(@Nullable String resourcePackage, @Nullable PsiElement contextElement) {
        if ("android".equals(resourcePackage)) {
            return this.getSystemResourceManager();
        }
        if (contextElement != null && AndroidFacet.isInAndroidSdk(contextElement)) {
            return this.getSystemResourceManager();
        }
        return this.getLocalResourceManager();
    }

    private static boolean isInAndroidSdk(PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        List entries = projectFileIndex.getOrderEntriesForFile(virtualFile);
        for (OrderEntry entry : entries) {
            Sdk sdk;
            if (!(entry instanceof JdkOrderEntry) || (sdk = ((JdkOrderEntry)entry).getJdk()) == null || !(sdk.getSdkType() instanceof AndroidSdkType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public LocalResourceManager getLocalResourceManager() {
        if (this.myLocalResourceManager == null) {
            this.myLocalResourceManager = new LocalResourceManager(this);
        }
        LocalResourceManager localResourceManager = this.myLocalResourceManager;
        if (localResourceManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getLocalResourceManager"));
        }
        return localResourceManager;
    }

    @Nullable
    public SystemResourceManager getSystemResourceManager() {
        return this.getSystemResourceManager(true);
    }

    @Nullable
    public SystemResourceManager getSystemResourceManager(boolean publicOnly) {
        AndroidPlatform platform;
        if (publicOnly) {
            AndroidPlatform platform2;
            if (this.myPublicSystemResourceManager == null && (platform2 = ((AndroidFacetConfiguration)this.getConfiguration()).getAndroidPlatform()) != null) {
                this.myPublicSystemResourceManager = new SystemResourceManager(this.getModule().getProject(), platform2, true);
            }
            return this.myPublicSystemResourceManager;
        }
        if (this.myFullSystemResourceManager == null && (platform = ((AndroidFacetConfiguration)this.getConfiguration()).getAndroidPlatform()) != null) {
            this.myFullSystemResourceManager = new SystemResourceManager(this.getModule().getProject(), platform, false);
        }
        return this.myFullSystemResourceManager;
    }

    @Nullable
    public Manifest getManifest() {
        VirtualFile manifestFile = this.getMainIdeaSourceProvider().getManifestFile();
        return manifestFile != null ? AndroidUtils.loadDomElement(this.getModule(), manifestFile, Manifest.class) : null;
    }

    @NotNull
    public static AndroidFacetType getFacetType() {
        AndroidFacetType androidFacetType = (AndroidFacetType)FacetTypeRegistry.getInstance().findFacetType(ID);
        if (androidFacetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getFacetType"));
        }
        return androidFacetType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Map<String, PsiClass> getClassMap(final @NotNull String className, final @NotNull ClassMapConstructor constructor) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/android/facet/AndroidFacet", "getClassMap"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/android/facet/AndroidFacet", "getClassMap"));
        }
        Object object = this.myClassMapLock;
        // MONITORENTER : object
        CachedValue value = this.myClassMaps.get(className);
        if (value == null) {
            value = CachedValuesManager.getManager((Project)this.getModule().getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, PsiClass>>(){

                @Nullable
                public CachedValueProvider.Result<Map<String, PsiClass>> compute() {
                    Map map = AndroidFacet.this.computeClassMap(className, constructor);
                    return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
                }
            }, false);
            this.myClassMaps.put(className, (CachedValue<Map<String, PsiClass>>)value);
        }
        Map map = (Map)value.getValue();
        // MONITOREXIT : object
        if (map != null) return map;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getClassMap"));
    }

    @NotNull
    private Map<String, PsiClass> computeClassMap(@NotNull String className, @NotNull ClassMapConstructor constructor) {
        PsiClass aClass;
        SmartPsiElementPointer<PsiClass> pointer;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/android/facet/AndroidFacet", "computeClassMap"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/android/facet/AndroidFacet", "computeClassMap"));
        }
        Map<String, SmartPsiElementPointer<PsiClass>> classMap = this.getInitialClassMap(className, constructor, false);
        HashMap result = Maps.newHashMap();
        boolean shouldRebuildInitialMap = false;
        for (String key : classMap.keySet()) {
            pointer = classMap.get(key);
            if (!AndroidFacet.isUpToDate(pointer, key, constructor)) {
                shouldRebuildInitialMap = true;
                break;
            }
            aClass = (PsiClass)pointer.getElement();
            if (aClass == null) continue;
            result.put(key, aClass);
        }
        if (shouldRebuildInitialMap) {
            result.clear();
            classMap = this.getInitialClassMap(className, constructor, true);
            for (String key : classMap.keySet()) {
                pointer = classMap.get(key);
                aClass = (PsiClass)pointer.getElement();
                if (aClass == null) continue;
                result.put(key, aClass);
            }
        }
        Project project = this.getModule().getProject();
        this.fillMap(className, constructor, ProjectScope.getProjectScope((Project)project), result, false);
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "computeClassMap"));
        }
        return hashMap;
    }

    private static boolean isUpToDate(SmartPsiElementPointer<PsiClass> pointer, String tagName, ClassMapConstructor constructor) {
        PsiClass aClass = (PsiClass)pointer.getElement();
        if (aClass == null) {
            return false;
        }
        Object[] tagNames = constructor.getTagNamesByClass(aClass);
        return ArrayUtilRt.find((Object[])tagNames, (Object)tagName) >= 0;
    }

    @NotNull
    private Map<String, SmartPsiElementPointer<PsiClass>> getInitialClassMap(@NotNull String className, @NotNull ClassMapConstructor constructor, boolean forceRebuild) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/android/facet/AndroidFacet", "getInitialClassMap"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/android/facet/AndroidFacet", "getInitialClassMap"));
        }
        HashMap viewClassMap = this.myInitialClassMaps.get(className);
        if (viewClassMap != null && !forceRebuild) {
            HashMap hashMap = viewClassMap;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getInitialClassMap"));
            }
            return hashMap;
        }
        HashMap map = Maps.newHashMap();
        if (this.fillMap(className, constructor, this.getModule().getModuleWithDependenciesAndLibrariesScope(true), map, true)) {
            viewClassMap = Maps.newHashMapWithExpectedSize((int)map.size());
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.getModule().getProject());
            for (Map.Entry entry : map.entrySet()) {
                viewClassMap.put(entry.getKey(), manager.createSmartPsiElementPointer((PsiElement)entry.getValue()));
            }
            this.myInitialClassMaps.put(className, viewClassMap);
        }
        Map map2 = viewClassMap != null ? viewClassMap : Collections.emptyMap();
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getInitialClassMap"));
        }
        return map2;
    }

    private boolean fillMap(final @NotNull String className, final @NotNull ClassMapConstructor constructor, @NotNull GlobalSearchScope scope, final Map<String, PsiClass> map, final boolean libClassesOnly) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/android/facet/AndroidFacet", "fillMap"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/android/facet/AndroidFacet", "fillMap"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/android/facet/AndroidFacet", "fillMap"));
        }
        final JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getModule().getProject());
        PsiClass baseClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            @Nullable
            public PsiClass compute() {
                PsiClass aClass;
                try {
                    aClass = facade.findClass(className, AndroidFacet.this.getModule().getModuleWithDependenciesAndLibrariesScope(true));
                }
                catch (IndexNotReadyException e) {
                    aClass = null;
                }
                return aClass;
            }
        });
        if (baseClass != null) {
            String[] baseClassTagNames;
            for (String tagName : baseClassTagNames = constructor.getTagNamesByClass(baseClass)) {
                map.put(tagName, baseClass);
            }
            try {
                ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)scope, (boolean)true).forEach((Processor)new Processor<PsiClass>(){

                    public boolean process(PsiClass c) {
                        String[] tagNames;
                        if (libClassesOnly && c.getManager().isInProject((PsiElement)c)) {
                            return true;
                        }
                        for (String tagName : tagNames = constructor.getTagNamesByClass(c)) {
                            map.put(tagName, c);
                        }
                        return true;
                    }
                });
            }
            catch (IndexNotReadyException e) {
                LOG.info((Throwable)e);
                return false;
            }
        }
        return map.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSourceRegenerating(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/android/facet/AndroidFacet", "scheduleSourceRegenerating"));
        }
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            this.myDirtyModes.add(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanRegeneratingState(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/android/facet/AndroidFacet", "cleanRegeneratingState"));
        }
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            return this.myDirtyModes.remove((Object)mode);
        }
    }

    @NotNull
    public ConfigurationManager getConfigurationManager() {
        ConfigurationManager configurationManager = this.getConfigurationManager(true);
        if (configurationManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getConfigurationManager"));
        }
        return configurationManager;
    }

    @Contract(value="true -> !null")
    @Nullable
    public ConfigurationManager getConfigurationManager(boolean createIfNecessary) {
        if (this.myConfigurationManager == null && createIfNecessary) {
            this.myConfigurationManager = ConfigurationManager.create(this.getModule());
            Disposer.register((Disposable)this, (Disposable)this.myConfigurationManager);
        }
        return this.myConfigurationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    @Nullable
    public AppResourceRepository getAppResources(boolean createIfNecessary) {
        Object object = APP_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myAppResources == null && createIfNecessary) {
                this.myAppResources = AppResourceRepository.create(this);
            }
            return this.myAppResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    @Nullable
    public ProjectResourceRepository getProjectResources(boolean createIfNecessary) {
        Object object = PROJECT_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myProjectResources == null && createIfNecessary) {
                this.myProjectResources = ProjectResourceRepository.create(this);
            }
            return this.myProjectResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    @Nullable
    public LocalResourceRepository getModuleResources(boolean createIfNecessary) {
        Object object = MODULE_RESOURCES_LOCK;
        synchronized (object) {
            if (this.myModuleResources == null && createIfNecessary) {
                this.myModuleResources = ModuleResourceRepository.create(this);
            }
            return this.myModuleResources;
        }
    }

    public void refreshResources() {
        this.myModuleResources = null;
        this.myProjectResources = null;
        this.myAppResources = null;
        this.myConfigurationManager.getResolverCache().reset();
        ResourceFolderRegistry.reset();
        FileResourceRepository.reset();
    }

    @NotNull
    public JpsAndroidModuleProperties getProperties() {
        JpsAndroidModuleProperties state = ((AndroidFacetConfiguration)this.getConfiguration()).getState();
        assert (state != null);
        JpsAndroidModuleProperties jpsAndroidModuleProperties = state;
        if (jpsAndroidModuleProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getProperties"));
        }
        return jpsAndroidModuleProperties;
    }

    public boolean isDataBindingEnabled() {
        return this.myDataBindingEnabled;
    }

    public void setDataBindingEnabled(boolean dataBindingEnabled) {
        this.myDataBindingEnabled = dataBindingEnabled;
    }

    public void addListener(@NotNull GradleSyncListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/android/facet/AndroidFacet", "addListener"));
        }
        Module module = this.getModule();
        GradleSyncState.subscribe(module.getProject(), listener);
    }

    @Nullable
    public PsiClass getLightRClass() {
        return this.myLightRClass;
    }

    public void setLightRClass(@NotNull PsiClass rClass) {
        if (rClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rClass", "org/jetbrains/android/facet/AndroidFacet", "setLightRClass"));
        }
        this.myLightRClass = rClass;
    }

    @NotNull
    public AndroidModuleInfo getAndroidModuleInfo() {
        AndroidModuleInfo androidModuleInfo = this.myAndroidModuleInfo;
        if (androidModuleInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getAndroidModuleInfo"));
        }
        return androidModuleInfo;
    }

    @NotNull
    public RenderService getRenderService() {
        if (this.myRenderService == null) {
            this.myRenderService = new RenderService(this);
        }
        RenderService renderService = this.myRenderService;
        if (renderService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidFacet", "getRenderService"));
        }
        return renderService;
    }

    public void setLightBrClass(DataBindingUtil.LightBrClass lightBrClass) {
        this.myLightBrClass = lightBrClass;
    }

    public DataBindingUtil.LightBrClass getLightBrClass() {
        return this.myLightBrClass;
    }

    private class LegacySourceProvider
    implements SourceProvider {
        private LegacySourceProvider() {
        }

        public String getName() {
            return "main";
        }

        public File getManifestFile() {
            Module module = AndroidFacet.this.getModule();
            VirtualFile manifestFile = AndroidRootUtil.getFileByRelativeModulePath(module, AndroidFacet.this.getProperties().MANIFEST_FILE_RELATIVE_PATH, true);
            if (manifestFile == null) {
                VirtualFile root;
                VirtualFile virtualFile = root = !AndroidFacet.this.requiresAndroidModel() ? AndroidRootUtil.getMainContentRoot(AndroidFacet.this) : null;
                if (root != null) {
                    return new File(VfsUtilCore.virtualToIoFile((VirtualFile)root), "AndroidManifest.xml");
                }
                return new File("AndroidManifest.xml");
            }
            return VfsUtilCore.virtualToIoFile((VirtualFile)manifestFile);
        }

        public Set<File> getJavaDirectories() {
            HashSet dirs = Sets.newHashSet();
            Module module = AndroidFacet.this.getModule();
            VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (contentRoots.length != 0) {
                for (VirtualFile root : contentRoots) {
                    dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)root));
                }
            }
            return dirs;
        }

        public Set<File> getResourcesDirectories() {
            return Collections.emptySet();
        }

        public Set<File> getAidlDirectories() {
            VirtualFile dir = AndroidRootUtil.getAidlGenDir(AndroidFacet.this);
            return dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
        }

        public Set<File> getRenderscriptDirectories() {
            VirtualFile dir = AndroidRootUtil.getRenderscriptGenDir(AndroidFacet.this);
            return dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
        }

        public Set<File> getResDirectories() {
            String resRelPath = AndroidFacet.this.getProperties().RES_FOLDER_RELATIVE_PATH;
            VirtualFile dir = AndroidRootUtil.getFileByRelativeModulePath(AndroidFacet.this.getModule(), resRelPath, true);
            return dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
        }

        public Set<File> getAssetsDirectories() {
            VirtualFile dir = AndroidRootUtil.getAssetsDir(AndroidFacet.this);
            return dir == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)dir));
        }

        public Collection<File> getJniLibsDirectories() {
            return Collections.emptyList();
        }

        public Collection<File> getCDirectories() {
            return Collections.emptyList();
        }

        public Collection<File> getCppDirectories() {
            return Collections.emptyList();
        }
    }
}

