/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.model.ManifestInfo;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.ActivityLocator;
import org.jetbrains.android.run.AndroidActivityLauncher;
import org.jetbrains.android.run.AndroidRunConfigurationBase;
import org.jetbrains.android.run.AndroidRunConfigurationEditor;
import org.jetbrains.android.run.AndroidRunningState;
import org.jetbrains.android.run.ApkProvider;
import org.jetbrains.android.run.ApplicationRunParameters;
import org.jetbrains.android.run.DefaultActivityLocator;
import org.jetbrains.android.run.EmptyActivityLocator;
import org.jetbrains.android.run.GradleApkProvider;
import org.jetbrains.android.run.MavenDefaultActivityLocator;
import org.jetbrains.android.run.NonGradleApkProvider;
import org.jetbrains.android.run.SpecificActivityLocator;
import org.jetbrains.android.run.TargetSelectionMode;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunConfiguration
extends AndroidRunConfigurationBase
implements RefactoringListenerProvider {
    @NonNls
    public static final String LAUNCH_DEFAULT_ACTIVITY = "default_activity";
    @NonNls
    public static final String LAUNCH_SPECIFIC_ACTIVITY = "specific_activity";
    @NonNls
    public static final String DO_NOTHING = "do_nothing";
    public String ACTIVITY_CLASS = "";
    public String ACTIVITY_EXTRA_FLAGS = "";
    public String MODE = "default_activity";
    public boolean DEPLOY = true;
    public String ARTIFACT_NAME = "";

    public AndroidRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
    }

    @Override
    protected Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/run/AndroidRunConfiguration", "supportsRunningLibraryProjects"));
        }
        return Pair.create((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
    }

    @Override
    protected void checkConfiguration(@NotNull AndroidFacet facet) throws RuntimeConfigurationException {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/run/AndroidRunConfiguration", "checkConfiguration"));
        }
        if (this.getTargetSelectionMode() == TargetSelectionMode.CLOUD_DEVICE_LAUNCH && !this.IS_VALID_CLOUD_DEVICE_SELECTION) {
            throw new RuntimeConfigurationError(this.INVALID_CLOUD_DEVICE_SELECTION_ERROR);
        }
        this.getApplicationLauncher(facet).checkConfiguration();
    }

    @Override
    public AndroidRunningState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/android/run/AndroidRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/android/run/AndroidRunConfiguration", "getState"));
        }
        AndroidRunningState state = super.getState(executor, env);
        if (state != null) {
            state.setDeploy(this.DEPLOY);
            state.setOpenLogcatAutomatically(this.SHOW_LOGCAT_AUTOMATICALLY);
        }
        return state;
    }

    @Override
    @NotNull
    protected ApkProvider getApkProvider() {
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        assert (module != null);
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        if (facet.getAndroidModel() != null && facet.getAndroidModel() instanceof AndroidGradleModel) {
            GradleApkProvider gradleApkProvider = new GradleApkProvider(facet, false);
            if (gradleApkProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunConfiguration", "getApkProvider"));
            }
            return gradleApkProvider;
        }
        NonGradleApkProvider nonGradleApkProvider = new NonGradleApkProvider(facet, this.ARTIFACT_NAME);
        if (nonGradleApkProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunConfiguration", "getApkProvider"));
        }
        return nonGradleApkProvider;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        AndroidRunConfigurationEditor editor = new AndroidRunConfigurationEditor(project, (Predicate<AndroidFacet>)Predicates.alwaysFalse());
        editor.setConfigurationSpecificEditor(new ApplicationRunParameters(project, editor.getModuleSelector()));
        AndroidRunConfigurationEditor androidRunConfigurationEditor = editor;
        if (androidRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunConfiguration", "getConfigurationEditor"));
        }
        return androidRunConfigurationEditor;
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        return RefactoringListeners.getClassOrPackageListener((PsiElement)element, (RefactoringListeners.Accessor)new RefactoringListeners.Accessor<PsiClass>(){

            public void setName(String qualifiedName) {
                AndroidRunConfiguration.this.ACTIVITY_CLASS = qualifiedName;
            }

            @Nullable
            public PsiClass getPsiElement() {
                return ((JavaRunConfigurationModule)AndroidRunConfiguration.this.getConfigurationModule()).findClass(AndroidRunConfiguration.this.ACTIVITY_CLASS);
            }

            public void setPsiElement(PsiClass psiClass) {
                AndroidRunConfiguration.this.ACTIVITY_CLASS = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass);
            }
        });
    }

    @Override
    @NotNull
    protected ConsoleView attachConsole(AndroidRunningState state, Executor executor) {
        Project project = ((JavaRunConfigurationModule)this.getConfigurationModule()).getProject();
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        ConsoleView console = builder.getConsole();
        console.attachToProcess(state.getProcessHandler());
        ConsoleView consoleView = console;
        if (consoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunConfiguration", "attachConsole"));
        }
        return consoleView;
    }

    @Override
    protected boolean supportMultipleDevices() {
        return true;
    }

    @Override
    @NotNull
    protected AndroidActivityLauncher getApplicationLauncher(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/run/AndroidRunConfiguration", "getApplicationLauncher"));
        }
        AndroidActivityLauncher androidActivityLauncher = new AndroidActivityLauncher(facet, this.needsLaunch(), this.getActivityLocator(facet), this.ACTIVITY_EXTRA_FLAGS);
        if (androidActivityLauncher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunConfiguration", "getApplicationLauncher"));
        }
        return androidActivityLauncher;
    }

    @NotNull
    protected ActivityLocator getActivityLocator(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/run/AndroidRunConfiguration", "getActivityLocator"));
        }
        if (this.MODE.equals(LAUNCH_DEFAULT_ACTIVITY)) {
            if (facet.getProperties().USE_CUSTOM_COMPILER_MANIFEST) {
                MavenDefaultActivityLocator mavenDefaultActivityLocator = new MavenDefaultActivityLocator(facet);
                if (mavenDefaultActivityLocator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunConfiguration", "getActivityLocator"));
                }
                return mavenDefaultActivityLocator;
            }
            DefaultActivityLocator defaultActivityLocator = new DefaultActivityLocator(facet);
            if (defaultActivityLocator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunConfiguration", "getActivityLocator"));
            }
            return defaultActivityLocator;
        }
        if (this.MODE.equals(LAUNCH_SPECIFIC_ACTIVITY)) {
            SpecificActivityLocator specificActivityLocator = new SpecificActivityLocator(facet, this.ACTIVITY_CLASS);
            if (specificActivityLocator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunConfiguration", "getActivityLocator"));
            }
            return specificActivityLocator;
        }
        EmptyActivityLocator emptyActivityLocator = new EmptyActivityLocator();
        if (emptyActivityLocator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunConfiguration", "getActivityLocator"));
        }
        return emptyActivityLocator;
    }

    protected boolean needsLaunch() {
        return LAUNCH_SPECIFIC_ACTIVITY.equals(this.MODE) || LAUNCH_DEFAULT_ACTIVITY.equals(this.MODE);
    }

    public static boolean isWatchFaceApp(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/run/AndroidRunConfiguration", "isWatchFaceApp"));
        }
        ManifestInfo info = ManifestInfo.get(facet.getModule(), true);
        if (!info.getActivities().isEmpty()) {
            return false;
        }
        final List<Service> services = info.getServices();
        if (services.size() != 1) {
            return false;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                List<IntentFilter> filters = ((Service)services.get(0)).getIntentFilters();
                return filters.size() == 1 && AndroidDomUtil.containsAction(filters.get(0), "android.service.wallpaper.WallpaperService") && AndroidDomUtil.containsCategory(filters.get(0), "com.google.android.wearable.watchface.category.WATCH_FACE");
            }
        });
    }
}

