/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.ddms.DevicePanel;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.ddms.adb.AdbService;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.service.notification.hyperlink.SyncProjectHyperlink;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.monitor.AndroidToolWindowFactory;
import com.android.tools.idea.run.CloudConfiguration;
import com.android.tools.idea.run.CloudConfigurationProvider;
import com.android.tools.idea.run.CloudDebuggingTargetChooser;
import com.android.tools.idea.run.CloudTargetChooser;
import com.android.tools.idea.run.InstalledApks;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.stats.UsageTracker;
import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.intellij.CommonBundle;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AvdsNotSupportedException;
import org.jetbrains.android.run.AndroidApplicationLauncher;
import org.jetbrains.android.run.AndroidExecutionState;
import org.jetbrains.android.run.AndroidProcessText;
import org.jetbrains.android.run.AndroidRunConfigurationBase;
import org.jetbrains.android.run.AndroidRunningStateListener;
import org.jetbrains.android.run.ApkInfo;
import org.jetbrains.android.run.ApkProvider;
import org.jetbrains.android.run.ApkProvisionException;
import org.jetbrains.android.run.CreateAvdDialog;
import org.jetbrains.android.run.DebugLauncher;
import org.jetbrains.android.run.DeviceChooser;
import org.jetbrains.android.run.DeviceChooserDialog;
import org.jetbrains.android.run.DeviceReadyListener;
import org.jetbrains.android.run.DeviceStateAtLaunch;
import org.jetbrains.android.run.EmulatorTargetChooser;
import org.jetbrains.android.run.ExtendedDeviceChooserDialog;
import org.jetbrains.android.run.ManualTargetChooser;
import org.jetbrains.android.run.ProcessHandlerSimpleLogger;
import org.jetbrains.android.run.TargetChooser;
import org.jetbrains.android.run.UsbDeviceTargetChooser;
import org.jetbrains.android.run.testing.AndroidTestRunConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.sdk.AvdManagerLog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunningState
implements RunProfileState,
AndroidDebugBridge.IClientChangeListener,
AndroidExecutionState {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.run.AndroidRunningState");
    @NonNls
    private static final String ANDROID_TARGET_DEVICES_PROPERTY = "AndroidTargetDevices";
    private static final IDevice[] EMPTY_DEVICE_ARRAY = new IDevice[0];
    public static final int WAITING_TIME_SECS = 20;
    private static final Pattern FAILURE = Pattern.compile("Failure\\s+\\[(.*)\\]");
    private static final Pattern TYPED_ERROR = Pattern.compile("Error\\s+[Tt]ype\\s+(\\d+).*");
    private static final String ERROR_PREFIX = "Error";
    public static final int NO_ERROR = -2;
    public static final int UNTYPED_ERROR = -1;
    private final ApkProvider myApkProvider;
    private String myTargetPackageName;
    private final AndroidFacet myFacet;
    private final String myCommandLine;
    private final AndroidApplicationLauncher myApplicationLauncher;
    private final AndroidRunConfigurationBase myConfiguration;
    private final Object myDebugLock;
    @NotNull
    private volatile IDevice[] myTargetDevices;
    private volatile String myAvdName;
    private volatile boolean myDebugMode;
    private volatile boolean myOpenLogcatAutomatically;
    private volatile DebugLauncher myDebugLauncher;
    private final ExecutionEnvironment myEnv;
    private volatile boolean myStopped;
    private volatile ProcessHandler myProcessHandler;
    private final Object myLock;
    private volatile boolean myDeploy;
    private volatile boolean myApplicationDeployed;
    private ConsoleView myConsole;
    private TargetChooser myTargetChooser;
    private final boolean mySupportMultipleDevices;
    private final boolean myClearLogcatBeforeStart;
    private final List<AndroidRunningStateListener> myListeners;
    private final boolean myNonDebuggableOnDevice;
    private static int ourInstallationCount = 0;

    public void setDebugMode(boolean debugMode) {
        this.myDebugMode = debugMode;
    }

    @Nullable
    public DebugLauncher getDebugLauncher() {
        return this.myDebugLauncher;
    }

    public void setDebugLauncher(@NotNull DebugLauncher debugLauncher) {
        if (debugLauncher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugLauncher", "org/jetbrains/android/run/AndroidRunningState", "setDebugLauncher"));
        }
        this.myDebugLauncher = debugLauncher;
    }

    public boolean isDebugMode() {
        return this.myDebugMode;
    }

    private static void runInDispatchedThread(@NotNull Runnable r, boolean blocking) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "org/jetbrains/android/run/AndroidRunningState", "runInDispatchedThread"));
        }
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            r.run();
        } else if (blocking) {
            application.invokeAndWait(r, ModalityState.defaultModalityState());
        } else {
            application.invokeLater(r);
        }
    }

    public ExecutionResult execute(final @NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        boolean debugMatrixOnCloud;
        TextConsoleBuilder builder;
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/android/run/AndroidRunningState", "execute"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "org/jetbrains/android/run/AndroidRunningState", "execute"));
        }
        Project project = this.myFacet.getModule().getProject();
        this.myProcessHandler = new DefaultDebugProcessHandler();
        AndroidProcessText.attach(this.myProcessHandler);
        ConsoleView console = null;
        if (this.isDebugMode() && (console = (builder = TextConsoleBuilderFactory.getInstance().createBuilder(project)).getConsole()) != null) {
            console.attachToProcess(this.myProcessHandler);
        }
        final CloudConfigurationProvider provider = CloudConfigurationProvider.getCloudConfigurationProvider();
        boolean bl = debugMatrixOnCloud = this.myTargetChooser instanceof CloudTargetChooser && ((CloudTargetChooser)this.myTargetChooser).getConfigurationKind() == CloudConfiguration.Kind.MATRIX && executor instanceof DefaultDebugExecutor;
        if (this.myTargetChooser instanceof ManualTargetChooser || debugMatrixOnCloud) {
            if (this.myConfiguration.USE_LAST_SELECTED_DEVICE) {
                Set<IDevice> onlineDevices;
                DeviceStateAtLaunch lastLaunchState = this.myConfiguration.getDevicesUsedInLastLaunch();
                if (lastLaunchState != null && lastLaunchState.matchesCurrentAvailableDevices(onlineDevices = this.getOnlineDevices())) {
                    Collection<IDevice> usedDevices = lastLaunchState.filterByUsed(onlineDevices);
                    this.myTargetDevices = usedDevices.toArray(new IDevice[usedDevices.size()]);
                }
                if (this.myTargetDevices.length > 1 && !this.mySupportMultipleDevices) {
                    this.myTargetDevices = EMPTY_DEVICE_ARRAY;
                }
            }
            if (this.myTargetDevices.length == 0) {
                AndroidPlatform platform = ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getAndroidPlatform();
                if (platform == null) {
                    LOG.error("Android platform not set for module: " + this.myFacet.getModule().getName());
                    return null;
                }
                boolean showCloudTarget = this.getConfiguration() instanceof AndroidTestRunConfiguration && !(executor instanceof DefaultDebugExecutor);
                ExtendedDeviceChooserDialog chooser = new ExtendedDeviceChooserDialog(this.myFacet, platform.getTarget(), this.mySupportMultipleDevices, true, this.myConfiguration.USE_LAST_SELECTED_DEVICE, showCloudTarget, this.myCommandLine);
                chooser.show();
                if (chooser.getExitCode() != 0) {
                    return null;
                }
                if (chooser.isToLaunchEmulator()) {
                    String selectedAvd = chooser.getSelectedAvd();
                    if (selectedAvd == null) {
                        return null;
                    }
                    this.myTargetChooser = new EmulatorTargetChooser(selectedAvd);
                    this.myAvdName = selectedAvd;
                } else {
                    if (chooser.isCloudTestOptionSelected()) {
                        return provider.executeCloudMatrixTests(chooser.getSelectedMatrixConfigurationId(), chooser.getChosenCloudProjectId(), this, executor);
                    }
                    Object[] selectedDevices = chooser.getSelectedDevices();
                    if (selectedDevices.length == 0) {
                        return null;
                    }
                    this.myTargetDevices = selectedDevices;
                    if (chooser.useSameDevicesAgain()) {
                        this.myConfiguration.USE_LAST_SELECTED_DEVICE = true;
                        this.myConfiguration.setDevicesUsedInLaunch(Sets.newHashSet((Object[])selectedDevices), this.getOnlineDevices());
                    } else {
                        this.myConfiguration.USE_LAST_SELECTED_DEVICE = false;
                        this.myConfiguration.setDevicesUsedInLaunch(Collections.<IDevice>emptySet(), Collections.<IDevice>emptySet());
                    }
                }
            }
        } else {
            if (this.myTargetChooser instanceof CloudTargetChooser) {
                assert (provider != null);
                final CloudTargetChooser cloudTargetChooser = (CloudTargetChooser)this.myTargetChooser;
                if (cloudTargetChooser.getConfigurationKind() == CloudConfiguration.Kind.MATRIX) {
                    return provider.executeCloudMatrixTests(cloudTargetChooser.getCloudConfigurationId(), cloudTargetChooser.getCloudProjectId(), this, executor);
                }
                assert (cloudTargetChooser.getConfigurationKind() == CloudConfiguration.Kind.SINGLE_DEVICE);
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        provider.launchCloudDevice(cloudTargetChooser.getCloudConfigurationId(), cloudTargetChooser.getCloudProjectId(), AndroidRunningState.this.myFacet);
                    }
                });
                return new DefaultExecutionResult((ExecutionConsole)console, this.myProcessHandler);
            }
            if (this.myTargetChooser instanceof CloudDebuggingTargetChooser) {
                assert (provider != null);
                this.myTargetDevices = EMPTY_DEVICE_ARRAY;
                String cloudDeviceSerialNumber = ((CloudDebuggingTargetChooser)this.myTargetChooser).getCloudDeviceSerialNumber();
                for (IDevice device : AndroidDebugBridge.getBridge().getDevices()) {
                    if (!device.getSerialNumber().equals(cloudDeviceSerialNumber)) continue;
                    this.myTargetDevices = new IDevice[]{device};
                    break;
                }
                if (this.myTargetDevices.length == 0) {
                    return null;
                }
            }
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                AndroidRunningState.this.start(true);
            }
        });
        if (console == null) {
            console = this.myConfiguration.attachConsole(this, executor);
        }
        this.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (outputType.equals((Object)ProcessOutputTypes.STDERR)) {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ToolWindowManager.getInstance((Project)AndroidRunningState.this.myFacet.getModule().getProject()).getToolWindow(executor.getToolWindowId()).activate(null, true, false);
                        }
                    });
                }
            }

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                AndroidRunningState.this.getProcessHandler().removeProcessListener((ProcessListener)this);
            }
        });
        this.myConsole = console;
        return new DefaultExecutionResult((ExecutionConsole)console, this.myProcessHandler);
    }

    private Set<IDevice> getOnlineDevices() {
        AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge(this.myFacet.getModule().getProject());
        if (debugBridge == null) {
            return Collections.emptySet();
        }
        return Sets.newHashSet((Object[])debugBridge.getDevices());
    }

    @Override
    @NotNull
    public AndroidRunConfigurationBase getConfiguration() {
        AndroidRunConfigurationBase androidRunConfigurationBase = this.myConfiguration;
        if (androidRunConfigurationBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunningState", "getConfiguration"));
        }
        return androidRunConfigurationBase;
    }

    public ExecutionEnvironment getEnvironment() {
        return this.myEnv;
    }

    public boolean isStopped() {
        return this.myStopped;
    }

    public Object getRunningLock() {
        return this.myLock;
    }

    public String getPackageName() {
        try {
            return this.myApkProvider.getPackageName();
        }
        catch (ApkProvisionException e) {
            return null;
        }
    }

    public String getTestPackageName() {
        try {
            return this.myApkProvider.getTestPackageName();
        }
        catch (ApkProvisionException e) {
            return null;
        }
    }

    public Module getModule() {
        return this.myFacet.getModule();
    }

    @NotNull
    public AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunningState", "getFacet"));
        }
        return androidFacet;
    }

    @Override
    public IDevice[] getDevices() {
        return this.myTargetDevices;
    }

    @Override
    @Nullable
    public ConsoleView getConsoleView() {
        return this.myConsole;
    }

    public AndroidRunningState(@NotNull ExecutionEnvironment environment, @NotNull AndroidFacet facet, @NotNull ApkProvider apkProvider, @Nullable TargetChooser targetChooser, @NotNull String commandLine, AndroidApplicationLauncher applicationLauncher, boolean supportMultipleDevices, boolean clearLogcatBeforeStart, @NotNull AndroidRunConfigurationBase configuration, boolean nonDebuggableOnDevice) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/android/run/AndroidRunningState", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/run/AndroidRunningState", "<init>"));
        }
        if (apkProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkProvider", "org/jetbrains/android/run/AndroidRunningState", "<init>"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "org/jetbrains/android/run/AndroidRunningState", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/android/run/AndroidRunningState", "<init>"));
        }
        this.myDebugLock = new Object();
        this.myTargetDevices = EMPTY_DEVICE_ARRAY;
        this.myLock = new Object();
        this.myDeploy = true;
        this.myApplicationDeployed = false;
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myFacet = facet;
        this.myApkProvider = apkProvider;
        this.myCommandLine = commandLine;
        this.myConfiguration = configuration;
        this.myTargetChooser = targetChooser;
        this.mySupportMultipleDevices = supportMultipleDevices;
        this.myAvdName = targetChooser instanceof EmulatorTargetChooser ? ((EmulatorTargetChooser)targetChooser).getAvd() : null;
        this.myEnv = environment;
        this.myApplicationLauncher = applicationLauncher;
        this.myClearLogcatBeforeStart = clearLogcatBeforeStart;
        this.myNonDebuggableOnDevice = nonDebuggableOnDevice;
    }

    public void setDeploy(boolean deploy) {
        this.myDeploy = deploy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetPackageName(String targetPackageName) {
        Object object = this.myDebugLock;
        synchronized (object) {
            this.myTargetPackageName = targetPackageName;
        }
    }

    @Nullable
    private IDevice[] chooseDevicesAutomatically() {
        List<IDevice> compatibleDevices = this.getAllCompatibleDevices();
        if (compatibleDevices.size() == 0) {
            return EMPTY_DEVICE_ARRAY;
        }
        if (compatibleDevices.size() == 1) {
            return new IDevice[]{compatibleDevices.get(0)};
        }
        final IDevice[][] devicesWrapper = new IDevice[][]{null};
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                devicesWrapper[0] = AndroidRunningState.this.chooseDevicesManually((Predicate<IDevice>)((Predicate)new Predicate<IDevice>(){

                    public boolean apply(IDevice device) {
                        return AndroidRunningState.this.isCompatibleDevice(device) != Boolean.FALSE;
                    }
                }));
            }
        }, ModalityState.defaultModalityState());
        return devicesWrapper[0].length > 0 ? devicesWrapper[0] : null;
    }

    @NotNull
    List<IDevice> getAllCompatibleDevices() {
        ArrayList<IDevice> compatibleDevices = new ArrayList<IDevice>();
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge != null) {
            IDevice[] devices;
            for (IDevice device : devices = bridge.getDevices()) {
                if (this.isCompatibleDevice(device) == Boolean.FALSE) continue;
                compatibleDevices.add(device);
            }
        }
        ArrayList<IDevice> arrayList = compatibleDevices;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunningState", "getAllCompatibleDevices"));
        }
        return arrayList;
    }

    private void chooseAvd() {
        IAndroidTarget buildTarget = ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getAndroidTarget();
        assert (buildTarget != null);
        AvdInfo[] avds = this.myFacet.getValidCompatibleAvds();
        if (avds.length > 0) {
            this.myAvdName = avds[0].getName();
        } else {
            final Project project = this.myFacet.getModule().getProject();
            AvdManager manager = null;
            try {
                manager = this.myFacet.getAvdManager(new AvdManagerLog(){

                    @Override
                    public void error(Throwable t, String errorFormat, Object ... args) {
                        super.error(t, errorFormat, args);
                        if (errorFormat != null) {
                            String msg = String.format(errorFormat, args);
                            AndroidRunningState.this.message(msg, ProcessOutputTypes.STDERR);
                        }
                    }
                });
            }
            catch (AvdsNotSupportedException e) {
                LOG.error((Throwable)e);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                LOG.info((Throwable)e);
                AndroidRunningState.runInDispatchedThread(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
                    }
                }, false);
                return;
            }
            final AvdManager finalManager = manager;
            assert (finalManager != null);
            AndroidRunningState.runInDispatchedThread(new Runnable(){

                @Override
                public void run() {
                    AvdInfo createdAvd;
                    CreateAvdDialog dialog = new CreateAvdDialog(project, AndroidRunningState.this.myFacet, finalManager, true, true);
                    dialog.show();
                    if (dialog.getExitCode() == 0 && (createdAvd = dialog.getCreatedAvd()) != null) {
                        AndroidRunningState.this.myAvdName = createdAvd.getName();
                    }
                }
            }, true);
        }
    }

    void start(boolean chooseTargetDevice) {
        try {
            this.setTargetPackageName(this.myApkProvider.getPackageName());
        }
        catch (ApkProvisionException e) {
            this.message(e.getMessage(), ProcessOutputTypes.STDERR);
            LOG.error((Throwable)e);
            this.getProcessHandler().destroyProcess();
            return;
        }
        if (chooseTargetDevice) {
            this.message("Waiting for device.", ProcessOutputTypes.STDOUT);
            if (this.myTargetDevices.length == 0 && !this.chooseOrLaunchDevice()) {
                this.getProcessHandler().destroyProcess();
                this.fireExecutionFailed();
                return;
            }
        }
        this.doStart();
    }

    private void doStart() {
        if (this.myDebugMode) {
            AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        }
        final DeviceReadyListener[] deviceListener = new DeviceReadyListener[]{null};
        this.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                if (AndroidRunningState.this.myDebugMode) {
                    AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)AndroidRunningState.this);
                }
                if (deviceListener[0] != null) {
                    Disposer.dispose((Disposable)deviceListener[0]);
                    AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)deviceListener[0]);
                }
                AndroidRunningState.this.myStopped = true;
                Object object = AndroidRunningState.this.myLock;
                synchronized (object) {
                    AndroidRunningState.this.myLock.notifyAll();
                }
            }
        });
        deviceListener[0] = this.prepareAndStartAppWhenDeviceIsOnline();
    }

    private boolean chooseOrLaunchDevice() {
        IDevice[] targetDevices = this.chooseDevicesAutomatically();
        if (targetDevices == null) {
            this.message("Canceled", ProcessOutputTypes.STDERR);
            return false;
        }
        if (targetDevices.length > 0) {
            this.myTargetDevices = targetDevices;
        } else if (this.myTargetChooser instanceof EmulatorTargetChooser) {
            if (this.myAvdName == null) {
                this.chooseAvd();
            }
            if (this.myAvdName != null) {
                this.myFacet.launchEmulator(this.myAvdName, this.myCommandLine);
            } else if (this.getProcessHandler().isStartNotified()) {
                this.message("Canceled", ProcessOutputTypes.STDERR);
                return false;
            }
        } else {
            this.message("USB device not found", ProcessOutputTypes.STDERR);
            return false;
        }
        return true;
    }

    @NotNull
    private IDevice[] chooseDevicesManually(@Nullable Predicate<IDevice> filter) {
        Project project = this.myFacet.getModule().getProject();
        String value = PropertiesComponent.getInstance((Project)project).getValue(ANDROID_TARGET_DEVICES_PROPERTY);
        String[] selectedSerials = value != null ? AndroidRunningState.fromString(value) : null;
        AndroidPlatform platform = ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            LOG.error("Android platform not set for module: " + this.myFacet.getModule().getName());
            if (DeviceChooser.EMPTY_DEVICE_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunningState", "chooseDevicesManually"));
            }
            return DeviceChooser.EMPTY_DEVICE_ARRAY;
        }
        DeviceChooserDialog chooser = new DeviceChooserDialog(this.myFacet, platform.getTarget(), this.mySupportMultipleDevices, selectedSerials, filter);
        chooser.show();
        IDevice[] devices = chooser.getSelectedDevices();
        if (chooser.getExitCode() != 0 || devices.length == 0) {
            if (DeviceChooser.EMPTY_DEVICE_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunningState", "chooseDevicesManually"));
            }
            return DeviceChooser.EMPTY_DEVICE_ARRAY;
        }
        PropertiesComponent.getInstance((Project)project).setValue(ANDROID_TARGET_DEVICES_PROPERTY, AndroidRunningState.toString(devices));
        if (devices == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunningState", "chooseDevicesManually"));
        }
        return devices;
    }

    @NotNull
    public static String toString(@NotNull IDevice[] devices) {
        if (devices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "devices", "org/jetbrains/android/run/AndroidRunningState", "toString"));
        }
        StringBuilder builder = new StringBuilder();
        int n = devices.length;
        for (int i = 0; i < n; ++i) {
            builder.append(devices[i].getSerialNumber());
            if (i >= n - 1) continue;
            builder.append(' ');
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunningState", "toString"));
        }
        return string;
    }

    @NotNull
    private static String[] fromString(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/android/run/AndroidRunningState", "fromString"));
        }
        String[] stringArray = s.split(" ");
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunningState", "fromString"));
        }
        return stringArray;
    }

    public void message(@NotNull String message, @NotNull Key outputKey) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/android/run/AndroidRunningState", "message"));
        }
        if (outputKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputKey", "org/jetbrains/android/run/AndroidRunningState", "message"));
        }
        this.getProcessHandler().notifyTextAvailable(message + '\n', outputKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientChanged(Client client, int changeMask) {
        Object object = this.myDebugLock;
        synchronized (object) {
            if (this.myDebugLauncher == null) {
                return;
            }
            if (this.myDeploy && !this.myApplicationDeployed) {
                return;
            }
            IDevice device = client.getDevice();
            if (this.isMyDevice(device) && device.isOnline()) {
                if (this.myTargetDevices.length == 0) {
                    this.myTargetDevices = new IDevice[]{device};
                }
                ClientData data = client.getClientData();
                if (this.myDebugLauncher != null && this.isToLaunchDebug(data)) {
                    this.launchDebug(client);
                }
            }
        }
    }

    private boolean isToLaunchDebug(@NotNull ClientData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/android/run/AndroidRunningState", "isToLaunchDebug"));
        }
        if (data.getDebuggerConnectionStatus() == ClientData.DebuggerStatus.WAITING) {
            return true;
        }
        String description = data.getClientDescription();
        if (description == null) {
            return false;
        }
        return description.equals(this.myTargetPackageName) && this.myApplicationLauncher.isReadyForDebugging(data, this.getProcessHandler());
    }

    private void launchDebug(@NotNull Client client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/android/run/AndroidRunningState", "launchDebug"));
        }
        this.myDebugLauncher.launchDebug(client);
        this.myDebugLauncher = null;
    }

    @Nullable
    Boolean isCompatibleDevice(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/AndroidRunningState", "isCompatibleDevice"));
        }
        if (this.myTargetChooser instanceof EmulatorTargetChooser) {
            if (device.isEmulator()) {
                String avdName = device.getAvdName();
                if (this.myAvdName != null) {
                    return this.myAvdName.equals(avdName);
                }
                AndroidPlatform androidPlatform = ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getAndroidPlatform();
                if (androidPlatform == null) {
                    LOG.error("Target Android platform not set for module: " + this.myFacet.getModule().getName());
                    return false;
                }
                LaunchCompatibility compatibility = LaunchCompatibility.canRunOnDevice(AndroidModuleInfo.get(this.myFacet).getRuntimeMinSdkVersion(), androidPlatform.getTarget(), EnumSet.noneOf(IDevice.HardwareFeature.class), device, null);
                return compatibility.isCompatible() != ThreeState.NO;
            }
        } else {
            if (this.myTargetChooser instanceof UsbDeviceTargetChooser) {
                return !device.isEmulator();
            }
            if (this.myTargetChooser instanceof ManualTargetChooser && this.myConfiguration.USE_LAST_SELECTED_DEVICE) {
                DeviceStateAtLaunch lastLaunchState = this.myConfiguration.getDevicesUsedInLastLaunch();
                return lastLaunchState != null && lastLaunchState.usedDevice(device);
            }
        }
        return false;
    }

    private boolean isMyDevice(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/AndroidRunningState", "isMyDevice"));
        }
        if (this.myTargetDevices.length > 0) {
            return ArrayUtilRt.find((Object[])this.myTargetDevices, (Object)device) >= 0;
        }
        Boolean compatible = this.isCompatibleDevice(device);
        return compatible == null || compatible != false;
    }

    public void setTargetDevices(@NotNull IDevice[] targetDevices) {
        if (targetDevices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDevices", "org/jetbrains/android/run/AndroidRunningState", "setTargetDevices"));
        }
        this.myTargetDevices = targetDevices;
    }

    public void setConsole(@NotNull ConsoleView console) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "org/jetbrains/android/run/AndroidRunningState", "setConsole"));
        }
        this.myConsole = console;
    }

    @Nullable
    private DeviceReadyListener prepareAndStartAppWhenDeviceIsOnline() {
        if (this.myTargetDevices.length > 0) {
            boolean allDevicesOnline = true;
            for (IDevice targetDevice : this.myTargetDevices) {
                if (targetDevice.isOnline()) {
                    if (this.prepareAndStartApp(targetDevice) || this.myStopped) continue;
                    this.myStopped = true;
                    this.getProcessHandler().destroyProcess();
                    break;
                }
                allDevicesOnline = false;
            }
            if (allDevicesOnline) {
                if (!this.myDebugMode && !this.myStopped) {
                    this.getProcessHandler().destroyProcess();
                }
                return null;
            }
        }
        Predicate<IDevice> deviceFilter = new Predicate<IDevice>(){

            public boolean apply(IDevice device) {
                return AndroidRunningState.this.isMyDevice(device);
            }
        };
        DeviceReadyListener.Callback callback = new DeviceReadyListener.Callback(){

            @Override
            public void onDeviceReady(@NotNull IDevice device) {
                if (device == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/AndroidRunningState$10", "onDeviceReady"));
                }
                if (!(AndroidRunningState.this.prepareAndStartApp(device) && AndroidRunningState.this.myDebugMode || AndroidRunningState.this.myStopped)) {
                    AndroidRunningState.this.getProcessHandler().destroyProcess();
                }
            }
        };
        DeviceReadyListener deviceListener = new DeviceReadyListener(new ProcessHandlerSimpleLogger(this.getProcessHandler()), deviceFilter, callback);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)deviceListener);
        return deviceListener;
    }

    public synchronized void setProcessHandler(ProcessHandler processHandler) {
        this.myProcessHandler = processHandler;
    }

    public synchronized ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    private boolean prepareAndStartApp(IDevice device) {
        if (this.myDebugMode && this.myNonDebuggableOnDevice && !device.isEmulator()) {
            this.message(AndroidBundle.message("android.cannot.debug.noDebugPermissions", this.getPackageName(), device.getName()), ProcessOutputTypes.STDERR);
            this.fireExecutionFailed();
            return false;
        }
        if (!this.doPrepareAndStart(device)) {
            this.fireExecutionFailed();
            return false;
        }
        return true;
    }

    private void fireExecutionFailed() {
        for (AndroidRunningStateListener listener : this.myListeners) {
            listener.executionFailed();
        }
    }

    public void setOpenLogcatAutomatically(boolean openLogcatAutomatically) {
        this.myOpenLogcatAutomatically = openLogcatAutomatically;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doPrepareAndStart(final @NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/AndroidRunningState", "doPrepareAndStart"));
        }
        if (this.myClearLogcatBeforeStart) {
            AndroidRunningState.clearLogcatAndConsole(this.getModule().getProject(), device);
        }
        this.message("Target device: " + device.getName(), ProcessOutputTypes.STDOUT);
        try {
            Client client;
            AndroidApplicationLauncher.LaunchResult launchResult;
            AndroidVersion canDismissKeyguard;
            if (this.myDeploy) {
                Collection<ApkInfo> apks;
                try {
                    apks = this.myApkProvider.getApks(device);
                }
                catch (ApkProvisionException e) {
                    this.message(e.getMessage(), ProcessOutputTypes.STDERR);
                    LOG.warn((Throwable)e);
                    return false;
                }
                for (ApkInfo apk : apks) {
                    if (this.uploadAndInstallApk(device, apk.getApplicationId(), apk.getFile())) continue;
                    return false;
                }
                AndroidRunningState.trackInstallation(device);
                this.myApplicationDeployed = true;
            }
            if ((canDismissKeyguard = new AndroidVersion(23, null)).compareTo(DevicePropertyUtil.getDeviceVersion(device)) <= 0) {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            device.executeShellCommand("wm dismiss-keyguard", (IShellOutputReceiver)new NullOutputReceiver(), 10L, TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            LOG.warn("Unable to dismiss keyguard before launching activity");
                        }
                    }
                });
            }
            if ((launchResult = this.myApplicationLauncher.launch(this, device)) == AndroidApplicationLauncher.LaunchResult.STOP) {
                return false;
            }
            if (launchResult == AndroidApplicationLauncher.LaunchResult.SUCCESS) {
                this.checkDdms();
            }
            Object object = this.myDebugLock;
            synchronized (object) {
                client = device.getClient(this.myTargetPackageName);
                if (this.myDebugLauncher != null) {
                    if (client != null && this.myApplicationLauncher.isReadyForDebugging(client.getClientData(), this.getProcessHandler())) {
                        this.launchDebug(client);
                    } else {
                        this.message("Waiting for process: " + this.myTargetPackageName, ProcessOutputTypes.STDOUT);
                    }
                }
            }
            if (!this.myDebugMode && this.myOpenLogcatAutomatically) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final ToolWindow androidToolWindow = ToolWindowManager.getInstance((Project)AndroidRunningState.this.myEnv.getProject()).getToolWindow(AndroidToolWindowFactory.TOOL_WINDOW_ID);
                        androidToolWindow.activate(new Runnable(){

                            @Override
                            public void run() {
                                int count = androidToolWindow.getContentManager().getContentCount();
                                for (int i = 0; i < count; ++i) {
                                    DevicePanel devicePanel;
                                    Content content = androidToolWindow.getContentManager().getContent(i);
                                    DevicePanel devicePanel2 = devicePanel = content == null ? null : (DevicePanel)content.getUserData(AndroidToolWindowFactory.DEVICES_PANEL_KEY);
                                    if (devicePanel == null) continue;
                                    devicePanel.selectDevice(device);
                                    devicePanel.selectClient(client);
                                    break;
                                }
                            }
                        }, false);
                    }
                });
            }
            return true;
        }
        catch (TimeoutException e) {
            LOG.info((Throwable)e);
            this.message("Error: Connection to ADB failed with a timeout", ProcessOutputTypes.STDERR);
            return false;
        }
        catch (AdbCommandRejectedException e) {
            LOG.info((Throwable)e);
            this.message("Error: Adb refused a command", ProcessOutputTypes.STDERR);
            return false;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            String message = e.getMessage();
            this.message("I/O Error" + (message != null ? ": " + message : ""), ProcessOutputTypes.STDERR);
            return false;
        }
    }

    private static void trackInstallation(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/AndroidRunningState", "trackInstallation"));
        }
        if (!UsageTracker.getInstance().canTrack()) {
            return;
        }
        if ((ourInstallationCount = (ourInstallationCount + 1) % 10) != 0) {
            return;
        }
        UsageTracker.getInstance().trackEvent("deployment", "apkDeployed", null, null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.serialno.hashed", Hashing.md5().hashString((CharSequence)device.getSerialNumber(), Charsets.UTF_8).toString(), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.tags", device.getProperty("ro.build.tags"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.type", device.getProperty("ro.build.type"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.version.release", device.getProperty("ro.build.version.release"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.build.version.sdk", device.getProperty("ro.build.version.sdk"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.product.manufacturer", device.getProperty("ro.product.manufacturer"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.product.model", device.getProperty("ro.product.model"), null);
        UsageTracker.getInstance().trackEvent("deviceInfo", "ro.product.cpu.abi", device.getProperty("ro.product.cpu.abi"), null);
    }

    protected static void clearLogcatAndConsole(final @NotNull Project project, final @NotNull IDevice device) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/run/AndroidRunningState", "clearLogcatAndConsole"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/AndroidRunningState", "clearLogcatAndConsole"));
        }
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(AndroidToolWindowFactory.TOOL_WINDOW_ID);
                if (toolWindow == null) {
                    return;
                }
                for (Content content : toolWindow.getContentManager().getContents()) {
                    AndroidLogcatView view = (AndroidLogcatView)content.getUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY);
                    if (view == null) continue;
                    view.clearLogcat(device);
                }
            }
        }, ModalityState.defaultModalityState());
    }

    private boolean checkDdms() {
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (this.myDebugMode && bridge != null && AdbService.canDdmsBeCorrupted(bridge)) {
            JComponent component;
            this.message(AndroidBundle.message("ddms.corrupted.error", new Object[0]), ProcessOutputTypes.STDERR);
            JComponent jComponent = component = this.myConsole == null ? null : this.myConsole.getComponent();
            if (component != null) {
                final ExecutionEnvironment environment = (ExecutionEnvironment)LangDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext((Component)component));
                if (environment == null) {
                    return false;
                }
                this.myConsole.printHyperlink(AndroidBundle.message("restart.adb.fix.text", new Object[0]), new HyperlinkInfo(){

                    public void navigate(Project project) {
                        AdbService.getInstance().restartDdmlib(project);
                        ProcessHandler processHandler = AndroidRunningState.this.getProcessHandler();
                        if (!processHandler.isProcessTerminated()) {
                            processHandler.destroyProcess();
                        }
                        ExecutionUtil.restart((ExecutionEnvironment)environment);
                    }
                });
                this.myConsole.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            }
            return false;
        }
        return true;
    }

    private boolean uploadAndInstallApk(@NotNull IDevice device, @NotNull String packageName, @NotNull File localFile) throws IOException, AdbCommandRejectedException, TimeoutException {
        String errorMessage;
        String exceptionMessage;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/AndroidRunningState", "uploadAndInstallApk"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/run/AndroidRunningState", "uploadAndInstallApk"));
        }
        if (localFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "org/jetbrains/android/run/AndroidRunningState", "uploadAndInstallApk"));
        }
        if (this.myStopped) {
            return false;
        }
        String remotePath = "/data/local/tmp/" + packageName;
        this.message("Uploading file\n\tlocal path: " + localFile + "\n\tremote path: " + remotePath, ProcessOutputTypes.STDOUT);
        try {
            InstalledApks installedApks = (InstalledApks)ServiceManager.getService(InstalledApks.class);
            if (this.myConfiguration.SKIP_NOOP_APK_INSTALLATIONS && installedApks.isInstalled(device, localFile, packageName)) {
                this.message("No apk changes detected.", ProcessOutputTypes.STDOUT);
                if (this.myConfiguration.FORCE_STOP_RUNNING_APP) {
                    this.message("Skipping file upload, force stopping package instead.", ProcessOutputTypes.STDOUT);
                    this.forceStopPackageSilently(device, packageName, true);
                }
                return true;
            }
            device.pushFile(localFile.getPath(), remotePath);
            boolean installed = this.installApp(device, remotePath, packageName);
            if (installed) {
                installedApks.setInstalled(device, localFile, packageName);
            }
            return installed;
        }
        catch (TimeoutException e) {
            LOG.info((Throwable)e);
            exceptionMessage = e.getMessage();
            errorMessage = "Connection timeout";
        }
        catch (AdbCommandRejectedException e) {
            LOG.info((Throwable)e);
            exceptionMessage = e.getMessage();
            errorMessage = "ADB refused the command";
        }
        catch (SyncException e) {
            LOG.info((Throwable)e);
            final SyncException.SyncError errorCode = e.getErrorCode();
            if (SyncException.SyncError.NO_LOCAL_FILE.equals((Object)errorCode)) {
                DataManager.getInstance().getDataContextFromFocus().doWhenDone((Consumer)new Consumer<DataContext>(){

                    public void consume(DataContext dataContext) {
                        Project project;
                        if (dataContext != null && (project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) != null && this.hasGradleFiles(project)) {
                            AndroidGradleNotification notification = AndroidGradleNotification.getInstance(project);
                            String message = errorCode.getMessage() + '\n' + e.getMessage() + '\n' + "The project may need to be synced with Gradle files.";
                            notification.showBalloon("Unexpected Error", message, NotificationType.ERROR, new SyncProjectHyperlink());
                        }
                    }

                    private boolean hasGradleFiles(@NotNull Project project) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/run/AndroidRunningState$15", "hasGradleFiles"));
                        }
                        File rootDirPath = new File(FileUtil.toSystemDependentName((String)project.getBasePath()));
                        return GradleUtil.getGradleBuildFilePath(rootDirPath).isFile() || GradleUtil.getGradleSettingsFilePath(rootDirPath).isFile();
                    }
                });
            }
            errorMessage = errorCode.getMessage();
            exceptionMessage = e.getMessage();
        }
        if (errorMessage.equals(exceptionMessage) || exceptionMessage == null) {
            this.message(errorMessage, ProcessOutputTypes.STDERR);
        } else {
            this.message(errorMessage + '\n' + exceptionMessage, ProcessOutputTypes.STDERR);
        }
        return false;
    }

    private void forceStopPackageSilently(@NotNull IDevice device, @NotNull String packageName, boolean ignoreErrors) {
        block4: {
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/AndroidRunningState", "forceStopPackageSilently"));
            }
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/run/AndroidRunningState", "forceStopPackageSilently"));
            }
            try {
                this.executeDeviceCommandAndWriteToConsole(device, "am force-stop " + packageName, new MyReceiver());
            }
            catch (Exception e) {
                if (ignoreErrors) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    public void executeDeviceCommandAndWriteToConsole(@NotNull IDevice device, @NotNull String command, @NotNull AndroidOutputReceiver receiver) throws IOException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/AndroidRunningState", "executeDeviceCommandAndWriteToConsole"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/android/run/AndroidRunningState", "executeDeviceCommandAndWriteToConsole"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/android/run/AndroidRunningState", "executeDeviceCommandAndWriteToConsole"));
        }
        this.message("DEVICE SHELL COMMAND: " + command, ProcessOutputTypes.STDOUT);
        AndroidUtils.executeCommandOnDevice(device, command, receiver, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean installApp(@NotNull IDevice device, @NotNull String remotePath, @NotNull String packageName) throws IOException, AdbCommandRejectedException, TimeoutException {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/AndroidRunningState", "installApp"));
        }
        if (remotePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePath", "org/jetbrains/android/run/AndroidRunningState", "installApp"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/run/AndroidRunningState", "installApp"));
        }
        this.message("Installing " + packageName, ProcessOutputTypes.STDOUT);
        InstallResult result = null;
        boolean retry = true;
        block14: while (!this.myStopped && retry) {
            result = this.installApp(device, remotePath);
            if (result.installOutput != null) {
                this.message(result.installOutput, result.failureCode == InstallFailureCode.NO_ERROR ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR);
            }
            switch (result.failureCode) {
                case DEVICE_NOT_RESPONDING: {
                    this.message("Device is not ready. Waiting for 20 sec.", ProcessOutputTypes.STDOUT);
                    Object object = this.myLock;
                    synchronized (object) {
                        try {
                            this.myLock.wait(20000L);
                        }
                        catch (InterruptedException e) {
                            LOG.info((Throwable)e);
                        }
                    }
                    retry = true;
                    continue block14;
                }
                case INSTALL_FAILED_VERSION_DOWNGRADE: {
                    String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.text", AndroidBundle.message("deployment.failed.reason.version.downgrade", new Object[0]));
                    retry = this.promptUninstallExistingApp(reason) && this.uninstallPackage(device, packageName);
                    continue block14;
                }
                case INCONSISTENT_CERTIFICATES: {
                    String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.text", AndroidBundle.message("deployment.failed.reason.different.signature", new Object[0]));
                    retry = this.promptUninstallExistingApp(reason) && this.uninstallPackage(device, packageName);
                    continue block14;
                }
                case INSTALL_FAILED_DEXOPT: {
                    String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.text", AndroidBundle.message("deployment.failed.reason.dexopt", new Object[0]));
                    retry = this.promptUninstallExistingApp(reason) && this.uninstallPackage(device, packageName);
                    continue block14;
                }
                case NO_CERTIFICATE: {
                    this.message(AndroidBundle.message("deployment.failed.no.certificates.explanation", new Object[0]), ProcessOutputTypes.STDERR);
                    this.showMessageDialog(AndroidBundle.message("deployment.failed.no.certificates.explanation", new Object[0]));
                    retry = false;
                    continue block14;
                }
                case INSTALL_FAILED_OLDER_SDK: {
                    String reason = this.validateSdkVersion(device);
                    if (reason != null) {
                        if (this.shouldOpenProjectStructure(reason)) {
                            this.openProjectStructure();
                        }
                        retry = false;
                        continue block14;
                    }
                }
                case UNTYPED_ERROR: {
                    String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.generic.text", result.failureMessage);
                    retry = this.promptUninstallExistingApp(reason) && this.uninstallPackage(device, packageName);
                    continue block14;
                }
            }
            retry = false;
        }
        return result != null && result.failureCode == InstallFailureCode.NO_ERROR;
    }

    private boolean uninstallPackage(@NotNull IDevice device, @NotNull String packageName) {
        String output;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/AndroidRunningState", "uninstallPackage"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/run/AndroidRunningState", "uninstallPackage"));
        }
        this.message("DEVICE SHELL COMMAND: pm uninstall " + packageName, ProcessOutputTypes.STDOUT);
        try {
            output = device.uninstallPackage(packageName);
        }
        catch (InstallException e) {
            return false;
        }
        if (output != null) {
            this.message(output, ProcessOutputTypes.STDERR);
            return false;
        }
        return true;
    }

    private boolean promptUninstallExistingApp(final String reason) {
        final AtomicBoolean uninstall = new AtomicBoolean(false);
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                int result = Messages.showOkCancelDialog((Project)AndroidRunningState.this.myFacet.getModule().getProject(), (String)reason, (String)AndroidBundle.message("deployment.failed.title", new Object[0]), (Icon)Messages.getQuestionIcon());
                uninstall.set(result == 0);
            }
        }, ModalityState.defaultModalityState());
        return uninstall.get();
    }

    private void showMessageDialog(final @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/android/run/AndroidRunningState", "showMessageDialog"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showErrorDialog((Project)AndroidRunningState.this.myFacet.getModule().getProject(), (String)message, (String)AndroidBundle.message("deployment.failed.title", new Object[0]));
            }
        });
    }

    private InstallResult installApp(@NotNull IDevice device, @NotNull String remotePath) throws AdbCommandRejectedException, TimeoutException, IOException {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/AndroidRunningState", "installApp"));
        }
        if (remotePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePath", "org/jetbrains/android/run/AndroidRunningState", "installApp"));
        }
        MyReceiver receiver = new MyReceiver();
        try {
            this.executeDeviceCommandAndWriteToConsole(device, "pm install -r \"" + remotePath + "\"", receiver);
        }
        catch (ShellCommandUnresponsiveException e) {
            LOG.info((Throwable)e);
            return new InstallResult(InstallFailureCode.DEVICE_NOT_RESPONDING, null, null);
        }
        return new InstallResult(this.getFailureCode(receiver), receiver.failureMessage, receiver.output.toString());
    }

    private String validateSdkVersion(@NotNull IDevice device) {
        AndroidVersion minSdkVersion;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/AndroidRunningState", "validateSdkVersion"));
        }
        AndroidVersion deviceVersion = DevicePropertyUtil.getDeviceVersion(device);
        if (!deviceVersion.canRun(minSdkVersion = this.myFacet.getAndroidModuleInfo().getRuntimeMinSdkVersion())) {
            this.message("Device API level: " + deviceVersion.toString(), ProcessOutputTypes.STDERR);
            return AndroidBundle.message("deployment.failed.reason.oldersdk", minSdkVersion.toString(), deviceVersion.toString());
        }
        return null;
    }

    private boolean shouldOpenProjectStructure(final @NotNull String reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/android/run/AndroidRunningState", "shouldOpenProjectStructure"));
        }
        final AtomicBoolean open = new AtomicBoolean(false);
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                int result = Messages.showOkCancelDialog((Project)AndroidRunningState.this.myFacet.getModule().getProject(), (String)reason, (String)AndroidBundle.message("deployment.failed.title", new Object[0]), (Icon)Messages.getQuestionIcon());
                open.set(result == 0);
            }
        }, ModalityState.defaultModalityState());
        return open.get();
    }

    private boolean openProjectStructure() {
        final ProjectSettingsService service = ProjectSettingsService.getInstance((Project)this.myFacet.getModule().getProject());
        if (service instanceof AndroidProjectSettingsService) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((AndroidProjectSettingsService)service).openAndSelectFlavorsEditor(AndroidRunningState.this.myFacet.getModule());
                }
            });
        }
        return false;
    }

    private InstallFailureCode getFailureCode(MyReceiver receiver) {
        if (receiver.errorType == -2 && receiver.failureMessage == null) {
            return InstallFailureCode.NO_ERROR;
        }
        if ("INSTALL_PARSE_FAILED_INCONSISTENT_CERTIFICATES".equals(receiver.failureMessage)) {
            return InstallFailureCode.INCONSISTENT_CERTIFICATES;
        }
        if ("INSTALL_PARSE_FAILED_NO_CERTIFICATES".equals(receiver.failureMessage)) {
            return InstallFailureCode.NO_CERTIFICATE;
        }
        if ("INSTALL_FAILED_VERSION_DOWNGRADE".equals(receiver.failureMessage)) {
            return InstallFailureCode.INSTALL_FAILED_VERSION_DOWNGRADE;
        }
        if ("INSTALL_FAILED_DEXOPT".equals(receiver.failureMessage)) {
            return InstallFailureCode.INSTALL_FAILED_DEXOPT;
        }
        if ("INSTALL_FAILED_OLDER_SDK".equals(receiver.failureMessage)) {
            return InstallFailureCode.INSTALL_FAILED_OLDER_SDK;
        }
        return InstallFailureCode.UNTYPED_ERROR;
    }

    public void addListener(@NotNull AndroidRunningStateListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/android/run/AndroidRunningState", "addListener"));
        }
        this.myListeners.add(listener);
    }

    private static class InstallResult {
        public final InstallFailureCode failureCode;
        @Nullable
        public final String failureMessage;
        @Nullable
        public final String installOutput;

        public InstallResult(InstallFailureCode failureCode, @Nullable String failureMessage, @Nullable String installOutput) {
            this.failureCode = failureCode;
            this.failureMessage = failureMessage;
            this.installOutput = installOutput;
        }
    }

    private static enum InstallFailureCode {
        NO_ERROR,
        DEVICE_NOT_RESPONDING,
        INCONSISTENT_CERTIFICATES,
        INSTALL_FAILED_VERSION_DOWNGRADE,
        INSTALL_FAILED_DEXOPT,
        NO_CERTIFICATE,
        INSTALL_FAILED_OLDER_SDK,
        UNTYPED_ERROR;

    }

    public class MyReceiver
    extends AndroidOutputReceiver {
        private int errorType = -2;
        private String failureMessage = null;
        private final StringBuilder output = new StringBuilder();

        @Override
        protected void processNewLine(String line) {
            if (line.length() > 0) {
                Matcher errorMatcher;
                Matcher failureMatcher = FAILURE.matcher(line);
                if (failureMatcher.matches()) {
                    this.failureMessage = failureMatcher.group(1);
                }
                if ((errorMatcher = TYPED_ERROR.matcher(line)).matches()) {
                    this.errorType = Integer.parseInt(errorMatcher.group(1));
                } else if (line.startsWith(AndroidRunningState.ERROR_PREFIX) && this.errorType == -2) {
                    this.errorType = -1;
                }
            }
            this.output.append(line).append('\n');
        }

        public int getErrorType() {
            return this.errorType;
        }

        public boolean isCancelled() {
            return AndroidRunningState.this.myStopped;
        }

        public StringBuilder getOutput() {
            return this.output;
        }
    }
}

