/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.tools.idea.model.AndroidModuleInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.GenericAttributeValue;
import java.io.File;
import java.io.IOException;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.AndroidRunConfigurationBase;
import org.jetbrains.android.run.ApkProvisionException;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class ApkProviderUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static String computePackageName(@NotNull AndroidFacet facet) throws ApkProvisionException {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/run/ApkProviderUtil", "computePackageName"));
        }
        if (facet.getProperties().USE_CUSTOM_MANIFEST_PACKAGE) {
            String string = facet.getProperties().CUSTOM_MANIFEST_PACKAGE;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/ApkProviderUtil", "computePackageName"));
            }
            return string;
        }
        if (facet.getProperties().USE_CUSTOM_COMPILER_MANIFEST) {
            Manifest manifest;
            VirtualFile manifestVFile;
            Pair<File, String> pair;
            LocalFileSystem.getInstance().refresh(false);
            File manifestCopy = null;
            try {
                pair = AndroidRunConfigurationBase.getCopyOfCompilerManifestFile(facet);
            }
            catch (IOException e) {
                throw new ApkProvisionException("Could not compute package name because of I/O error: " + e.getMessage(), e);
            }
            manifestCopy = pair != null ? (File)pair.getFirst() : null;
            VirtualFile virtualFile = manifestVFile = manifestCopy != null ? LocalFileSystem.getInstance().refreshAndFindFileByIoFile(manifestCopy) : null;
            if (manifestVFile != null) {
                manifestVFile.refresh(false, false);
                manifest = AndroidUtils.loadDomElement(facet.getModule(), manifestVFile, Manifest.class);
            } else {
                manifest = null;
            }
            final String manifestLocalPath = pair != null ? (String)pair.getSecond() : null;
            Module module = facet.getModule();
            final String moduleName = module.getName();
            if (manifest == null) {
                throw new ApkProvisionException("Cannot find AndroidManifest.xml file for module " + moduleName);
            }
            String string = (String)ApplicationManager.getApplication().runReadAction((ThrowableComputable)new ThrowableComputable<String, ApkProvisionException>(){

                public String compute() throws ApkProvisionException {
                    GenericAttributeValue<String> packageAttrValue = manifest.getPackage();
                    String aPackage = (String)packageAttrValue.getValue();
                    if (aPackage == null || aPackage.isEmpty()) {
                        throw new ApkProvisionException("[" + moduleName + "] Main package is not specified in file " + manifestLocalPath);
                    }
                    return aPackage;
                }
            });
            String string2 = string;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/ApkProviderUtil", "computePackageName"));
            }
            return string2;
            finally {
                if (manifestCopy != null) {
                    FileUtil.delete((File)manifestCopy.getParentFile());
                }
            }
        }
        String pkg = AndroidModuleInfo.get(facet).getPackage();
        if (pkg == null || pkg.isEmpty()) {
            throw new ApkProvisionException("[" + facet.getModule().getName() + "] Unable to obtain main package from manifest.");
        }
        String string = pkg;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/ApkProviderUtil", "computePackageName"));
        }
        return string;
    }
}

