/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.google.common.base.Predicate;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import org.jetbrains.android.run.SimpleLogger;
import org.jetbrains.annotations.NotNull;

final class DeviceReadyListener
implements AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    private final MergingUpdateQueue myQueue;
    @NotNull
    private final SimpleLogger myLogger;
    @NotNull
    private final Predicate<IDevice> myDeviceFilter;
    @NotNull
    private final Callback myCallback;
    @NotNull
    private final Object myFinishedLock;
    private boolean myFinished;

    public DeviceReadyListener(@NotNull SimpleLogger logger, @NotNull Predicate<IDevice> deviceFilter, @NotNull Callback callback) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "org/jetbrains/android/run/DeviceReadyListener", "<init>"));
        }
        if (deviceFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceFilter", "org/jetbrains/android/run/DeviceReadyListener", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/android/run/DeviceReadyListener", "<init>"));
        }
        this.myQueue = new MergingUpdateQueue("ANDROID_DEVICE_STATE_UPDATE_QUEUE", 1000, true, null, (Disposable)this, null, false);
        this.myFinishedLock = new Object();
        this.myLogger = logger;
        this.myDeviceFilter = deviceFilter;
        this.myCallback = callback;
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/DeviceReadyListener", "deviceConnected"));
        }
        if (device.getAvdName() == null || this.myDeviceFilter.apply((Object)device)) {
            this.myLogger.stdout("Device connected: " + device.getSerialNumber());
            this.myQueue.queue((Update)new MyDeviceStateUpdate(device));
        }
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/DeviceReadyListener", "deviceDisconnected"));
        }
        if (this.myDeviceFilter.apply((Object)device)) {
            this.myLogger.stdout("Device disconnected: " + device.getSerialNumber());
        }
    }

    public void deviceChanged(final @NotNull IDevice device, int changeMask) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/DeviceReadyListener", "deviceChanged"));
        }
        this.myQueue.queue(new Update(device.getSerialNumber()){

            public void run() {
                DeviceReadyListener.this.onDeviceChanged(device);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDeviceChanged(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/DeviceReadyListener", "onDeviceChanged"));
        }
        Object object = this.myFinishedLock;
        synchronized (object) {
            if (this.myFinished || !this.myDeviceFilter.apply((Object)device) || !device.isOnline()) {
                return;
            }
            if (device.getClients().length < 5 && device.getClient("android.process.acore") == null && device.getClient("com.google.android.wearable.app") == null) {
                this.myLogger.stdout(String.format("Device %1$s is online, waiting for processes to start up..", device.getName()));
                return;
            }
            this.myLogger.stdout("Device is ready: " + device.getName());
            this.myFinished = true;
        }
        Disposer.dispose((Disposable)this.myQueue);
        this.myCallback.onDeviceReady(device);
    }

    public void dispose() {
    }

    private class MyDeviceStateUpdate
    extends Update {
        @NotNull
        private final IDevice myDevice;

        public MyDeviceStateUpdate(IDevice device) {
            if (device == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/DeviceReadyListener$MyDeviceStateUpdate", "<init>"));
            }
            super((Object)device.getSerialNumber());
            this.myDevice = device;
        }

        public void run() {
            DeviceReadyListener.this.onDeviceChanged(this.myDevice);
            DeviceReadyListener.this.myQueue.queue((Update)new MyDeviceStateUpdate(this.myDevice));
        }
    }

    static interface Callback {
        public void onDeviceReady(@NotNull IDevice var1);
    }
}

