/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.build.OutputFile;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Variant;
import com.android.ddmlib.IDevice;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.ApkInfo;
import org.jetbrains.android.run.ApkProvider;
import org.jetbrains.android.run.ApkProviderUtil;
import org.jetbrains.android.run.ApkProvisionException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class GradleApkProvider
implements ApkProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.run.GradleApkProvider");
    private static final String DEFAULT_TEST_PACKAGE_SUFFIX = ".test";
    @NotNull
    private final AndroidFacet myFacet;
    private final boolean myTest;

    public GradleApkProvider(@NotNull AndroidFacet facet, boolean test) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/run/GradleApkProvider", "<init>"));
        }
        this.myFacet = facet;
        this.myTest = test;
    }

    @Override
    @NotNull
    public Collection<ApkInfo> getApks(@NotNull IDevice device) throws ApkProvisionException {
        BaseArtifact testArtifactInfo;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/GradleApkProvider", "getApks"));
        }
        AndroidGradleModel androidModel = AndroidGradleModel.get(this.myFacet);
        assert (androidModel != null);
        Variant selectedVariant = androidModel.getSelectedVariant();
        ArrayList<ApkInfo> apkList = new ArrayList<ApkInfo>();
        if (!androidModel.getAndroidProject().isLibrary()) {
            File apk = GradleApkProvider.getApk(selectedVariant, device);
            apkList.add(new ApkInfo(apk, this.getPackageName()));
        }
        if (this.myTest && (testArtifactInfo = androidModel.findSelectedTestArtifactInSelectedVariant()) instanceof AndroidArtifact) {
            AndroidArtifactOutput output = GradleUtil.getOutput((AndroidArtifact)testArtifactInfo);
            File testApk = output.getMainOutputFile().getOutputFile();
            String testPackageName = this.getTestPackageName();
            assert (testPackageName != null);
            apkList.add(new ApkInfo(testApk, testPackageName));
        }
        ArrayList<ApkInfo> arrayList = apkList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/GradleApkProvider", "getApks"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getPackageName() throws ApkProvisionException {
        String string = ApkProviderUtil.computePackageName(this.myFacet);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/GradleApkProvider", "getPackageName"));
        }
        return string;
    }

    @Override
    public String getTestPackageName() throws ApkProvisionException {
        AndroidGradleModel androidModel = AndroidGradleModel.get(this.myFacet);
        assert (androidModel != null);
        Variant selectedVariant = androidModel.getSelectedVariant();
        String testPackageName = selectedVariant.getMergedFlavor().getTestApplicationId();
        return testPackageName != null ? testPackageName : this.getPackageName() + DEFAULT_TEST_PACKAGE_SUFFIX;
    }

    @NotNull
    private static File getApk(@NotNull Variant variant, @NotNull IDevice device) throws ApkProvisionException {
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "org/jetbrains/android/run/GradleApkProvider", "getApk"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/run/GradleApkProvider", "getApk"));
        }
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        ArrayList outputs = Lists.newArrayList((Iterable)mainArtifact.getOutputs());
        if (outputs.isEmpty()) {
            throw new ApkProvisionException("No outputs for the main artifact of variant: " + variant.getDisplayName());
        }
        List abis = device.getAbis();
        int density = device.getDensity();
        Set variantAbiFilters = mainArtifact.getAbiFilters();
        List apkFiles = SplitOutputMatcher.computeBestOutput((List)outputs, (Collection)variantAbiFilters, (int)density, (Collection)abis);
        if (apkFiles.isEmpty()) {
            String message = AndroidBundle.message("deployment.failed.splitapk.nomatch", variant.getDisplayName(), outputs.size(), density, Joiner.on((String)", ").join((Iterable)abis));
            throw new ApkProvisionException(message);
        }
        File file = ((OutputFile)apkFiles.get(0)).getOutputFile();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/GradleApkProvider", "getApk"));
        }
        return file;
    }
}

