/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import org.jetbrains.android.run.SimpleLogger;
import org.jetbrains.annotations.NotNull;

public final class ProcessHandlerSimpleLogger
implements SimpleLogger {
    @NotNull
    private final ProcessHandler myProcessHandler;

    public ProcessHandlerSimpleLogger(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "org/jetbrains/android/run/ProcessHandlerSimpleLogger", "<init>"));
        }
        this.myProcessHandler = processHandler;
    }

    @Override
    public void stdout(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/android/run/ProcessHandlerSimpleLogger", "stdout"));
        }
        this.myProcessHandler.notifyTextAvailable(message + "\n", ProcessOutputTypes.STDOUT);
    }

    @Override
    public void stderr(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/android/run/ProcessHandlerSimpleLogger", "stderr"));
        }
        this.myProcessHandler.notifyTextAvailable(message + "\n", ProcessOutputTypes.STDERR);
    }
}

