/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.MaterialColorUtils;
import com.android.tools.idea.editors.theme.StateListPicker;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.rendering.ResourceNameValidator;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ColorPickerListener;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeSelectionModel;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.actions.CreateXmlResourcePanel;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidBaseLayoutRefactoringAction;
import org.jetbrains.android.refactoring.AndroidExtractStyleAction;
import org.jetbrains.android.resourceManagers.FileResourceProcessor;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.uipreview.ColorPicker;
import org.jetbrains.android.uipreview.ResourceDialogSouthPanel;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseResourceDialog
extends DialogWrapper
implements TreeSelectionListener {
    private static final String TYPE_KEY = "ResourceType";
    private static final String TEXT = "Text";
    private static final String COMBO = "Combo";
    private static final String IMAGE = "Image";
    private static final String NONE = "None";
    private static final Icon RESOURCE_ITEM_ICON = AllIcons.Css.Property;
    private final Module myModule;
    @Nullable
    private final XmlTag myTag;
    private final JBTabbedPane myContentPanel;
    private final ResourcePanel myProjectPanel;
    private final ResourcePanel mySystemPanel;
    private ResourceDialogTabComponent myColorPickerPanel;
    private ColorPicker myColorPicker;
    private ResourceDialogTabComponent myStateListPickerPanel;
    private StateListPicker myStateListPicker;
    private ResourcePickerListener myResourcePickerListener;
    private boolean myAllowCreateResource;
    private final Action myNewResourceAction;
    private final AnAction myNewResourceValueAction;
    private final AnAction myNewResourceFileAction;
    private final AnAction myExtractStyleAction;
    private String myResultResourceName;
    private boolean myOverwriteResource;
    private ResourceNameVisibility myResourceNameVisibility;

    public ChooseResourceDialog(@NotNull Module module, @NotNull ResourceType[] types, @Nullable String value, @Nullable XmlTag tag) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        this(module, types, value, tag, ResourceNameVisibility.HIDE, null);
    }

    public ChooseResourceDialog(@NotNull Module module, @NotNull ResourceType[] types, @Nullable String value, @Nullable XmlTag tag, ResourceNameVisibility resourceNameVisibility, @Nullable String resourceName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        this(module, null, types, value, tag, resourceNameVisibility, resourceName, null);
    }

    public ChooseResourceDialog(@NotNull Module module, @NotNull Configuration configuration, @NotNull ResourceType[] types, @NotNull ResourceHelper.StateList stateList, ResourceNameVisibility resourceNameVisibility, @Nullable String resourceName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        if (stateList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateList", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        this(module, configuration, types, null, null, resourceNameVisibility, resourceName, stateList);
    }

    private ChooseResourceDialog(@NotNull Module module, @Nullable Configuration configuration, @NotNull ResourceType[] types, @Nullable String value, @Nullable XmlTag tag, ResourceNameVisibility resourceNameVisibility, @Nullable String resourceName, @Nullable ResourceHelper.StateList stateList) {
        int index;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/android/uipreview/ChooseResourceDialog", "<init>"));
        }
        super(module.getProject());
        this.myAllowCreateResource = true;
        this.myNewResourceAction = new AbstractAction("New Resource", AllIcons.General.ComboArrowDown){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComponent component = (JComponent)e.getSource();
                ActionPopupMenu popupMenu = ChooseResourceDialog.this.createNewResourcePopupMenu();
                popupMenu.getComponent().show(component, 0, component.getHeight());
            }
        };
        this.myNewResourceValueAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ResourceType type = (ResourceType)this.getTemplatePresentation().getClientProperty(ChooseResourceDialog.TYPE_KEY);
                ChooseResourceDialog.this.createNewResourceValue(type);
            }
        };
        this.myNewResourceFileAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                ResourceType type = (ResourceType)this.getTemplatePresentation().getClientProperty(ChooseResourceDialog.TYPE_KEY);
                ChooseResourceDialog.this.createNewResourceFile(type);
            }
        };
        this.myExtractStyleAction = new AnAction("Extract Style..."){

            public void actionPerformed(AnActionEvent e) {
                ChooseResourceDialog.this.extractStyle();
            }
        };
        this.myOverwriteResource = false;
        this.myModule = module;
        this.myTag = tag;
        this.myResourceNameVisibility = resourceNameVisibility;
        this.setTitle("Resources");
        AndroidFacet facet = AndroidFacet.getInstance(module);
        this.myProjectPanel = new ResourcePanel(facet, types, false);
        this.mySystemPanel = new ResourcePanel(facet, types, true);
        this.myContentPanel = new JBTabbedPane();
        this.myContentPanel.addTab("Project", (Component)this.myProjectPanel.myComponent);
        this.myContentPanel.addTab("System", (Component)this.mySystemPanel.myComponent);
        this.myProjectPanel.myTreeBuilder.expandAll(null);
        this.mySystemPanel.myTreeBuilder.expandAll(null);
        boolean doSelection = value != null;
        int numberOfTabs = 2;
        if (ArrayUtil.contains((Object)ResourceType.COLOR, (Object[])types) || ArrayUtil.contains((Object)ResourceType.DRAWABLE, (Object[])types)) {
            Color color = ResourceHelper.parseColor(value);
            this.myColorPicker = new ColorPicker(this.myDisposable, color, true, new ColorPickerListener(){

                public void colorChanged(Color color) {
                    ChooseResourceDialog.this.notifyResourcePickerListeners(ResourceHelper.colorToString(color));
                }

                public void closed(@Nullable Color color) {
                }
            });
            this.myColorPicker.pickARGB();
            this.myColorPickerPanel = new ResourceDialogTabComponent(new JPanel(new BorderLayout()), ResourceType.COLOR, ResourceFolderType.VALUES);
            this.myColorPickerPanel.setBorder(null);
            this.myColorPickerPanel.addCenter(this.myColorPicker);
            this.myContentPanel.addTab("Color", (Component)((Object)this.myColorPickerPanel));
            ++numberOfTabs;
            if (this.myResourceNameVisibility != ResourceNameVisibility.HIDE) {
                this.myColorPickerPanel.addResourceDialogSouthPanel(resourceName, false);
            }
            if (color != null) {
                this.myContentPanel.setSelectedIndex(numberOfTabs - 1);
                doSelection = false;
            }
            this.myColorPickerPanel.setValidator(ResourceNameValidator.create(false, AppResourceRepository.getAppResources(this.myModule, true), ResourceType.COLOR, false));
        }
        if (stateList != null) {
            ResourceFolderType resFolderType = stateList.getType();
            ResourceType resType = ResourceType.getEnum((String)resFolderType.getName());
            assert (resType != null);
            assert (configuration != null);
            this.myStateListPicker = new StateListPicker(stateList, module, configuration);
            this.myStateListPickerPanel = new ResourceDialogTabComponent(new JPanel(new BorderLayout()), resType, resFolderType);
            this.myStateListPickerPanel.setBorder(null);
            this.myStateListPickerPanel.addCenter(this.myStateListPicker);
            this.myStateListPickerPanel.setChangeFileNameVisible(false);
            this.myContentPanel.addTab("StateList", (Component)((Object)this.myStateListPickerPanel));
            ++numberOfTabs;
            if (this.myResourceNameVisibility != ResourceNameVisibility.HIDE) {
                this.myStateListPickerPanel.addResourceDialogSouthPanel(resourceName, true);
            }
            this.myContentPanel.setSelectedIndex(numberOfTabs - 1);
            this.myStateListPickerPanel.setValidator(ResourceNameValidator.create(true, AppResourceRepository.getAppResources(this.myModule, true), resType, true));
        }
        if (doSelection && value.startsWith("@") && (index = (value = StringUtil.replace((String)value, (String)"+", (String)"")).indexOf(47)) != -1) {
            String type;
            ResourcePanel panel;
            String name = value.substring(index + 1);
            if (value.startsWith("@android:")) {
                panel = this.mySystemPanel;
                type = value.substring("@android:".length(), index);
            } else {
                panel = this.myProjectPanel;
                type = value.substring(1, index);
            }
            this.myContentPanel.setSelectedComponent((Component)panel.myComponent);
            panel.select(type, name);
        }
        this.myContentPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ChooseResourceDialog.this.valueChanged(null);
            }
        });
        this.valueChanged(null);
        this.init();
        this.doValidate();
    }

    protected boolean postponeValidation() {
        return false;
    }

    private String getErrorString(@NotNull ResourceDialogTabComponent tabComponent) {
        if (tabComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabComponent", "org/jetbrains/android/uipreview/ChooseResourceDialog", "getErrorString"));
        }
        this.myOverwriteResource = false;
        String result = null;
        ResourceNameValidator validator = tabComponent.getValidator();
        if (validator != null) {
            String enteredName = tabComponent.getResourceNameField().getText();
            if (validator.doesResourceExist(enteredName)) {
                result = String.format("Saving this color will override existing resource %1$s.", enteredName);
                this.myOverwriteResource = true;
            } else {
                result = validator.getErrorText(enteredName);
            }
        }
        return result;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        boolean okActionEnabled;
        Component selectedComponent = this.myContentPanel.getSelectedComponent();
        ValidationInfo error = null;
        if (selectedComponent == this.mySystemPanel.myComponent || selectedComponent == this.myProjectPanel.myComponent) {
            boolean isProjectPanel = selectedComponent == this.myProjectPanel.myComponent;
            ResourcePanel panel = isProjectPanel ? this.myProjectPanel : this.mySystemPanel;
            ResourceItem element = ChooseResourceDialog.getSelectedElement(panel.myTreeBuilder, ResourceItem.class);
            okActionEnabled = element != null;
        } else {
            if (this.myResourceNameVisibility != ResourceNameVisibility.HIDE) {
                ResourceDialogTabComponent tabComponent = (ResourceDialogTabComponent)((Object)selectedComponent);
                String errorText = this.getErrorString(tabComponent);
                if (errorText != null && !this.myOverwriteResource) {
                    tabComponent.getResourceNameMessage().setText("");
                    error = new ValidationInfo(errorText, (JComponent)tabComponent.getResourceNameField());
                } else {
                    tabComponent.getResourceNameMessage().setText(errorText != null ? errorText : "");
                    error = tabComponent.getLocationSettings().doValidate();
                }
            }
            if (error == null && selectedComponent == this.myStateListPickerPanel) {
                error = this.myStateListPicker.getPrivateResourceError();
            }
            if (error == null && selectedComponent == this.myStateListPickerPanel) {
                int minDirectoriesApi = ThemeEditorUtils.getMinFolderApi(this.myStateListPickerPanel.getLocationSettings().getDirNames(), this.myModule);
                error = this.myStateListPicker.getApiError(minDirectoriesApi);
            }
            okActionEnabled = error == null;
        }
        this.setOKActionEnabled(okActionEnabled);
        return error;
    }

    public void setResourcePickerListener(ResourcePickerListener resourcePickerListener) {
        this.myResourcePickerListener = resourcePickerListener;
    }

    protected void notifyResourcePickerListeners(String resource) {
        if (this.myResourcePickerListener != null) {
            this.myResourcePickerListener.resourceChanged(resource);
        }
    }

    public void generateColorSuggestions(@NotNull Color primaryColor, @NotNull String attributeName) {
        if (primaryColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryColor", "org/jetbrains/android/uipreview/ChooseResourceDialog", "generateColorSuggestions"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "org/jetbrains/android/uipreview/ChooseResourceDialog", "generateColorSuggestions"));
        }
        List<Color> suggestedColors = null;
        if ("colorPrimary".equals(attributeName)) {
            suggestedColors = MaterialColorUtils.suggestPrimaryColors();
        } else if ("colorPrimaryDark".equals(attributeName)) {
            suggestedColors = MaterialColorUtils.suggestPrimaryDarkColors(primaryColor);
        } else if ("colorAccent".equals(attributeName)) {
            suggestedColors = MaterialColorUtils.suggestAccentColors(primaryColor);
        }
        if (suggestedColors != null) {
            this.myColorPicker.setRecommendedColors(suggestedColors);
        }
    }

    private ActionPopupMenu createNewResourcePopupMenu() {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        ResourceGroup resourceGroup = ChooseResourceDialog.getSelectedElement(this.myProjectPanel.myTreeBuilder, ResourceGroup.class);
        if (resourceGroup == null) {
            resourceGroup = ChooseResourceDialog.getSelectedElement(this.myProjectPanel.myTreeBuilder, ResourceItem.class).getGroup();
        }
        if (AndroidResourceUtil.XML_FILE_RESOURCE_TYPES.contains(resourceGroup.getType())) {
            this.myNewResourceFileAction.getTemplatePresentation().setText("New " + resourceGroup + " File...");
            this.myNewResourceFileAction.getTemplatePresentation().putClientProperty(TYPE_KEY, (Object)resourceGroup.getType());
            actionGroup.add(this.myNewResourceFileAction);
        }
        if (AndroidResourceUtil.VALUE_RESOURCE_TYPES.contains(resourceGroup.getType())) {
            String title = "New " + resourceGroup + " Value...";
            if (resourceGroup.getType() == ResourceType.LAYOUT) {
                title = "New Layout Alias";
            }
            this.myNewResourceValueAction.getTemplatePresentation().setText(title);
            this.myNewResourceValueAction.getTemplatePresentation().putClientProperty(TYPE_KEY, (Object)resourceGroup.getType());
            actionGroup.add(this.myNewResourceValueAction);
        }
        if (this.myTag != null && ResourceType.STYLE.equals((Object)resourceGroup.getType())) {
            boolean enabled = AndroidBaseLayoutRefactoringAction.getLayoutViewElement(this.myTag) != null && AndroidExtractStyleAction.doIsEnabled(this.myTag);
            this.myExtractStyleAction.getTemplatePresentation().setEnabled(enabled);
            actionGroup.add(this.myExtractStyleAction);
        }
        return actionManager.createActionPopupMenu("unknown", (ActionGroup)actionGroup);
    }

    private void createNewResourceValue(ResourceType resourceType) {
        CreateXmlResourceDialog dialog = new CreateXmlResourceDialog(this.myModule, resourceType, null, null, true);
        dialog.setTitle("New " + StringUtil.capitalize((String)resourceType.getDisplayName()) + " Value Resource");
        if (!dialog.showAndGet()) {
            return;
        }
        Module moduleToPlaceResource = dialog.getModule();
        if (moduleToPlaceResource == null) {
            return;
        }
        String fileName = dialog.getFileName();
        List<String> dirNames = dialog.getDirNames();
        String resValue = dialog.getValue();
        String resName = dialog.getResourceName();
        if (!AndroidResourceUtil.createValueResource(moduleToPlaceResource, resName, resourceType, fileName, dirNames, resValue)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myModule.getProject()).commitAllDocuments();
        this.myResultResourceName = "@" + resourceType.getName() + "/" + resName;
        this.close(0);
    }

    private void createNewResourceFile(ResourceType resourceType) {
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        XmlFile newFile = CreateResourceFileAction.createFileResource(facet, resourceType, null, null, null, true, null);
        if (newFile != null) {
            String name = newFile.getName();
            int index = name.lastIndexOf(46);
            if (index != -1) {
                name = name.substring(0, index);
            }
            this.myResultResourceName = "@" + resourceType.getName() + "/" + name;
            this.close(0);
        }
    }

    private void extractStyle() {
        String resName = AndroidExtractStyleAction.doExtractStyle(this.myModule, this.myTag, false, null);
        if (resName == null) {
            return;
        }
        this.myResultResourceName = "@style/" + resName;
        this.close(0);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myProjectPanel.myTree;
    }

    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray;
        if (this.myAllowCreateResource) {
            Action[] actionArray2 = new Action[1];
            actionArray = actionArray2;
            actionArray2[0] = this.myNewResourceAction;
        } else {
            actionArray = new Action[]{};
        }
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog", "createLeftSideActions"));
        }
        return actionArray;
    }

    public ChooseResourceDialog setAllowCreateResource(boolean allowCreateResource) {
        this.myAllowCreateResource = allowCreateResource;
        return this;
    }

    public boolean getAllowCreateResource() {
        return this.myAllowCreateResource;
    }

    public void openLocationSettings() {
        ResourceDialogTabComponent tabComponent = (ResourceDialogTabComponent)((Object)this.myContentPanel.getSelectedComponent());
        tabComponent.openLocationSettings();
    }

    protected void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myProjectPanel.myTreeBuilder);
        Disposer.dispose((Disposable)this.mySystemPanel.myTreeBuilder);
    }

    public String getResourceName() {
        return this.myResultResourceName;
    }

    protected void doOKAction() {
        this.valueChanged(null);
        if (this.myContentPanel.getSelectedComponent() == this.myColorPickerPanel && this.myResourceNameVisibility != ResourceNameVisibility.HIDE) {
            String colorName = this.myColorPickerPanel.getResourceNameField().getText();
            Module module = this.myColorPickerPanel.getLocationSettings().getModule();
            String fileName = this.myColorPickerPanel.getLocationSettings().getFileName();
            List<String> dirNames = this.myColorPickerPanel.getLocationSettings().getDirNames();
            assert (module != null);
            AndroidFacet facet = AndroidFacet.getInstance(module);
            assert (facet != null);
            if (!AndroidResourceUtil.changeColorResource(facet, colorName, this.myResultResourceName, fileName, dirNames)) {
                AndroidResourceUtil.createValueResource(module, colorName, ResourceType.COLOR, fileName, dirNames, this.myResultResourceName);
            }
            this.myResultResourceName = "@color/" + colorName;
        } else if (this.myContentPanel.getSelectedComponent() == this.myStateListPickerPanel && this.myResourceNameVisibility != ResourceNameVisibility.HIDE) {
            String stateListName = this.myStateListPickerPanel.getResourceNameField().getText();
            List<String> dirNames = this.myStateListPickerPanel.getLocationSettings().getDirNames();
            ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType((String)dirNames.get(0));
            ResourceType resourceType = ResourceType.getEnum((String)resourceFolderType.getName());
            List<VirtualFile> files = null;
            if (resourceType != null) {
                files = AndroidResourceUtil.findOrCreateStateListFiles(this.myModule, resourceFolderType, resourceType, stateListName, dirNames);
            }
            if (files != null) {
                this.myStateListPicker.updateStateList(files);
            }
            if (resourceFolderType == ResourceFolderType.COLOR) {
                this.myResultResourceName = "@color/" + stateListName;
            } else if (resourceFolderType == ResourceFolderType.DRAWABLE) {
                this.myResultResourceName = "@drawable/" + stateListName;
            }
        }
        super.doOKAction();
    }

    @Nullable
    private static <T> T getSelectedElement(AbstractTreeBuilder treeBuilder, Class<T> elementClass) {
        Set elements = treeBuilder.getSelectedElements(elementClass);
        return elements.isEmpty() ? null : (T)elements.iterator().next();
    }

    @Override
    public void valueChanged(@Nullable TreeSelectionEvent e) {
        Component selectedComponent = this.myContentPanel.getSelectedComponent();
        if (selectedComponent == this.myColorPickerPanel) {
            Color color = this.myColorPicker.getColor();
            this.myNewResourceAction.setEnabled(false);
            this.myResultResourceName = ResourceHelper.colorToString(color);
        } else if (selectedComponent == this.myStateListPickerPanel) {
            this.myNewResourceAction.setEnabled(false);
            this.myResultResourceName = null;
        } else {
            boolean isProjectPanel = selectedComponent == this.myProjectPanel.myComponent;
            ResourcePanel panel = isProjectPanel ? this.myProjectPanel : this.mySystemPanel;
            ResourceItem element = ChooseResourceDialog.getSelectedElement(panel.myTreeBuilder, ResourceItem.class);
            this.myNewResourceAction.setEnabled(isProjectPanel && !panel.myTreeBuilder.getSelectedElements().isEmpty());
            if (element == null) {
                this.myResultResourceName = null;
            } else {
                String prefix = panel == this.myProjectPanel ? "@" : "@android:";
                this.myResultResourceName = prefix + element.getName();
            }
            panel.showPreview(element);
        }
        this.notifyResourcePickerListeners(this.myResultResourceName);
    }

    private static String getResourceElementValue(ResourceElement element) {
        String text = element.getRawText();
        if (StringUtil.isEmpty((String)text)) {
            return element.getXmlTag().getText();
        }
        return text;
    }

    private class ResourceDialogTabComponent
    extends JBScrollPane {
        private final JPanel myCenterPanel;
        private final ResourceType myResourceType;
        private final ResourceDialogSouthPanel mySouthPanel;
        private ResourceNameValidator myValidator;
        private final CreateXmlResourcePanel myLocationSettings;

        public ResourceDialogTabComponent(@NotNull JPanel centerPanel, @NotNull ResourceType resourceType, ResourceFolderType folderType) {
            if (centerPanel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "centerPanel", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceDialogTabComponent", "<init>"));
            }
            if (resourceType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceType", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceDialogTabComponent", "<init>"));
            }
            if (folderType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderType", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceDialogTabComponent", "<init>"));
            }
            super((Component)centerPanel);
            this.mySouthPanel = new ResourceDialogSouthPanel();
            this.myCenterPanel = centerPanel;
            this.myResourceType = resourceType;
            this.myLocationSettings = new CreateXmlResourcePanel(ChooseResourceDialog.this.myModule, resourceType, null, folderType);
        }

        public void addResourceDialogSouthPanel(@Nullable String resourceName, final boolean allowXmlFile) {
            if (resourceName != null) {
                this.mySouthPanel.getResourceNameField().setText(resourceName);
            }
            this.myCenterPanel.add((Component)this.mySouthPanel.getFullPanel(), "South");
            this.mySouthPanel.setExpertPanel(this.myLocationSettings.getPanel());
            this.myLocationSettings.addModuleComboActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Module module = ResourceDialogTabComponent.this.myLocationSettings.getModule();
                    assert (module != null);
                    ResourceDialogTabComponent.this.myValidator = ResourceNameValidator.create(allowXmlFile, AppResourceRepository.getAppResources(module, true), ResourceDialogTabComponent.this.myResourceType, allowXmlFile);
                }
            });
        }

        public void addCenter(@NotNull Component component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceDialogTabComponent", "addCenter"));
            }
            this.myCenterPanel.add(component);
        }

        public void setValidator(@NotNull ResourceNameValidator validator) {
            if (validator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validator", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceDialogTabComponent", "setValidator"));
            }
            this.myValidator = validator;
        }

        @Nullable
        public ResourceNameValidator getValidator() {
            return this.myValidator;
        }

        @NotNull
        public JLabel getResourceNameMessage() {
            JBLabel jBLabel = this.mySouthPanel.getResourceNameMessage();
            if (jBLabel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceDialogTabComponent", "getResourceNameMessage"));
            }
            return jBLabel;
        }

        @NotNull
        public JTextField getResourceNameField() {
            JTextField jTextField = this.mySouthPanel.getResourceNameField();
            if (jTextField == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceDialogTabComponent", "getResourceNameField"));
            }
            return jTextField;
        }

        @NotNull
        public CreateXmlResourcePanel getLocationSettings() {
            CreateXmlResourcePanel createXmlResourcePanel = this.myLocationSettings;
            if (createXmlResourcePanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceDialogTabComponent", "getLocationSettings"));
            }
            return createXmlResourcePanel;
        }

        public void openLocationSettings() {
            this.mySouthPanel.setOn(true);
        }

        public void setChangeFileNameVisible(boolean isVisible) {
            this.myLocationSettings.setChangeFileNameVisible(isVisible);
        }
    }

    public static class SizedIcon
    implements Icon {
        private final int myWidth;
        private final int myHeight;
        private final Image myImage;

        public SizedIcon(int maxWidth, int maxHeight, Image image) {
            this.myWidth = Math.min(maxWidth, image.getWidth(null));
            this.myHeight = Math.min(maxHeight, image.getHeight(null));
            this.myImage = image;
        }

        public SizedIcon(int maxWidth, int maxHeight, ImageIcon icon) {
            this(maxWidth, maxHeight, icon.getImage());
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawImage(this.myImage, x, y, this.myWidth, this.myHeight, null);
        }

        @Override
        public int getIconWidth() {
            return this.myWidth;
        }

        @Override
        public int getIconHeight() {
            return this.myHeight;
        }
    }

    public static final class TreeNodeDescriptor
    extends NodeDescriptor {
        private final Object myElement;

        public TreeNodeDescriptor(@Nullable NodeDescriptor parentDescriptor, Object element) {
            super(null, parentDescriptor);
            this.myElement = element;
        }

        public TreeNodeDescriptor(@Nullable NodeDescriptor parentDescriptor, Object element, String name) {
            this(parentDescriptor, element);
            this.myName = name;
        }

        public boolean update() {
            return true;
        }

        public Object getElement() {
            return this.myElement;
        }
    }

    private static class TreeContentProvider
    extends AbstractTreeStructure {
        private final Object myTreeRoot = new Object();
        private final ResourceGroup[] myGroups;

        public TreeContentProvider(ResourceGroup[] groups) {
            this.myGroups = groups;
        }

        public Object getRootElement() {
            return this.myTreeRoot;
        }

        public Object[] getChildElements(Object element) {
            if (element == this.myTreeRoot) {
                return this.myGroups;
            }
            if (element instanceof ResourceGroup) {
                ResourceGroup group = (ResourceGroup)element;
                return group.getItems().toArray();
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public Object getParentElement(Object element) {
            if (element instanceof ResourceItem) {
                ResourceItem resource = (ResourceItem)element;
                return resource.getGroup();
            }
            return null;
        }

        @NotNull
        public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
            TreeNodeDescriptor descriptor = new TreeNodeDescriptor(parentDescriptor, element, element == null ? null : element.toString());
            if (element instanceof ResourceGroup) {
                descriptor.setIcon(AllIcons.Nodes.TreeClosed);
            } else if (element instanceof ResourceItem) {
                descriptor.setIcon(((ResourceItem)element).getIcon());
            }
            TreeNodeDescriptor treeNodeDescriptor = descriptor;
            if (treeNodeDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/uipreview/ChooseResourceDialog$TreeContentProvider", "createDescriptor"));
            }
            return treeNodeDescriptor;
        }

        public boolean hasSomethingToCommit() {
            return false;
        }

        public void commit() {
        }
    }

    public static class ResourceItem {
        private final ResourceGroup myGroup;
        private final String myName;
        private final VirtualFile myFile;
        private final Icon myIcon;
        private String myPreviewString;
        private List<ResourceElement> myPreviewResources;
        private DefaultComboBoxModel myPreviewComboModel;
        private String myDefaultSelection;
        private Icon myPreviewIcon;

        public ResourceItem(@NotNull ResourceGroup group, @NotNull String name, @Nullable VirtualFile file, Icon icon) {
            if (group == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceItem", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceItem", "<init>"));
            }
            this.myGroup = group;
            this.myName = name;
            this.myFile = file;
            this.myIcon = icon;
        }

        public ResourceGroup getGroup() {
            return this.myGroup;
        }

        public String getName() {
            return this.myGroup.getName() + "/" + this.myName;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        public String getPreviewString() {
            return this.myPreviewString;
        }

        public void setPreviewString(String previewString) {
            this.myPreviewString = previewString;
        }

        public List<ResourceElement> getPreviewResources() {
            return this.myPreviewResources;
        }

        public DefaultComboBoxModel getPreviewComboModel() {
            return this.myPreviewComboModel;
        }

        public String getPreviewComboDefaultSelection() {
            return this.myDefaultSelection;
        }

        public void setPreviewResources(List<ResourceElement> previewResources, DefaultComboBoxModel previewComboModel, String defaultSelection) {
            this.myPreviewResources = previewResources;
            this.myPreviewComboModel = previewComboModel;
            this.myDefaultSelection = defaultSelection;
        }

        public Icon getPreviewIcon() {
            return this.myPreviewIcon;
        }

        public void setPreviewIcon(Icon previewIcon) {
            this.myPreviewIcon = previewIcon;
        }

        public String toString() {
            return this.myName;
        }
    }

    public static class ResourceGroup {
        private List<ResourceItem> myItems = new ArrayList<ResourceItem>();
        private final ResourceType myType;

        public ResourceGroup(ResourceType type, ResourceManager manager) {
            this(type, manager, true);
        }

        public ResourceGroup(ResourceType type, ResourceManager manager, boolean includeFileResources) {
            this.myType = type;
            String resourceType = type.getName();
            Collection<String> resourceNames = manager.getValueResourceNames(resourceType);
            for (String resourceName : resourceNames) {
                this.myItems.add(new ResourceItem(this, resourceName, null, RESOURCE_ITEM_ICON));
            }
            final HashSet fileNames = new HashSet();
            if (includeFileResources) {
                manager.processFileResources(resourceType, new FileResourceProcessor(){

                    @Override
                    public boolean process(@NotNull VirtualFile resFile, @NotNull String resName, @NotNull String resFolderType) {
                        if (resFile == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resFile", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceGroup$1", "process"));
                        }
                        if (resName == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resName", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceGroup$1", "process"));
                        }
                        if (resFolderType == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resFolderType", "org/jetbrains/android/uipreview/ChooseResourceDialog$ResourceGroup$1", "process"));
                        }
                        if (fileNames.add(resName)) {
                            ResourceGroup.this.myItems.add(new ResourceItem(ResourceGroup.this, resName, resFile, resFile.getFileType().getIcon()));
                        }
                        return true;
                    }
                });
            }
            if (type == ResourceType.ID) {
                for (String id : manager.getIds(true)) {
                    if (resourceNames.contains(id)) continue;
                    this.myItems.add(new ResourceItem(this, id, null, RESOURCE_ITEM_ICON));
                }
            }
            Collections.sort(this.myItems, new Comparator<ResourceItem>(){

                @Override
                public int compare(ResourceItem resource1, ResourceItem resource2) {
                    return resource1.toString().compareTo(resource2.toString());
                }
            });
        }

        public ResourceType getType() {
            return this.myType;
        }

        public String getName() {
            return this.myType.getName();
        }

        public List<ResourceItem> getItems() {
            return this.myItems;
        }

        public String toString() {
            return this.myType.getDisplayName();
        }
    }

    private class ResourcePanel {
        public final Tree myTree = new Tree();
        public final AbstractTreeBuilder myTreeBuilder;
        public final JBSplitter myComponent;
        private final JPanel myPreviewPanel;
        private final JTextArea myTextArea;
        private final JTextArea myComboTextArea;
        private final JComboBox myComboBox;
        private final JLabel myImageComponent;
        private final JLabel myNoPreviewComponent;
        private final ResourceGroup[] myGroups;
        private final ResourceManager myManager;

        public ResourcePanel(AndroidFacet facet, ResourceType[] types, boolean system) {
            this.myTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
            this.myTree.setScrollsOnExpand(true);
            this.myTree.setRootVisible(false);
            this.myTree.setShowsRootHandles(true);
            new DoubleClickListener(){

                protected boolean onDoubleClick(MouseEvent e) {
                    if (!ResourcePanel.this.myTreeBuilder.getSelectedElements(ResourceItem.class).isEmpty()) {
                        ChooseResourceDialog.this.close(0);
                        return true;
                    }
                    return false;
                }
            }.installOn((Component)this.myTree);
            ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
            TreeUtil.installActions((JTree)this.myTree);
            this.myManager = facet.getResourceManager(system ? "android" : null);
            if (ArrayUtil.contains((Object)ResourceType.DRAWABLE, (Object[])types) && !ArrayUtil.contains((Object)ResourceType.COLOR, (Object[])types)) {
                this.myGroups = new ResourceGroup[types.length + 1];
                this.myGroups[types.length] = new ResourceGroup(ResourceType.COLOR, this.myManager, false);
            } else {
                this.myGroups = new ResourceGroup[types.length];
            }
            for (int i = 0; i < types.length; ++i) {
                this.myGroups[i] = new ResourceGroup(types[i], this.myManager);
            }
            this.myTreeBuilder = new AbstractTreeBuilder((JTree)this.myTree, (DefaultTreeModel)this.myTree.getModel(), (AbstractTreeStructure)new TreeContentProvider(this.myGroups), null);
            this.myTreeBuilder.initRootNode();
            TreeSelectionModel selectionModel = this.myTree.getSelectionModel();
            selectionModel.setSelectionMode(1);
            selectionModel.addTreeSelectionListener(ChooseResourceDialog.this);
            this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
            new TreeSpeedSearch(this.myTree, TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING, true);
            this.myComponent = new JBSplitter(true, 0.8f);
            this.myComponent.setSplitterProportionKey("android.resource_dialog_splitter");
            this.myComponent.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myTree));
            this.myPreviewPanel = new JPanel(new CardLayout());
            this.myComponent.setSecondComponent((JComponent)this.myPreviewPanel);
            this.myTextArea = new JTextArea(5, 20);
            this.myTextArea.setEditable(false);
            this.myPreviewPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTextArea), ChooseResourceDialog.TEXT);
            this.myComboTextArea = new JTextArea(5, 20);
            this.myComboTextArea.setEditable(false);
            this.myComboBox = new JComboBox();
            this.myComboBox.setMaximumRowCount(15);
            this.myComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List resources = (List)ResourcePanel.this.myComboBox.getClientProperty(ChooseResourceDialog.COMBO);
                    ResourcePanel.this.myComboTextArea.setText(ChooseResourceDialog.getResourceElementValue((ResourceElement)resources.get(ResourcePanel.this.myComboBox.getSelectedIndex())));
                }
            });
            JPanel comboPanel = new JPanel(new BorderLayout(0, 1){

                @Override
                public void layoutContainer(Container target) {
                    super.layoutContainer(target);
                    Rectangle bounds = ResourcePanel.this.myComboBox.getBounds();
                    Dimension size = ResourcePanel.this.myComboBox.getPreferredSize();
                    size.width += 20;
                    ResourcePanel.this.myComboBox.setBounds((int)bounds.getMaxX() - size.width, bounds.y, size.width, size.height);
                }
            });
            comboPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myComboTextArea), "Center");
            comboPanel.add((Component)this.myComboBox, "South");
            this.myPreviewPanel.add((Component)comboPanel, ChooseResourceDialog.COMBO);
            this.myImageComponent = new JLabel();
            this.myImageComponent.setHorizontalAlignment(0);
            this.myImageComponent.setVerticalAlignment(0);
            this.myPreviewPanel.add((Component)this.myImageComponent, ChooseResourceDialog.IMAGE);
            this.myNoPreviewComponent = new JLabel("No Preview");
            this.myNoPreviewComponent.setHorizontalAlignment(0);
            this.myNoPreviewComponent.setVerticalAlignment(0);
            this.myPreviewPanel.add((Component)this.myNoPreviewComponent, ChooseResourceDialog.NONE);
        }

        /*
         * Unable to fully structure code
         */
        public void showPreview(@Nullable ResourceItem element) {
            block15: {
                layout = (CardLayout)this.myPreviewPanel.getLayout();
                if (element == null || element.getGroup().getType() == ResourceType.ID) {
                    layout.show(this.myPreviewPanel, "None");
                    return;
                }
                try {
                    block16: {
                        block17: {
                            file = element.getFile();
                            if (file != null) break block16;
                            value = element.getPreviewString();
                            if (value != null) break block17;
                            resources = element.getPreviewResources();
                            if (resources != null) ** GOTO lbl38
                            time = System.currentTimeMillis();
                            resources = this.myManager.findValueResources(element.getGroup().getType().getName(), element.toString());
                            if (ApplicationManagerEx.getApplicationEx().isInternal()) {
                                System.out.println("Time: " + (System.currentTimeMillis() - time));
                            }
                            if ((size = resources.size()) == 1) {
                                value = ChooseResourceDialog.access$600(resources.get(0));
                                element.setPreviewString(value);
                            } else {
                                if (size > 1) {
                                    resources = new ArrayList<ResourceElement>(resources);
                                    Collections.sort(resources, new Comparator<ResourceElement>(){

                                        @Override
                                        public int compare(ResourceElement element1, ResourceElement element2) {
                                            PsiDirectory directory1 = element1.getXmlTag().getContainingFile().getParent();
                                            PsiDirectory directory2 = element2.getXmlTag().getContainingFile().getParent();
                                            if (directory1 == null && directory2 == null) {
                                                return 0;
                                            }
                                            if (directory2 == null) {
                                                return 1;
                                            }
                                            if (directory1 == null) {
                                                return -1;
                                            }
                                            return directory1.getName().compareTo(directory2.getName());
                                        }
                                    });
                                    model = new DefaultComboBoxModel<String>();
                                    defaultSelection = null;
                                    for (i = 0; i < size; ++i) {
                                        resource = resources.get(i);
                                        directory = resource.getXmlTag().getContainingFile().getParent();
                                        name = directory == null ? "unknown-" + i : directory.getName();
                                        model.addElement(name);
                                        if (defaultSelection != null || !"values".equalsIgnoreCase(name)) continue;
                                        defaultSelection = name;
                                    }
                                    element.setPreviewResources(resources, model, defaultSelection);
                                    this.showComboPreview(element);
                                    return;
                                }
                                layout.show(this.myPreviewPanel, "None");
                                return;
lbl38:
                                // 1 sources

                                this.showComboPreview(element);
                                return;
                            }
                        }
                        if (value == null) {
                            layout.show(this.myPreviewPanel, "None");
                            return;
                        }
                        this.myTextArea.setText(value);
                        layout.show(this.myPreviewPanel, "Text");
                        break block15;
                    }
                    if (ImageFileTypeManager.getInstance().isImage(file)) {
                        icon = element.getPreviewIcon();
                        if (icon == null) {
                            icon = new SizedIcon(100, 100, new ImageIcon(file.getPath()));
                            element.setPreviewIcon(icon);
                        }
                        this.myImageComponent.setIcon(icon);
                        layout.show(this.myPreviewPanel, "Image");
                    } else if (file.getFileType() == XmlFileType.INSTANCE) {
                        value = element.getPreviewString();
                        if (value == null) {
                            value = new String(file.contentsToByteArray());
                            element.setPreviewString(value);
                        }
                        this.myTextArea.setText(value);
                        this.myTextArea.setEditable(false);
                        layout.show(this.myPreviewPanel, "Text");
                    } else {
                        layout.show(this.myPreviewPanel, "None");
                    }
                }
                catch (IOException e) {
                    layout.show(this.myPreviewPanel, "None");
                }
            }
        }

        private void showComboPreview(ResourceItem element) {
            int index;
            List<ResourceElement> resources = element.getPreviewResources();
            String selection = (String)this.myComboBox.getSelectedItem();
            if (selection == null) {
                selection = element.getPreviewComboDefaultSelection();
            }
            if ((index = element.getPreviewComboModel().getIndexOf(selection)) == -1) {
                index = 0;
            }
            this.myComboBox.setModel(element.getPreviewComboModel());
            this.myComboBox.putClientProperty(ChooseResourceDialog.COMBO, resources);
            this.myComboBox.setSelectedIndex(index);
            this.myComboTextArea.setText(ChooseResourceDialog.getResourceElementValue(resources.get(index)));
            CardLayout layout = (CardLayout)this.myPreviewPanel.getLayout();
            layout.show(this.myPreviewPanel, ChooseResourceDialog.COMBO);
        }

        private void select(String type, String name) {
            for (ResourceGroup group : this.myGroups) {
                if (!type.equalsIgnoreCase(group.getName())) continue;
                for (ResourceItem item : group.getItems()) {
                    if (!name.equals(item.toString())) continue;
                    this.myTreeBuilder.select((Object)item);
                    return;
                }
                return;
            }
        }
    }

    public static enum ResourceNameVisibility {
        HIDE,
        FORCE;

    }

    public static interface ResourcePickerListener {
        public void resourceChanged(String var1);
    }
}

