/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.chartlib;

import com.android.tools.chartlib.CircularArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TimelineData {
    private final int myStreams;
    private final List<Sample> mSamples;
    private long mStart;
    private float mMaxTotal;

    public TimelineData(int streams, int capacity) {
        this.myStreams = streams;
        this.mSamples = new CircularArrayList<Sample>(capacity);
        this.clear();
    }

    public synchronized long getStartTime() {
        return this.mStart;
    }

    public int getStreamCount() {
        return this.myStreams;
    }

    public synchronized float getMaxTotal() {
        return this.mMaxTotal;
    }

    public synchronized void add(long time, int type, float ... values) {
        this.add(new Sample((float)(time - this.mStart) / 1000.0f, type, values));
    }

    private static List<Sample> convertAreasToSamples(float time, int type, float[] areas, Sample lastSample) {
        float[] startValues;
        int streamSize = areas.length;
        float startTime = lastSample != null ? lastSample.time : 0.0f;
        float[] fArray = startValues = lastSample != null ? lastSample.values : new float[streamSize];
        assert (streamSize == startValues.length);
        float maxInterval = time - startTime;
        if (maxInterval <= 0.0f) {
            return new ArrayList<Sample>();
        }
        float[] nonZeroIntervalsForStreams = new float[streamSize];
        float[] endValuesForStreams = new float[streamSize];
        for (int i = 0; i < streamSize; ++i) {
            if (startValues[i] * maxInterval / 2.0f < areas[i]) {
                nonZeroIntervalsForStreams[i] = maxInterval;
                endValuesForStreams[i] = areas[i] * 2.0f / maxInterval - startValues[i];
                continue;
            }
            if (areas[i] == 0.0f) {
                nonZeroIntervalsForStreams[i] = maxInterval;
                endValuesForStreams[i] = 0.0f;
                continue;
            }
            nonZeroIntervalsForStreams[i] = areas[i] * 2.0f / startValues[i];
            endValuesForStreams[i] = 0.0f;
        }
        float[] ascendingIntervals = Arrays.copyOf(nonZeroIntervalsForStreams, streamSize);
        Arrays.sort(ascendingIntervals);
        ArrayList<Sample> sampleList = new ArrayList<Sample>();
        for (float interval : ascendingIntervals) {
            float[] sampleValues = new float[streamSize];
            for (int j = 0; j < streamSize; ++j) {
                sampleValues[j] = startValues[j] - (startValues[j] - endValuesForStreams[j]) * interval / nonZeroIntervalsForStreams[j];
                if (!(sampleValues[j] < 0.0f)) continue;
                sampleValues[j] = 0.0f;
            }
            sampleList.add(new Sample(interval + startTime, type, sampleValues));
            if (interval == maxInterval) break;
        }
        if (ascendingIntervals[streamSize - 1] < maxInterval) {
            sampleList.add(new Sample(time, type, new float[streamSize]));
        }
        return sampleList;
    }

    public synchronized void addFromArea(long timeMills, int type, float ... areas) {
        float timeForStart = (float)(timeMills - this.mStart) / 1000.0f;
        Sample lastSample = this.mSamples.isEmpty() ? null : this.mSamples.get(this.mSamples.size() - 1);
        for (Sample sample : TimelineData.convertAreasToSamples(timeForStart, type, areas, lastSample)) {
            this.add(sample);
        }
    }

    private void add(Sample sample) {
        float[] values = sample.values;
        assert (values.length == this.myStreams);
        float total = 0.0f;
        for (float value : values) {
            total += value;
        }
        this.mMaxTotal = Math.max(this.mMaxTotal, total);
        this.mSamples.add(sample);
    }

    public synchronized void clear() {
        this.mSamples.clear();
        this.mMaxTotal = 0.0f;
        this.mStart = System.currentTimeMillis();
    }

    public int size() {
        return this.mSamples.size();
    }

    public Sample get(int index) {
        return this.mSamples.get(index);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized float getEndTime() {
        return (this.mSamples.isEmpty() ? 0.0f : (float)(System.currentTimeMillis() - this.mStart)) / 1000.0f;
    }

    public static class Sample {
        public final float time;
        public final float[] values;
        public final int type;

        public Sample(float time, int type, float[] values) {
            this.time = time;
            this.values = values;
            this.type = type;
        }
    }
}

