/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryID;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Type;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class Array
extends Type {
    private String mAlias;
    private Type mValueType;
    private int mSize;
    private static final byte[] IDBytes = new byte[]{122, -120, 62, 9, -21, -57, 92, 44, 105, -62, -101, -99, 60, 93, -37, -28, 63, -64, 126, -58};
    public static final BinaryID ID = new BinaryID(IDBytes);

    @Override
    @NotNull
    public String getName() {
        String string = "array<" + this.mValueType.getName() + ">";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/rpclib/schema/Array", "getName"));
        }
        return string;
    }

    @Override
    public void encodeValue(@NotNull Encoder e, Object value) throws IOException {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/rpclib/schema/Array", "encodeValue"));
        }
        assert (value instanceof Object[]);
        Object[] array = (Object[])value;
        for (int i = 0; i < this.mSize; ++i) {
            this.mValueType.encodeValue(e, array[i]);
        }
    }

    @Override
    public Object decodeValue(@NotNull Decoder d) throws IOException {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/rpclib/schema/Array", "decodeValue"));
        }
        Object[] array = new Object[this.mSize];
        for (int i = 0; i < this.mSize; ++i) {
            array[i] = this.mValueType.decodeValue(d);
        }
        return array;
    }

    public String getAlias() {
        return this.mAlias;
    }

    public Array setAlias(String v) {
        this.mAlias = v;
        return this;
    }

    public Type getValueType() {
        return this.mValueType;
    }

    public Array setValueType(Type v) {
        this.mValueType = v;
        return this;
    }

    public int getSize() {
        return this.mSize;
    }

    public Array setSize(int v) {
        this.mSize = v;
        return this;
    }

    @Override
    @NotNull
    public BinaryClass klass() {
        Klass klass = Klass.INSTANCE;
        if (klass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/rpclib/schema/Array", "klass"));
        }
        return klass;
    }

    public static void register() {
    }

    static {
        Namespace.register(ID, Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        @Override
        @NotNull
        public BinaryID id() {
            BinaryID binaryID = ID;
            if (binaryID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/rpclib/schema/Array$Klass", "id"));
            }
            return binaryID;
        }

        @Override
        @NotNull
        public BinaryObject create() {
            Array array = new Array();
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/rpclib/schema/Array$Klass", "create"));
            }
            return array;
        }

        @Override
        public void encode(@NotNull Encoder e, BinaryObject obj) throws IOException {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/rpclib/schema/Array$Klass", "encode"));
            }
            Array o = (Array)obj;
            e.string(o.mAlias);
            e.object(o.mValueType.unwrap());
            e.uint32(o.mSize);
        }

        @Override
        public void decode(@NotNull Decoder d, BinaryObject obj) throws IOException {
            if (d == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/rpclib/schema/Array$Klass", "decode"));
            }
            Array o = (Array)obj;
            o.mAlias = d.string();
            o.mValueType = Type.wrap(d.object());
            o.mSize = d.uint32();
        }
    }
}

