/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryID;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Type;
import com.intellij.util.containers.HashMap;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class Map
extends Type {
    private String mAlias;
    private Type mKeyType;
    private Type mValueType;
    private static final byte[] IDBytes = new byte[]{32, -52, -102, 82, -34, 117, 95, 22, 43, 52, -117, 51, -50, 24, 103, -99, -123, 64, -77, 100};
    public static final BinaryID ID = new BinaryID(IDBytes);

    @Override
    @NotNull
    public String getName() {
        String string = "map<" + this.mKeyType.getName() + "," + this.mValueType.getName() + ">";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/rpclib/schema/Map", "getName"));
        }
        return string;
    }

    @Override
    public void encodeValue(@NotNull Encoder e, Object value) throws IOException {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/rpclib/schema/Map", "encodeValue"));
        }
        assert (value instanceof java.util.Map);
        java.util.Map map = (java.util.Map)value;
        e.uint32(map.size());
        for (Map.Entry entry : map.entrySet()) {
            this.mKeyType.encodeValue(e, entry.getKey());
            this.mValueType.encodeValue(e, entry.getValue());
        }
    }

    @Override
    public Object decodeValue(@NotNull Decoder d) throws IOException {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/rpclib/schema/Map", "decodeValue"));
        }
        int size = d.uint32();
        HashMap map = new HashMap();
        for (int i = 0; i < size; ++i) {
            map.put(this.mKeyType.decodeValue(d), this.mValueType.decodeValue(d));
        }
        return map;
    }

    public String getAlias() {
        return this.mAlias;
    }

    public Map setAlias(String v) {
        this.mAlias = v;
        return this;
    }

    public Type getKeyType() {
        return this.mKeyType;
    }

    public Map setKeyType(Type v) {
        this.mKeyType = v;
        return this;
    }

    public Type getValueType() {
        return this.mValueType;
    }

    public Map setValueType(Type v) {
        this.mValueType = v;
        return this;
    }

    @Override
    @NotNull
    public BinaryClass klass() {
        Klass klass = Klass.INSTANCE;
        if (klass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/rpclib/schema/Map", "klass"));
        }
        return klass;
    }

    public static void register() {
    }

    static {
        Namespace.register(ID, Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        @Override
        @NotNull
        public BinaryID id() {
            BinaryID binaryID = ID;
            if (binaryID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/rpclib/schema/Map$Klass", "id"));
            }
            return binaryID;
        }

        @Override
        @NotNull
        public BinaryObject create() {
            Map map = new Map();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/rpclib/schema/Map$Klass", "create"));
            }
            return map;
        }

        @Override
        public void encode(@NotNull Encoder e, BinaryObject obj) throws IOException {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/rpclib/schema/Map$Klass", "encode"));
            }
            Map o = (Map)obj;
            e.string(o.mAlias);
            e.object(o.mKeyType.unwrap());
            e.object(o.mValueType.unwrap());
        }

        @Override
        public void decode(@NotNull Decoder d, BinaryObject obj) throws IOException {
            if (d == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/rpclib/schema/Map$Klass", "decode"));
            }
            Map o = (Map)obj;
            o.mAlias = d.string();
            o.mKeyType = Type.wrap(d.object());
            o.mValueType = Type.wrap(d.object());
        }
    }
}

