package ${packageName};

import android.content.Intent;
import android.os.Bundle;
import ${superClassFqcn};
<#if hasAppBar>
import android.support.v7.widget.Toolbar;
import android.support.design.widget.FloatingActionButton;
import android.support.design.widget.Snackbar;
import android.view.View;
</#if>
<#if (parentActivityClass != "" && minApiLevel lt 16)>import android.support.v4.app.NavUtils;</#if>
<#if parentActivityClass != "">import android.view.MenuItem;</#if>
<#if applicationPackage??>
import ${applicationPackage}.R;
</#if>

/**
 * An activity representing a list of ${objectKindPlural}. This activity
 * has different presentations for handset and tablet-size devices. On
 * handsets, the activity presents a list of items, which when touched,
 * lead to a {@link ${DetailName}Activity} representing
 * item details. On tablets, the activity presents the list of items and
 * item details side-by-side using two vertical panes.
 * <p>
 * The activity makes heavy use of fragments. The list of items is a
 * {@link ${CollectionName}Fragment} and the item details
 * (if present) is a {@link ${DetailName}Fragment}.
 * <p>
 * This activity also implements the required
 * {@link ${CollectionName}Fragment.Callbacks} interface
 * to listen for item selections.
 */
public class ${CollectionName}Activity extends ${superClass}
        implements ${CollectionName}Fragment.Callbacks {

    /**
     * Whether or not the activity is in two-pane mode, i.e. running on a tablet
     * device.
     */
    private boolean mTwoPane;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
<#if hasAppBar>
        setContentView(R.layout.activity_${extractLetters(objectKind?lower_case)}_app_bar);

        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        toolbar.setTitle(getTitle());

        FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
        fab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
                        .setAction("Action", null).show();
            }
        });
<#else>
        setContentView(R.layout.activity_${extractLetters(objectKind?lower_case)}_list);
</#if>
<#if parentActivityClass != "">
        // Show the Up button in the action bar.
        get${Support}ActionBar().setDisplayHomeAsUpEnabled(true);
</#if>

        if (findViewById(R.id.${detail_name}_container) != null) {
            // The detail container view will be present only in the
            // large-screen layouts (res/values-large and
            // res/values-sw600dp). If this view is present, then the
            // activity should be in two-pane mode.
            mTwoPane = true;

            // In two-pane mode, list items should be given the
            // 'activated' state when touched.
            ((${CollectionName}Fragment) get${Support}FragmentManager()
                    .findFragmentById(R.id.${collection_name}))
                    .setActivateOnItemClick(true);
        }

        // TODO: If exposing deep links into your app, handle intents here.
    }
    <#if parentActivityClass != "">

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();
        if (id == android.R.id.home) {
            // This ID represents the Home or Up button. In the case of this
            // activity, the Up button is shown. Use NavUtils to allow users
            // to navigate up one level in the application structure. For
            // more details, see the Navigation pattern on Android Design:
            //
            // http://developer.android.com/design/patterns/navigation.html#up-vs-back
            //
            ${(minApiLevel lt 16)?string('NavUtils.','')}navigateUpFromSameTask(this);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
    </#if>

    /**
     * Callback method from {@link ${CollectionName}Fragment.Callbacks}
     * indicating that the item with the given ID was selected.
     */
    @Override
    public void onItemSelected(String id) {
        if (mTwoPane) {
            // In two-pane mode, show the detail view in this activity by
            // adding or replacing the detail fragment using a
            // fragment transaction.
            Bundle arguments = new Bundle();
            arguments.putString(${DetailName}Fragment.ARG_ITEM_ID, id);
            ${DetailName}Fragment fragment = new ${DetailName}Fragment();
            fragment.setArguments(arguments);
            get${Support}FragmentManager().beginTransaction()
                    .replace(R.id.${detail_name}_container, fragment)
                    .commit();

        } else {
            // In single-pane mode, simply start the detail activity
            // for the selected item ID.
            Intent detailIntent = new Intent(this, ${DetailName}Activity.class);
            detailIntent.putExtra(${DetailName}Fragment.ARG_ITEM_ID, id);
            startActivity(detailIntent);
        }
    }
}
