/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.ArrayMemberAccess;
import com.intellij.codeInsight.completion.BasicExpressionCompletionContributor;
import com.intellij.codeInsight.completion.CastingLookupElementDecorator;
import com.intellij.codeInsight.completion.ChainedCallCompletion;
import com.intellij.codeInsight.completion.FromArrayConversion;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.completion.ToArrayConversion;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SlowerTypeConversions
implements Runnable {
    private static final PrefixMatcher TRUE_MATCHER = new PrefixMatcher(""){

        public boolean prefixMatches(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/completion/SlowerTypeConversions$1", "prefixMatches"));
            }
            return true;
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/codeInsight/completion/SlowerTypeConversions$1", "cloneWithPrefix"));
            }
            1 v0 = this;
            if (v0 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/SlowerTypeConversions$1", "cloneWithPrefix"));
            }
            return v0;
        }
    };
    private final Set<LookupElement> myBase;
    private final PsiElement myElement;
    private final PsiJavaCodeReferenceElement myReference;
    private final JavaSmartCompletionParameters myParameters;
    private final Consumer<LookupElement> myResult;

    SlowerTypeConversions(Set<LookupElement> base, PsiElement element, PsiJavaCodeReferenceElement reference, JavaSmartCompletionParameters parameters, Consumer<LookupElement> result2) {
        this.myBase = base;
        this.myElement = element;
        this.myReference = reference;
        this.myParameters = parameters;
        this.myResult = result2;
    }

    @Override
    public void run() {
        final HashSet processedChains = ContainerUtil.newHashSet();
        for (LookupElement item : this.myBase) {
            SlowerTypeConversions.addSecondCompletionVariants(this.myElement, (PsiReference)this.myReference, item, this.myParameters, new Consumer<LookupElement>(){

                public void consume(LookupElement lookupElement) {
                    ContainerUtil.addIfNotNull((Collection)processedChains, (Object)SlowerTypeConversions.chainInfo(lookupElement));
                    SlowerTypeConversions.this.myResult.consume((Object)lookupElement);
                }
            });
        }
        if (!((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."})).accepts((Object)this.myElement)) {
            BasicExpressionCompletionContributor.processDataflowExpressionTypes(this.myElement, null, TRUE_MATCHER, new Consumer<LookupElement>(){

                public void consume(LookupElement baseItem) {
                    SlowerTypeConversions.addSecondCompletionVariants(SlowerTypeConversions.this.myElement, (PsiReference)SlowerTypeConversions.this.myReference, baseItem, SlowerTypeConversions.this.myParameters, (Consumer<LookupElement>)((Consumer)new Consumer<LookupElement>(){

                        public void consume(LookupElement lookupElement) {
                            if (!processedChains.contains(SlowerTypeConversions.chainInfo(lookupElement))) {
                                SlowerTypeConversions.this.myResult.consume((Object)lookupElement);
                            }
                        }
                    }));
                }
            });
        }
    }

    private static void addSecondCompletionVariants(PsiElement element, PsiReference reference, LookupElement baseItem, JavaSmartCompletionParameters parameters, Consumer<LookupElement> result2) {
        Object object = baseItem.getObject();
        try {
            PsiType itemType = JavaCompletionUtil.getLookupElementType(baseItem);
            if (itemType instanceof PsiWildcardType) {
                itemType = ((PsiWildcardType)itemType).getExtendsBound();
            }
            if (itemType == null) {
                return;
            }
            assert (itemType.isValid()) : baseItem + "; " + baseItem.getClass();
            PsiElement element1 = reference.getElement();
            PsiElement qualifier = element1 instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)element1).getQualifier() : null;
            PsiType expectedType = parameters.getExpectedType();
            ChainedCallCompletion.addChains(element, baseItem, result2, itemType, expectedType, parameters);
            String prefix = SlowerTypeConversions.getItemText(object);
            if (prefix == null) {
                return;
            }
            FromArrayConversion.addConversions(element, prefix, itemType, result2, qualifier, expectedType);
            ToArrayConversion.addConversions(element, object, prefix, itemType, result2, qualifier, expectedType);
            ArrayMemberAccess.addMemberAccessors(element, prefix, itemType, qualifier, result2, (PsiModifierListOwner)object, expectedType);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
    }

    @Nullable
    private static String getItemText(Object o) {
        if (o instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)o;
            PsiType type = method.getReturnType();
            if (PsiType.VOID.equals((Object)type) || PsiType.NULL.equals((Object)type)) {
                return null;
            }
            if (method.getParameterList().getParametersCount() > 0) {
                return null;
            }
            return method.getName() + "(" + ReferenceExpressionCompletionContributor.getSpace(CodeStyleSettingsManager.getSettings((Project)method.getProject()).SPACE_WITHIN_METHOD_CALL_PARENTHESES) + ")";
        }
        if (o instanceof PsiVariable) {
            return ((PsiVariable)o).getName();
        }
        return null;
    }

    @Nullable
    private static Pair<LookupElement, String> chainInfo(LookupElement lookupElement) {
        Object object;
        if (lookupElement instanceof JavaChainLookupElement && (object = lookupElement.getObject()) instanceof PsiMember) {
            LookupElement qualifier = ((JavaChainLookupElement)lookupElement).getQualifier();
            if (qualifier instanceof CastingLookupElementDecorator) {
                qualifier = ((CastingLookupElementDecorator)qualifier).getDelegate();
            }
            return Pair.create((Object)qualifier, (Object)lookupElement.getLookupString());
        }
        return null;
    }
}

