/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.CheckLevelHighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.codeInsight.daemon.impl.analysis.PostHighlightingVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.PsiMethodReferenceHighlightingUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MostlySingularMultiMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightVisitorImpl
extends JavaElementVisitor
implements HighlightVisitor {
    @NotNull
    private final PsiResolveHelper myResolveHelper;
    private HighlightInfoHolder myHolder;
    private RefCountHolder myRefCountHolder;
    private final Map<PsiElement, Collection<PsiReferenceExpression>> myUninitializedVarProblems;
    private final Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> myFinalVarProblems;
    private final TObjectIntHashMap<PsiParameter> myReassignedParameters;
    private final Map<String, Pair<PsiImportStaticReferenceElement, PsiClass>> mySingleImportedClasses;
    private final Map<String, Pair<PsiImportStaticReferenceElement, PsiField>> mySingleImportedFields;
    private PsiFile myFile;
    private final PsiElementVisitor REGISTER_REFERENCES_VISITOR;
    private final Map<PsiClass, MostlySingularMultiMap<MethodSignature, PsiMethod>> myDuplicateMethods;
    private LanguageLevel myLanguageLevel;
    private JavaSdkVersion myJavaSdkVersion;

    private HighlightVisitorImpl(@NotNull PsiResolveHelper resolveHelper) {
        if (resolveHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveHelper", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "<init>"));
        }
        this.myUninitializedVarProblems = new THashMap();
        this.myFinalVarProblems = new THashMap();
        this.myReassignedParameters = new TObjectIntHashMap();
        this.mySingleImportedClasses = new THashMap();
        this.mySingleImportedFields = new THashMap();
        this.REGISTER_REFERENCES_VISITOR = new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                for (PsiReference reference : element.getReferences()) {
                    PsiElement resolved = reference.resolve();
                    if (!(resolved instanceof PsiNamedElement)) continue;
                    HighlightVisitorImpl.this.myRefCountHolder.registerLocallyReferenced((PsiNamedElement)resolved);
                }
            }
        };
        this.myDuplicateMethods = new THashMap();
        this.myResolveHelper = resolveHelper;
    }

    @NotNull
    private MostlySingularMultiMap<MethodSignature, PsiMethod> getDuplicateMethods(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "getDuplicateMethods"));
        }
        MostlySingularMultiMap signatures = this.myDuplicateMethods.get(aClass);
        if (signatures == null) {
            signatures = new MostlySingularMultiMap();
            for (PsiMethod method : aClass.getMethods()) {
                if (method instanceof ExternallyDefinedPsiElement) continue;
                MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
                signatures.add((Object)signature, (Object)method);
            }
            this.myDuplicateMethods.put(aClass, (MostlySingularMultiMap<MethodSignature, PsiMethod>)signatures);
        }
        MostlySingularMultiMap mostlySingularMultiMap = signatures;
        if (mostlySingularMultiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "getDuplicateMethods"));
        }
        return mostlySingularMultiMap;
    }

    @Override
    @NotNull
    public HighlightVisitorImpl clone() {
        HighlightVisitorImpl highlightVisitorImpl = new HighlightVisitorImpl(this.myResolveHelper);
        if (highlightVisitorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "clone"));
        }
        return highlightVisitorImpl;
    }

    @Override
    public int order() {
        return 0;
    }

    @Override
    public boolean suitableForFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "suitableForFile"));
        }
        return file2 instanceof PsiImportHolder && !InjectedLanguageManager.getInstance((Project)file2.getProject()).isInjectedFragment(file2);
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "visit"));
        }
        if (Holder.CHECK_ELEMENT_LEVEL) {
            ((CheckLevelHighlightInfoHolder)this.myHolder).enterLevel(element);
            element.accept((PsiElementVisitor)this);
            ((CheckLevelHighlightInfoHolder)this.myHolder).enterLevel(null);
        } else {
            element.accept((PsiElementVisitor)this);
        }
    }

    private void registerReferencesFromInjectedFragments(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "registerReferencesFromInjectedFragments"));
        }
        InjectedLanguageManager.getInstance((Project)this.myFile.getProject()).enumerateEx(element, this.myFile, false, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl$2", "visit"));
                }
                if (places == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl$2", "visit"));
                }
                injectedPsi.accept(HighlightVisitorImpl.this.REGISTER_REFERENCES_VISITOR);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(final @NotNull PsiFile file2, boolean updateWholeFile, final @NotNull HighlightInfoHolder holder, final @NotNull Runnable highlight) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "analyze"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "analyze"));
        }
        if (highlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlight", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "analyze"));
        }
        this.myFile = file2;
        this.myHolder = Holder.CHECK_ELEMENT_LEVEL ? new CheckLevelHighlightInfoHolder(file2, holder) : holder;
        boolean success = true;
        try {
            this.myLanguageLevel = PsiUtil.getLanguageLevel((PsiElement)file2);
            this.myJavaSdkVersion = (JavaSdkVersion)ObjectUtils.notNull((Object)JavaVersionService.getInstance().getJavaSdkVersion((PsiElement)file2), (Object)JavaSdkVersion.fromLanguageLevel((LanguageLevel)this.myLanguageLevel));
            if (updateWholeFile) {
                RefCountHolder refCountHolder;
                Project project = file2.getProject();
                DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
                FileStatusMap fileStatusMap = daemonCodeAnalyzer.getFileStatusMap();
                final ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                if (progress == null) {
                    throw new IllegalStateException("Must be run under progress");
                }
                this.myRefCountHolder = refCountHolder = RefCountHolder.get(file2);
                final Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
                TextRange dirtyScope = (TextRange)ObjectUtils.notNull((Object)(document == null ? null : fileStatusMap.getFileDirtyScope(document, 4)), (Object)file2.getTextRange());
                success = refCountHolder.analyze(file2, dirtyScope, progress, new Runnable(){

                    @Override
                    public void run() {
                        highlight.run();
                        progress.checkCanceled();
                        HighlightingSession highlightingSession = HighlightingSessionImpl.getHighlightingSession(file2, progress);
                        PostHighlightingVisitor highlightingVisitor = new PostHighlightingVisitor(file2, document, refCountHolder);
                        highlightingVisitor.collectHighlights(file2, holder, progress);
                    }
                });
            } else {
                this.myRefCountHolder = null;
                highlight.run();
            }
        }
        finally {
            this.myUninitializedVarProblems.clear();
            this.myFinalVarProblems.clear();
            this.mySingleImportedClasses.clear();
            this.mySingleImportedFields.clear();
            this.myReassignedParameters.clear();
            this.myRefCountHolder = null;
            this.myFile = null;
            this.myHolder = null;
            this.myDuplicateMethods.clear();
        }
        return success;
    }

    public void visitElement(PsiElement element) {
        if (this.myRefCountHolder != null && this.myFile instanceof ServerPageFile) {
            try {
                for (PsiReference reference : element.getReferences()) {
                    if (!(reference instanceof PsiJavaReference)) continue;
                    PsiJavaReference psiJavaReference = (PsiJavaReference)reference;
                    this.myRefCountHolder.registerReference((PsiReference)psiJavaReference, psiJavaReference.advancedResolve(false));
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
    }

    public void visitAnnotation(PsiAnnotation annotation) {
        super.visitAnnotation(annotation);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature((PsiElement)annotation, HighlightUtil.Feature.ANNOTATIONS));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkApplicability(annotation, this.myLanguageLevel, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkAnnotationType(annotation));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkMissingAttributes(annotation));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkTargetAnnotationDuplicates(annotation));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkDuplicateAnnotations(annotation, this.myLanguageLevel));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkForeignInnerClassesUsed(annotation));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkFunctionalInterface(annotation, this.myLanguageLevel));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkRepeatableAnnotation(annotation));
        }
        if ("java.lang.Override".equals(annotation.getQualifiedName())) {
            PsiElement parent;
            PsiAnnotationOwner owner = annotation.getOwner();
            PsiElement psiElement = parent = owner instanceof PsiModifierList ? ((PsiModifierList)owner).getParent() : null;
            if (parent instanceof PsiMethod) {
                this.myHolder.add(GenericsHighlightUtil.checkOverrideAnnotation((PsiMethod)parent, annotation, this.myLanguageLevel));
            }
        }
    }

    public void visitAnnotationArrayInitializer(PsiArrayInitializerMemberValue initializer) {
        PsiType type;
        PsiMethod method = null;
        PsiElement parent = initializer.getParent();
        if (parent instanceof PsiNameValuePair) {
            method = (PsiMethod)parent.getReference().resolve();
        } else if (PsiUtil.isAnnotationMethod((PsiElement)parent)) {
            method = (PsiMethod)parent;
        }
        if (method != null && (type = method.getReturnType()) instanceof PsiArrayType) {
            PsiAnnotationMemberValue[] initializers;
            type = ((PsiArrayType)type).getComponentType();
            for (PsiAnnotationMemberValue initializer1 : initializers = initializer.getInitializers()) {
                this.myHolder.add(AnnotationsHighlightUtil.checkMemberValueType(initializer1, type));
            }
        }
    }

    public void visitAnnotationMethod(PsiAnnotationMethod method) {
        PsiType returnType = method.getReturnType();
        PsiAnnotationMemberValue value = method.getDefaultValue();
        if (returnType != null && value != null) {
            this.myHolder.add(AnnotationsHighlightUtil.checkMemberValueType(value, returnType));
        }
        this.myHolder.add(AnnotationsHighlightUtil.checkValidAnnotationType(method.getReturnType(), method.getReturnTypeElement()));
        PsiClass aClass = method.getContainingClass();
        this.myHolder.add(AnnotationsHighlightUtil.checkCyclicMemberType(method.getReturnTypeElement(), aClass));
        this.myHolder.add(AnnotationsHighlightUtil.checkClashesWithSuperMethods(method));
        if (!this.myHolder.hasErrorResults() && aClass != null) {
            this.myHolder.add(HighlightMethodUtil.checkDuplicateMethod(aClass, (PsiMethod)method, this.getDuplicateMethods(aClass)));
        }
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        super.visitArrayInitializerExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkArrayInitializerApplicable(expression));
        }
        if (!(expression.getParent() instanceof PsiNewExpression) && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkGenericArrayCreation((PsiElement)expression, expression.getType()));
        }
    }

    public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAssignmentCompatibleTypes(assignment));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAssignmentOperatorApplicable(assignment, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression((PsiExpression)assignment);
        }
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression) {
        super.visitPolyadicExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkPolyadicOperatorApplicable(expression));
        }
    }

    public void visitLambdaExpression(PsiLambdaExpression expression) {
        this.myHolder.add(this.checkFeature((PsiElement)expression, HighlightUtil.Feature.LAMBDA_EXPRESSIONS));
        if (!this.myHolder.hasErrorResults()) {
            PsiElement body;
            if (LambdaUtil.isValidLambdaContext((PsiElement)expression.getParent())) {
                PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
                if (functionalInterfaceType != null) {
                    String notFunctionalMessage = LambdaHighlightingUtil.checkInterfaceFunctional(functionalInterfaceType);
                    if (notFunctionalMessage != null) {
                        HighlightInfo result2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(notFunctionalMessage).create();
                        this.myHolder.add(result2);
                    } else {
                        String errorMessage;
                        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
                        PsiCallExpression callExpression = parent instanceof PsiExpressionList && parent.getParent() instanceof PsiCallExpression ? (PsiCallExpression)parent.getParent() : null;
                        JavaResolveResult containingCallResolveResult = callExpression != null ? callExpression.resolveMethodGenerics() : null;
                        String string = errorMessage = containingCallResolveResult instanceof MethodCandidateInfo ? ((MethodCandidateInfo)containingCallResolveResult).getInferenceErrorMessage() : null;
                        if (errorMessage != null) {
                            HighlightInfo result3 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(errorMessage).create();
                            this.myHolder.add(result3);
                        } else {
                            String incompatibleReturnTypesMessage = LambdaUtil.checkReturnTypeCompatible((PsiLambdaExpression)expression, (PsiType)LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType));
                            if (incompatibleReturnTypesMessage != null) {
                                List returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)expression);
                                PsiElement returnStatementToHighlight = returnExpressions.size() == 1 ? (PsiElement)returnExpressions.get(0) : expression.getBody();
                                HighlightInfo result4 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)(returnStatementToHighlight != null ? returnStatementToHighlight : expression)).descriptionAndTooltip(incompatibleReturnTypesMessage).create();
                                this.myHolder.add(result4);
                            } else {
                                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
                                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
                                if (interfaceMethod != null) {
                                    PsiParameter[] parameters = interfaceMethod.getParameterList().getParameters();
                                    HighlightInfo result5 = LambdaHighlightingUtil.checkParametersCompatible(expression, parameters, LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult));
                                    if (result5 != null) {
                                        this.myHolder.add(result5);
                                    } else {
                                        this.checkFunctionalInterfaceTypeAccessible((PsiFunctionalExpression)expression, functionalInterfaceType);
                                    }
                                }
                            }
                        }
                    }
                } else if (LambdaUtil.getFunctionalInterfaceType((PsiElement)expression, (boolean)true) != null) {
                    this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip("Cannot infer functional interface type").create());
                }
            } else {
                HighlightInfo result6 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip("Lambda expression not expected here").create();
                this.myHolder.add(result6);
            }
            if (!this.myHolder.hasErrorResults() && (body = expression.getBody()) instanceof PsiCodeBlock) {
                this.myHolder.add(HighlightControlFlowUtil.checkUnreachableStatement((PsiCodeBlock)body));
            }
        }
    }

    public void visitBreakStatement(PsiBreakStatement statement) {
        super.visitBreakStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelDefined(statement.getLabelIdentifier(), statement.findExitedStatement()));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkBreakOutsideLoop(statement));
        }
    }

    public void visitClass(PsiClass aClass) {
        super.visitClass(aClass);
        if (aClass instanceof PsiSyntheticClass) {
            return;
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkInterfaceMultipleInheritance(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.areSupersAccessible(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkDuplicateTopLevelClass(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkEnumMustNotBeLocal(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkEnumWithoutConstantsCantHaveAbstractMethods(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkImplicitThisReferenceBeforeSuper(aClass, this.myJavaSdkVersion));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkClassAndPackageConflict(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkPublicClassInRightFile(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkTypeParameterOverrideEquivalentMethods(aClass, this.myLanguageLevel));
        }
    }

    public void visitClassInitializer(PsiClassInitializer initializer) {
        super.visitClassInitializer(initializer);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkInitializerCompleteNormally(initializer));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkUnreachableStatement(initializer.getBody()));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkThingNotAllowedInInterface((PsiElement)initializer, initializer.getContainingClass()));
        }
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
        super.visitClassObjectAccessExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkClassObjectAccessExpression(expression));
        }
    }

    public void visitComment(PsiComment comment) {
        super.visitComment(comment);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnclosedComment(comment));
        }
        if (this.myRefCountHolder != null && !this.myHolder.hasErrorResults()) {
            this.registerReferencesFromInjectedFragments((PsiElement)comment);
        }
    }

    public void visitContinueStatement(PsiContinueStatement statement) {
        super.visitContinueStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelDefined(statement.getLabelIdentifier(), statement.findContinuedStatement()));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkContinueOutsideLoop(statement));
        }
    }

    public void visitJavaToken(PsiJavaToken token) {
        super.visitJavaToken(token);
        if (!this.myHolder.hasErrorResults() && token.getTokenType() == JavaTokenType.RBRACE && token.getParent() instanceof PsiCodeBlock) {
            PsiType returnType;
            PsiCodeBlock codeBlock;
            PsiElement gParent = token.getParent().getParent();
            if (gParent instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)gParent;
                codeBlock = method.getBody();
                returnType = method.getReturnType();
            } else if (gParent instanceof PsiLambdaExpression) {
                PsiElement body = ((PsiLambdaExpression)gParent).getBody();
                if (!(body instanceof PsiCodeBlock)) {
                    return;
                }
                codeBlock = (PsiCodeBlock)body;
                returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)gParent));
            } else {
                return;
            }
            this.myHolder.add(HighlightControlFlowUtil.checkMissingReturnStatement(codeBlock, returnType));
        }
    }

    public void visitDocComment(PsiDocComment comment) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnclosedComment((PsiComment)comment));
        }
    }

    public void visitDocTagValue(PsiDocTagValue value) {
        PsiReference reference = value.getReference();
        if (reference != null) {
            PsiElement element = reference.resolve();
            TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
            if (element instanceof PsiMethod) {
                this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMethod)element, ((PsiDocMethodOrFieldRef)value).getNameElement(), false, colorsScheme));
            } else if (element instanceof PsiParameter) {
                this.myHolder.add(HighlightNamesUtil.highlightVariableName((PsiVariable)element, value.getNavigationElement(), colorsScheme));
            }
        }
    }

    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        super.visitEnumConstant(enumConstant);
        if (!this.myHolder.hasErrorResults()) {
            GenericsHighlightUtil.checkEnumConstantForConstructorProblems(enumConstant, this.myHolder, this.myJavaSdkVersion);
        }
        if (!this.myHolder.hasErrorResults()) {
            this.registerConstructorCall((PsiConstructorCall)enumConstant);
        }
    }

    public void visitEnumConstantInitializer(PsiEnumConstantInitializer enumConstantInitializer) {
        super.visitEnumConstantInitializer(enumConstantInitializer);
        if (!this.myHolder.hasErrorResults()) {
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)enumConstantInitializer);
            this.myHolder.add(HighlightClassUtil.checkClassMustBeAbstract((PsiClass)enumConstantInitializer, textRange));
        }
    }

    public void visitExpression(PsiExpression expression) {
        PsiElement parent;
        ProgressManager.checkCanceled();
        super.visitExpression(expression);
        PsiType type = expression.getType();
        if (this.myHolder.add(HighlightUtil.checkMustBeBoolean(expression, type))) {
            return;
        }
        if (expression instanceof PsiArrayAccessExpression) {
            this.myHolder.add(HighlightUtil.checkValidArrayAccessExpression((PsiArrayAccessExpression)expression));
        }
        if ((parent = expression.getParent()) instanceof PsiNewExpression && ((PsiNewExpression)parent).getQualifier() != expression && ((PsiNewExpression)parent).getArrayInitializer() != expression) {
            this.myHolder.add(HighlightUtil.checkAssignability((PsiType)PsiType.INT, expression.getType(), expression, (PsiElement)expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkCannotWriteToFinal(expression, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkVariableExpected(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(HighlightUtil.checkArrayInitializer(expression, type));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkTernaryOperatorConditionIsBoolean(expression, type));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAssertOperatorTypes(expression, type));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkSynchronizedExpressionType(expression, type, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkConditionalExpressionBranchTypesMatch(expression, type));
        }
        if (!this.myHolder.hasErrorResults() && parent instanceof PsiThrowStatement && ((PsiThrowStatement)parent).getException() == expression) {
            this.myHolder.add(HighlightUtil.checkMustBeThrowable(type, (PsiElement)expression, true));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkConstantExpression(expression));
        }
        if (!this.myHolder.hasErrorResults() && parent instanceof PsiForeachStatement && ((PsiForeachStatement)parent).getIteratedValue() == expression) {
            this.myHolder.add(GenericsHighlightUtil.checkForeachExpressionTypeIsIterable(expression));
        }
    }

    public void visitExpressionList(PsiExpressionList list) {
        PsiMethodCallExpression expression;
        super.visitExpressionList(list);
        PsiElement parent = list.getParent();
        if (parent instanceof PsiMethodCallExpression && (expression = (PsiMethodCallExpression)parent).getArgumentList() == list) {
            JavaResolveResult result2;
            JavaResolveResult[] results;
            PsiReferenceExpression referenceExpression = expression.getMethodExpression();
            try {
                results = this.resolveOptimised(referenceExpression);
                result2 = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
            }
            catch (IndexNotReadyException e) {
                return;
            }
            PsiElement resolved = result2.getElement();
            if (!(result2.isAccessible() && result2.isStaticsScopeCorrect() || HighlightMethodUtil.isDummyConstructorCall(expression, this.myResolveHelper, list, referenceExpression) || referenceExpression.getParent() != expression)) {
                try {
                    if (PsiTreeUtil.findChildrenOfType((PsiElement)expression.getArgumentList(), PsiLambdaExpression.class).isEmpty()) {
                        this.myHolder.add(HighlightMethodUtil.checkAmbiguousMethodCallArguments(referenceExpression, results, list, resolved, result2, expression, this.myResolveHelper, (PsiElement)list));
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
            }
        }
    }

    public void visitField(PsiField field) {
        super.visitField(field);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkFinalFieldInitialized(field));
        }
    }

    public void visitForStatement(PsiForStatement statement) {
        this.myHolder.add(HighlightUtil.checkForStatement(statement));
    }

    public void visitForeachStatement(PsiForeachStatement statement) {
        this.myHolder.add(this.checkFeature((PsiElement)statement, HighlightUtil.Feature.FOR_EACH));
    }

    public void visitImportStaticStatement(PsiImportStaticStatement statement) {
        this.myHolder.add(this.checkFeature((PsiElement)statement, HighlightUtil.Feature.STATIC_IMPORTS));
    }

    public void visitIdentifier(PsiIdentifier identifier) {
        TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
        PsiElement parent = identifier.getParent();
        if (parent instanceof PsiVariable) {
            boolean isMethodParameter;
            PsiElement child;
            PsiVariable variable = (PsiVariable)parent;
            this.myHolder.add(HighlightUtil.checkVariableAlreadyDefined(variable));
            if (variable.getInitializer() == null && (child = variable.getLastChild()) instanceof PsiErrorElement && child.getPrevSibling() == identifier) {
                return;
            }
            boolean bl = isMethodParameter = variable instanceof PsiParameter && ((PsiParameter)variable).getDeclarationScope() instanceof PsiMethod;
            if (isMethodParameter) {
                this.myReassignedParameters.put((Object)((PsiParameter)variable), 1);
            } else if (HighlightControlFlowUtil.isReassigned(variable, this.myFinalVarProblems)) {
                this.myHolder.add(HighlightNamesUtil.highlightReassignedVariable(variable, (PsiElement)identifier));
            } else {
                this.myHolder.add(HighlightNamesUtil.highlightVariableName(variable, (PsiElement)identifier, colorsScheme));
            }
        } else if (parent instanceof PsiClass) {
            PsiClass aClass = (PsiClass)parent;
            if (aClass.isAnnotationType()) {
                this.myHolder.add(this.checkFeature((PsiElement)identifier, HighlightUtil.Feature.ANNOTATIONS));
            }
            this.myHolder.add(HighlightClassUtil.checkClassAlreadyImported(aClass, (PsiElement)identifier));
            if (!(parent instanceof PsiAnonymousClass) && aClass.getNameIdentifier() == identifier) {
                this.myHolder.add(HighlightNamesUtil.highlightClassName(aClass, (PsiElement)identifier, colorsScheme));
            }
            if (!this.myHolder.hasErrorResults() && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                this.myHolder.add(GenericsHighlightUtil.checkUnrelatedDefaultMethods(aClass, aClass.getVisibleSignatures(), identifier));
            }
        } else if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            if (method.isConstructor()) {
                this.myHolder.add(HighlightMethodUtil.checkConstructorName(method));
            }
            this.myHolder.add(HighlightNamesUtil.highlightMethodName(method, (PsiElement)identifier, true, colorsScheme));
            PsiClass aClass = method.getContainingClass();
            if (aClass != null) {
                this.myHolder.add(GenericsHighlightUtil.checkDefaultMethodOverrideEquivalentToObjectNonPrivate(this.myLanguageLevel, aClass, method, (PsiElement)identifier));
            }
        }
        this.myHolder.add(HighlightUtil.checkUnderscore(identifier, this.myLanguageLevel));
        super.visitIdentifier(identifier);
    }

    public void visitImportStatement(PsiImportStatement statement) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkSingleImportClassConflict(statement, this.mySingleImportedClasses, this.myFile));
        }
    }

    public void visitImportStaticReferenceElement(PsiImportStaticReferenceElement ref) {
        String refName = ref.getReferenceName();
        JavaResolveResult[] results = ref.multiResolve(false);
        PsiElement referenceNameElement = ref.getReferenceNameElement();
        if (results.length == 0) {
            String description = JavaErrorMessages.message("cannot.resolve.symbol", refName);
            assert (referenceNameElement != null) : ref;
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(referenceNameElement).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createSetupJDKFix());
            this.myHolder.add(highlightInfo);
        } else {
            PsiManager manager = ref.getManager();
            for (JavaResolveResult result2 : results) {
                Pair<PsiImportStaticReferenceElement, PsiClass> imported;
                PsiElement element = result2.getElement();
                String description = null;
                if (element instanceof PsiClass) {
                    PsiClass aClass;
                    imported = this.mySingleImportedClasses.get(refName);
                    PsiClass psiClass = aClass = imported == null ? null : (PsiClass)imported.getSecond();
                    if (aClass != null && !manager.areElementsEquivalent((PsiElement)aClass, element)) {
                        description = imported.first == null ? JavaErrorMessages.message("single.import.class.conflict", refName) : (((PsiImportStaticReferenceElement)imported.first).equals(ref) ? JavaErrorMessages.message("class.is.ambiguous.in.single.static.import", refName) : JavaErrorMessages.message("class.is.already.defined.in.single.static.import", refName));
                    }
                    this.mySingleImportedClasses.put(refName, (Pair<PsiImportStaticReferenceElement, PsiClass>)Pair.create((Object)ref, (Object)((PsiClass)element)));
                } else if (element instanceof PsiField) {
                    PsiField field;
                    imported = this.mySingleImportedFields.get(refName);
                    PsiField psiField = field = imported == null ? null : (PsiField)imported.getSecond();
                    if (field != null && !manager.areElementsEquivalent((PsiElement)field, element)) {
                        description = ((PsiImportStaticReferenceElement)imported.first).equals(ref) ? JavaErrorMessages.message("field.is.ambiguous.in.single.static.import", refName) : JavaErrorMessages.message("field.is.already.defined.in.single.static.import", refName);
                    }
                    this.mySingleImportedFields.put(refName, (Pair<PsiImportStaticReferenceElement, PsiField>)Pair.create((Object)ref, (Object)((PsiField)element)));
                }
                if (description == null) continue;
                this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip(description).create());
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            PsiElement resolved = results.length == 1 ? results[0].getElement() : null;
            TextAttributesScheme textAttributesScheme = this.myHolder.getColorsScheme();
            if (resolved instanceof PsiClass) {
                this.myHolder.add(HighlightNamesUtil.highlightClassName((PsiClass)resolved, (PsiElement)ref, textAttributesScheme));
            } else {
                this.myHolder.add(HighlightNamesUtil.highlightClassNameInQualifier((PsiJavaCodeReferenceElement)ref, textAttributesScheme));
                if (resolved instanceof PsiVariable) {
                    this.myHolder.add(HighlightNamesUtil.highlightVariableName((PsiVariable)resolved, referenceNameElement, textAttributesScheme));
                } else if (resolved instanceof PsiMethod) {
                    this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMethod)resolved, referenceNameElement, false, textAttributesScheme));
                }
            }
        }
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
        super.visitInstanceOfExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkInstanceOfApplicable(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkInstanceOfGenericType(expression));
        }
    }

    public void visitKeyword(PsiKeyword keyword) {
        super.visitKeyword(keyword);
        PsiElement parent = keyword.getParent();
        String text = keyword.getText();
        if (parent instanceof PsiModifierList) {
            PsiModifierList psiModifierList = (PsiModifierList)parent;
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkNotAllowedModifier(keyword, psiModifierList));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkIllegalModifierCombination(keyword, psiModifierList));
            }
            if ("abstract".equals(text) && psiModifierList.getParent() instanceof PsiMethod && !this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkAbstractMethodInConcreteClass((PsiMethod)psiModifierList.getParent(), (PsiElement)keyword));
            }
        } else if ("interface".equals(text) && parent instanceof PsiClass && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkInterfaceCannotBeLocal((PsiClass)parent));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkStaticDeclarationInInnerClass(keyword));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkIllegalVoidType(keyword));
        }
    }

    public void visitLabeledStatement(PsiLabeledStatement statement) {
        super.visitLabeledStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelWithoutStatement(statement));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelAlreadyInUse(statement));
        }
    }

    public void visitLiteralExpression(PsiLiteralExpression expression) {
        super.visitLiteralExpression(expression);
        if (this.myHolder.hasErrorResults()) {
            return;
        }
        this.myHolder.add(HighlightUtil.checkLiteralExpressionParsingError(expression, this.myLanguageLevel, this.myFile));
        if (this.myRefCountHolder != null && !this.myHolder.hasErrorResults()) {
            this.registerReferencesFromInjectedFragments((PsiElement)expression);
        }
    }

    public void visitMethod(PsiMethod method) {
        super.visitMethod(method);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkUnreachableStatement(method.getBody()));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkConstructorHandleSuperClassExceptions(method));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkRecursiveConstructorInvocation(method));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkSafeVarargsAnnotation(method, this.myLanguageLevel));
        }
        PsiClass aClass = method.getContainingClass();
        if (!this.myHolder.hasErrorResults() && method.isConstructor()) {
            this.myHolder.add(HighlightClassUtil.checkThingNotAllowedInInterface((PsiElement)method, aClass));
        }
        if (!this.myHolder.hasErrorResults() && method.hasModifierProperty("default")) {
            this.myHolder.add(this.checkFeature((PsiElement)method, HighlightUtil.Feature.EXTENSION_METHODS));
        }
        if (!this.myHolder.hasErrorResults() && aClass != null && aClass.isInterface() && method.hasModifierProperty("static")) {
            this.myHolder.add(this.checkFeature((PsiElement)method, HighlightUtil.Feature.EXTENSION_METHODS));
        }
        if (!this.myHolder.hasErrorResults() && aClass != null) {
            this.myHolder.add(HighlightMethodUtil.checkDuplicateMethod(aClass, method, this.getDuplicateMethods(aClass)));
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
        for (PsiParameter parameter : parameters) {
            int info = this.myReassignedParameters.get((Object)parameter);
            if (info == 0) continue;
            if (info == 2) {
                this.myHolder.add(HighlightNamesUtil.highlightReassignedVariable((PsiVariable)parameter, (PsiElement)parameter.getNameIdentifier()));
                continue;
            }
            this.myHolder.add(HighlightNamesUtil.highlightVariableName((PsiVariable)parameter, (PsiElement)parameter.getNameIdentifier(), colorsScheme));
        }
    }

    private void highlightReferencedMethodOrClassName(PsiJavaCodeReferenceElement element, PsiElement resolved) {
        PsiElement parent = element.getParent();
        if (parent instanceof PsiReferenceExpression || parent instanceof PsiJavaCodeReferenceElement) {
            return;
        }
        TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
        if (parent instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)parent).resolveMethod();
            PsiElement methodNameElement = element.getReferenceNameElement();
            if (method != null && methodNameElement != null && !(methodNameElement instanceof PsiKeyword)) {
                this.myHolder.add(HighlightNamesUtil.highlightMethodName(method, methodNameElement, false, colorsScheme));
                this.myHolder.add(HighlightNamesUtil.highlightClassNameInQualifier(element, colorsScheme));
            }
        } else if (parent instanceof PsiConstructorCall) {
            try {
                PsiMethod method = ((PsiConstructorCall)parent).resolveConstructor();
                if (method == null) {
                    if (resolved instanceof PsiClass) {
                        this.myHolder.add(HighlightNamesUtil.highlightClassName((PsiClass)resolved, (PsiElement)element, colorsScheme));
                    }
                } else {
                    PsiElement referenceNameElement = element.getReferenceNameElement();
                    if (referenceNameElement != null) {
                        TextRange range = new TextRange(element.getTextRange().getStartOffset(), referenceNameElement.getTextRange().getEndOffset());
                        this.myHolder.add(HighlightNamesUtil.highlightMethodName(method, referenceNameElement, range, colorsScheme, false));
                    }
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {}
        } else if (parent instanceof PsiImportStatement && ((PsiImportStatement)parent).isOnDemand()) {
            this.myHolder.add(HighlightNamesUtil.highlightClassName(null, (PsiElement)element, colorsScheme));
        } else if (resolved instanceof PsiClass) {
            this.myHolder.add(HighlightNamesUtil.highlightClassName((PsiClass)resolved, (PsiElement)element, colorsScheme));
        }
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkEnumSuperConstructorCall(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkSuperQualifierType(this.myFile.getProject(), expression));
        }
        if (this.myFile.isPhysical() && !this.myHolder.hasErrorResults()) {
            try {
                this.myHolder.add(HighlightMethodUtil.checkMethodCall(expression, this.myResolveHelper, this.myLanguageLevel, this.myJavaSdkVersion));
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkConstructorCallMustBeFirstStatement(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkSuperAbstractMethodDirectCall(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression((PsiExpression)expression);
        }
    }

    public void visitModifierList(PsiModifierList list) {
        super.visitModifierList(list);
        PsiElement parent = list.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkMethodCanHaveBody(method, this.myLanguageLevel));
            }
            MethodSignatureBackedByPsiMethod methodSignature = MethodSignatureBackedByPsiMethod.create((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            if (!method.isConstructor()) {
                try {
                    List superMethodSignatures = method.getHierarchicalMethodSignature().getSuperSignatures();
                    if (!superMethodSignatures.isEmpty()) {
                        if (!this.myHolder.hasErrorResults()) {
                            this.myHolder.add(HighlightMethodUtil.checkMethodIncompatibleReturnType(methodSignature, superMethodSignatures, true));
                        }
                        if (!this.myHolder.hasErrorResults()) {
                            this.myHolder.add(HighlightMethodUtil.checkMethodIncompatibleThrows(methodSignature, superMethodSignatures, true, method.getContainingClass()));
                        }
                        if (!method.hasModifierProperty("static")) {
                            if (!this.myHolder.hasErrorResults()) {
                                this.myHolder.add(HighlightMethodUtil.checkMethodWeakerPrivileges(methodSignature, superMethodSignatures, true, this.myFile));
                            }
                            if (!this.myHolder.hasErrorResults()) {
                                this.myHolder.add(HighlightMethodUtil.checkMethodOverridesFinal(methodSignature, superMethodSignatures));
                            }
                        }
                    }
                }
                catch (IndexNotReadyException superMethodSignatures) {
                    // empty catch block
                }
            }
            PsiClass aClass = method.getContainingClass();
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkMethodMustHaveBody(method, aClass));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkConstructorCallsBaseClassConstructor(method, this.myRefCountHolder, this.myResolveHelper));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkStaticMethodOverride(method, this.myFile));
            }
        } else if (parent instanceof PsiClass) {
            PsiClass aClass = (PsiClass)parent;
            try {
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightClassUtil.checkDuplicateNestedClass(aClass));
                }
                if (!this.myHolder.hasErrorResults()) {
                    TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
                    this.myHolder.add(HighlightClassUtil.checkClassMustBeAbstract(aClass, textRange));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightClassUtil.checkClassDoesNotCallSuperConstructorOrHandleExceptions(aClass, this.myRefCountHolder, this.myResolveHelper));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightMethodUtil.checkOverrideEquivalentInheritedMethods(aClass, this.myFile, this.myLanguageLevel));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.addAll(GenericsHighlightUtil.checkOverrideEquivalentMethods(aClass));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightClassUtil.checkCyclicInheritance(aClass));
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {}
        } else if (parent instanceof PsiEnumConstant && !this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(GenericsHighlightUtil.checkEnumConstantModifierList(list));
        }
    }

    public void visitNameValuePair(PsiNameValuePair pair) {
        PsiIdentifier nameId;
        this.myHolder.add(AnnotationsHighlightUtil.checkNameValuePair(pair));
        if (!this.myHolder.hasErrorResults() && (nameId = pair.getNameIdentifier()) != null) {
            HighlightInfo result2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ANNOTATION_ATTRIBUTE_NAME).range((PsiElement)nameId).create();
            this.myHolder.add(result2);
        }
    }

    public void visitNewExpression(PsiNewExpression expression) {
        PsiType type = expression.getType();
        PsiClass aClass = PsiUtil.resolveClassInType((PsiType)type);
        this.myHolder.add(HighlightUtil.checkUnhandledExceptions((PsiElement)expression, null));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkAnonymousInheritFinal(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkQualifiedNew(expression, type, aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkCreateInnerClassFromStaticContext(expression, type, aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkTypeParameterInstantiation(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkInstantiationOfAbstractClass(aClass, (PsiElement)expression));
        }
        try {
            if (!this.myHolder.hasErrorResults()) {
                HighlightMethodUtil.checkNewExpression(expression, type, this.myHolder, this.myJavaSdkVersion);
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkEnumInstantiation((PsiElement)expression, aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkGenericArrayCreation((PsiElement)expression, type));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.registerConstructorCall((PsiConstructorCall)expression);
        }
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression((PsiExpression)expression);
        }
    }

    public void visitPackageStatement(PsiPackageStatement statement) {
        super.visitPackageStatement(statement);
        this.myHolder.add(AnnotationsHighlightUtil.checkPackageAnnotationContainingFile(statement));
    }

    public void visitParameter(PsiParameter parameter) {
        super.visitParameter(parameter);
        PsiElement parent = parameter.getParent();
        if (parent instanceof PsiParameterList && parameter.isVarArgs()) {
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(this.checkFeature((PsiElement)parameter, HighlightUtil.Feature.VARARGS));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkVarArgParameterIsLast(parameter));
            }
        } else if (parent instanceof PsiCatchSection) {
            if (!this.myHolder.hasErrorResults() && parameter.getType() instanceof PsiDisjunctionType) {
                this.myHolder.add(this.checkFeature((PsiElement)parameter, HighlightUtil.Feature.MULTI_CATCH));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkCatchParameterIsThrowable(parameter));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.addAll(GenericsHighlightUtil.checkCatchParameterIsClass(parameter));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.addAll(HighlightUtil.checkCatchTypeIsDisjoint(parameter));
            }
        } else if (parent instanceof PsiForeachStatement && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkForEachParameterType((PsiForeachStatement)parent, parameter));
        }
    }

    public void visitParameterList(PsiParameterList list) {
        super.visitParameterList(list);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAnnotationMethodParameters(list));
        }
    }

    public void visitPostfixExpression(PsiPostfixExpression expression) {
        super.visitPostfixExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnaryOperatorApplicable(expression.getOperationSign(), expression.getOperand()));
        }
    }

    public void visitPrefixExpression(PsiPrefixExpression expression) {
        super.visitPrefixExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnaryOperatorApplicable(expression.getOperationSign(), expression.getOperand()));
        }
    }

    private void registerConstructorCall(@NotNull PsiConstructorCall constructorCall) {
        JavaResolveResult resolveResult;
        PsiElement resolved;
        if (constructorCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorCall", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "registerConstructorCall"));
        }
        if (this.myRefCountHolder != null && (resolved = (resolveResult = constructorCall.resolveMethodGenerics()).getElement()) instanceof PsiNamedElement) {
            this.myRefCountHolder.registerLocallyReferenced((PsiNamedElement)resolved);
        }
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement ref) {
        JavaResolveResult resolveResult = this.doVisitReferenceElement(ref);
        if (resolveResult != null && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkRawOnParameterizedType(ref, resolveResult.getElement()));
        }
    }

    private JavaResolveResult doVisitReferenceElement(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiClass containingClass;
        JavaResolveResult result2;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "doVisitReferenceElement"));
        }
        try {
            result2 = this.resolveOptimised(ref);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
        PsiElement resolved = result2.getElement();
        PsiElement parent = ref.getParent();
        if (this.myRefCountHolder != null) {
            this.myRefCountHolder.registerReference((PsiReference)ref, result2);
        }
        this.myHolder.add(HighlightUtil.checkReference(ref, result2, this.myFile, this.myLanguageLevel));
        if ((parent instanceof PsiJavaCodeReferenceElement || ref.isQualified()) && !this.myHolder.hasErrorResults() && resolved instanceof PsiTypeParameter) {
            boolean cannotSelectFromTypeParameter;
            boolean bl = cannotSelectFromTypeParameter = !this.myJavaSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_7);
            if (!cannotSelectFromTypeParameter && (containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class)) != null && (PsiTreeUtil.isAncestor((PsiElement)containingClass.getExtendsList(), (PsiElement)ref, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)containingClass.getImplementsList(), (PsiElement)ref, (boolean)false))) {
                cannotSelectFromTypeParameter = true;
            }
            if (cannotSelectFromTypeParameter) {
                this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).descriptionAndTooltip("Cannot select from a type parameter").range((PsiElement)ref).create());
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkAbstractInstantiation(ref));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkExtendsDuplicate(ref, resolved, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkClassExtendsForeignInnerClass(ref, resolved));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkSelectStaticClassFromParameterizedType(resolved, ref));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(resolved, ref, result2.getSubstitutor(), this.myJavaSdkVersion));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkCannotPassInner(ref));
        }
        if (resolved != null && parent instanceof PsiReferenceList && !this.myHolder.hasErrorResults()) {
            PsiReferenceList referenceList = (PsiReferenceList)parent;
            this.myHolder.add(HighlightUtil.checkElementInReferenceList(ref, referenceList, result2, this.myLanguageLevel));
        }
        if (parent instanceof PsiAnonymousClass && ref.equals(((PsiAnonymousClass)parent).getBaseClassReference())) {
            PsiClass aClass = (PsiClass)parent;
            this.myHolder.addAll(GenericsHighlightUtil.checkOverrideEquivalentMethods(aClass));
        }
        if (resolved instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)resolved;
            containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class);
            if (containingClass instanceof PsiAnonymousClass && !PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)variable, (boolean)false) && !(variable instanceof PsiField) && !PsiTreeUtil.isAncestor((PsiElement)((PsiAnonymousClass)containingClass).getArgumentList(), (PsiElement)ref, (boolean)false)) {
                this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.IMPLICIT_ANONYMOUS_CLASS_PARAMETER).range((PsiElement)ref).create());
            }
            if (variable instanceof PsiParameter && ref instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)ref))) {
                this.myReassignedParameters.put((Object)((PsiParameter)variable), 2);
            }
            TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
            if (!variable.hasModifierProperty("final") && this.isReassigned(variable)) {
                this.myHolder.add(HighlightNamesUtil.highlightReassignedVariable(variable, (PsiElement)ref));
            } else {
                this.myHolder.add(HighlightNamesUtil.highlightVariableName(variable, ref.getReferenceNameElement(), colorsScheme));
            }
            this.myHolder.add(HighlightNamesUtil.highlightClassNameInQualifier(ref, colorsScheme));
        } else {
            this.highlightReferencedMethodOrClassName(ref, resolved);
        }
        if (parent instanceof PsiNewExpression && !(resolved instanceof PsiClass) && resolved instanceof PsiNamedElement && ((PsiNewExpression)parent).getClassOrAnonymousClassReference() == ref) {
            this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip("Cannot find symbol " + ((PsiNamedElement)resolved).getName()).create());
        }
        if (!this.myHolder.hasErrorResults() && resolved instanceof PsiClass) {
            PsiClass outerClass;
            PsiTypeParameterListOwner owner;
            PsiClass aClass = ((PsiClass)resolved).getContainingClass();
            if (aClass != null) {
                PsiExpression newQualifier;
                PsiElement qualifier = ref.getQualifier();
                Object place = qualifier instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)qualifier).resolve() : (parent instanceof PsiNewExpression ? ((newQualifier = ((PsiNewExpression)parent).getQualifier()) == null ? ref : PsiUtil.resolveClassInType((PsiType)newQualifier.getType())) : ref);
                if (place != null && PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)place, (boolean)false) && aClass.hasTypeParameters()) {
                    this.myHolder.add(HighlightClassUtil.checkCreateInnerClassFromStaticContext((PsiElement)ref, place, (PsiClass)resolved));
                }
            } else if (resolved instanceof PsiTypeParameter && (owner = ((PsiTypeParameter)resolved).getOwner()) instanceof PsiClass && !InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)(outerClass = (PsiClass)owner), (PsiElement)ref, (boolean)false, (boolean)false)) {
                this.myHolder.add(HighlightClassUtil.reportIllegalEnclosingUsage((PsiElement)ref, null, (PsiClass)owner, (PsiElement)ref));
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkPackageAndClassConflict(ref, this.myFile));
        }
        return result2;
    }

    @NotNull
    private JavaResolveResult resolveOptimised(@NotNull PsiJavaCodeReferenceElement ref) {
        JavaResolveResult[] results;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "resolveOptimised"));
        }
        JavaResolveResult result2 = ref instanceof PsiReferenceExpressionImpl ? ((results = JavaResolveUtil.resolveWithContainingFile(ref, PsiReferenceExpressionImpl.OurGenericsResolver.INSTANCE, true, true, this.myFile)).length == 1 ? results[0] : JavaResolveResult.EMPTY) : ref.advancedResolve(true);
        JavaResolveResult javaResolveResult = result2;
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "resolveOptimised"));
        }
        return javaResolveResult;
    }

    @NotNull
    private JavaResolveResult[] resolveOptimised(@NotNull PsiReferenceExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "resolveOptimised"));
        }
        JavaResolveResult[] results = expression instanceof PsiReferenceExpressionImpl ? JavaResolveUtil.resolveWithContainingFile(expression, PsiReferenceExpressionImpl.OurGenericsResolver.INSTANCE, true, true, this.myFile) : expression.multiResolve(true);
        if (results == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "resolveOptimised"));
        }
        return results;
    }

    public void visitReferenceExpression(PsiReferenceExpression expression) {
        PsiExpressionList list;
        PsiMethodCallExpression methodCallExpression2;
        PsiElement parent;
        JavaResolveResult result2;
        JavaResolveResult[] results;
        JavaResolveResult resultForIncompleteCode = this.doVisitReferenceElement((PsiJavaCodeReferenceElement)expression);
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression((PsiExpression)expression);
            if (this.myHolder.hasErrorResults()) {
                return;
            }
        }
        try {
            results = this.resolveOptimised(expression);
            result2 = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        }
        catch (IndexNotReadyException e) {
            return;
        }
        PsiElement resolved = result2.getElement();
        if (resolved instanceof PsiVariable && resolved.getContainingFile() == expression.getContainingFile()) {
            PsiVariable variable;
            boolean isFinal;
            if (!this.myHolder.hasErrorResults()) {
                try {
                    this.myHolder.add(HighlightControlFlowUtil.checkVariableInitializedBeforeUsage(expression, (PsiVariable)resolved, this.myUninitializedVarProblems, this.myFile));
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
            }
            if ((isFinal = (variable = (PsiVariable)resolved).hasModifierProperty("final")) && !variable.hasInitializer()) {
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightControlFlowUtil.checkFinalVariableMightAlreadyHaveBeenAssignedTo(variable, expression, this.myFinalVarProblems));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightControlFlowUtil.checkFinalVariableInitializedInLoop(expression, resolved));
                }
            }
        }
        if (!(!((parent = expression.getParent()) instanceof PsiMethodCallExpression) || ((PsiMethodCallExpression)parent).getMethodExpression() != expression || result2.isAccessible() && result2.isStaticsScopeCorrect() || HighlightMethodUtil.isDummyConstructorCall(methodCallExpression2 = (PsiMethodCallExpression)parent, this.myResolveHelper, list = methodCallExpression2.getArgumentList(), expression))) {
            try {
                this.myHolder.add(HighlightMethodUtil.checkAmbiguousMethodCallIdentifier(expression, results, list, resolved, result2, methodCallExpression2, this.myResolveHelper));
                if (!PsiTreeUtil.findChildrenOfType((PsiElement)methodCallExpression2.getArgumentList(), PsiLambdaExpression.class).isEmpty()) {
                    this.myHolder.add(HighlightMethodUtil.checkAmbiguousMethodCallArguments(expression, results, list, resolved, result2, methodCallExpression2, this.myResolveHelper, expression.getReferenceNameElement()));
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkExpressionRequired(expression, resultForIncompleteCode));
        }
        if (!this.myHolder.hasErrorResults() && resolved instanceof PsiField) {
            try {
                this.myHolder.add(HighlightUtil.checkIllegalForwardReferenceToField(expression, (PsiField)resolved));
            }
            catch (IndexNotReadyException methodCallExpression2) {
                // empty catch block
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkAccessStaticFieldFromEnumConstructor(expression, result2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkClassReferenceAfterQualifier(expression, resolved));
        }
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        this.myHolder.add(HighlightUtil.checkUnqualifiedSuperInDefaultMethod(this.myLanguageLevel, expression, qualifierExpression));
        if (!this.myHolder.hasErrorResults() && qualifierExpression != null) {
            PsiClass psiClass;
            PsiType type = qualifierExpression.getType();
            if (type instanceof PsiCapturedWildcardType) {
                type = ((PsiCapturedWildcardType)type).getUpperBound();
            }
            if ((psiClass = PsiUtil.resolveClassInType((PsiType)type)) != null) {
                this.myHolder.add(GenericsHighlightUtil.areSupersAccessible(psiClass, (PsiElement)qualifierExpression));
            }
        }
    }

    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
        PsiElement qualifier;
        PsiElement method;
        JavaResolveResult result2;
        JavaResolveResult[] results;
        this.myHolder.add(this.checkFeature((PsiElement)expression, HighlightUtil.Feature.METHOD_REFERENCES));
        try {
            results = expression.multiResolve(true);
            result2 = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        }
        catch (IndexNotReadyException e) {
            return;
        }
        if (this.myRefCountHolder != null) {
            this.myRefCountHolder.registerReference((PsiReference)expression, result2);
        }
        if ((method = result2.getElement()) != null && !result2.isAccessible()) {
            String accessProblem = HighlightUtil.buildProblemWithAccessDescription((PsiElement)expression, result2);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(accessProblem).create();
            this.myHolder.add(info);
        } else {
            TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
            if (method instanceof PsiMethod) {
                PsiElement methodNameElement = expression.getReferenceNameElement();
                this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMethod)method, methodNameElement, false, colorsScheme));
            }
            this.myHolder.add(HighlightNamesUtil.highlightClassNameInQualifier((PsiJavaCodeReferenceElement)expression, colorsScheme));
        }
        if (!this.myHolder.hasErrorResults()) {
            PsiClassType.ClassResolveResult resolveResult;
            PsiMethod interfaceMethod;
            PsiElement referenceNameElement;
            PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
            if (functionalInterfaceType != null) {
                boolean notFunctional;
                boolean bl = notFunctional = !LambdaUtil.isFunctionalType((PsiType)functionalInterfaceType);
                if (notFunctional) {
                    this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(functionalInterfaceType.getPresentableText() + " is not a functional interface").create());
                }
            }
            if (!this.myHolder.hasErrorResults() && (referenceNameElement = expression.getReferenceNameElement()) instanceof PsiKeyword && !PsiMethodReferenceUtil.isValidQualifier((PsiMethodReferenceExpression)expression)) {
                PsiElement qualifier2 = expression.getQualifier();
                String description = "Cannot find class " + qualifier2.getText();
                HighlightInfo result1 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(qualifier2).descriptionAndTooltip(description).create();
                this.myHolder.add(result1);
            }
            if (!this.myHolder.hasErrorResults() && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)(resolveResult = this.checkFunctionalInterfaceTypeAccessible((PsiFunctionalExpression)expression, functionalInterfaceType)))) != null) {
                String badReturnTypeMessage;
                String errorMessage;
                if (!this.myHolder.hasErrorResults() && (errorMessage = PsiMethodReferenceUtil.checkMethodReferenceContext((PsiMethodReferenceExpression)expression)) != null) {
                    this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(errorMessage).create());
                }
                if (!this.myHolder.hasErrorResults() && (badReturnTypeMessage = PsiMethodReferenceUtil.checkReturnType((PsiMethodReferenceExpression)expression, (JavaResolveResult)result2, (PsiType)functionalInterfaceType)) != null) {
                    this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(badReturnTypeMessage).create());
                }
            }
        }
        if (!this.myHolder.hasErrorResults() && (qualifier = expression.getQualifier()) instanceof PsiTypeElement) {
            PsiType psiType = ((PsiTypeElement)qualifier).getType();
            HighlightInfo genericArrayCreationInfo = GenericsHighlightUtil.checkGenericArrayCreation(qualifier, psiType);
            if (genericArrayCreationInfo != null) {
                this.myHolder.add(genericArrayCreationInfo);
            } else {
                String wildcardMessage = PsiMethodReferenceUtil.checkTypeArguments((PsiTypeElement)((PsiTypeElement)qualifier), (PsiType)psiType);
                if (wildcardMessage != null) {
                    this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(qualifier).descriptionAndTooltip(wildcardMessage).create());
                }
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(PsiMethodReferenceHighlightingUtil.checkRawConstructorReference(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnhandledExceptions((PsiElement)expression, expression.getTextRange()));
        }
        if (!this.myHolder.hasErrorResults() && (results.length == 0 || results[0] instanceof MethodCandidateInfo && !((MethodCandidateInfo)results[0]).isApplicable() && expression.getFunctionalInterfaceType() != null)) {
            String description = null;
            if (expression.isConstructor()) {
                PsiClass containingClass = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)expression).getContainingClass();
                if (containingClass != null && !this.myHolder.add(HighlightClassUtil.checkInstantiationOfAbstractClass(containingClass, (PsiElement)expression)) && !this.myHolder.add(GenericsHighlightUtil.checkEnumInstantiation((PsiElement)expression, containingClass)) && containingClass.isPhysical()) {
                    description = JavaErrorMessages.message("cannot.resolve.constructor", containingClass.getName());
                }
            } else {
                description = JavaErrorMessages.message("cannot.resolve.method", expression.getReferenceName());
            }
            if (description != null) {
                PsiElement referenceNameElement = expression.getReferenceNameElement();
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(results.length == 0 ? HighlightInfoType.WRONG_REF : HighlightInfoType.ERROR).descriptionAndTooltip(description).range(referenceNameElement).create();
                this.myHolder.add(highlightInfo);
                TextRange fixRange = HighlightMethodUtil.getFixRange(referenceNameElement);
                QuickFixAction.registerQuickFixAction(highlightInfo, fixRange, QuickFixFactory.getInstance().createCreateMethodFromUsageFix(expression));
            }
        }
    }

    private PsiClassType.ClassResolveResult checkFunctionalInterfaceTypeAccessible(PsiFunctionalExpression expression, PsiType functionalInterfaceType) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null) {
            if (!PsiUtil.isAccessible((Project)this.myFile.getProject(), (PsiMember)psiClass, (PsiElement)expression, null)) {
                this.myHolder.add(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip(HighlightUtil.buildProblemWithAccessDescription((PsiElement)expression, (JavaResolveResult)resolveResult)).create());
            } else {
                for (PsiType type : resolveResult.getSubstitutor().getSubstitutionMap().values()) {
                    this.checkFunctionalInterfaceTypeAccessible(expression, type);
                }
            }
        }
        return resolveResult;
    }

    public void visitReferenceList(PsiReferenceList list) {
        if (list.getFirstChild() == null) {
            return;
        }
        PsiElement parent = list.getParent();
        if (!(parent instanceof PsiTypeParameter)) {
            this.myHolder.add(AnnotationsHighlightUtil.checkAnnotationDeclaration(parent, list));
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkExtendsAllowed(list));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkImplementsAllowed(list));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkClassExtendsOnlyOneClass(list));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkGenericCannotExtendException(list));
            }
        }
    }

    public void visitReferenceParameterList(PsiReferenceParameterList list) {
        if (list.getTextLength() == 0) {
            return;
        }
        this.myHolder.add(this.checkFeature((PsiElement)list, HighlightUtil.Feature.GENERICS));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkParametersAllowed(list));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkParametersOnRaw(list));
        }
        if (!this.myHolder.hasErrorResults()) {
            for (PsiTypeElement typeElement : list.getTypeParameterElements()) {
                if (!(typeElement.getType() instanceof PsiDiamondType)) continue;
                this.myHolder.add(this.checkFeature((PsiElement)list, HighlightUtil.Feature.DIAMOND_TYPES));
            }
        }
    }

    public void visitReturnStatement(PsiReturnStatement statement) {
        try {
            this.myHolder.add(HighlightUtil.checkReturnStatementType(statement));
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    public void visitStatement(PsiStatement statement) {
        super.visitStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkNotAStatement(statement));
        }
    }

    public void visitSuperExpression(PsiSuperExpression expr) {
        this.myHolder.add(HighlightUtil.checkThisOrSuperExpressionInIllegalContext((PsiExpression)expr, expr.getQualifier(), this.myLanguageLevel));
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression((PsiExpression)expr);
        }
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
        super.visitSwitchLabelStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkCaseStatement(statement));
        }
    }

    public void visitSwitchStatement(PsiSwitchStatement statement) {
        super.visitSwitchStatement(statement);
        this.myHolder.add(HighlightUtil.checkStatementPrependedWithCaseInsideSwitch(statement));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkSwitchSelectorType(statement, this.myLanguageLevel));
        }
    }

    public void visitThisExpression(PsiThisExpression expr) {
        if (!(expr.getParent() instanceof PsiReceiverParameter)) {
            this.myHolder.add(HighlightUtil.checkThisOrSuperExpressionInIllegalContext((PsiExpression)expr, expr.getQualifier(), this.myLanguageLevel));
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkMemberReferencedBeforeConstructorCalled((PsiElement)expr, null, this.myFile));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.visitExpression((PsiExpression)expr);
            }
        }
    }

    public void visitThrowStatement(PsiThrowStatement statement) {
        this.myHolder.add(HighlightUtil.checkUnhandledExceptions((PsiElement)statement, null));
        if (!this.myHolder.hasErrorResults()) {
            this.visitStatement((PsiStatement)statement);
        }
    }

    public void visitTryStatement(PsiTryStatement statement) {
        super.visitTryStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            Set<PsiClassType> thrownTypes = HighlightUtil.collectUnhandledExceptions(statement);
            for (PsiParameter parameter : statement.getCatchBlockParameters()) {
                boolean added = this.myHolder.addAll(HighlightUtil.checkExceptionAlreadyCaught(parameter));
                if (!added) {
                    added = this.myHolder.addAll(HighlightUtil.checkExceptionThrownInTry(parameter, thrownTypes));
                }
                if (added) continue;
                this.myHolder.addAll(HighlightUtil.checkWithImprovedCatchAnalysis(parameter, thrownTypes, this.myFile));
            }
        }
    }

    public void visitResourceList(PsiResourceList resourceList) {
        super.visitResourceList(resourceList);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature((PsiElement)resourceList, HighlightUtil.Feature.TRY_WITH_RESOURCES));
        }
    }

    public void visitResourceVariable(PsiResourceVariable resource) {
        super.visitResourceVariable(resource);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkTryResourceIsAutoCloseable((PsiResourceListElement)resource));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnhandledCloserExceptions((PsiResourceListElement)resource));
        }
    }

    public void visitResourceExpression(PsiResourceExpression resource) {
        super.visitResourceExpression(resource);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature((PsiElement)resource, HighlightUtil.Feature.REFS_AS_RESOURCE));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkResourceVariableIsFinal(resource));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkTryResourceIsAutoCloseable((PsiResourceListElement)resource));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnhandledCloserExceptions((PsiResourceListElement)resource));
        }
    }

    public void visitTypeElement(PsiTypeElement type) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkIllegalType(type));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkReferenceTypeUsedAsTypeArgument(type, this.myLanguageLevel));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkWildcardUsage(type));
        }
    }

    public void visitTypeCastExpression(PsiTypeCastExpression typeCast) {
        super.visitTypeCastExpression(typeCast);
        try {
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkIntersectionInTypeCast(typeCast, this.myLanguageLevel));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkInconvertibleTypeCast(typeCast));
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    public void visitTypeParameterList(PsiTypeParameterList list) {
        PsiTypeParameter[] typeParameters = list.getTypeParameters();
        if (typeParameters.length > 0) {
            this.myHolder.add(this.checkFeature((PsiElement)list, HighlightUtil.Feature.GENERICS));
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkTypeParametersList(list, typeParameters, this.myLanguageLevel));
            }
        }
    }

    public void visitVariable(PsiVariable variable) {
        super.visitVariable(variable);
        try {
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkVariableInitializerType(variable));
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    private boolean isReassigned(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "isReassigned"));
        }
        try {
            boolean reassigned = variable instanceof PsiParameter ? this.myReassignedParameters.get((Object)((PsiParameter)variable)) == 2 : HighlightControlFlowUtil.isReassigned(variable, this.myFinalVarProblems);
            return reassigned;
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    public void visitConditionalExpression(PsiConditionalExpression expression) {
        super.visitConditionalExpression(expression);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) && PsiPolyExpressionUtil.isPolyExpression((PsiExpression)expression)) {
            PsiType conditionalType;
            PsiExpression thenExpression = expression.getThenExpression();
            PsiExpression elseExpression = expression.getElseExpression();
            if (thenExpression != null && elseExpression != null && (conditionalType = expression.getType()) != null) {
                PsiExpression[] sides;
                for (PsiExpression side : sides = new PsiExpression[]{thenExpression, elseExpression}) {
                    PsiType sideType = side.getType();
                    if (sideType == null || TypeConversionUtil.isAssignable((PsiType)conditionalType, (PsiType)sideType)) continue;
                    this.myHolder.add(HighlightUtil.checkAssignability(conditionalType, sideType, side, (PsiElement)side));
                }
            }
        }
    }

    public void visitReceiverParameter(PsiReceiverParameter parameter) {
        super.visitReceiverParameter(parameter);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature((PsiElement)parameter, HighlightUtil.Feature.RECEIVERS));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkReceiverPlacement(parameter));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkReceiverType(parameter));
        }
    }

    @Nullable
    private HighlightInfo checkFeature(@NotNull PsiElement element, @NotNull HighlightUtil.Feature feature) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "checkFeature"));
        }
        if (feature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "feature", "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl", "checkFeature"));
        }
        return HighlightUtil.checkFeature(element, feature, this.myLanguageLevel, this.myFile);
    }

    private static class Holder {
        private static final boolean CHECK_ELEMENT_LEVEL = ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal();

        private Holder() {
        }
    }
}

