/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.actions.CodeInspectionAction;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.header.InspectionToolsConfigurable;
import javax.swing.JComboBox;

public class CodeCleanupAction
extends CodeInspectionAction {
    public static final String CODE_CLEANUP_INSPECTIONS_DISPLAY_NAME = "Code Cleanup Inspections";

    public CodeCleanupAction() {
        super("Code Cleanup", "Code Cleanup");
    }

    @Override
    protected void runInspections(Project project, AnalysisScope scope) {
        InspectionProfile profile = this.myExternalProfile != null ? this.myExternalProfile : InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
        InspectionManager managerEx = InspectionManager.getInstance((Project)project);
        GlobalInspectionContextBase globalContext = (GlobalInspectionContextBase)managerEx.createNewGlobalContext(false);
        globalContext.codeCleanup(project, scope, profile, this.getTemplatePresentation().getText(), null, false);
    }

    @Override
    protected String getHelpTopic() {
        return "reference.dialogs.cleanup.scope";
    }

    @Override
    protected InspectionToolsConfigurable createConfigurable(InspectionProjectProfileManager projectProfileManager, InspectionProfileManager profileManager, JComboBox profilesCombo) {
        return new CodeInspectionAction.ExternalProfilesComboboxAwareInspectionToolsConfigurable(projectProfileManager, profileManager, profilesCombo){

            @Override
            protected boolean acceptTool(InspectionToolWrapper entry) {
                return super.acceptTool(entry) && entry.isCleanupTool();
            }

            @Override
            public String getDisplayName() {
                return CodeCleanupAction.CODE_CLEANUP_INSPECTIONS_DISPLAY_NAME;
            }
        };
    }
}

