/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.EqClass;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TLongArrayList;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongIterator;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaMemoryStateImpl
implements DfaMemoryState {
    private final DfaValueFactory myFactory;
    private final List<EqClass> myEqClasses;
    private final TIntObjectHashMap<int[]> myIdToEqClassesIndices;
    private final Stack<DfaValue> myStack;
    private final TLongHashSet myDistinctClasses;
    private final LinkedHashMap<DfaVariableValue, DfaVariableState> myVariableStates;
    private final Map<DfaVariableValue, DfaVariableState> myDefaultVariableStates;
    private final LinkedHashSet<DfaVariableValue> myUnknownVariables;
    private boolean myEphemeral;
    private LinkedHashSet<UnorderedPair<EqClass>> myCachedDistinctClassPairs;
    private LinkedHashSet<EqClass> myCachedNonTrivialEqClasses;
    private Integer myCachedHash;

    protected DfaMemoryStateImpl(DfaValueFactory factory) {
        this.myFactory = factory;
        this.myDefaultVariableStates = ContainerUtil.newTroveMap();
        this.myEqClasses = ContainerUtil.newArrayList();
        this.myUnknownVariables = ContainerUtil.newLinkedHashSet();
        this.myVariableStates = ContainerUtil.newLinkedHashMap();
        this.myDistinctClasses = new TLongHashSet();
        this.myStack = new Stack();
        this.myIdToEqClassesIndices = new MyIdMap(20);
    }

    protected DfaMemoryStateImpl(DfaMemoryStateImpl toCopy) {
        this.myFactory = toCopy.myFactory;
        this.myEphemeral = toCopy.myEphemeral;
        this.myDefaultVariableStates = toCopy.myDefaultVariableStates;
        this.myStack = new Stack(toCopy.myStack);
        this.myDistinctClasses = new TLongHashSet(toCopy.myDistinctClasses.toArray());
        this.myUnknownVariables = ContainerUtil.newLinkedHashSet(toCopy.myUnknownVariables);
        this.myEqClasses = ContainerUtil.newArrayList(toCopy.myEqClasses);
        this.myIdToEqClassesIndices = new MyIdMap(toCopy.myIdToEqClassesIndices.size());
        toCopy.myIdToEqClassesIndices.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<int[]>(){

            public boolean execute(int id, int[] set) {
                DfaMemoryStateImpl.this.myIdToEqClassesIndices.put(id, (Object)set);
                return true;
            }
        });
        this.myVariableStates = ContainerUtil.newLinkedHashMap(toCopy.myVariableStates);
        this.myCachedDistinctClassPairs = toCopy.myCachedDistinctClassPairs;
        this.myCachedNonTrivialEqClasses = toCopy.myCachedNonTrivialEqClasses;
        this.myCachedHash = toCopy.myCachedHash;
    }

    @NotNull
    public DfaValueFactory getFactory() {
        DfaValueFactory dfaValueFactory = this.myFactory;
        if (dfaValueFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getFactory"));
        }
        return dfaValueFactory;
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createCopy() {
        DfaMemoryStateImpl dfaMemoryStateImpl = new DfaMemoryStateImpl(this);
        if (dfaMemoryStateImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "createCopy"));
        }
        return dfaMemoryStateImpl;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaMemoryStateImpl)) {
            return false;
        }
        DfaMemoryStateImpl that = (DfaMemoryStateImpl)obj;
        if (this.myCachedHash != null && that.myCachedHash != null && !this.myCachedHash.equals(that.myCachedHash)) {
            return false;
        }
        return this.equalsSuperficially(that) && this.equalsByUnknownVariables(that) && this.equalsByRelations(that) && this.equalsByVariableStates(that);
    }

    private boolean equalsByUnknownVariables(DfaMemoryStateImpl that) {
        return this.myUnknownVariables.equals(that.myUnknownVariables);
    }

    Object getSuperficialKey() {
        return Pair.create((Object)this.myEphemeral, this.myStack);
    }

    private boolean equalsSuperficially(DfaMemoryStateImpl other) {
        return this.myEphemeral == other.myEphemeral && this.myStack.equals(other.myStack);
    }

    boolean equalsByRelations(DfaMemoryStateImpl that) {
        return this.getNonTrivialEqClasses().equals(that.getNonTrivialEqClasses()) && this.getDistinctClassPairs().equals(that.getDistinctClassPairs());
    }

    boolean equalsByVariableStates(DfaMemoryStateImpl that) {
        return this.myVariableStates.equals(that.myVariableStates);
    }

    LinkedHashSet<UnorderedPair<EqClass>> getDistinctClassPairs() {
        if (this.myCachedDistinctClassPairs != null) {
            return this.myCachedDistinctClassPairs;
        }
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        for (long encodedPair : this.myDistinctClasses.toArray()) {
            result2.add(new UnorderedPair((Object)this.myEqClasses.get(DfaMemoryStateImpl.low(encodedPair)), (Object)this.myEqClasses.get(DfaMemoryStateImpl.high(encodedPair))));
        }
        this.myCachedDistinctClassPairs = result2;
        return this.myCachedDistinctClassPairs;
    }

    LinkedHashSet<EqClass> getNonTrivialEqClasses() {
        if (this.myCachedNonTrivialEqClasses != null) {
            return this.myCachedNonTrivialEqClasses;
        }
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        for (EqClass eqClass : this.myEqClasses) {
            if (eqClass == null || eqClass.size() <= 1) continue;
            result2.add(eqClass);
        }
        this.myCachedNonTrivialEqClasses = result2;
        return this.myCachedNonTrivialEqClasses;
    }

    public int hashCode() {
        if (this.myCachedHash != null) {
            return this.myCachedHash;
        }
        int hash = this.getPartialHashCode(true, true);
        this.myCachedHash = hash;
        return hash;
    }

    int getPartialHashCode(boolean unknowns, boolean varStates) {
        int hash = (this.getNonTrivialEqClasses().hashCode() * 31 + this.getDistinctClassPairs().hashCode()) * 31 + this.myStack.hashCode();
        if (varStates) {
            hash = hash * 31 + this.myVariableStates.hashCode();
        }
        if (unknowns && !this.myUnknownVariables.isEmpty()) {
            hash = hash * 31 + this.myUnknownVariables.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append('<');
        if (this.myEphemeral) {
            result2.append("ephemeral, ");
        }
        for (EqClass eqClass : this.getNonTrivialEqClasses()) {
            result2.append(eqClass);
        }
        if (!this.myDistinctClasses.isEmpty()) {
            result2.append("\n  distincts: ");
            ArrayList<String> distincts = new ArrayList<String>();
            for (UnorderedPair unorderedPair : this.getDistinctClassPairs()) {
                distincts.add("{" + unorderedPair.first + ", " + unorderedPair.second + "}");
            }
            Collections.sort(distincts);
            result2.append(StringUtil.join(distincts, (String)" "));
        }
        if (!this.myStack.isEmpty()) {
            result2.append("\n  stack: ").append(StringUtil.join(this.myStack, (String)","));
        }
        if (!this.myVariableStates.isEmpty()) {
            result2.append("\n  vars: ");
            for (Map.Entry entry : this.myVariableStates.entrySet()) {
                result2.append("[").append(entry.getKey()).append("->").append(entry.getValue()).append("] ");
            }
        }
        if (!this.myUnknownVariables.isEmpty()) {
            result2.append("\n  unknowns: ").append(new HashSet<DfaVariableValue>(this.myUnknownVariables));
        }
        result2.append('>');
        return result2.toString();
    }

    @Override
    public DfaValue pop() {
        this.myCachedHash = null;
        return (DfaValue)this.myStack.pop();
    }

    @Override
    public DfaValue peek() {
        return (DfaValue)this.myStack.peek();
    }

    @Override
    public void push(@NotNull DfaValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "push"));
        }
        this.myCachedHash = null;
        this.myStack.push((Object)value);
    }

    @Override
    public void emptyStack() {
        this.myCachedHash = null;
        this.myStack.clear();
    }

    @Override
    public void setVarValue(DfaVariableValue var, DfaValue value) {
        if (var == value) {
            return;
        }
        value = this.handleFlush(var, value);
        this.flushVariable(var);
        if (value instanceof DfaUnknownValue) {
            this.setVariableState(var, this.getVariableState(var).withNullable(false));
            return;
        }
        this.setVariableState(var, this.getVariableState(var).withValue(value));
        if (value instanceof DfaTypeValue) {
            this.setVariableState(var, this.getVariableState(var).withNullability(((DfaTypeValue)value).getNullness()));
            DfaRelationValue dfaInstanceof = this.myFactory.getRelationFactory().createRelation(var, value, JavaTokenType.INSTANCEOF_KEYWORD, false);
            if (((DfaTypeValue)value).isNotNull()) {
                this.applyCondition(dfaInstanceof);
            } else {
                this.applyInstanceofOrNull(dfaInstanceof);
            }
        } else {
            DfaRelationValue dfaEqual = this.myFactory.getRelationFactory().createRelation(var, value, JavaTokenType.EQEQ, false);
            if (dfaEqual == null) {
                return;
            }
            this.applyCondition(dfaEqual);
            if (value instanceof DfaVariableValue) {
                this.setVariableState(var, this.getVariableState((DfaVariableValue)value));
            }
        }
        if (this.getVariableState(var).isNotNull()) {
            this.applyCondition(this.compareToNull(var, true));
        }
    }

    private DfaValue handleFlush(DfaVariableValue flushed, DfaValue value) {
        if (value instanceof DfaVariableValue && (value == flushed || this.myFactory.getVarFactory().getAllQualifiedBy(flushed).contains(value))) {
            Nullness nullability = this.isNotNull(value) ? Nullness.NOT_NULL : ((DfaVariableValue)value).getInherentNullability();
            return this.myFactory.createTypeValue(((DfaVariableValue)value).getVariableType(), nullability);
        }
        return value;
    }

    @Nullable(value="for boxed values which can't be compared by ==")
    private Integer getOrCreateEqClassIndex(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getOrCreateEqClassIndex"));
        }
        int i = this.getEqClassIndex(dfaValue);
        if (i != -1) {
            return i;
        }
        if (!DfaMemoryStateImpl.canBeInRelation(dfaValue) || !this.canBeReused(dfaValue) && !(((DfaBoxedValue)dfaValue).getWrappedValue() instanceof DfaConstValue)) {
            return null;
        }
        int freeIndex = this.myEqClasses.indexOf(null);
        int resultIndex = freeIndex >= 0 ? freeIndex : this.myEqClasses.size();
        EqClass aClass = new EqClass(this.myFactory);
        aClass.add(dfaValue.getID());
        if (freeIndex >= 0) {
            this.myEqClasses.set(freeIndex, aClass);
        } else {
            this.myEqClasses.add(aClass);
        }
        this.addToMap(dfaValue.getID(), resultIndex);
        return resultIndex;
    }

    private void addToMap(int id, int index) {
        int[] classes = (int[])this.myIdToEqClassesIndices.get(id = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID());
        if (classes == null) {
            classes = new int[]{index};
            this.myIdToEqClassesIndices.put(id, (Object)classes);
        } else {
            classes = ArrayUtil.append((int[])classes, (int)index);
            this.myIdToEqClassesIndices.put(id, (Object)classes);
        }
    }

    private void removeFromMap(int id, int index) {
        int i;
        int[] classes = (int[])this.myIdToEqClassesIndices.get(id = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID());
        if (classes != null && (i = ArrayUtil.indexOf((int[])classes, (int)index)) != -1) {
            classes = ArrayUtil.remove((int[])classes, (int)i);
            this.myIdToEqClassesIndices.put(id, (Object)classes);
        }
    }

    private void removeAllFromMap(int id) {
        if (id < 0) {
            return;
        }
        id = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID();
        this.myIdToEqClassesIndices.remove(id);
    }

    private static boolean canBeInRelation(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "canBeInRelation"));
        }
        DfaValue unwrapped = DfaMemoryStateImpl.unwrap(dfaValue);
        return unwrapped instanceof DfaVariableValue || unwrapped instanceof DfaConstValue;
    }

    @NotNull
    List<DfaValue> getEquivalentValues(@NotNull DfaValue dfaValue) {
        EqClass set;
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getEquivalentValues"));
        }
        int index = this.getEqClassIndex(dfaValue);
        EqClass eqClass = set = index == -1 ? null : this.myEqClasses.get(index);
        if (set == null) {
            List<DfaValue> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getEquivalentValues"));
            }
            return list;
        }
        List<DfaValue> list = set.getMemberValues();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getEquivalentValues"));
        }
        return list;
    }

    private boolean canBeNaN(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "canBeNaN"));
        }
        for (DfaValue eq : this.getEquivalentValues(dfaValue)) {
            if (eq instanceof DfaBoxedValue) {
                eq = ((DfaBoxedValue)eq).getWrappedValue();
            }
            if (!(eq instanceof DfaConstValue) || DfaMemoryStateImpl.isNaN(eq)) continue;
            return false;
        }
        return dfaValue instanceof DfaVariableValue && TypeConversionUtil.isFloatOrDoubleType((PsiType)((DfaVariableValue)dfaValue).getVariableType());
    }

    private boolean isEffectivelyNaN(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "isEffectivelyNaN"));
        }
        for (DfaValue eqClass : this.getEquivalentValues(dfaValue)) {
            if (!DfaMemoryStateImpl.isNaN(eqClass)) continue;
            return true;
        }
        return false;
    }

    private int getEqClassIndex(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getEqClassIndex"));
        }
        int id = DfaMemoryStateImpl.unwrap(dfaValue).getID();
        int[] classes = (int[])this.myIdToEqClassesIndices.get(id);
        int result2 = -1;
        if (classes != null) {
            for (int index : classes) {
                EqClass aClass = this.myEqClasses.get(index);
                if (!aClass.contains(dfaValue.getID())) continue;
                if (!this.canBeReused(dfaValue) && aClass.size() > 1) break;
                result2 = index;
                break;
            }
        }
        return result2;
    }

    private boolean canBeReused(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "canBeReused"));
        }
        if (dfaValue instanceof DfaBoxedValue) {
            DfaValue valueToWrap = ((DfaBoxedValue)dfaValue).getWrappedValue();
            if (valueToWrap instanceof DfaConstValue) {
                return DfaMemoryStateImpl.cacheable((DfaConstValue)valueToWrap);
            }
            if (valueToWrap instanceof DfaVariableValue) {
                if (PsiType.BOOLEAN.equals((Object)((DfaVariableValue)valueToWrap).getVariableType())) {
                    return true;
                }
                for (DfaValue value : this.getEquivalentValues(valueToWrap)) {
                    if (!(value instanceof DfaConstValue) || !DfaMemoryStateImpl.cacheable((DfaConstValue)value)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static boolean cacheable(@NotNull DfaConstValue dfaConstValue) {
        if (dfaConstValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaConstValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "cacheable"));
        }
        Object value = dfaConstValue.getValue();
        return DfaMemoryStateImpl.box(value) == DfaMemoryStateImpl.box(value);
    }

    private static Object box(Object value) {
        Constable newBoxedValue;
        if (value instanceof Integer) {
            newBoxedValue = (int)((Integer)value);
        } else if (value instanceof Byte) {
            newBoxedValue = (byte)((Byte)value);
        } else if (value instanceof Short) {
            newBoxedValue = (short)((Short)value);
        } else if (value instanceof Long) {
            newBoxedValue = (long)((Long)value);
        } else if (value instanceof Boolean) {
            newBoxedValue = (Boolean)value;
        } else if (value instanceof Character) {
            newBoxedValue = Character.valueOf(((Character)value).charValue());
        } else {
            return new Object();
        }
        return newBoxedValue;
    }

    private boolean uniteClasses(int c1Index, int c2Index) {
        int i;
        long[] distincts;
        EqClass c1 = this.myEqClasses.get(c1Index);
        EqClass c2 = this.myEqClasses.get(c2Index);
        THashSet vars = ContainerUtil.newTroveSet();
        THashSet negatedVars = ContainerUtil.newTroveSet();
        int[] cs = new int[c1.size() + c2.size()];
        c1.set(0, cs, 0, c1.size());
        c2.set(0, cs, c1.size(), c2.size());
        int nConst = 0;
        for (int c : cs) {
            DfaValue dfaValue = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(c));
            if (dfaValue instanceof DfaConstValue) {
                ++nConst;
            }
            if (dfaValue instanceof DfaVariableValue) {
                DfaVariableValue variableValue = (DfaVariableValue)dfaValue;
                if (variableValue.isNegated()) {
                    negatedVars.add(variableValue.createNegated());
                } else {
                    vars.add(variableValue);
                }
            }
            if (nConst <= 1) continue;
            return false;
        }
        if (ContainerUtil.intersects((Collection)vars, (Collection)negatedVars)) {
            return false;
        }
        TLongArrayList c2Pairs = new TLongArrayList();
        for (long distinct : distincts = this.myDistinctClasses.toArray()) {
            int pc1 = DfaMemoryStateImpl.low(distinct);
            int pc2 = DfaMemoryStateImpl.high(distinct);
            boolean addedToC1 = false;
            if (pc1 == c1Index || pc2 == c1Index) {
                addedToC1 = true;
            }
            if (pc1 != c2Index && pc2 != c2Index) continue;
            if (addedToC1) {
                return false;
            }
            c2Pairs.add(distinct);
        }
        EqClass newClass = new EqClass(c1);
        this.myEqClasses.set(c1Index, newClass);
        for (i = 0; i < c2.size(); ++i) {
            int c = c2.get(i);
            newClass.add(c);
            this.removeFromMap(c, c2Index);
            this.addToMap(c, c1Index);
        }
        for (i = 0; i < c2Pairs.size(); ++i) {
            long c = c2Pairs.get(i);
            this.myDistinctClasses.remove(c);
            this.myDistinctClasses.add(DfaMemoryStateImpl.createPair(c1Index, DfaMemoryStateImpl.low(c) == c2Index ? DfaMemoryStateImpl.high(c) : DfaMemoryStateImpl.low(c)));
        }
        this.myEqClasses.set(c2Index, null);
        return true;
    }

    private static int low(long l) {
        return (int)l;
    }

    private static int high(long l) {
        return (int)((l & 0xFFFFFFFF00000000L) >> 32);
    }

    private static long createPair(int i1, int i2) {
        if (i1 < i2) {
            long l = i1;
            l <<= 32;
            return l += (long)i2;
        }
        long l = i2;
        l <<= 32;
        return l += (long)i1;
    }

    private void makeClassesDistinct(int c1Index, int c2Index) {
        this.myDistinctClasses.add(DfaMemoryStateImpl.createPair(c1Index, c2Index));
    }

    @Override
    public boolean isNull(DfaValue dfaValue) {
        if (dfaValue instanceof DfaConstValue) {
            return ((DfaConstValue)dfaValue).getValue() == null;
        }
        if (dfaValue instanceof DfaVariableValue) {
            int c1Index = this.getEqClassIndex(dfaValue);
            return c1Index >= 0 && c1Index == this.getEqClassIndex(this.myFactory.getConstFactory().getNull());
        }
        return false;
    }

    @Override
    public boolean isNotNull(DfaValue dfaVar) {
        long[] pairs;
        if (dfaVar instanceof DfaConstValue) {
            return ((DfaConstValue)dfaVar).getValue() != null;
        }
        if (dfaVar instanceof DfaBoxedValue) {
            return true;
        }
        if (dfaVar instanceof DfaTypeValue) {
            return ((DfaTypeValue)dfaVar).isNotNull();
        }
        if (dfaVar instanceof DfaVariableValue) {
            if (this.getVariableState((DfaVariableValue)dfaVar).isNotNull()) {
                return true;
            }
            DfaConstValue constantValue = this.getConstantValue((DfaVariableValue)dfaVar);
            if (constantValue != null && constantValue.getValue() != null) {
                return true;
            }
        }
        DfaConstValue dfaNull = this.myFactory.getConstFactory().getNull();
        int c1Index = this.getEqClassIndex(dfaVar);
        int c2Index = this.getEqClassIndex(dfaNull);
        if (c1Index < 0 || c2Index < 0) {
            return false;
        }
        for (long pair : pairs = this.myDistinctClasses.toArray()) {
            if ((c1Index != DfaMemoryStateImpl.low(pair) || c2Index != DfaMemoryStateImpl.high(pair)) && (c1Index != DfaMemoryStateImpl.high(pair) || c2Index != DfaMemoryStateImpl.low(pair))) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public DfaConstValue getConstantValue(@NotNull DfaVariableValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getConstantValue"));
        }
        int index = this.getEqClassIndex(value);
        EqClass ec = index == -1 ? null : this.myEqClasses.get(index);
        return ec == null ? null : (DfaConstValue)DfaMemoryStateImpl.unwrap(ec.findConstant(true));
    }

    @Override
    public void markEphemeral() {
        this.myEphemeral = true;
    }

    @Override
    public boolean isEphemeral() {
        return this.myEphemeral;
    }

    @Override
    public boolean applyInstanceofOrNull(@NotNull DfaRelationValue dfaCond) {
        if (dfaCond == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaCond", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "applyInstanceofOrNull"));
        }
        DfaValue left = DfaMemoryStateImpl.unwrap(dfaCond.getLeftOperand());
        if (!(left instanceof DfaVariableValue)) {
            return true;
        }
        DfaVariableValue dfaVar = (DfaVariableValue)left;
        DfaTypeValue dfaType = (DfaTypeValue)dfaCond.getRightOperand();
        if (this.isUnknownState(dfaVar) || this.isNull(dfaVar)) {
            return true;
        }
        DfaVariableState newState = this.getVariableState(dfaVar).withInstanceofValue(dfaType);
        if (newState != null) {
            this.setVariableState(dfaVar, newState);
            return true;
        }
        return false;
    }

    static DfaValue unwrap(DfaValue value) {
        if (value instanceof DfaBoxedValue) {
            return ((DfaBoxedValue)value).getWrappedValue();
        }
        if (value instanceof DfaUnboxedValue) {
            return ((DfaUnboxedValue)value).getVariable();
        }
        return value;
    }

    @Override
    public boolean applyCondition(DfaValue dfaCond) {
        if (dfaCond instanceof DfaUnknownValue) {
            return true;
        }
        if (dfaCond instanceof DfaUnboxedValue) {
            DfaVariableValue dfaVar = ((DfaUnboxedValue)dfaCond).getVariable();
            boolean isNegated = dfaVar.isNegated();
            DfaVariableValue dfaNormalVar = isNegated ? dfaVar.createNegated() : dfaVar;
            DfaValue boxedTrue = this.myFactory.getBoxedFactory().createBoxed(this.myFactory.getConstFactory().getTrue());
            return this.applyRelationCondition(this.myFactory.getRelationFactory().createRelation(dfaNormalVar, boxedTrue, JavaTokenType.EQEQ, isNegated));
        }
        if (dfaCond instanceof DfaVariableValue) {
            DfaVariableValue dfaVar = (DfaVariableValue)dfaCond;
            boolean isNegated = dfaVar.isNegated();
            DfaVariableValue dfaNormalVar = isNegated ? dfaVar.createNegated() : dfaVar;
            DfaConstValue dfaTrue = this.myFactory.getConstFactory().getTrue();
            return this.applyRelationCondition(this.myFactory.getRelationFactory().createRelation(dfaNormalVar, dfaTrue, JavaTokenType.EQEQ, isNegated));
        }
        if (dfaCond instanceof DfaConstValue) {
            return dfaCond == this.myFactory.getConstFactory().getTrue() || dfaCond != this.myFactory.getConstFactory().getFalse();
        }
        if (!(dfaCond instanceof DfaRelationValue)) {
            return true;
        }
        return this.applyRelationCondition((DfaRelationValue)dfaCond);
    }

    private boolean applyRelationCondition(@NotNull DfaRelationValue dfaRelation) {
        if (dfaRelation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaRelation", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "applyRelationCondition"));
        }
        DfaValue dfaLeft = dfaRelation.getLeftOperand();
        DfaValue dfaRight = dfaRelation.getRightOperand();
        if (dfaLeft instanceof DfaUnknownValue || dfaRight instanceof DfaUnknownValue) {
            return true;
        }
        boolean isNegated = dfaRelation.isNegated();
        if (dfaLeft instanceof DfaTypeValue && ((DfaTypeValue)dfaLeft).isNotNull() && dfaRight == this.myFactory.getConstFactory().getNull()) {
            return isNegated;
        }
        if (dfaRight instanceof DfaTypeValue) {
            if (dfaLeft instanceof DfaVariableValue) {
                DfaVariableState newState;
                DfaVariableValue dfaVar = (DfaVariableValue)dfaLeft;
                if (this.isUnknownState(dfaVar)) {
                    return true;
                }
                if (!dfaRelation.isInstanceOf()) {
                    if (((DfaTypeValue)dfaRight).isNotNull() && this.isNull(dfaVar)) {
                        return isNegated;
                    }
                    return true;
                }
                if (isNegated) {
                    DfaVariableState newState2 = this.getVariableState(dfaVar).withNotInstanceofValue((DfaTypeValue)dfaRight);
                    if (newState2 != null) {
                        this.setVariableState(dfaVar, newState2);
                        return true;
                    }
                    return this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), false);
                }
                if (this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), true) && (newState = this.getVariableState(dfaVar).withInstanceofValue((DfaTypeValue)dfaRight)) != null) {
                    this.setVariableState(dfaVar, newState);
                    return true;
                }
                return false;
            }
            return true;
        }
        if (this.isEffectivelyNaN(dfaLeft) || this.isEffectivelyNaN(dfaRight)) {
            this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
            return isNegated;
        }
        if (this.canBeNaN(dfaLeft) && this.canBeNaN(dfaRight)) {
            this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
            return true;
        }
        return this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
    }

    private void updateVarStateOnComparison(@NotNull DfaVariableValue dfaVar, DfaValue value) {
        if (dfaVar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaVar", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "updateVarStateOnComparison"));
        }
        if (!this.isUnknownState(dfaVar)) {
            if (value instanceof DfaConstValue && ((DfaConstValue)value).getValue() == null) {
                this.setVariableState(dfaVar, this.getVariableState(dfaVar).withNullability(Nullness.NULLABLE));
            } else if (this.isNotNull(value) && !this.isNotNull(dfaVar)) {
                this.setVariableState(dfaVar, this.getVariableState(dfaVar).withNullability(Nullness.UNKNOWN));
                this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), true);
            }
        }
    }

    private boolean applyEquivalenceRelation(@NotNull DfaRelationValue dfaRelation, DfaValue dfaLeft, DfaValue dfaRight) {
        boolean containsCalls;
        if (dfaRelation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaRelation", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "applyEquivalenceRelation"));
        }
        boolean isNegated = dfaRelation.isNonEquality();
        if (!isNegated && !dfaRelation.isEquality()) {
            return true;
        }
        boolean bl = containsCalls = dfaLeft instanceof DfaVariableValue && ((DfaVariableValue)dfaLeft).containsCalls();
        if (containsCalls && !this.isNotNull(dfaLeft) && this.isNull(dfaRight) && !isNegated) {
            return true;
        }
        if (dfaLeft == dfaRight) {
            return containsCalls || !isNegated;
        }
        if (this.isNull(dfaLeft) && this.isNotNull(dfaRight) || this.isNull(dfaRight) && this.isNotNull(dfaLeft)) {
            return isNegated;
        }
        if (!isNegated) {
            if (dfaLeft instanceof DfaVariableValue) {
                this.updateVarStateOnComparison((DfaVariableValue)dfaLeft, dfaRight);
            }
            if (dfaRight instanceof DfaVariableValue) {
                this.updateVarStateOnComparison((DfaVariableValue)dfaRight, dfaLeft);
            }
        }
        if (!this.applyRelation(dfaLeft, dfaRight, isNegated)) {
            return false;
        }
        if (!this.checkCompareWithBooleanLiteral(dfaLeft, dfaRight, isNegated)) {
            return false;
        }
        if (dfaLeft instanceof DfaVariableValue) {
            if (!this.applyUnboxedRelation((DfaVariableValue)dfaLeft, dfaRight, isNegated)) {
                return false;
            }
            if (!this.applyBoxedRelation((DfaVariableValue)dfaLeft, dfaRight, isNegated)) {
                return false;
            }
        }
        return true;
    }

    private boolean applyBoxedRelation(@NotNull DfaVariableValue dfaLeft, DfaValue dfaRight, boolean negated) {
        if (dfaLeft == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaLeft", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "applyBoxedRelation"));
        }
        if (!TypeConversionUtil.isPrimitiveAndNotNull((PsiType)dfaLeft.getVariableType())) {
            return true;
        }
        DfaBoxedValue.Factory boxedFactory = this.myFactory.getBoxedFactory();
        DfaValue boxedLeft = boxedFactory.createBoxed(dfaLeft);
        DfaValue boxedRight = boxedFactory.createBoxed(dfaRight);
        return boxedLeft == null || boxedRight == null || this.applyRelation(boxedLeft, boxedRight, negated);
    }

    private boolean applyUnboxedRelation(@NotNull DfaVariableValue dfaLeft, DfaValue dfaRight, boolean negated) {
        DfaValue unboxedRight;
        if (dfaLeft == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaLeft", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "applyUnboxedRelation"));
        }
        PsiType type = dfaLeft.getVariableType();
        if (!TypeConversionUtil.isPrimitiveWrapper((PsiType)type)) {
            return true;
        }
        if (negated) {
            return true;
        }
        DfaBoxedValue.Factory boxedFactory = this.myFactory.getBoxedFactory();
        DfaValue unboxedLeft = boxedFactory.createUnboxed(dfaLeft);
        return this.applyRelation(unboxedLeft, unboxedRight = boxedFactory.createUnboxed(dfaRight), false) && this.checkCompareWithBooleanLiteral(unboxedLeft, unboxedRight, false);
    }

    private boolean checkCompareWithBooleanLiteral(DfaValue dfaLeft, DfaValue dfaRight, boolean negated) {
        Object constVal;
        if (dfaRight instanceof DfaConstValue && (constVal = ((DfaConstValue)dfaRight).getValue()) instanceof Boolean) {
            DfaConstValue negVal = this.myFactory.getConstFactory().createFromValue((Boolean)constVal == false, (PsiType)PsiType.BOOLEAN, null);
            if (!this.applyRelation(dfaLeft, negVal, !negated)) {
                return false;
            }
            if (!this.applyRelation(dfaLeft.createNegated(), negVal, negated)) {
                return false;
            }
        }
        return true;
    }

    static boolean isNaN(DfaValue dfa) {
        if (dfa instanceof DfaConstValue) {
            Object value = ((DfaConstValue)dfa).getValue();
            if (value instanceof Double && ((Double)value).isNaN()) {
                return true;
            }
            if (value instanceof Float && ((Float)value).isNaN()) {
                return true;
            }
        } else if (dfa instanceof DfaBoxedValue) {
            return DfaMemoryStateImpl.isNaN(((DfaBoxedValue)dfa).getWrappedValue());
        }
        return false;
    }

    private boolean applyRelation(@NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight, boolean isNegated) {
        if (dfaLeft == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaLeft", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "applyRelation"));
        }
        if (dfaRight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaRight", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "applyRelation"));
        }
        if (this.isUnknownState(dfaLeft) || this.isUnknownState(dfaRight)) {
            return true;
        }
        Integer c1Index = this.getOrCreateEqClassIndex(dfaLeft);
        Integer c2Index = this.getOrCreateEqClassIndex(dfaRight);
        if (c1Index == null || c2Index == null) {
            return true;
        }
        if (!isNegated) {
            if (c1Index.equals(c2Index) || this.areCompatibleConstants(c1Index, c2Index)) {
                return true;
            }
            if (!this.uniteClasses(c1Index, c2Index)) {
                return false;
            }
            for (long encodedPair : this.myDistinctClasses.toArray()) {
                EqClass c1 = this.myEqClasses.get(DfaMemoryStateImpl.low(encodedPair));
                EqClass c2 = this.myEqClasses.get(DfaMemoryStateImpl.high(encodedPair));
                DfaConstValue const1 = (DfaConstValue)c1.findConstant(false);
                DfaConstValue const2 = (DfaConstValue)c2.findConstant(false);
                if (const1 == null || const2 == null || DfaMemoryStateImpl.preserveConstantDistinction(const1.getValue(), const2.getValue())) continue;
                this.myDistinctClasses.remove(encodedPair);
            }
            this.myCachedDistinctClassPairs = null;
            this.myCachedNonTrivialEqClasses = null;
            this.myCachedHash = null;
        } else {
            if (c1Index.equals(c2Index) || this.areCompatibleConstants(c1Index, c2Index)) {
                return false;
            }
            if (this.isNull(dfaLeft) && DfaMemoryStateImpl.isPrimitive(dfaRight) || this.isNull(dfaRight) && DfaMemoryStateImpl.isPrimitive(dfaLeft)) {
                return true;
            }
            this.makeClassesDistinct(c1Index, c2Index);
            this.myCachedDistinctClassPairs = null;
            this.myCachedHash = null;
        }
        return true;
    }

    private static boolean isPrimitive(DfaValue value) {
        return value instanceof DfaVariableValue && ((DfaVariableValue)value).getVariableType() instanceof PsiPrimitiveType;
    }

    private static boolean preserveConstantDistinction(Object c1, Object c2) {
        return c1 == null && c2 instanceof PsiEnumConstant || c2 == null && c1 instanceof PsiEnumConstant;
    }

    private boolean areCompatibleConstants(int i1, int i2) {
        Double dv1 = this.getDoubleValue(i1);
        return dv1 != null && dv1.equals(this.getDoubleValue(i2));
    }

    @Nullable
    private Double getDoubleValue(int eqClassIndex) {
        EqClass ec = this.myEqClasses.get(eqClassIndex);
        DfaValue dfaConst = ec == null ? null : ec.findConstant(false);
        Object constValue = dfaConst instanceof DfaConstValue ? ((DfaConstValue)dfaConst).getValue() : null;
        return constValue instanceof Number ? Double.valueOf(((Number)constValue).doubleValue()) : null;
    }

    private boolean isUnknownState(DfaValue val) {
        if ((val = DfaMemoryStateImpl.unwrap(val)) instanceof DfaVariableValue) {
            if (this.myUnknownVariables.contains(val)) {
                return true;
            }
            DfaVariableValue negatedValue = ((DfaVariableValue)val).getNegatedValue();
            if (negatedValue != null && this.myUnknownVariables.contains(negatedValue)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkNotNullable(DfaValue value) {
        if (value == this.myFactory.getConstFactory().getNull()) {
            return false;
        }
        if (value instanceof DfaTypeValue && ((DfaTypeValue)value).isNullable()) {
            return false;
        }
        if (value instanceof DfaVariableValue) {
            DfaVariableValue varValue = (DfaVariableValue)value;
            if (varValue.getVariableType() instanceof PsiPrimitiveType) {
                return true;
            }
            if (this.isNotNull(varValue)) {
                return true;
            }
            if (this.getVariableState(varValue).isNullable()) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private DfaRelationValue compareToNull(DfaValue dfaVar, boolean negated) {
        DfaConstValue dfaNull = this.myFactory.getConstFactory().getNull();
        return this.myFactory.getRelationFactory().createRelation(dfaVar, dfaNull, JavaTokenType.EQEQ, negated);
    }

    void setVariableState(DfaVariableValue dfaVar, DfaVariableState state) {
        assert (!this.myUnknownVariables.contains(dfaVar));
        if (state.equals(this.myDefaultVariableStates.get(dfaVar))) {
            this.myVariableStates.remove(dfaVar);
        } else {
            this.myVariableStates.put(dfaVar, state);
        }
        this.myCachedHash = null;
    }

    DfaVariableState getVariableState(DfaVariableValue dfaVar) {
        DfaVariableState state = this.myVariableStates.get(dfaVar);
        if (state == null) {
            state = this.myDefaultVariableStates.get(dfaVar);
            if (state == null) {
                state = this.createVariableState(dfaVar);
                DfaTypeValue initialType = dfaVar.getTypeValue();
                if (initialType != null) {
                    state = state.withInstanceofValue(initialType);
                    assert (state != null);
                }
                this.myDefaultVariableStates.put(dfaVar, state);
            }
            if (this.isUnknownState(dfaVar)) {
                return state.withNullable(false);
            }
        }
        return state;
    }

    @NotNull
    Map<DfaVariableValue, DfaVariableState> getVariableStates() {
        LinkedHashMap<DfaVariableValue, DfaVariableState> linkedHashMap = this.myVariableStates;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getVariableStates"));
        }
        return linkedHashMap;
    }

    @NotNull
    protected DfaVariableState createVariableState(@NotNull DfaVariableValue var) {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "createVariableState"));
        }
        DfaVariableState dfaVariableState = new DfaVariableState(var);
        if (dfaVariableState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "createVariableState"));
        }
        return dfaVariableState;
    }

    @Override
    public void flushFields() {
        LinkedHashSet vars = ContainerUtil.newLinkedHashSet(this.getChangedVariables());
        for (EqClass aClass : this.myEqClasses) {
            if (aClass == null) continue;
            vars.addAll(aClass.getVariables(true));
        }
        for (DfaVariableValue value : vars) {
            if (!value.isFlushableByCalls()) continue;
            this.doFlush(value, this.shouldMarkUnknown(value));
        }
    }

    private boolean shouldMarkUnknown(@NotNull DfaVariableValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "shouldMarkUnknown"));
        }
        int eqClassIndex = this.getEqClassIndex(value);
        if (eqClassIndex < 0) {
            return false;
        }
        EqClass eqClass = this.myEqClasses.get(eqClassIndex);
        if (eqClass == null) {
            return false;
        }
        if (eqClass.findConstant(true) != null) {
            return true;
        }
        for (UnorderedPair unorderedPair : this.getDistinctClassPairs()) {
            if ((unorderedPair.first != eqClass || ((EqClass)unorderedPair.second).findConstant(true) == null) && (unorderedPair.second != eqClass || ((EqClass)unorderedPair.first).findConstant(true) == null)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    Set<DfaVariableValue> getChangedVariables() {
        Set<DfaVariableValue> set = this.myVariableStates.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getChangedVariables"));
        }
        return set;
    }

    @Override
    public void flushVariable(final @NotNull DfaVariableValue variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "flushVariable"));
        }
        List updatedStack = ContainerUtil.map(this.myStack, (Function)new Function<DfaValue, DfaValue>(){

            public DfaValue fun(DfaValue value) {
                return DfaMemoryStateImpl.this.handleFlush(variable, value);
            }
        });
        this.myStack.clear();
        for (DfaValue value : updatedStack) {
            this.myStack.push((Object)value);
        }
        this.doFlush(variable, false);
        this.flushDependencies(variable);
        this.myUnknownVariables.remove(variable);
        this.myUnknownVariables.removeAll(this.myFactory.getVarFactory().getAllQualifiedBy(variable));
        this.myCachedHash = null;
    }

    void flushDependencies(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "flushDependencies"));
        }
        for (DfaVariableValue dependent : this.myFactory.getVarFactory().getAllQualifiedBy(variable)) {
            this.doFlush(dependent, false);
        }
    }

    @NotNull
    Set<DfaVariableValue> getUnknownVariables() {
        LinkedHashSet<DfaVariableValue> linkedHashSet = this.myUnknownVariables;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getUnknownVariables"));
        }
        return linkedHashSet;
    }

    void doFlush(@NotNull DfaVariableValue varPlain, boolean markUnknown) {
        if (varPlain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varPlain", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "doFlush"));
        }
        DfaVariableValue varNegated = varPlain.getNegatedValue();
        int idPlain = varPlain.getID();
        int idNegated = varNegated == null ? -1 : varNegated.getID();
        int[] classes = (int[])this.myIdToEqClassesIndices.get(idPlain);
        int[] negatedClasses = (int[])this.myIdToEqClassesIndices.get(idNegated);
        int[] result2 = ArrayUtil.mergeArrays((int[])((int[])ObjectUtils.notNull((Object)classes, (Object)ArrayUtil.EMPTY_INT_ARRAY)), (int[])((int[])ObjectUtils.notNull((Object)negatedClasses, (Object)ArrayUtil.EMPTY_INT_ARRAY)));
        int interruptCount = 0;
        for (int varClassIndex : result2) {
            TLongIterator iterator;
            EqClass varClass = this.myEqClasses.get(varClassIndex);
            if ((++interruptCount & 0xF) == 0) {
                ProgressManager.checkCanceled();
            }
            varClass = new EqClass(varClass);
            this.myEqClasses.set(varClassIndex, varClass);
            for (int id : varClass.toNativeArray()) {
                int idUnwrapped;
                if (id != idPlain && id != idNegated && (idUnwrapped = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID()) != idPlain && idUnwrapped != idNegated) continue;
                varClass.removeValue(id);
            }
            if (varClass.isEmpty()) {
                this.myEqClasses.set(varClassIndex, null);
                iterator = this.myDistinctClasses.iterator();
                while (iterator.hasNext()) {
                    long pair = iterator.next();
                    if (DfaMemoryStateImpl.low(pair) != varClassIndex && DfaMemoryStateImpl.high(pair) != varClassIndex) continue;
                    iterator.remove();
                }
                continue;
            }
            if (!varClass.containsConstantsOnly()) continue;
            iterator = this.myDistinctClasses.iterator();
            while (iterator.hasNext()) {
                long pair = iterator.next();
                if ((DfaMemoryStateImpl.low(pair) != varClassIndex || !this.myEqClasses.get(DfaMemoryStateImpl.high(pair)).containsConstantsOnly()) && (DfaMemoryStateImpl.high(pair) != varClassIndex || !this.myEqClasses.get(DfaMemoryStateImpl.low(pair)).containsConstantsOnly())) continue;
                iterator.remove();
            }
        }
        this.removeAllFromMap(idPlain);
        this.removeAllFromMap(idNegated);
        this.myVariableStates.remove(varPlain);
        if (varNegated != null) {
            this.myVariableStates.remove(varNegated);
        }
        if (markUnknown) {
            this.myUnknownVariables.add(varPlain);
        }
        this.myCachedNonTrivialEqClasses = null;
        this.myCachedDistinctClassPairs = null;
        this.myCachedHash = null;
    }

    private class MyIdMap
    extends TIntObjectHashMap<int[]> {
        private MyIdMap(int initialCapacity) {
            super(initialCapacity);
        }

        public String toString() {
            final StringBuilder s = new StringBuilder("{");
            this.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<int[]>(){

                public boolean execute(int id, int[] set) {
                    DfaValue value = DfaMemoryStateImpl.this.myFactory.getValue(id);
                    s.append(value + " -> " + Arrays.toString(set) + ", ");
                    return true;
                }
            });
            s.append("}");
            return s.toString();
        }
    }
}

