/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ApplierCompleter;
import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import jsr166e.ForkJoinPool;
import jsr166e.ForkJoinTask;
import jsr166e.ForkJoinWorkerThread;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobLauncherImpl
extends JobLauncher {
    private static final AtomicLong bits = new AtomicLong();
    private static final ForkJoinPool.ForkJoinWorkerThreadFactory FACTORY = new ForkJoinPool.ForkJoinWorkerThreadFactory(){

        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            final int n = this.addThread();
            ForkJoinWorkerThread thread = new ForkJoinWorkerThread(pool){

                protected void onTermination(Throwable exception) {
                    this.finishThread(n);
                    super.onTermination(exception);
                }
            };
            thread.setName("JobScheduler FJ pool " + n + "/" + JobSchedulerImpl.CORES_COUNT);
            return thread;
        }

        private int addThread() {
            int n;
            long next;
            long l;
            boolean set;
            do {
                l = bits.longValue();
                next = l + 1L | l;
                n = Long.numberOfTrailingZeros(l + 1L);
            } while (!(set = bits.compareAndSet(l, next)));
            return n;
        }

        private void finishThread(int n) {
            long next;
            long l;
            boolean set;
            do {
                l = bits.get();
                next = l & (1L << n ^ 0xFFFFFFFFFFFFFFFFL);
            } while (!(set = bits.compareAndSet(l, next)));
        }
    };
    private static final ForkJoinPool pool = new ForkJoinPool(JobSchedulerImpl.CORES_COUNT, FACTORY, null, false);
    static final int CORES_FORK_THRESHOLD = 1;

    @Override
    public <T> boolean invokeConcurrentlyUnderProgress(@NotNull List<T> things, ProgressIndicator progress, boolean runInReadAction, boolean failFastOnAcquireReadAction, @NotNull Processor<? super T> thingProcessor) throws ProcessCanceledException {
        if (things == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "things", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyUnderProgress"));
        }
        if (thingProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thingProcessor", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyUnderProgress"));
        }
        AbstractProgressIndicatorBase wrapper = progress == null ? new AbstractProgressIndicatorBase() : new SensitiveProgressWrapper(progress);
        Boolean result2 = JobLauncherImpl.processImmediatelyIfTooFew(things, wrapper, runInReadAction, thingProcessor);
        if (result2 != null) {
            return result2;
        }
        ApplierCompleter<? super T> applier = new ApplierCompleter<T>(null, runInReadAction, wrapper, things, thingProcessor, 0, things.size(), null);
        try {
            pool.invoke(applier);
            if (applier.throwable != null) {
                throw applier.throwable;
            }
        }
        catch (ApplierCompleter.ComputationAbortedException e) {
            return false;
        }
        catch (ProcessCanceledException e) {
            return false;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        assert (applier.isDone());
        return applier.completeTaskWhichFailToAcquireReadAction();
    }

    private static <T> Boolean processImmediatelyIfTooFew(final @NotNull List<T> things, final ProgressIndicator progress, boolean runInReadAction, final @NotNull Processor<? super T> thingProcessor) {
        if (things == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "things", "com/intellij/concurrency/JobLauncherImpl", "processImmediatelyIfTooFew"));
        }
        if (thingProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thingProcessor", "com/intellij/concurrency/JobLauncherImpl", "processImmediatelyIfTooFew"));
        }
        if (things.isEmpty()) {
            return true;
        }
        if (things.size() <= 1 || JobSchedulerImpl.CORES_COUNT <= 1) {
            final AtomicBoolean result2 = new AtomicBoolean(true);
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = 0; i < things.size(); ++i) {
                                Object thing = things.get(i);
                                if (thingProcessor.process(thing)) continue;
                                result2.set(false);
                                break;
                            }
                        }
                    }, progress);
                }
            };
            if (runInReadAction) {
                if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(runnable2)) {
                    return false;
                }
            } else {
                runnable2.run();
            }
            return result2.get();
        }
        return null;
    }

    @Override
    @NotNull
    public <T> AsyncFuture<Boolean> invokeConcurrentlyUnderProgressAsync(@NotNull List<T> things, ProgressIndicator progress, boolean failFastOnAcquireReadAction, @NotNull Processor<? super T> thingProcessor) {
        if (things == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "things", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyUnderProgressAsync"));
        }
        if (thingProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thingProcessor", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyUnderProgressAsync"));
        }
        AsyncFuture asyncFuture = AsyncUtil.wrapBoolean((boolean)this.invokeConcurrentlyUnderProgress(things, progress, failFastOnAcquireReadAction, thingProcessor));
        if (asyncFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyUnderProgressAsync"));
        }
        return asyncFuture;
    }

    @Override
    @NotNull
    public Job<Void> submitToJobThread(@NotNull Runnable action, @Nullable Consumer<Future> onDoneCallback) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/concurrency/JobLauncherImpl", "submitToJobThread"));
        }
        VoidForkJoinTask task = new VoidForkJoinTask(action, onDoneCallback);
        task.submit();
        VoidForkJoinTask voidForkJoinTask = task;
        if (voidForkJoinTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/concurrency/JobLauncherImpl", "submitToJobThread"));
        }
        return voidForkJoinTask;
    }

    public <T> boolean processQueue(final @NotNull BlockingQueue<T> things, final @NotNull Queue<T> failedToProcess, final @NotNull ProgressIndicator progress, final @NotNull T tombStone, final @NotNull Processor<? super T> thingProcessor) {
        class MyTask
        implements Callable<Boolean> {
            private final int mySeq;
            private boolean result;

            MyTask(int seq) {
                this.mySeq = seq;
            }

            @Override
            public Boolean call() throws Exception {
                ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                    /*
                     * Exception decompiling
                     */
                    @Override
                    public void run() {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 1[TRYBLOCK]
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                }, progress);
                return this.result;
            }

            public String toString() {
                return super.toString() + " seq=" + this.mySeq;
            }

            static /* synthetic */ boolean access$802(MyTask x0, boolean x1) {
                x0.result = x1;
                return x0.result;
            }
        }
        if (things == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "things", "com/intellij/concurrency/JobLauncherImpl", "processQueue"));
        }
        if (failedToProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failedToProcess", "com/intellij/concurrency/JobLauncherImpl", "processQueue"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/concurrency/JobLauncherImpl", "processQueue"));
        }
        if (tombStone == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tombStone", "com/intellij/concurrency/JobLauncherImpl", "processQueue"));
        }
        if (thingProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thingProcessor", "com/intellij/concurrency/JobLauncherImpl", "processQueue"));
        }
        boolean isSmallEnough = things.contains(tombStone);
        if (isSmallEnough) {
            try {
                return new MyTask(0).call();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<ForkJoinTask> tasks = new ArrayList<ForkJoinTask>();
        for (int i = 0; i < JobSchedulerImpl.CORES_COUNT; ++i) {
            tasks.add(pool.submit((Callable)new MyTask(i)));
        }
        boolean result2 = true;
        RuntimeException exception = null;
        for (ForkJoinTask task : tasks) {
            try {
                result2 &= ((Boolean)task.join()).booleanValue();
            }
            catch (RuntimeException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return result2;
    }

    private static class VoidForkJoinTask
    implements Job<Void> {
        private final Runnable myAction;
        private final Consumer<Future> myOnDoneCallback;
        private volatile Status myStatus;
        private final ForkJoinTask<Void> myForkJoinTask;

        private VoidForkJoinTask(@NotNull Runnable action, @Nullable Consumer<Future> onDoneCallback) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/concurrency/JobLauncherImpl$VoidForkJoinTask", "<init>"));
            }
            this.myForkJoinTask = new ForkJoinTask<Void>(){

                public Void getRawResult() {
                    return null;
                }

                protected void setRawResult(Void value) {
                }

                protected boolean exec() {
                    VoidForkJoinTask.this.myStatus = Status.STARTED;
                    try {
                        VoidForkJoinTask.this.myAction.run();
                        this.complete(null);
                    }
                    catch (Throwable throwable) {
                        this.completeExceptionally(throwable);
                    }
                    finally {
                        VoidForkJoinTask.this.myStatus = Status.EXECUTED;
                        if (VoidForkJoinTask.this.myOnDoneCallback != null) {
                            VoidForkJoinTask.this.myOnDoneCallback.consume((Object)this);
                        }
                    }
                    return true;
                }
            };
            this.myAction = action;
            this.myOnDoneCallback = onDoneCallback;
        }

        private void submit() {
            pool.submit(this.myForkJoinTask);
        }

        public boolean isDone() {
            boolean wasCancelled = this.myForkJoinTask.isCancelled();
            Status status = this.myStatus;
            return status == Status.EXECUTED || status == null && wasCancelled;
        }

        public String getTitle() {
            throw new IncorrectOperationException();
        }

        public boolean isCanceled() {
            return this.myForkJoinTask.isCancelled();
        }

        public void addTask(@NotNull Callable<Void> task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/concurrency/JobLauncherImpl$VoidForkJoinTask", "addTask"));
            }
            throw new IncorrectOperationException();
        }

        public void addTask(@NotNull Runnable task, Void result2) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/concurrency/JobLauncherImpl$VoidForkJoinTask", "addTask"));
            }
            throw new IncorrectOperationException();
        }

        public void addTask(@NotNull Runnable task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/concurrency/JobLauncherImpl$VoidForkJoinTask", "addTask"));
            }
            throw new IncorrectOperationException();
        }

        public List<Void> scheduleAndWaitForResults() throws Throwable {
            throw new IncorrectOperationException();
        }

        public void cancel() {
            this.myForkJoinTask.cancel(true);
        }

        public void schedule() {
            throw new IncorrectOperationException();
        }

        public void waitForCompletion(int millis) throws InterruptedException, ExecutionException, TimeoutException {
            while (!this.isDone()) {
                try {
                    this.myForkJoinTask.get((long)millis, TimeUnit.MILLISECONDS);
                    break;
                }
                catch (CancellationException e) {
                    if (!(Thread.currentThread() instanceof ForkJoinWorkerThread)) continue;
                    pool.awaitQuiescence((long)millis, TimeUnit.MILLISECONDS);
                }
            }
        }

        private static enum Status {
            STARTED,
            EXECUTED;

        }
    }
}

