/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.ReloadComponentStoreStatus;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StoreAwareProjectManagerKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.StateStorageBase;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageManagerListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.ex.VirtualFileManagerAdapter;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"]\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u0003\u0015\tA!A\u0003\u0002\u0011\u0017)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0007a\u0001\u0001%\t\u001a\u0003a\u0005Q\u0014!\t\"\u0016%\u0019\u0001\"A\u0007\u00021\u0007I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\t\u0007\u0015\"Aa\u0003\u0005\t\u001b\u0005A\n\"\n\u0003\u0005\b!IQ\"\u0001M\tK\u0011!\u0011\u0001c\u0005\u000e\u0003aQQ\u0005\u0004\u0003\u0002\u0011+i\u0011\u0001'\u0005\u001a\u0007!YQ\"\u0001M\u00053\rA9\"D\u0001\u0019\u0019\u0015BAa\u0003E\r\u001b\u0005A\n\"G\u0002\t\u001b5\t\u00014D\u0013\r\t-Aa\"D\u0001\u0019\u0012e\u0019\u0001RD\u0007\u00021=I2\u0001C\u0007\u000e\u0003amQ\u0005\u0002\u0003\u0002\u0011?i\u0011\u0001\u0007\u0006&\t\u0011Y\u0001\u0002E\u0007\u00021#I#\u0002B!\t\u0011\u000fiA!\u0003\u0002\n\u0003a%\u0001\u0004B)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!)Q\"\u0001M\u0006#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001BB\u0007\u00021\u001b\t6!A\u0003\u0001S\u001d!\u0011\t\u0003\u0005\b\u001b\u0005Az!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lcom/intellij/configurationStore/StoreAwareProjectManager;", "Lcom/intellij/openapi/project/impl/ProjectManagerImpl;", "virtualFileManager", "Lcom/intellij/openapi/vfs/VirtualFileManager;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "(Lcom/intellij/openapi/vfs/VirtualFileManager;Lcom/intellij/openapi/progress/ProgressManager;)V", "changedApplicationFiles", "Ljava/util/LinkedHashSet;", "Lcom/intellij/openapi/components/StateStorage;", "changedFilesAlarm", "Lcom/intellij/util/SingleAlarm;", "reloadBlockCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "restartApplicationOrReloadProjectTask", "Ljava/lang/Runnable;", "blockReloadingProjectOnExternalChanges", "", "flushChangedAlarm", "isReloadUnblocked", "", "registerChangedStorage", "storage", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "reloadProject", "project", "Lcom/intellij/openapi/project/Project;", "saveChangedProjectFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "tryToReloadApplication", "unblockReloadingProjectOnExternalChanges", "Companion"}, moduleName="configuration-store-impl")
public final class StoreAwareProjectManager
extends ProjectManagerImpl {
    private static final Key<MultiMap<ComponentStoreImpl, StateStorage>> CHANGED_FILES_KEY;
    private final AtomicInteger reloadBlockCount;
    private final LinkedHashSet<StateStorage> changedApplicationFiles;
    private final Runnable restartApplicationOrReloadProjectTask;
    private final SingleAlarm changedFilesAlarm;
    public static final Companion Companion;

    static {
        Companion = com.intellij.configurationStore.StoreAwareProjectManager$Companion.INSTANCE;
        CHANGED_FILES_KEY = Key.create((String)"CHANGED_FILES_KEY");
    }

    private final boolean isReloadUnblocked() {
        int count = this.reloadBlockCount.get();
        Logger $receiver = ComponentStoreImplKt.getLOG();
        if ($receiver.isDebugEnabled()) {
            Logger logger = $receiver;
            String string = "[RELOAD] myReloadBlockCount = " + count;
            logger.debug(string);
        }
        return count == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveChangedProjectFile(@NotNull VirtualFile file2, @NotNull Project project) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)project);
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        }
        StateStorageManager stateStorageManager = ((ComponentStoreImpl)iComponentStore).getStorageManager();
        if (!(stateStorageManager instanceof StateStorageManagerImpl)) {
            stateStorageManager = null;
        }
        StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
        if (stateStorageManagerImpl == null) {
            return;
        }
        StateStorageManagerImpl storageManager2 = stateStorageManagerImpl;
        String string = file2.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
        FileBasedStorage fileBasedStorage = (FileBasedStorage)CollectionsKt.firstOrNull((Iterable)storageManager2.getCachedFileStorages(CollectionsKt.listOf((Object)storageManager2.collapseMacros(string))));
        if (fileBasedStorage != null) {
            void $receiver;
            FileBasedStorage fileBasedStorage2 = fileBasedStorage;
            FileBasedStorage it = (FileBasedStorage)$receiver;
            this.registerChangedStorage(it, (ComponentManager)project);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    @Override
    public void blockReloadingProjectOnExternalChanges() {
        this.reloadBlockCount.incrementAndGet();
    }

    @Override
    public void unblockReloadingProjectOnExternalChanges() {
        PreconditionsKt.assert((this.reloadBlockCount.get() > 0 ? 1 : 0) != 0);
        if (this.reloadBlockCount.decrementAndGet() == 0 && this.changedFilesAlarm.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.changedFilesAlarm.request(true);
            } else {
                ApplicationManager.getApplication().invokeLater(this.restartApplicationOrReloadProjectTask, ModalityState.NON_MODAL);
            }
        }
    }

    public final void flushChangedAlarm() {
        this.changedFilesAlarm.flush();
    }

    @Override
    public void reloadProject(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        StoreAwareProjectManager.Companion.getCHANGED_FILES_KEY().set((UserDataHolder)project, null);
        super.reloadProject(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void registerChangedStorage(StateStorage storage2, ComponentManager componentManager) {
        void lock;
        Ref.ObjectRef changes;
        Project project;
        ComponentManager componentManager2;
        if (ComponentStoreImplKt.getLOG().isDebugEnabled()) {
            ComponentStoreImplKt.getLOG().debug("[RELOAD] Registering project to reload: " + storage2, (Throwable)new Exception());
        }
        Project project2 = (componentManager2 = componentManager) instanceof Project ? (Project)componentManager : (project = componentManager2 instanceof Module ? ((Module)componentManager).getProject() : (Project)null);
        if (project == null) {
            changes = this.changedApplicationFiles;
            synchronized (changes) {
                Boolean bl = changes.add(storage2);
            }
        }
        changes = new Ref.ObjectRef();
        changes.element = (MultiMap)StoreAwareProjectManager.Companion.getCHANGED_FILES_KEY().get((UserDataHolder)project);
        if ((MultiMap)changes.element == null) {
            changes.element = MultiMap.createLinkedSet();
            StoreAwareProjectManager.Companion.getCHANGED_FILES_KEY().set((UserDataHolder)project, (Object)((MultiMap)changes.element));
        }
        MultiMap $i$a$1 = (MultiMap)changes.element;
        synchronized (lock) {
            IComponentStore iComponentStore = ServiceKt.getStateStore(componentManager);
            if (iComponentStore == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
            }
            ((MultiMap)changes.element).putValue((Object)((ComponentStoreImpl)iComponentStore), (Object)storage2);
            Unit unit = Unit.INSTANCE;
        }
        componentManager2 = null;
        if (storage2 instanceof StateStorageBase) {
            ((StateStorageBase)storage2).disableSaving();
        }
        if (this.isReloadUnblocked()) {
            this.changedFilesAlarm.cancelAndRequest();
        }
    }

    private final boolean tryToReloadApplication() {
        if (ApplicationManager.getApplication().isDisposed()) {
            return false;
        }
        if (this.changedApplicationFiles.isEmpty()) {
            return true;
        }
        LinkedHashSet changes = new LinkedHashSet(this.changedApplicationFiles);
        this.changedApplicationFiles.clear();
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication());
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        }
        ReloadComponentStoreStatus status = StoreAwareProjectManagerKt.access$reloadStore(changes, (ComponentStoreImpl)iComponentStore, true);
        if (Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ReloadComponentStoreStatus.RESTART_AGREED))) {
            ApplicationManagerEx.getApplicationEx().restart(true);
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ReloadComponentStoreStatus.SUCCESS)) || Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ReloadComponentStoreStatus.RESTART_CANCELLED));
    }

    public StoreAwareProjectManager(@NotNull VirtualFileManager virtualFileManager, @NotNull ProgressManager progressManager) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFileManager, (String)"virtualFileManager");
        Intrinsics.checkParameterIsNotNull((Object)progressManager, (String)"progressManager");
        super(progressManager);
        this.reloadBlockCount = new AtomicInteger();
        this.changedApplicationFiles = new LinkedHashSet();
        this.restartApplicationOrReloadProjectTask = new Runnable(this){
            final /* synthetic */ StoreAwareProjectManager this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void run() {
                if (StoreAwareProjectManager.access$isReloadUnblocked(this.this$0) && StoreAwareProjectManager.access$tryToReloadApplication(this.this$0)) {
                    THashSet projectsToReload = new THashSet();
                    Project[] projectArray = this.this$0.getOpenProjects();
                    for (int i = 0; i < projectArray.length; ++i) {
                        void messageBus;
                        MultiMap changes;
                        Project project = projectArray[i];
                        if (project.isDisposed()) continue;
                        if ((MultiMap)com.intellij.configurationStore.StoreAwareProjectManager$Companion.access$getCHANGED_FILES_KEY$p(StoreAwareProjectManager.Companion).get((UserDataHolder)project) == null) {
                            continue;
                        }
                        com.intellij.configurationStore.StoreAwareProjectManager$Companion.access$getCHANGED_FILES_KEY$p(StoreAwareProjectManager.Companion).set((UserDataHolder)project, null);
                        if (changes.isEmpty()) continue;
                        Intrinsics.checkExpressionValueIsNotNull((Object)project.getMessageBus(), (String)"project.messageBus");
                        BatchUpdateListener publisher = (BatchUpdateListener)messageBus.syncPublisher(BatchUpdateListener.TOPIC);
                        publisher.onBatchUpdateStarted();
                        try {
                            Iterator<E> iterator = changes.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Unit unit;
                                StateStorageManagerImpl stateStorageManagerImpl;
                                void $receiver;
                                void $receiver2;
                                Map.Entry entry;
                                Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                                ComponentStoreImpl store = (ComponentStoreImpl)$receiver2.getKey();
                                Map.Entry $i$f$component1 = entry;
                                Collection storages = (Collection)$receiver.getValue();
                                StateStorageManager stateStorageManager = store.getStorageManager();
                                if (!(stateStorageManager instanceof StateStorageManagerImpl)) {
                                    stateStorageManager = null;
                                }
                                if ((stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager) != null && (stateStorageManagerImpl = stateStorageManagerImpl.getComponentManager()) != null ? stateStorageManagerImpl.isDisposed() : false) continue;
                                Collection collection = storages;
                                if (collection == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Set<com.intellij.openapi.components.StateStorage>");
                                }
                                Set set = (Set)collection;
                                ComponentStoreImpl componentStoreImpl = store;
                                Intrinsics.checkExpressionValueIsNotNull((Object)componentStoreImpl, (String)"store");
                                if (Intrinsics.areEqual((Object)((Object)StoreAwareProjectManagerKt.access$reloadStore(set, componentStoreImpl, false)), (Object)((Object)ReloadComponentStoreStatus.RESTART_AGREED))) {
                                    projectsToReload.add((Object)project);
                                    unit = Unit.INSTANCE;
                                    continue;
                                }
                                unit = Unit.INSTANCE;
                            }
                            Unit unit = Unit.INSTANCE;
                            continue;
                        }
                        finally {
                            publisher.onBatchUpdateFinished();
                        }
                    }
                    for (Project project : projectsToReload) {
                        ProjectManagerImpl.doReloadProject(project);
                    }
                }
            }
            {
                this.this$0 = storeAwareProjectManager;
            }
        };
        this.changedFilesAlarm = new SingleAlarm(this.restartApplicationOrReloadProjectTask, 300, this);
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(StateStorageManager.STORAGE_TOPIC, (Object)new StorageManagerListener(){

            @Override
            public void storageFileChanged(@NotNull VFileEvent event, @NotNull StateStorage storage2, @NotNull ComponentManager componentManager) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
                Intrinsics.checkParameterIsNotNull((Object)componentManager, (String)"componentManager");
                if (event instanceof VFilePropertyChangeEvent) {
                    return;
                }
                if (event.getRequestor() instanceof StateStorage.SaveSession || event.getRequestor() instanceof StateStorage || event.getRequestor() instanceof ProjectManagerImpl) {
                    return;
                }
                this.registerChangedStorage(storage2, componentManager);
            }
        });
        virtualFileManager.addVirtualFileManagerListener((VirtualFileManagerListener)new VirtualFileManagerAdapter(){

            @Override
            public void beforeRefreshStart(boolean asynchronous) {
                this.blockReloadingProjectOnExternalChanges();
            }

            @Override
            public void afterRefreshFinish(boolean asynchronous) {
                this.unblockReloadingProjectOnExternalChanges();
            }
        });
    }

    public static final /* synthetic */ boolean access$isReloadUnblocked(StoreAwareProjectManager $this) {
        return $this.isReloadUnblocked();
    }

    public static final /* synthetic */ boolean access$tryToReloadApplication(StoreAwareProjectManager $this) {
        return $this.tryToReloadApplication();
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA1\u0001\u0003D\u00041\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005IS\u0007B!\t\u0011\u0007i1&\u0003\n\n#%\u0011\u0011\"\u0001\r\u0004\u0013\tI\u0011\u0001g\u0002\u0011\tUA\u0011BA\u0005\u00021\rI!!C\u0001\u0019\b1\u0005\u0001T\u0001M\u0003!\u0011)R#\u0003\n\n#%\u0011\u0011\"\u0001\r\u0004\u0013\tI\u0011\u0001g\u0002\u0011\tUA\u0011BA\u0005\u00021\rI!!C\u0001\u0019\b1\u0005\u0001T\u0001M\u0003\u0019\u0003A\"\u0001\u0007\u0002R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011%\u0001\"\u0002"}, strings={"Lcom/intellij/configurationStore/StoreAwareProjectManager$Companion;", "", "()V", "CHANGED_FILES_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "Lcom/intellij/openapi/components/StateStorage;", "kotlin.jvm.PlatformType", "getCHANGED_FILES_KEY", "()Lcom/intellij/openapi/util/Key;"}, moduleName="configuration-store-impl")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final Key<MultiMap<ComponentStoreImpl, StateStorage>> getCHANGED_FILES_KEY() {
            return CHANGED_FILES_KEY;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

