/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ReloadComponentStoreStatus;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.StateStorageBase;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.Messages;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"-\u0015\u0001Q!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001bD\u0003\u0002\u0011\u001d)\u0001!B\u0001\t#\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u00031\tQr\u0007\u0005\u0001\u001b\u0005A\n!G\u0002\t\u00035\t\u00014A\r\u0007\u0011\tiA!\u0003\u0002\n\u0003a\u0019\u0001TA\r\b\u0011\u000fiQ!\u0003\u0002\n\u0003a%A\u0012\u0001\r\u00053\rAQ!D\u0001\u0019\u0002Q\u001bY!$\u000b\u0005\u0003!1Q\"\u0001M\u00073\u0019A9!\u0004\u0003\n\u0005%\t\u0001\u0014\u0002\r\u00053\rA\u0011!D\u0001\u0019\u000fe\u0019\u0001\"B\u0007\u00021\u0003!61\u0002"}, strings={"askToRestart", "", "store", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "notReloadableComponents", "", "", "changedStorages", "", "Lcom/intellij/openapi/components/StateStorage;", "isApp", "StoreAwareProjectManagerKt", "reloadStore", "Lcom/intellij/configurationStore/ReloadComponentStoreStatus;", "Lcom/intellij/configurationStore/ComponentStoreImpl;"}, moduleName="configuration-store-impl")
public final class StoreAwareProjectManagerKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ReloadComponentStoreStatus reloadStore(Set<? extends StateStorage> changedStorages, ComponentStoreImpl store, boolean isApp) {
        boolean willBeReloaded = false;
        try {
            Collection<String> notReloadableComponents;
            try {
                notReloadableComponents = store.reload(changedStorages);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().warn(e);
                Messages.showWarningDialog((String)ProjectBundle.message((String)"project.reload.failed", (Object[])new Object[]{e.getMessage()}), (String)ProjectBundle.message((String)"project.reload.failed.title", (Object[])new Object[0]));
                ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.ERROR;
                if (!willBeReloaded) {
                    for (StateStorage stateStorage : changedStorages) {
                        if (!(stateStorage instanceof StateStorageBase)) continue;
                        ((StateStorageBase)stateStorage).enableSaving();
                    }
                }
                return reloadComponentStoreStatus;
            }
            if (notReloadableComponents == null || notReloadableComponents.isEmpty()) {
                ReloadComponentStoreStatus reloadComponentStoreStatus = ReloadComponentStoreStatus.SUCCESS;
                return reloadComponentStoreStatus;
            }
            willBeReloaded = StoreAwareProjectManagerKt.askToRestart(store, notReloadableComponents, changedStorages, isApp);
            ReloadComponentStoreStatus reloadComponentStoreStatus = willBeReloaded ? ReloadComponentStoreStatus.RESTART_AGREED : ReloadComponentStoreStatus.RESTART_CANCELLED;
            return reloadComponentStoreStatus;
        }
        finally {
            if (!willBeReloaded) {
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).enableSaving();
                }
            }
        }
    }

    public static final boolean askToRestart(@NotNull IComponentStore store, @NotNull Collection<? extends String> notReloadableComponents, @Nullable Set<? extends StateStorage> changedStorages, boolean isApp) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        Intrinsics.checkParameterIsNotNull(notReloadableComponents, (String)"notReloadableComponents");
        StringBuilder message = new StringBuilder();
        String storeName = store instanceof IProjectStore ? "Project '" + ((IProjectStore)store).getProjectName() + "'" : "Application";
        message.append(storeName).append(' ');
        message.append("components were changed externally and cannot be reloaded:\n\n");
        int count = 0;
        for (String string : notReloadableComponents) {
            if (count == 10) {
                message.append('\n').append("and ").append(notReloadableComponents.size() - count).append(" more").append('\n');
                continue;
            }
            message.append(string).append('\n');
            ++count;
        }
        message.append("\nWould you like to ");
        if (isApp) {
            message.append(ApplicationManager.getApplication().isRestartCapable() ? "restart" : "shutdown").append(' ');
            message.append(ApplicationNamesInfo.getInstance().getProductName()).append('?');
        } else {
            message.append("reload project?");
        }
        if (Messages.showYesNoDialog((String)message.toString(), (String)(storeName + " Files Changed"), (Icon)Messages.getQuestionIcon()) == 0) {
            if (changedStorages != null) {
                for (StateStorage stateStorage : changedStorages) {
                    if (!(stateStorage instanceof StateStorageBase)) continue;
                    ((StateStorageBase)stateStorage).disableSaving();
                }
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static final /* synthetic */ ReloadComponentStoreStatus access$reloadStore(@NotNull Set changedStorages, @NotNull ComponentStoreImpl store, boolean isApp) {
        return StoreAwareProjectManagerKt.reloadStore(changedStorages, store, isApp);
    }
}

