/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;

public class DebuggerKeymapExtension
implements KeymapExtension {
    public KeymapGroup createGroup(Condition<AnAction> filtered, Project project) {
        ActionManager actionManager = ActionManager.getInstance();
        Object[] xDebuggerActions = ((DefaultActionGroup)actionManager.getActionOrStub("XDebugger.Actions")).getChildActionsOrStubs();
        Object[] javaDebuggerActions = ((DefaultActionGroup)actionManager.getActionOrStub("JavaDebuggerActions")).getChildActionsOrStubs();
        ArrayList<String> ids = new ArrayList<String>();
        for (AnAction debuggerAction : (AnAction[])ArrayUtil.mergeArrays((Object[])xDebuggerActions, (Object[])javaDebuggerActions)) {
            String actionId;
            String string = actionId = debuggerAction instanceof ActionStub ? ((ActionStub)debuggerAction).getId() : actionManager.getId(debuggerAction);
            if (filtered != null && !filtered.value((Object)debuggerAction)) continue;
            ids.add(actionId);
        }
        Collections.sort(ids);
        Group group = new Group(KeyMapBundle.message((String)"debugger.actions.group.title", (Object[])new Object[0]), AllIcons.General.Debug);
        for (String id : ids) {
            group.addActionId(id);
        }
        return group;
    }
}

