/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.impl.InspectDialog;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.sun.jdi.Field;
import javax.swing.Icon;

public class InspectAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        final DebuggerTreeNodeImpl node = InspectAction.getSelectedNode(e.getDataContext());
        if (node == null) {
            return;
        }
        final NodeDescriptorImpl descriptor = node.getDescriptor();
        final DebuggerStateManager stateManager = InspectAction.getContextManager(e.getDataContext());
        if (!(descriptor instanceof ValueDescriptorImpl) || stateManager == null) {
            return;
        }
        final DebuggerContextImpl context = stateManager.getContext();
        if (!InspectAction.canInspect((ValueDescriptorImpl)descriptor, context)) {
            return;
        }
        context.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(context){

            @Override
            public void threadAction() {
                try {
                    final TextWithImports evaluationText = DebuggerTreeNodeExpression.createEvaluationText(node, context);
                    final NodeDescriptorImpl inspectDescriptor = descriptor instanceof WatchItemDescriptor ? (NodeDescriptorImpl)((WatchItemDescriptor)descriptor).getModifier().getInspectItem(project) : descriptor;
                    DebuggerInvocationUtil.swingInvokeLater(project, new Runnable(){

                        @Override
                        public void run() {
                            InspectDialog dialog = new InspectDialog(project, stateManager, ActionsBundle.actionText((String)"Debugger.Inspect") + " '" + evaluationText + "'", inspectDescriptor);
                            dialog.show();
                        }
                    });
                }
                catch (EvaluateException e1) {
                    DebuggerInvocationUtil.swingInvokeLater(project, new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)project, (String)e1.getMessage(), (String)ActionsBundle.actionText((String)"Debugger.Inspect"));
                        }
                    });
                }
            }
        });
    }

    private static boolean canInspect(ValueDescriptorImpl descriptor, DebuggerContextImpl context) {
        DebuggerSession session = context.getDebuggerSession();
        if (session == null || !session.isPaused()) {
            return false;
        }
        boolean isField = descriptor instanceof FieldDescriptorImpl;
        if (descriptor instanceof WatchItemDescriptor) {
            Modifier modifier = ((WatchItemDescriptor)descriptor).getModifier();
            if (modifier == null || !modifier.canInspect()) {
                return false;
            }
            isField = modifier instanceof Field;
        }
        if (isField && !context.getDebugProcess().canWatchFieldModification()) {
            Messages.showMessageDialog((Project)context.getProject(), (String)DebuggerBundle.message((String)"error.modification.watchpoints.not.supported", (Object[])new Object[0]), (String)ActionsBundle.actionText((String)"Debugger.Inspect"), (Icon)Messages.getInformationIcon());
            return false;
        }
        return true;
    }

    public void update(AnActionEvent e) {
        NodeDescriptorImpl descriptor;
        DebuggerTreeNodeImpl selectedNode = InspectAction.getSelectedNode(e.getDataContext());
        boolean enabled = false;
        if (selectedNode != null && (descriptor = selectedNode.getDescriptor()) != null) {
            if (descriptor instanceof LocalVariableDescriptorImpl || descriptor instanceof FieldDescriptorImpl || descriptor instanceof ArrayElementDescriptorImpl) {
                enabled = true;
            } else if (descriptor instanceof WatchItemDescriptor) {
                Modifier modifier = ((WatchItemDescriptor)descriptor).getModifier();
                enabled = modifier != null && modifier.canInspect();
            }
        }
        e.getPresentation().setVisible(enabled);
    }
}

