/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.settings.CompositeDataBinding;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.debugger.settings.ToggleButtonBinding;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ThreadsViewConfigurable
extends BaseConfigurable {
    private final ThreadsViewSettings mySettings;
    private JPanel myPanel;
    private JCheckBox myShowGroupsCheckBox;
    private JCheckBox myLineNumberCheckBox;
    private JCheckBox myClassNameCheckBox;
    private JCheckBox mySourceCheckBox;
    private JCheckBox myShowSyntheticsCheckBox;
    private JCheckBox myShowCurrentThreadChechBox;
    private JCheckBox myPackageCheckBox;
    private JCheckBox myArgsTypesCheckBox;
    private final CompositeDataBinding myDataBinding;

    public ThreadsViewConfigurable(ThreadsViewSettings settings) {
        this.$$$setupUI$$$();
        this.myDataBinding = new CompositeDataBinding();
        this.mySettings = settings;
        this.myDataBinding.addBinding(new ToggleButtonBinding("SHOW_CLASS_NAME", this.myClassNameCheckBox));
        this.myDataBinding.addBinding(new ToggleButtonBinding("SHOW_PACKAGE_NAME", this.myPackageCheckBox));
        this.myDataBinding.addBinding(new ToggleButtonBinding("SHOW_ARGUMENTS_TYPES", this.myArgsTypesCheckBox));
        this.myDataBinding.addBinding(new ToggleButtonBinding("SHOW_LINE_NUMBER", this.myLineNumberCheckBox));
        this.myDataBinding.addBinding(new ToggleButtonBinding("SHOW_SOURCE_NAME", this.mySourceCheckBox));
        this.myDataBinding.addBinding(new ToggleButtonBinding("SHOW_THREAD_GROUPS", this.myShowGroupsCheckBox));
        this.myDataBinding.addBinding(new ToggleButtonBinding("SHOW_SYNTHETIC_FRAMES", this.myShowSyntheticsCheckBox));
        this.myDataBinding.addBinding(new ToggleButtonBinding("SHOW_CURRENT_THREAD", this.myShowCurrentThreadChechBox));
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"threads.view.configurable.display.name", (Object[])new Object[0]);
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public void apply() {
        this.myDataBinding.saveData(this.mySettings);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            for (DebuggerSession session : DebuggerManagerEx.getInstanceEx(project).getSessions()) {
                session.refresh(false);
            }
            XDebuggerUtilImpl.rebuildAllSessionsViews(project);
        }
    }

    public void reset() {
        this.myDataBinding.loadData(this.mySettings);
    }

    public boolean isModified() {
        return this.myDataBinding.isModified(this.mySettings);
    }

    public String getHelpTopic() {
        return "reference.dialogs.customizeThreadView";
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.myShowGroupsCheckBox = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.threads.view.configurable.show.thread.groups"));
        jCheckBox8.setMargin(new Insets(5, 2, 2, 2));
        jPanel2.add((Component)jCheckBox8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowSyntheticsCheckBox = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.threads.view.configurable.show.stack.frames.for.synthetic.methods"));
        jPanel2.add((Component)jCheckBox7, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowCurrentThreadChechBox = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.threads.view.configurable.current.thread.on.top"));
        jPanel2.add((Component)jCheckBox6, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.myLineNumberCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.threads.view.configurable.show.line.number"));
        jCheckBox5.setMargin(new Insets(5, 2, 2, 2));
        jPanel3.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myClassNameCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.threads.view.configurable.show.class.name"));
        jPanel3.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySourceCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.threads.view.configurable.show.source.file.name"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPackageCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.threads.view.configurable.show.package"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myArgsTypesCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.threads.view.configurable.show.prams.types"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

