/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HotSwapProgressImpl
extends HotSwapProgress {
    static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"HotSwap", (String)ToolWindowId.DEBUG);
    private final TIntObjectHashMap<List<String>> myMessages = new TIntObjectHashMap();
    private final ProgressWindow myProgressWindow;
    private String myTitle = DebuggerBundle.message((String)"progress.hot.swap.title", (Object[])new Object[0]);
    private final MergingUpdateQueue myUpdateQueue;

    public HotSwapProgressImpl(Project project) {
        super(project);
        this.myProgressWindow = new BackgroundableProcessIndicator(this.getProject(), this.myTitle, new PerformInBackgroundOption(){

            public boolean shouldStartInBackground() {
                return DebuggerSettings.getInstance().HOTSWAP_IN_BACKGROUND;
            }

            public void processSentToBackground() {
            }
        }, null, null, true);
        this.myProgressWindow.addStateDelegate(new AbstractProgressIndicatorExBase(){

            @Override
            public void cancel() {
                super.cancel();
                HotSwapProgressImpl.this.cancel();
            }
        });
        this.myUpdateQueue = new MergingUpdateQueue("HotSwapProgress update queue", 100, true, null, (Disposable)this.myProgressWindow);
    }

    @Override
    public void finished() {
        super.finished();
        List<String> errors = this.getMessages(4);
        List<String> warnings = this.getMessages(5);
        if (!errors.isEmpty()) {
            NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"status.hot.swap.completed.with.errors", (Object[])new Object[0]), HotSwapProgressImpl.buildMessage(errors), NotificationType.ERROR, null).notify(this.getProject());
        } else if (!warnings.isEmpty()) {
            NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"status.hot.swap.completed.with.warnings", (Object[])new Object[0]), HotSwapProgressImpl.buildMessage(warnings), NotificationType.WARNING, null).notify(this.getProject());
        } else if (!this.myMessages.isEmpty()) {
            ArrayList<String> messages = new ArrayList<String>();
            for (int category : this.myMessages.keys()) {
                messages.addAll(this.getMessages(category));
            }
            NOTIFICATION_GROUP.createNotification(HotSwapProgressImpl.buildMessage(messages), NotificationType.INFORMATION).notify(this.getProject());
        }
    }

    private List<String> getMessages(int category) {
        List messages = (List)this.myMessages.get(category);
        return messages == null ? Collections.emptyList() : messages;
    }

    private static String buildMessage(List<String> messages) {
        return StringUtil.trimEnd((String)StringUtil.join(messages, (String)" \n").trim(), (String)";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(DebuggerSession session, int type, String text) {
        ArrayList<String> messages = (ArrayList<String>)this.myMessages.get(type);
        if (messages == null) {
            messages = new ArrayList<String>();
            this.myMessages.put(type, messages);
        }
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append(session.getSessionName()).append(": ").append(text).append(";");
            messages.add(builder.toString());
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @Override
    public void setText(final String text) {
        this.myUpdateQueue.queue(new Update("Text"){

            public void run() {
                DebuggerInvocationUtil.invokeLater(HotSwapProgressImpl.this.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        if (!HotSwapProgressImpl.this.myProgressWindow.isCanceled() && HotSwapProgressImpl.this.myProgressWindow.isRunning()) {
                            HotSwapProgressImpl.this.myProgressWindow.setText(text);
                        }
                    }
                }, HotSwapProgressImpl.this.myProgressWindow.getModalityState());
            }
        });
    }

    @Override
    public void setTitle(final String text) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), new Runnable(){

            @Override
            public void run() {
                if (!HotSwapProgressImpl.this.myProgressWindow.isCanceled() && HotSwapProgressImpl.this.myProgressWindow.isRunning()) {
                    HotSwapProgressImpl.this.myProgressWindow.setTitle(text);
                }
            }
        }, this.myProgressWindow.getModalityState());
    }

    @Override
    public void setFraction(final double v) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), new Runnable(){

            @Override
            public void run() {
                if (!HotSwapProgressImpl.this.myProgressWindow.isCanceled() && HotSwapProgressImpl.this.myProgressWindow.isRunning()) {
                    HotSwapProgressImpl.this.myProgressWindow.setFraction(v);
                }
            }
        }, this.myProgressWindow.getModalityState());
    }

    @Override
    public boolean isCancelled() {
        return this.myProgressWindow.isCanceled();
    }

    public ProgressIndicator getProgressIndicator() {
        return this.myProgressWindow;
    }

    @Override
    public void setDebuggerSession(DebuggerSession session) {
        this.myTitle = DebuggerBundle.message((String)"progress.hot.swap.title", (Object[])new Object[0]) + " : " + session.getSessionName();
        this.myProgressWindow.setTitle(this.myTitle);
    }
}

