/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.classFilter.ClassFilterEditor;
import com.intellij.util.IconUtil;
import java.awt.Component;
import javax.swing.Icon;

public class InstanceFilterEditor
extends ClassFilterEditor {
    public InstanceFilterEditor(Project project) {
        super(project);
    }

    protected void addClassFilter() {
        String idString = Messages.showInputDialog((Project)this.myProject, (String)DebuggerBundle.message((String)"add.instance.filter.dialog.prompt", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"add.instance.filter.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (idString != null) {
            ClassFilter filter = this.createFilter(idString);
            this.myTableModel.addRow(filter);
            int row = this.myTableModel.getRowCount() - 1;
            this.myTable.getSelectionModel().setSelectionInterval(row, row);
            this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
            this.myTable.requestFocus();
        }
    }

    protected String getAddButtonText() {
        return DebuggerBundle.message((String)"button.add", (Object[])new Object[0]);
    }

    protected Icon getAddButtonIcon() {
        return IconUtil.getAddIcon();
    }

    protected boolean addPatternButtonVisible() {
        return false;
    }

    protected ClassFilter createFilter(String pattern) {
        try {
            Long.parseLong(pattern);
            return super.createFilter(pattern);
        }
        catch (NumberFormatException e) {
            Messages.showMessageDialog((Component)((Object)this), (String)DebuggerBundle.message((String)"add.instance.filter.dialog.error.numeric.value.expected", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"add.instance.filter.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return null;
        }
    }
}

