/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.debugger.ui.breakpoints.AnyExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointDefaults;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaExceptionBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaFieldBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaWildcardMethodBreakpointType;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiField;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointAdapter;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.sun.jdi.InternalException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import gnu.trove.THashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaExceptionBreakpointProperties;

public class BreakpointManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.BreakpointManager");
    @NonNls
    private static final String MASTER_BREAKPOINT_TAGNAME = "master_breakpoint";
    @NonNls
    private static final String SLAVE_BREAKPOINT_TAGNAME = "slave_breakpoint";
    @NonNls
    private static final String DEFAULT_SUSPEND_POLICY_ATTRIBUTE_NAME = "default_suspend_policy";
    @NonNls
    private static final String DEFAULT_CONDITION_STATE_ATTRIBUTE_NAME = "default_condition_enabled";
    @NonNls
    private static final String RULES_GROUP_NAME = "breakpoint_rules";
    private static final String CONVERTED_PARAM = "converted";
    private final Project myProject;
    private final Map<String, String> myUIProperties;
    private final StartupManager myStartupManager;
    private final Map<String, Element> myOriginalBreakpointsNodes;

    public BreakpointManager(@NotNull Project project, @NotNull StartupManager startupManager, @NotNull DebuggerManagerImpl debuggerManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/BreakpointManager", "<init>"));
        }
        if (startupManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startupManager", "com/intellij/debugger/ui/breakpoints/BreakpointManager", "<init>"));
        }
        if (debuggerManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerManager", "com/intellij/debugger/ui/breakpoints/BreakpointManager", "<init>"));
        }
        this.myUIProperties = new LinkedHashMap<String, String>();
        this.myOriginalBreakpointsNodes = new LinkedHashMap<String, Element>();
        this.myProject = project;
        this.myStartupManager = startupManager;
        debuggerManager.getContextManager().addListener(new DebuggerContextListener(){
            private DebuggerSession myPreviousSession;

            @Override
            public void changeEvent(@NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
                if (newContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/debugger/ui/breakpoints/BreakpointManager$1", "changeEvent"));
                }
                if (event == DebuggerSession.Event.ATTACHED) {
                    for (XBreakpoint breakpoint : BreakpointManager.this.getXBreakpointManager().getAllBreakpoints()) {
                        if (BreakpointManager.checkAndNotifyPossiblySlowBreakpoint(breakpoint)) break;
                    }
                }
                if (newContext.getDebuggerSession() != this.myPreviousSession || event == DebuggerSession.Event.DETACHED) {
                    BreakpointManager.this.updateBreakpointsUI();
                    this.myPreviousSession = newContext.getDebuggerSession();
                }
            }
        });
    }

    private static boolean checkAndNotifyPossiblySlowBreakpoint(XBreakpoint breakpoint) {
        if (breakpoint.isEnabled() && (breakpoint.getType() instanceof JavaMethodBreakpointType || breakpoint.getType() instanceof JavaWildcardMethodBreakpointType)) {
            XDebugSessionImpl.NOTIFICATION_GROUP.createNotification("Method breakpoints may dramatically slow down debugging", MessageType.WARNING).notify(((XBreakpointBase)breakpoint).getProject());
            return true;
        }
        return false;
    }

    public void init() {
        XBreakpointManager manager = XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager();
        manager.addBreakpointListener((XBreakpointListener)new XBreakpointAdapter<XBreakpoint<?>>(){

            public void breakpointAdded(@NotNull XBreakpoint<?> xBreakpoint) {
                if (xBreakpoint == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xBreakpoint", "com/intellij/debugger/ui/breakpoints/BreakpointManager$2", "breakpointAdded"));
                }
                Breakpoint breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint);
                if (breakpoint != null) {
                    BreakpointManager.addBreakpoint(breakpoint);
                }
            }

            public void breakpointChanged(@NotNull XBreakpoint xBreakpoint) {
                if (xBreakpoint == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xBreakpoint", "com/intellij/debugger/ui/breakpoints/BreakpointManager$2", "breakpointChanged"));
                }
                Breakpoint breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint);
                if (breakpoint != null) {
                    BreakpointManager.this.fireBreakpointChanged(breakpoint);
                }
            }
        });
    }

    private XBreakpointManager getXBreakpointManager() {
        return XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager();
    }

    public void editBreakpoint(final Breakpoint breakpoint, final Editor editor) {
        DebuggerInvocationUtil.swingInvokeLater(this.myProject, new Runnable(){

            @Override
            public void run() {
                GutterIconRenderer renderer;
                RangeHighlighter highlighter;
                XBreakpoint xBreakpoint = breakpoint.myXBreakpoint;
                if (xBreakpoint instanceof XLineBreakpointImpl && (highlighter = ((XLineBreakpointImpl)xBreakpoint).getHighlighter()) != null && (renderer = highlighter.getGutterIconRenderer()) != null) {
                    DebuggerSupport.getDebuggerSupport(JavaDebuggerSupport.class).getEditBreakpointAction().editBreakpoint(BreakpointManager.this.myProject, editor, breakpoint.myXBreakpoint, renderer);
                }
            }
        });
    }

    public void setBreakpointDefaults(Key<? extends Breakpoint> category, BreakpointDefaults defaults) {
        Class typeCls = null;
        if (LineBreakpoint.CATEGORY.toString().equals(category.toString())) {
            typeCls = JavaLineBreakpointType.class;
        } else if (MethodBreakpoint.CATEGORY.toString().equals(category.toString())) {
            typeCls = JavaMethodBreakpointType.class;
        } else if (FieldBreakpoint.CATEGORY.toString().equals(category.toString())) {
            typeCls = JavaFieldBreakpointType.class;
        } else if (ExceptionBreakpoint.CATEGORY.toString().equals(category.toString())) {
            typeCls = JavaExceptionBreakpointType.class;
        }
        if (typeCls != null) {
            XBreakpointType type = XDebuggerUtil.getInstance().findBreakpointType(typeCls);
            ((XBreakpointManagerImpl)this.getXBreakpointManager()).getBreakpointDefaults(type).setSuspendPolicy(Breakpoint.transformSuspendPolicy(defaults.getSuspendPolicy()));
        }
    }

    @Nullable
    public RunToCursorBreakpoint addRunToCursorBreakpoint(@NotNull XSourcePosition position, boolean ignoreBreakpoints) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/BreakpointManager", "addRunToCursorBreakpoint"));
        }
        return RunToCursorBreakpoint.create(this.myProject, position, ignoreBreakpoints);
    }

    @Nullable
    public StepIntoBreakpoint addStepIntoBreakpoint(@NotNull BreakpointStepMethodFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/debugger/ui/breakpoints/BreakpointManager", "addStepIntoBreakpoint"));
        }
        return StepIntoBreakpoint.create(this.myProject, filter);
    }

    @Nullable
    public LineBreakpoint addLineBreakpoint(Document document, int lineIndex) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!LineBreakpoint.canAddLineBreakpoint(this.myProject, document, lineIndex)) {
            return null;
        }
        XLineBreakpoint xLineBreakpoint = this.addXLineBreakpoint(JavaLineBreakpointType.class, document, lineIndex);
        Breakpoint breakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)xLineBreakpoint);
        if (breakpoint instanceof LineBreakpoint) {
            BreakpointManager.addBreakpoint(breakpoint);
            return (LineBreakpoint)breakpoint;
        }
        return null;
    }

    @Nullable
    public FieldBreakpoint addFieldBreakpoint(@NotNull Document document, int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/debugger/ui/breakpoints/BreakpointManager", "addFieldBreakpoint"));
        }
        PsiField field = FieldBreakpoint.findField(this.myProject, document, offset);
        if (field == null) {
            return null;
        }
        int line = document.getLineNumber(offset);
        if (document.getLineNumber(field.getNameIdentifier().getTextOffset()) < line) {
            return null;
        }
        return this.addFieldBreakpoint(document, line, field.getName());
    }

    @Nullable
    public FieldBreakpoint addFieldBreakpoint(Document document, int lineIndex, String fieldName) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        XLineBreakpoint xBreakpoint = this.addXLineBreakpoint(JavaFieldBreakpointType.class, document, lineIndex);
        Breakpoint javaBreakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)xBreakpoint);
        if (javaBreakpoint instanceof FieldBreakpoint) {
            FieldBreakpoint fieldBreakpoint = (FieldBreakpoint)javaBreakpoint;
            fieldBreakpoint.setFieldName(fieldName);
            BreakpointManager.addBreakpoint(javaBreakpoint);
            return fieldBreakpoint;
        }
        return null;
    }

    @NotNull
    public ExceptionBreakpoint addExceptionBreakpoint(final @NotNull String exceptionClassName, final String packageName) {
        if (exceptionClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionClassName", "com/intellij/debugger/ui/breakpoints/BreakpointManager", "addExceptionBreakpoint"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final JavaExceptionBreakpointType type = (JavaExceptionBreakpointType)XDebuggerUtil.getInstance().findBreakpointType(JavaExceptionBreakpointType.class);
        ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<ExceptionBreakpoint>(){

            public ExceptionBreakpoint compute() {
                XBreakpoint xBreakpoint = XDebuggerManager.getInstance((Project)BreakpointManager.this.myProject).getBreakpointManager().addBreakpoint((XBreakpointType)type, (XBreakpointProperties)new JavaExceptionBreakpointProperties(exceptionClassName, packageName));
                Breakpoint javaBreakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint);
                if (javaBreakpoint instanceof ExceptionBreakpoint) {
                    ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)javaBreakpoint;
                    exceptionBreakpoint.setQualifiedName(exceptionClassName);
                    exceptionBreakpoint.setPackageName(packageName);
                    BreakpointManager.addBreakpoint(exceptionBreakpoint);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("ExceptionBreakpoint Added");
                    }
                    return exceptionBreakpoint;
                }
                return null;
            }
        });
        if (exceptionBreakpoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/BreakpointManager", "addExceptionBreakpoint"));
        }
        return exceptionBreakpoint;
    }

    @Nullable
    public MethodBreakpoint addMethodBreakpoint(Document document, int lineIndex) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        XLineBreakpoint xBreakpoint = this.addXLineBreakpoint(JavaMethodBreakpointType.class, document, lineIndex);
        Breakpoint javaBreakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)xBreakpoint);
        if (javaBreakpoint instanceof MethodBreakpoint) {
            BreakpointManager.addBreakpoint(javaBreakpoint);
            return (MethodBreakpoint)javaBreakpoint;
        }
        return null;
    }

    private <B extends XBreakpoint<?>> XLineBreakpoint addXLineBreakpoint(Class<? extends XBreakpointType<B, ?>> typeCls, Document document, final int lineIndex) {
        final XBreakpointType type = XDebuggerUtil.getInstance().findBreakpointType(typeCls);
        final VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        return (XLineBreakpoint)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<XLineBreakpoint>(){

            public XLineBreakpoint compute() {
                return XDebuggerManager.getInstance((Project)BreakpointManager.this.myProject).getBreakpointManager().addLineBreakpoint((XLineBreakpointType)type, file2.getUrl(), lineIndex, ((XLineBreakpointType)type).createBreakpointProperties(file2, lineIndex));
            }
        });
    }

    @Nullable
    public <T extends BreakpointWithHighlighter> T findBreakpoint(Document document, int offset, @Nullable Key<T> category) {
        for (Breakpoint breakpoint : this.getBreakpoints()) {
            if (!(breakpoint instanceof BreakpointWithHighlighter) || !((BreakpointWithHighlighter)breakpoint).isAt(document, offset) || category != null && !category.equals(breakpoint.getCategory())) continue;
            return (T)((BreakpointWithHighlighter)breakpoint);
        }
        return null;
    }

    public void readExternal(final @NotNull Element parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/debugger/ui/breakpoints/BreakpointManager", "readExternal"));
        }
        this.myOriginalBreakpointsNodes.clear();
        for (Element element : parentNode.getChildren()) {
            this.myOriginalBreakpointsNodes.put(element.getName(), element.clone());
        }
        if (this.myProject.isOpen()) {
            this.doRead(parentNode);
        } else {
            this.myStartupManager.registerPostStartupActivity(new Runnable(){

                @Override
                public void run() {
                    BreakpointManager.this.doRead(parentNode);
                }
            });
        }
    }

    private void doRead(final @NotNull Element parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/debugger/ui/breakpoints/BreakpointManager", "doRead"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                Element rulesGroup;
                THashMap nameToBreakpointMap = new THashMap();
                try {
                    List groups = parentNode.getChildren();
                    for (Object group1 : groups) {
                        JavaExceptionBreakpointType type;
                        XBreakpointManager manager;
                        XBreakpoint xBreakpoint;
                        Breakpoint breakpoint;
                        Element breakpointElement;
                        Element anyExceptionBreakpointGroup;
                        Element group = (Element)group1;
                        if (group.getName().equals(BreakpointManager.RULES_GROUP_NAME) || group.getAttribute(BreakpointManager.CONVERTED_PARAM) != null) continue;
                        String categoryName = group.getName();
                        Key breakpointCategory = BreakpointCategory.lookup(categoryName);
                        String defaultPolicy = group.getAttributeValue(BreakpointManager.DEFAULT_SUSPEND_POLICY_ATTRIBUTE_NAME);
                        boolean conditionEnabled = Boolean.parseBoolean(group.getAttributeValue(BreakpointManager.DEFAULT_CONDITION_STATE_ATTRIBUTE_NAME, "true"));
                        BreakpointManager.this.setBreakpointDefaults(breakpointCategory, new BreakpointDefaults(defaultPolicy, conditionEnabled));
                        if (!AnyExceptionBreakpoint.ANY_EXCEPTION_BREAKPOINT.equals(breakpointCategory)) {
                            anyExceptionBreakpointGroup = group.getChild(AnyExceptionBreakpoint.ANY_EXCEPTION_BREAKPOINT.toString());
                            for (Element breakpointNode : group.getChildren("breakpoint")) {
                                Breakpoint breakpoint2 = BreakpointManager.this.createBreakpoint(categoryName, breakpointNode);
                                breakpoint2.readExternal(breakpointNode);
                                nameToBreakpointMap.put(breakpoint2.getDisplayName(), breakpoint2);
                            }
                        } else {
                            anyExceptionBreakpointGroup = group;
                        }
                        if (anyExceptionBreakpointGroup == null || (breakpointElement = group.getChild("breakpoint")) == null || (breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint = (manager = XDebuggerManager.getInstance((Project)BreakpointManager.this.myProject).getBreakpointManager()).getDefaultBreakpoint((XBreakpointType)(type = (JavaExceptionBreakpointType)XDebuggerUtil.getInstance().findBreakpointType(JavaExceptionBreakpointType.class))))) == null) continue;
                        breakpoint.readExternal(breakpointElement);
                        BreakpointManager.addBreakpoint(breakpoint);
                    }
                }
                catch (InvalidDataException groups) {
                    // empty catch block
                }
                if ((rulesGroup = parentNode.getChild(BreakpointManager.RULES_GROUP_NAME)) != null) {
                    List rules = rulesGroup.getChildren("rule");
                    for (Element rule : rules) {
                        Breakpoint slaveBreakpoint;
                        Breakpoint masterBreakpoint;
                        Element slave;
                        Element master;
                        if (rule.getAttribute(BreakpointManager.CONVERTED_PARAM) != null || (master = rule.getChild(BreakpointManager.MASTER_BREAKPOINT_TAGNAME)) == null || (slave = rule.getChild(BreakpointManager.SLAVE_BREAKPOINT_TAGNAME)) == null || (masterBreakpoint = (Breakpoint)nameToBreakpointMap.get(master.getAttributeValue("name"))) == null || (slaveBreakpoint = (Breakpoint)nameToBreakpointMap.get(slave.getAttributeValue("name"))) == null) continue;
                        boolean leaveEnabled = "true".equalsIgnoreCase(rule.getAttributeValue("leaveEnabled"));
                        XDependentBreakpointManager dependentBreakpointManager = ((XBreakpointManagerImpl)BreakpointManager.this.getXBreakpointManager()).getDependentBreakpointManager();
                        dependentBreakpointManager.setMasterBreakpoint(slaveBreakpoint.myXBreakpoint, masterBreakpoint.myXBreakpoint, leaveEnabled);
                    }
                }
                DebuggerInvocationUtil.invokeLater(BreakpointManager.this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        BreakpointManager.this.updateBreakpointsUI();
                    }
                });
            }
        });
        this.myUIProperties.clear();
        Element props = parentNode.getChild("ui_properties");
        if (props != null) {
            List children2 = props.getChildren("property");
            for (Object child : children2) {
                Element property = (Element)child;
                String name = property.getAttributeValue("name");
                String value = property.getAttributeValue("value");
                if (name == null || value == null) continue;
                this.myUIProperties.put(name, value);
            }
        }
    }

    private Breakpoint createBreakpoint(String category, Element breakpointNode) throws InvalidDataException {
        Object xBreakpoint = null;
        if (category.equals(LineBreakpoint.CATEGORY.toString())) {
            xBreakpoint = this.createXLineBreakpoint(JavaLineBreakpointType.class, breakpointNode);
        } else if (category.equals(MethodBreakpoint.CATEGORY.toString())) {
            xBreakpoint = breakpointNode.getAttribute("url") != null ? this.createXLineBreakpoint(JavaMethodBreakpointType.class, breakpointNode) : this.createXBreakpoint(JavaWildcardMethodBreakpointType.class);
        } else if (category.equals(FieldBreakpoint.CATEGORY.toString())) {
            xBreakpoint = this.createXLineBreakpoint(JavaFieldBreakpointType.class, breakpointNode);
        } else if (category.equals(ExceptionBreakpoint.CATEGORY.toString())) {
            xBreakpoint = this.createXBreakpoint(JavaExceptionBreakpointType.class);
        }
        if (xBreakpoint == null) {
            throw new IllegalStateException("Unknown breakpoint category " + category);
        }
        return BreakpointManager.getJavaBreakpoint((XBreakpoint)xBreakpoint);
    }

    private <B extends XBreakpoint<?>> XBreakpoint createXBreakpoint(Class<? extends XBreakpointType<B, ?>> typeCls) {
        final XBreakpointType type = XDebuggerUtil.getInstance().findBreakpointType(typeCls);
        return (XBreakpoint)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<XBreakpoint>(){

            public XBreakpoint compute() {
                return XDebuggerManager.getInstance((Project)BreakpointManager.this.myProject).getBreakpointManager().addBreakpoint(type, type.createProperties());
            }
        });
    }

    private <B extends XBreakpoint<?>> XLineBreakpoint createXLineBreakpoint(Class<? extends XBreakpointType<B, ?>> typeCls, Element breakpointNode) throws InvalidDataException {
        int line;
        String url = breakpointNode.getAttributeValue("url");
        VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(url);
        if (vFile == null) {
            throw new InvalidDataException(DebuggerBundle.message((String)"error.breakpoint.file.not.found", (Object[])new Object[]{url}));
        }
        Document doc = FileDocumentManager.getInstance().getDocument(vFile);
        if (doc == null) {
            throw new InvalidDataException(DebuggerBundle.message((String)"error.cannot.load.breakpoint.file", (Object[])new Object[]{url}));
        }
        try {
            line = Integer.parseInt(breakpointNode.getAttributeValue("line"));
        }
        catch (Exception e) {
            throw new InvalidDataException("Line number is invalid for breakpoint");
        }
        return this.addXLineBreakpoint(typeCls, doc, line);
    }

    public static void addBreakpoint(@NotNull Breakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/BreakpointManager", "addBreakpoint"));
        }
        assert (breakpoint.myXBreakpoint.getUserData(Breakpoint.DATA_KEY) == breakpoint);
        breakpoint.updateUI();
        BreakpointManager.checkAndNotifyPossiblySlowBreakpoint(breakpoint.myXBreakpoint);
    }

    public void removeBreakpoint(final @Nullable Breakpoint breakpoint) {
        if (breakpoint == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                BreakpointManager.this.getXBreakpointManager().removeBreakpoint(breakpoint.myXBreakpoint);
            }
        });
    }

    public void writeExternal(@NotNull Element parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/debugger/ui/breakpoints/BreakpointManager", "writeExternal"));
        }
        for (Element group : this.myOriginalBreakpointsNodes.values()) {
            if (group.getAttribute(CONVERTED_PARAM) == null) {
                group.setAttribute(CONVERTED_PARAM, "true");
            }
            parentNode.addContent(group.clone());
        }
    }

    @NotNull
    public List<Breakpoint> getBreakpoints() {
        List list = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<Breakpoint>>(){

            public List<Breakpoint> compute() {
                return ContainerUtil.mapNotNull((Object[])BreakpointManager.this.getXBreakpointManager().getAllBreakpoints(), (Function)new Function<XBreakpoint<?>, Breakpoint>(){

                    public Breakpoint fun(XBreakpoint<?> xBreakpoint) {
                        return BreakpointManager.getJavaBreakpoint(xBreakpoint);
                    }
                });
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/BreakpointManager", "getBreakpoints"));
        }
        return list;
    }

    @Nullable
    public static Breakpoint getJavaBreakpoint(@Nullable XBreakpoint xBreakpoint) {
        if (xBreakpoint == null) {
            return null;
        }
        Breakpoint breakpoint = (Breakpoint)xBreakpoint.getUserData(Breakpoint.DATA_KEY);
        if (breakpoint == null && xBreakpoint.getType() instanceof JavaBreakpointType) {
            Project project = ((XBreakpointBase)xBreakpoint).getProject();
            breakpoint = ((JavaBreakpointType)xBreakpoint.getType()).createJavaBreakpoint(project, xBreakpoint);
            xBreakpoint.putUserData(Breakpoint.DATA_KEY, breakpoint);
        }
        return breakpoint;
    }

    public void disableBreakpoints(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/BreakpointManager", "disableBreakpoints"));
        }
        List<Breakpoint> breakpoints = this.getBreakpoints();
        if (!breakpoints.isEmpty()) {
            RequestManagerImpl requestManager = debugProcess.getRequestsManager();
            for (Breakpoint breakpoint : breakpoints) {
                breakpoint.markVerified(requestManager.isVerified(breakpoint));
                requestManager.deleteRequest(breakpoint);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BreakpointManager.this.updateBreakpointsUI();
                }
            });
        }
    }

    public void enableBreakpoints(DebugProcessImpl debugProcess) {
        List<Breakpoint> breakpoints = this.getBreakpoints();
        if (!breakpoints.isEmpty()) {
            for (Breakpoint breakpoint : breakpoints) {
                breakpoint.markVerified(false);
                breakpoint.createRequest(debugProcess);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BreakpointManager.this.updateBreakpointsUI();
                }
            });
        }
    }

    public void applyThreadFilter(@NotNull DebugProcessImpl debugProcess, @Nullable ThreadReference newFilterThread) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/BreakpointManager", "applyThreadFilter"));
        }
        RequestManagerImpl requestManager = debugProcess.getRequestsManager();
        ThreadReference oldFilterThread = requestManager.getFilterThread();
        if (Comparing.equal((Object)newFilterThread, (Object)oldFilterThread)) {
            return;
        }
        requestManager.setFilterThread(newFilterThread);
        if (newFilterThread == null || oldFilterThread != null) {
            List<Breakpoint> breakpoints = this.getBreakpoints();
            for (Breakpoint breakpoint : breakpoints) {
                if (!LineBreakpoint.CATEGORY.equals(breakpoint.getCategory()) && !MethodBreakpoint.CATEGORY.equals(breakpoint.getCategory())) continue;
                requestManager.deleteRequest(breakpoint);
                breakpoint.createRequest(debugProcess);
            }
        } else {
            EventRequestManager eventRequestManager = requestManager.getVMRequestManager();
            if (eventRequestManager != null) {
                abstract class FilterSetter<T extends EventRequest> {
                    FilterSetter() {
                    }

                    void applyFilter(@NotNull List<T> requests, ThreadReference thread) {
                        if (requests == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/debugger/ui/breakpoints/BreakpointManager$1FilterSetter", "applyFilter"));
                        }
                        for (EventRequest request : requests) {
                            try {
                                boolean wasEnabled = request.isEnabled();
                                if (wasEnabled) {
                                    request.disable();
                                }
                                this.addFilter(request, thread);
                                if (!wasEnabled) continue;
                                request.enable();
                            }
                            catch (InternalException e) {
                                LOG.info((Throwable)e);
                            }
                            catch (InvalidRequestStateException e) {
                                LOG.info((Throwable)e);
                            }
                        }
                    }

                    protected abstract void addFilter(T var1, ThreadReference var2);
                }
                new FilterSetter<BreakpointRequest>(){
                    {
                    }

                    @Override
                    protected void addFilter(@NotNull BreakpointRequest request, ThreadReference thread) {
                        if (request == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/debugger/ui/breakpoints/BreakpointManager$13", "addFilter"));
                        }
                        request.addThreadFilter(thread);
                    }
                }.applyFilter(eventRequestManager.breakpointRequests(), newFilterThread);
                new FilterSetter<MethodEntryRequest>(){
                    {
                    }

                    @Override
                    protected void addFilter(@NotNull MethodEntryRequest request, ThreadReference thread) {
                        if (request == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/debugger/ui/breakpoints/BreakpointManager$14", "addFilter"));
                        }
                        request.addThreadFilter(thread);
                    }
                }.applyFilter(eventRequestManager.methodEntryRequests(), newFilterThread);
                new FilterSetter<MethodExitRequest>(){
                    {
                    }

                    @Override
                    protected void addFilter(@NotNull MethodExitRequest request, ThreadReference thread) {
                        if (request == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/debugger/ui/breakpoints/BreakpointManager$15", "addFilter"));
                        }
                        request.addThreadFilter(thread);
                    }
                }.applyFilter(eventRequestManager.methodExitRequests(), newFilterThread);
            }
        }
    }

    public void updateBreakpointsUI() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (Breakpoint breakpoint : this.getBreakpoints()) {
            breakpoint.updateUI();
        }
    }

    public void reloadBreakpoints() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (Breakpoint breakpoint : this.getBreakpoints()) {
            breakpoint.reload();
        }
    }

    public void fireBreakpointChanged(Breakpoint breakpoint) {
        breakpoint.reload();
        breakpoint.updateUI();
    }

    public void setBreakpointEnabled(@NotNull Breakpoint breakpoint, boolean enabled) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/BreakpointManager", "setBreakpointEnabled"));
        }
        if (breakpoint.isEnabled() != enabled) {
            breakpoint.setEnabled(enabled);
        }
    }

    @Nullable
    public Breakpoint findMasterBreakpoint(@NotNull Breakpoint dependentBreakpoint) {
        if (dependentBreakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependentBreakpoint", "com/intellij/debugger/ui/breakpoints/BreakpointManager", "findMasterBreakpoint"));
        }
        XDependentBreakpointManager dependentBreakpointManager = ((XBreakpointManagerImpl)this.getXBreakpointManager()).getDependentBreakpointManager();
        return BreakpointManager.getJavaBreakpoint(dependentBreakpointManager.getMasterBreakpoint(dependentBreakpoint.myXBreakpoint));
    }

    public String getProperty(String name) {
        return this.myUIProperties.get(name);
    }

    public String setProperty(String name, String value) {
        return this.myUIProperties.put(name, value);
    }
}

