/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class WildcardMethodBreakpoint
extends Breakpoint<JavaMethodBreakpointProperties> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint");
    public static final String JDOM_LABEL = "wildcard_breakpoint";

    public WildcardMethodBreakpoint(Project project, XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        super(project, breakpoint);
    }

    @Override
    public Key<MethodBreakpoint> getCategory() {
        return MethodBreakpoint.CATEGORY;
    }

    protected WildcardMethodBreakpoint(Project project, @NotNull String classPattern, @NotNull String methodName, XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        if (classPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPattern", "com/intellij/debugger/ui/breakpoints/WildcardMethodBreakpoint", "<init>"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/debugger/ui/breakpoints/WildcardMethodBreakpoint", "<init>"));
        }
        super(project, breakpoint);
        this.setClassPattern(classPattern);
        this.setMethodName(methodName);
    }

    @Override
    public String getClassName() {
        return this.getClassPattern();
    }

    @Override
    @Nullable
    public String getShortClassName() {
        return this.getClassName();
    }

    public String getMethodName() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName;
    }

    @Override
    public PsiClass getPsiClass() {
        return (PsiClass)PsiDocumentManager.getInstance((Project)this.myProject).commitAndRunReadAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                return WildcardMethodBreakpoint.this.getClassName() != null ? DebuggerUtils.findClass((String)WildcardMethodBreakpoint.this.getClassName(), (Project)WildcardMethodBreakpoint.this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)WildcardMethodBreakpoint.this.myProject)) : null;
            }
        });
    }

    @Override
    public String getDisplayName() {
        if (!this.isValid()) {
            return DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
        }
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            buffer.append(this.getClassPattern());
            buffer.append(".");
            buffer.append(this.getMethodName());
            buffer.append("()");
            String string = buffer.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    @Override
    public Icon getIcon() {
        if (!this.isEnabled()) {
            Breakpoint master = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this);
            return master == null ? AllIcons.Debugger.Db_disabled_method_breakpoint : AllIcons.Debugger.Db_dep_method_breakpoint;
        }
        return AllIcons.Debugger.Db_method_breakpoint;
    }

    @Override
    public void reload() {
    }

    @Override
    public boolean evaluateCondition(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        return this.matchesEvent(event) && super.evaluateCondition(context, event);
    }

    @Override
    public void createRequest(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.shouldCreateRequest(debugProcess)) {
            return;
        }
        try {
            RequestManagerImpl requestManager = debugProcess.getRequestsManager();
            if (this.isWatchEntry()) {
                MethodEntryRequest entryRequest = MethodBreakpoint.findRequest(debugProcess, MethodEntryRequest.class, this);
                if (entryRequest == null) {
                    entryRequest = requestManager.createMethodEntryRequest(this);
                } else {
                    entryRequest.disable();
                }
                entryRequest.addClassFilter(this.getClassPattern());
                debugProcess.getRequestsManager().enableRequest(entryRequest);
            }
            if (this.isWatchExit()) {
                MethodExitRequest exitRequest = MethodBreakpoint.findRequest(debugProcess, MethodExitRequest.class, this);
                if (exitRequest == null) {
                    exitRequest = requestManager.createMethodExitRequest(this);
                } else {
                    exitRequest.disable();
                }
                exitRequest.addClassFilter(this.getClassPattern());
                debugProcess.getRequestsManager().enableRequest(exitRequest);
            }
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
    }

    @Override
    public void processClassPrepare(DebugProcess debugProcess, ReferenceType refType) {
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        Location location = event.location();
        String locationQName = DebuggerUtilsEx.getLocationMethodQName(location);
        String locationFileName = "";
        try {
            locationFileName = location.sourceName();
        }
        catch (AbsentInformationException e) {
            locationFileName = "";
        }
        int locationLine = location.lineNumber();
        if (event instanceof MethodEntryEvent) {
            MethodEntryEvent entryEvent = (MethodEntryEvent)event;
            Method method = entryEvent.method();
            return DebuggerBundle.message((String)"status.method.entry.breakpoint.reached", (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
        }
        if (event instanceof MethodExitEvent) {
            MethodExitEvent exitEvent = (MethodExitEvent)event;
            Method method = exitEvent.method();
            return DebuggerBundle.message((String)"status.method.exit.breakpoint.reached", (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
        }
        return "";
    }

    @Override
    public boolean isValid() {
        return this.getClassPattern() != null && this.getMethodName() != null;
    }

    @Override
    public PsiElement getEvaluationElement() {
        return null;
    }

    @Override
    public void readExternal(Element parentNode) throws InvalidDataException {
        super.readExternal(parentNode);
        String className = parentNode.getAttributeValue("class_name");
        this.setClassPattern(className);
        String methodName = parentNode.getAttributeValue("method_name");
        this.setMethodName(methodName);
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"WATCH_ENTRY"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"WATCH_EXIT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (className == null || methodName == null) {
            throw new InvalidDataException();
        }
    }

    public boolean matchesEvent(LocatableEvent event) {
        Method method = event.location().method();
        return method != null && this.getMethodName().equals(method.name());
    }

    public static WildcardMethodBreakpoint create(Project project, String classPattern, String methodName, XBreakpoint<JavaMethodBreakpointProperties> xBreakpoint) {
        return new WildcardMethodBreakpoint(project, classPattern, methodName, xBreakpoint);
    }

    private boolean isWatchEntry() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY;
    }

    private void setWatchEntry(boolean WATCH_ENTRY) {
        ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY = WATCH_ENTRY;
    }

    private boolean isWatchExit() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT;
    }

    private void setWatchExit(boolean WATCH_EXIT) {
        ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT = WATCH_EXIT;
    }

    private String getClassPattern() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myClassPattern;
    }

    private void setClassPattern(String classPattern) {
        ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myClassPattern = classPattern;
    }

    private void setMethodName(String methodName) {
        ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName = methodName;
    }
}

