/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.JavaValueModifier;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class ArgumentValueDescriptorImpl
extends ValueDescriptorImpl {
    private final DecompiledLocalVariable myVariable;

    public ArgumentValueDescriptorImpl(Project project, DecompiledLocalVariable variable, Value value) {
        super(project, value);
        this.myVariable = variable;
        this.setLvalue(true);
    }

    @Override
    public boolean canSetValue() {
        return LocalVariablesUtil.canSetValues();
    }

    @Override
    public boolean isPrimitive() {
        return this.getValue() instanceof PrimitiveValue;
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        return this.getValue();
    }

    public DecompiledLocalVariable getVariable() {
        return this.myVariable;
    }

    @Override
    public String getName() {
        return this.myVariable.getDisplayName();
    }

    public boolean isParameter() {
        return this.myVariable.isParam();
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        try {
            return elementFactory.createExpressionFromText(this.getName(), PositionUtil.getContextElement((StackFrameContext)context));
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.local.variable.name", (Object[])new Object[]{this.getName()}), (Throwable)e);
        }
    }

    @Override
    public XValueModifier getModifier(JavaValue value) {
        return new JavaValueModifier(value){

            @Override
            protected void setValueImpl(@NotNull String expression, @NotNull XValueModifier.XModificationCallback callback) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/debugger/ui/impl/watch/ArgumentValueDescriptorImpl$1", "setValueImpl"));
                }
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/ui/impl/watch/ArgumentValueDescriptorImpl$1", "setValueImpl"));
                }
                final DecompiledLocalVariable local = ArgumentValueDescriptorImpl.this.getVariable();
                if (local != null) {
                    final DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(ArgumentValueDescriptorImpl.this.getProject()).getContext();
                    this.set(expression, callback, debuggerContext, new JavaValueModifier.SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                            LocalVariablesUtil.setValue(debuggerContext.getFrameProxy().getStackFrame(), local.getSlot(), newValue);
                            1.update(debuggerContext);
                        }

                        @Override
                        public ReferenceType loadClass(EvaluationContextImpl evaluationContext, String className) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                            return evaluationContext.getDebugProcess().loadClass(evaluationContext, className, evaluationContext.getClassLoader());
                        }
                    });
                }
            }
        };
    }
}

