/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryContentImpl
extends DiffContentBase
implements DirectoryContent {
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final Project myProject;

    public DirectoryContentImpl(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/contents/DirectoryContentImpl", "<init>"));
        }
        assert (file2.isValid() && file2.isDirectory());
        this.myProject = project;
        this.myFile = file2;
    }

    @Nullable
    public OpenFileDescriptor getOpenFileDescriptor() {
        if (this.myProject == null || this.myProject.isDefault() || !this.myFile.isValid()) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, this.myFile);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/DirectoryContentImpl", "getFile"));
        }
        return virtualFile;
    }

    @Nullable
    public FileType getContentType() {
        return null;
    }
}

