/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.CSVReader;
import com.intellij.execution.process.IProcessList;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessListWin32Internal;
import com.intellij.execution.process.ProcessUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

class ProcessListWin32
implements IProcessList {
    private static final Logger LOG = Logger.getInstance(ProcessListWin32.class);
    private String myHelpersRoot;

    public ProcessListWin32(String helpersRoot) {
        this.myHelpersRoot = helpersRoot;
    }

    @Override
    public ProcessInfo[] getProcessList() {
        try {
            return ProcessListWin32.createFromWMIC();
        }
        catch (Exception exception) {
            Process p;
            try {
                String[] command = new String[]{"tasklist.exe", "/fo", "csv", "/nh", "/v"};
                p = ProcessUtils.createProcess(command, null, null);
            }
            catch (Exception e) {
                return new ProcessListWin32Internal(this.myHelpersRoot).getProcessList();
            }
            try {
                ProcessInfo[] processInfoArray = ProcessListWin32.parseListTasks(p.getInputStream());
                p.destroy();
                return processInfoArray;
            }
            catch (Throwable throwable) {
                try {
                    p.destroy();
                    throw throwable;
                }
                catch (IOException iOException) {
                    return ProcessInfo.EMPTY_ARRAY;
                }
            }
        }
    }

    private static ProcessInfo[] createFromWMIC() throws Exception {
        String[] command = new String[]{"wmic.exe", "path", "win32_process", "get", "Caption,Processid,Commandline"};
        Process p = ProcessUtils.createProcess(command, null, null);
        ArrayList<ProcessInfo> lst = new ArrayList<ProcessInfo>();
        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String line = br.readLine();
            int commandLineI = line.indexOf("CommandLine");
            int processIdI = line.indexOf("ProcessId");
            if (commandLineI == -1) {
                throw new AssertionError((Object)("Could not find CommandLine in: " + line));
            }
            if (processIdI == -1) {
                throw new AssertionError((Object)("Could not find ProcessId in: " + line));
            }
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                String name = line.substring(0, commandLineI).trim();
                String commandLine = line.substring(commandLineI, processIdI).trim();
                String processId = line.substring(processIdI, line.length()).trim();
                lst.add(new ProcessInfo(Integer.parseInt(processId), name + "   " + commandLine));
            }
            if (lst.size() == 0) {
                throw new AssertionError((Object)"Error: no processes found");
            }
            ProcessInfo[] processInfoArray = lst.toArray(new ProcessInfo[lst.size()]);
            return processInfoArray;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            throw e;
        }
        finally {
            br.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProcessInfo[] parseListTasks(InputStream stream) throws IOException {
        ArrayList processList = ContainerUtil.newArrayList();
        CSVReader reader = new CSVReader(new BufferedReader(new InputStreamReader(stream)));
        try {
            String[] next;
            do {
                try {
                    next = reader.readNext();
                    if (next == null) continue;
                    int pid = Integer.parseInt(next[1]);
                    String name = next[0] + " - " + next[next.length - 1];
                    processList.add(new ProcessInfo(pid, name));
                }
                catch (IOException e) {
                    break;
                }
            } while (next != null);
        }
        finally {
            reader.close();
        }
        return processList.isEmpty() ? ProcessInfo.EMPTY_ARRAY : processList.toArray(new ProcessInfo[processList.size()]);
    }
}

