/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.impl;

import com.intellij.execution.process.OSProcessManager;
import com.intellij.execution.process.RunnerWinProcess;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jvnet.winp.WinProcess;
import org.jvnet.winp.WinpException;

public class OSProcessManagerImpl
extends OSProcessManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.process.impl.OSProcessManagerImpl");

    public boolean killProcessTree(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/impl/OSProcessManagerImpl", "killProcessTree"));
        }
        if (SystemInfo.isWindows) {
            try {
                WinProcess winProcess = OSProcessManagerImpl.createWinProcess(process);
                winProcess.killRecursively();
                return true;
            }
            catch (Throwable e) {
                LOG.info("Cannot kill process tree", e);
            }
        } else if (SystemInfo.isUnix) {
            return UnixProcessManager.sendSigKillToProcessTree((Process)process);
        }
        return false;
    }

    public static void killProcess(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/impl/OSProcessManagerImpl", "killProcess"));
        }
        if (SystemInfo.isWindows) {
            try {
                WinProcess winProcess = OSProcessManagerImpl.createWinProcess(process);
                winProcess.kill();
            }
            catch (Throwable e) {
                LOG.info("Cannot kill process", e);
            }
        } else if (SystemInfo.isUnix) {
            UnixProcessManager.sendSignal((int)UnixProcessManager.getProcessPid((Process)process), (int)9);
        }
    }

    public static int getProcessID(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/impl/OSProcessManagerImpl", "getProcessID"));
        }
        if (SystemInfo.isWindows) {
            try {
                return OSProcessManagerImpl.createWinProcess(process).getPid();
            }
            catch (Throwable e) {
                LOG.info("Cannot get process id", e);
                return -1;
            }
        }
        if (SystemInfo.isUnix) {
            return UnixProcessManager.getProcessPid((Process)process);
        }
        throw new IllegalStateException("Unknown OS: " + SystemInfo.OS_NAME);
    }

    @NotNull
    private static WinProcess createWinProcess(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/impl/OSProcessManagerImpl", "createWinProcess"));
        }
        if (process instanceof RunnerWinProcess) {
            process = ((RunnerWinProcess)process).getOriginalProcess();
        }
        WinProcess winProcess = new WinProcess(process);
        if (winProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/impl/OSProcessManagerImpl", "createWinProcess"));
        }
        return winProcess;
    }

    public List<String> getCommandLinesOfRunningProcesses() {
        try {
            if (SystemInfo.isWindows) {
                ArrayList<String> commandLines = new ArrayList<String>();
                for (WinProcess process : WinProcess.all()) {
                    try {
                        commandLines.add(process.getCommandLine());
                    }
                    catch (WinpException winpException) {}
                }
                return commandLines;
            }
            Object[] cmd = UnixProcessManager.getPSCmd((boolean)true);
            Process process = Runtime.getRuntime().exec((String[])cmd);
            List<String> outputLines = OSProcessManagerImpl.readLines(process.getInputStream(), false);
            List<String> errorLines = OSProcessManagerImpl.readLines(process.getErrorStream(), false);
            if (!errorLines.isEmpty()) {
                throw new IOException(Arrays.toString(cmd) + " failed: " + StringUtil.join(errorLines, (String)"\n"));
            }
            return outputLines.subList(1, outputLines.size());
        }
        catch (Throwable e) {
            LOG.info("Cannot collect command lines");
            LOG.info(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readLines(@NotNull InputStream inputStream, boolean includeEmpty) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/execution/process/impl/OSProcessManagerImpl", "readLines"));
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                if (!includeEmpty && line.isEmpty()) continue;
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }
}

