/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.ProjectGroup;
import com.intellij.ide.ProjectGroupActionGroup;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.wm.impl.SystemDock;
import com.intellij.util.IconUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RecentProjectsManagerBase
extends RecentProjectsManager
implements PersistentStateComponent<State> {
    private static final int MAX_PROJECTS_IN_MAIN_MENU = 6;
    private static final Map<String, MyIcon> ourProjectIcons = new HashMap<String, MyIcon>();
    private static Icon ourSmallAppIcon;
    private final Object myStateLock;
    private State myState;
    private final Map<String, String> myNameCache;

    public static RecentProjectsManagerBase getInstanceEx() {
        return (RecentProjectsManagerBase)RecentProjectsManager.getInstance();
    }

    protected RecentProjectsManagerBase(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/ide/RecentProjectsManagerBase", "<init>"));
        }
        this.myStateLock = new Object();
        this.myState = new State();
        this.myNameCache = Collections.synchronizedMap(new THashMap());
        MessageBusConnection connection = messageBus.connect();
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new MyAppLifecycleListener());
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            connection.subscribe(ProjectManager.TOPIC, (Object)new MyProjectListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.validateRecentProjects();
            return this.myState;
        }
    }

    public void loadState(State state) {
        File lastFile;
        this.removeDuplicates(state);
        if (state.lastPath != null && !new File(state.lastPath).exists()) {
            state.lastPath = null;
        }
        if (state.lastPath != null && (lastFile = new File(state.lastPath)).isDirectory() && !new File(lastFile, ".idea").exists()) {
            state.lastPath = null;
        }
        this.myState = state;
    }

    protected void removeDuplicates(State state) {
        for (String path : new ArrayList<String>(state.recentPaths)) {
            if (!path.endsWith(File.separator)) continue;
            state.recentPaths.remove(path);
            state.additionalInfo.remove(path);
            state.openPaths.remove(path);
        }
    }

    private static void removePathFrom(List<String> items, String path) {
        Iterator<String> iterator = items.iterator();
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (!(SystemInfo.isFileSystemCaseSensitive ? path.equals(next) : path.equalsIgnoreCase(next))) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePath(@Nullable String path) {
        if (path == null) {
            return;
        }
        Object object = this.myStateLock;
        synchronized (object) {
            RecentProjectsManagerBase.removePathFrom(this.myState.recentPaths, path);
            this.myState.names.remove(path);
            for (ProjectGroup group : this.myState.groups) {
                group.removeProject(path);
            }
        }
    }

    @Nullable
    public String getLastProjectCreationLocation() {
        return this.myState.lastProjectLocation;
    }

    public void setLastProjectCreationLocation(@Nullable String lastProjectLocation) {
        this.myState.lastProjectLocation = StringUtil.nullize((String)lastProjectLocation, (boolean)true);
    }

    public String getLastProjectPath() {
        return this.myState.lastPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastProjectPath() {
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.openPaths.clear();
            if (openProjects.length == 0) {
                this.myState.lastPath = null;
            } else {
                this.myState.lastPath = this.getProjectPath(openProjects[openProjects.length - 1]);
                for (Project openProject : openProjects) {
                    String path = this.getProjectPath(openProject);
                    if (path == null) continue;
                    this.myState.openPaths.add(path);
                    this.myState.names.put(path, this.getProjectDisplayName(openProject));
                }
            }
        }
    }

    @NotNull
    protected String getProjectDisplayName(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/RecentProjectsManagerBase", "getProjectDisplayName"));
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/RecentProjectsManagerBase", "getProjectDisplayName"));
        }
        return "";
    }

    @Nullable
    public static Icon getProjectIcon(String path, boolean isDark) {
        File file2;
        File file3 = file2 = isDark ? new File(path + "/.idea/icon_dark.png") : new File(path + "/.idea/icon.png");
        if (file2.exists()) {
            long timestamp = file2.lastModified();
            MyIcon icon = ourProjectIcons.get(path);
            if (icon != null && icon.getTimestamp() == timestamp) {
                return icon.getIcon();
            }
            try {
                Icon ico = RecentProjectsManagerBase.createIcon(file2);
                icon = new MyIcon(ico, timestamp);
                ourProjectIcons.put(path, icon);
                return icon.getIcon();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @NotNull
    public static Icon createIcon(File file2) {
        BufferedImage image = RecentProjectsManagerBase.loadAndScaleImage(file2);
        Icon icon = RecentProjectsManagerBase.toRetinaAwareIcon(image);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/RecentProjectsManagerBase", "createIcon"));
        }
        return icon;
    }

    @NotNull
    protected static Icon toRetinaAwareIcon(final BufferedImage image) {
        Icon icon = new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (UIUtil.isRetina()) {
                    Graphics2D newG = (Graphics2D)g.create(x, y, image.getWidth(), image.getHeight());
                    newG.scale(0.5, 0.5);
                    newG.drawImage((Image)image, x / 2, y / 2, null);
                    newG.scale(1.0, 1.0);
                    newG.dispose();
                } else {
                    g.drawImage(image, x, y, null);
                }
            }

            @Override
            public int getIconWidth() {
                return UIUtil.isRetina() ? image.getWidth() / 2 : image.getWidth();
            }

            @Override
            public int getIconHeight() {
                return UIUtil.isRetina() ? image.getHeight() / 2 : image.getHeight();
            }
        };
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/RecentProjectsManagerBase", "toRetinaAwareIcon"));
        }
        return icon;
    }

    private static BufferedImage loadAndScaleImage(File file2) {
        try {
            Image img = ImageLoader.loadFromUrl((URL)file2.toURL());
            return Scalr.resize((BufferedImage)ImageUtil.toBufferedImage((Image)img), (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)(UIUtil.isRetina() ? 32 : JBUI.scale((int)16)), (BufferedImageOp[])new BufferedImageOp[0]);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static Icon getProjectOrAppIcon(String path) {
        Icon icon = RecentProjectsManagerBase.getProjectIcon(path, UIUtil.isUnderDarcula());
        if (icon != null) {
            return icon;
        }
        if (UIUtil.isUnderDarcula() && (icon = RecentProjectsManagerBase.getProjectIcon(path, false)) != null) {
            return icon;
        }
        return RecentProjectsManagerBase.getSmallApplicationIcon();
    }

    protected static Icon getSmallApplicationIcon() {
        if (ourSmallAppIcon == null) {
            try {
                Icon appIcon = IconLoader.findIcon((String)ApplicationInfoEx.getInstanceEx().getIconUrl());
                if (appIcon != null) {
                    if (appIcon.getIconWidth() == JBUI.scale((int)16) && appIcon.getIconHeight() == JBUI.scale((int)16)) {
                        ourSmallAppIcon = appIcon;
                    } else {
                        BufferedImage image = ImageUtil.toBufferedImage((Image)IconUtil.toImage((Icon)appIcon));
                        image = Scalr.resize((BufferedImage)image, (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)(UIUtil.isRetina() ? 32 : JBUI.scale((int)16)), (BufferedImageOp[])new BufferedImageOp[0]);
                        ourSmallAppIcon = RecentProjectsManagerBase.toRetinaAwareIcon(image);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ourSmallAppIcon == null) {
                ourSmallAppIcon = EmptyIcon.ICON_16;
            }
        }
        return ourSmallAppIcon;
    }

    private Set<String> getDuplicateProjectNames(Set<String> openedPaths, Set<String> recentPaths) {
        HashSet names = ContainerUtil.newHashSet();
        HashSet duplicates = ContainerUtil.newHashSet();
        for (String path : ContainerUtil.concat((Iterable[])new Iterable[]{openedPaths, recentPaths})) {
            if (names.add(this.getProjectName(path))) continue;
            duplicates.add(path);
        }
        return duplicates;
    }

    public AnAction[] getRecentProjectsActions(boolean forMainMenu) {
        return this.getRecentProjectsActions(forMainMenu, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnAction[] getRecentProjectsActions(boolean forMainMenu, boolean useGroups) {
        LinkedHashSet paths;
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.validateRecentProjects();
            paths = ContainerUtil.newLinkedHashSet(this.myState.recentPaths);
        }
        THashSet openedPaths = new THashSet();
        for (Project openProject : ProjectManager.getInstance().getOpenProjects()) {
            ContainerUtil.addIfNotNull((Collection)openedPaths, (Object)this.getProjectPath(openProject));
        }
        paths.remove(null);
        paths.removeAll((Collection<?>)openedPaths);
        SmartList actions = new SmartList();
        Set<String> duplicates = this.getDuplicateProjectNames((Set<String>)openedPaths, paths);
        if (useGroups) {
            ArrayList<ProjectGroup> groups = new ArrayList<ProjectGroup>(new ArrayList<ProjectGroup>(this.myState.groups));
            final ArrayList projectPaths = new ArrayList(paths);
            Collections.sort(groups, new Comparator<ProjectGroup>(){

                @Override
                public int compare(ProjectGroup o1, ProjectGroup o2) {
                    int ind2;
                    int ind1 = this.getGroupIndex(o1);
                    return ind1 == (ind2 = this.getGroupIndex(o2)) ? StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName()) : ind1 - ind2;
                }

                private int getGroupIndex(ProjectGroup group) {
                    int index = -1;
                    for (String path : group.getProjects()) {
                        int i = projectPaths.indexOf(path);
                        if (index < 0 || index <= i) continue;
                        index = i;
                    }
                    return index;
                }
            });
            for (ProjectGroup group : groups) {
                paths.removeAll(group.getProjects());
            }
            for (ProjectGroup group : groups) {
                ArrayList<AnAction> children2 = new ArrayList<AnAction>();
                for (String path : group.getProjects()) {
                    AnAction action = this.createOpenAction(path, duplicates);
                    if (action == null) continue;
                    children2.add(action);
                    if (!forMainMenu || children2.size() < 6) continue;
                    break;
                }
                actions.add(new ProjectGroupActionGroup(group, children2));
                if (!group.isExpanded()) continue;
                for (AnAction child : children2) {
                    actions.add(child);
                }
            }
        }
        for (String path : paths) {
            AnAction action = this.createOpenAction(path, duplicates);
            if (action == null) continue;
            actions.add(action);
        }
        if (actions.isEmpty()) {
            return AnAction.EMPTY_ARRAY;
        }
        return actions.toArray(new AnAction[actions.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnAction createOpenAction(String path, Set<String> duplicates) {
        String displayName;
        String projectName = this.getProjectName(path);
        Object object = this.myStateLock;
        synchronized (object) {
            displayName = this.myState.names.get(path);
        }
        if (StringUtil.isEmptyOrSpaces((String)displayName)) {
            String string = displayName = duplicates.contains(path) ? path : projectName;
        }
        if (new File(path).exists()) {
            return new ReopenProjectAction(path, projectName, displayName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markPathRecent(String path) {
        Object object = this.myStateLock;
        synchronized (object) {
            if (path.endsWith(File.separator)) {
                path = path.substring(0, path.length() - File.separator.length());
            }
            this.myState.lastPath = path;
            ProjectGroup group = this.getProjectGroup(path);
            this.removePath(path);
            this.myState.recentPaths.add(0, path);
            if (group != null) {
                List projects = group.getProjects();
                projects.add(0, path);
                group.save(projects);
            }
            this.myState.additionalInfo.remove(path);
            this.myState.additionalInfo.put(path, RecentProjectMetaInfo.create());
        }
    }

    @Nullable
    private ProjectGroup getProjectGroup(String path) {
        if (path == null) {
            return null;
        }
        for (ProjectGroup group : this.myState.groups) {
            if (!group.getProjects().contains(path)) continue;
            return group;
        }
        return null;
    }

    @Nullable
    protected abstract String getProjectPath(@NotNull Project var1);

    protected abstract void doOpenProject(@NotNull String var1, @Nullable Project var2, boolean var3);

    public static boolean isValidProjectPath(String projectPath) {
        File file2 = new File(projectPath);
        return file2.exists() && (!file2.isDirectory() || new File(file2, ".idea").exists());
    }

    @NotNull
    private String getProjectName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/RecentProjectsManagerBase", "getProjectName"));
        }
        String cached = this.myNameCache.get(path);
        if (cached != null) {
            String string = cached;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/RecentProjectsManagerBase", "getProjectName"));
            }
            return string;
        }
        String result2 = RecentProjectsManagerBase.readProjectName(path);
        this.myNameCache.put(path, result2);
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/RecentProjectsManagerBase", "getProjectName"));
        }
        return string;
    }

    public void clearNameCache() {
        this.myNameCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readProjectName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/RecentProjectsManagerBase", "readProjectName"));
        }
        File file2 = new File(path);
        if (!file2.isDirectory()) return FileUtilRt.getNameWithoutExtension((String)file2.getName());
        File nameFile = new File(new File(path, ".idea"), ".name");
        if (!nameFile.exists()) return file2.getName();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(nameFile), CharsetToolkit.UTF8_CHARSET));
            try {
                String name = in.readLine();
                if (StringUtil.isEmpty((String)name)) return file2.getName();
                String string = name.trim();
                return string;
            }
            finally {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file2.getName();
    }

    protected boolean willReopenProjectOnStart() {
        return GeneralSettings.getInstance().isReopenLastProject() && this.getLastProjectPath() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReopenLastProject() {
        GeneralSettings generalSettings = GeneralSettings.getInstance();
        if (generalSettings.isReopenLastProject()) {
            Set openPaths;
            boolean forceNewFrame = true;
            Iterator iterator = this.myStateLock;
            synchronized (iterator) {
                openPaths = ContainerUtil.newLinkedHashSet(this.myState.openPaths);
                if (openPaths.isEmpty()) {
                    openPaths = ContainerUtil.createMaybeSingletonSet((Object)this.myState.lastPath);
                    forceNewFrame = false;
                }
            }
            for (String openPath : openPaths) {
                if (!RecentProjectsManagerBase.isValidProjectPath(openPath)) continue;
                this.doOpenProject(openPath, null, forceNewFrame);
            }
        }
    }

    public List<ProjectGroup> getGroups() {
        return Collections.unmodifiableList(this.myState.groups);
    }

    public void addGroup(ProjectGroup group) {
        if (!this.myState.groups.contains(group)) {
            this.myState.groups.add(group);
        }
    }

    public void removeGroup(ProjectGroup group) {
        this.myState.groups.remove(group);
    }

    public static class RecentProjectMetaInfo {
        public String build;
        public String productionCode;
        public boolean eap;
        public String binFolder;
        public long projectOpenTimestamp;
        public long buildTimestamp;

        public static RecentProjectMetaInfo create() {
            RecentProjectMetaInfo info = new RecentProjectMetaInfo();
            info.build = ApplicationInfoEx.getInstanceEx().getBuild().asString();
            info.productionCode = ApplicationInfoEx.getInstanceEx().getBuild().getProductCode();
            info.eap = ApplicationInfoEx.getInstanceEx().isEAP();
            info.binFolder = PathManager.getBinPath();
            info.projectOpenTimestamp = System.currentTimeMillis();
            info.buildTimestamp = ApplicationInfoEx.getInstanceEx().getBuildDate().getTimeInMillis();
            return info;
        }
    }

    private static class MyIcon
    extends Pair<Icon, Long> {
        public MyIcon(Icon icon, Long timestamp) {
            super((Object)icon, (Object)timestamp);
        }

        public Icon getIcon() {
            return (Icon)this.first;
        }

        public long getTimestamp() {
            return (Long)this.second;
        }
    }

    private class MyAppLifecycleListener
    extends AppLifecycleListener.Adapter {
        private MyAppLifecycleListener() {
        }

        @Override
        public void appFrameCreated(String[] commandLineArgs, @NotNull Ref<Boolean> willOpenProject) {
            if (willOpenProject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "willOpenProject", "com/intellij/ide/RecentProjectsManagerBase$MyAppLifecycleListener", "appFrameCreated"));
            }
            if (RecentProjectsManagerBase.this.willReopenProjectOnStart()) {
                willOpenProject.set((Object)Boolean.TRUE);
            }
        }

        @Override
        public void appStarting(Project projectFromCommandLine) {
            if (projectFromCommandLine != null) {
                return;
            }
            RecentProjectsManagerBase.this.doReopenLastProject();
        }

        @Override
        public void projectFrameClosed() {
            RecentProjectsManagerBase.this.updateLastProjectPath();
        }

        @Override
        public void projectOpenFailed() {
            RecentProjectsManagerBase.this.updateLastProjectPath();
        }

        @Override
        public void appClosing() {
            RecentProjectsManagerBase.this.updateLastProjectPath();
        }
    }

    private class MyProjectListener
    extends ProjectManagerAdapter {
        private MyProjectListener() {
        }

        public void projectOpened(Project project) {
            String path = RecentProjectsManagerBase.this.getProjectPath(project);
            if (path != null) {
                RecentProjectsManagerBase.this.markPathRecent(path);
            }
            SystemDock.updateMenu();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void projectClosing(Project project) {
            Object object = RecentProjectsManagerBase.this.myStateLock;
            synchronized (object) {
                ((RecentProjectsManagerBase)RecentProjectsManagerBase.this).myState.names.put(RecentProjectsManagerBase.this.getProjectPath(project), RecentProjectsManagerBase.this.getProjectDisplayName(project));
            }
        }

        public void projectClosed(Project project) {
            String path;
            Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
            if (openProjects.length > 0 && (path = RecentProjectsManagerBase.this.getProjectPath(openProjects[openProjects.length - 1])) != null) {
                RecentProjectsManagerBase.this.markPathRecent(path);
            }
            SystemDock.updateMenu();
        }
    }

    public static class State {
        public List<String> recentPaths = new SmartList();
        public List<String> openPaths = new SmartList();
        public Map<String, String> names = ContainerUtil.newLinkedHashMap();
        public List<ProjectGroup> groups = new SmartList();
        public String lastPath;
        public Map<String, RecentProjectMetaInfo> additionalInfo = ContainerUtil.newLinkedHashMap();
        public String lastProjectLocation;

        void validateRecentProjects() {
            while (this.recentPaths.remove(null)) {
            }
            Collection<String> displayNames = this.names.values();
            while (displayNames.remove("")) {
            }
            while (this.recentPaths.size() > Registry.intValue((String)"ide.max.recent.projects")) {
                int index = this.recentPaths.size() - 1;
                this.names.remove(this.recentPaths.get(index));
                this.recentPaths.remove(index);
            }
        }
    }
}

