/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.registry.Registry;
import org.jetbrains.annotations.NotNull;

public class ShowStructureSettingsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        ShowStructureSettingsAction.showDialog(project);
    }

    static void showDialog(Project project) {
        if (Registry.is((String)"ide.new.project.settings")) {
            new SingleConfigurableEditor(project, (Configurable)ProjectStructureConfigurable.getInstance(project), "SettingsEditor"){

                @NotNull
                protected DialogWrapper.DialogStyle getStyle() {
                    DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
                    if (dialogStyle == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowStructureSettingsAction$1", "getStyle"));
                    }
                    return dialogStyle;
                }
            }.show();
        } else {
            ShowSettingsUtil.getInstance().editConfigurable(project, "SettingsEditor", (Configurable)ProjectStructureConfigurable.getInstance(project));
        }
    }
}

