/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectViewNodeWithChildrenList<T>
extends ProjectViewNode<T> {
    protected final List<AbstractTreeNode> myChildren = new ArrayList<AbstractTreeNode>();

    protected ProjectViewNodeWithChildrenList(Project project, T t, ViewSettings viewSettings) {
        super(project, t, viewSettings);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        List<AbstractTreeNode> list = this.myChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/ProjectViewNodeWithChildrenList", "getChildren"));
        }
        return list;
    }

    public void addChild(AbstractTreeNode node) {
        this.myChildren.add(node);
        node.setParent((AbstractTreeNode)this);
    }

    public void addChildBefore(AbstractTreeNode newNode, AbstractTreeNode existingNode) {
        int idx = -1;
        for (int i = 0; i < this.myChildren.size(); ++i) {
            AbstractTreeNode node = this.myChildren.get(i);
            if (node != existingNode) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            this.addChild(newNode);
        } else {
            this.myChildren.add(idx, newNode);
        }
    }
}

