/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MarkExcludeRootAction
extends MarkRootActionBase {
    @Override
    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (Registry.is((String)"ide.hide.excluded.files")) {
            String message = files.length == 1 ? FileUtil.toSystemDependentName((String)files[0].getPath()) : files.length + " selected files";
            int rc = Messages.showOkCancelDialog((Project)((Project)e.getData(CommonDataKeys.PROJECT)), (String)this.getPromptText(message), (String)"Mark as Excluded", (Icon)Messages.getQuestionIcon());
            if (rc != 0) {
                return;
            }
        }
        super.actionPerformed(e);
    }

    protected String getPromptText(String message) {
        return "Are you sure you would like to exclude " + message + " from the project?\nYou can restore excluded directories later using the Project Structure dialog.";
    }

    @Override
    protected void modifyRoots(@NotNull VirtualFile vFile, @NotNull ContentEntry entry) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/ide/projectView/actions/MarkExcludeRootAction", "modifyRoots"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/ide/projectView/actions/MarkExcludeRootAction", "modifyRoots"));
        }
        entry.addExcludeFolder(vFile);
    }

    @Override
    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/ide/projectView/actions/MarkExcludeRootAction", "isEnabled"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ide/projectView/actions/MarkExcludeRootAction", "isEnabled"));
        }
        return true;
    }
}

