/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources;

import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.util.CommonSourceRootDetectionUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.NullableFunction;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JavaSourceRootDetector
extends ProjectStructureDetector {
    @Override
    @NotNull
    public ProjectStructureDetector.DirectoryProcessingResult detectRoots(@NotNull File dir, @NotNull File[] children2, @NotNull File base, @NotNull List<DetectedProjectRoot> result2) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/ide/util/projectWizard/importSources/JavaSourceRootDetector", "detectRoots"));
        }
        if (children2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/ide/util/projectWizard/importSources/JavaSourceRootDetector", "detectRoots"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/util/projectWizard/importSources/JavaSourceRootDetector", "detectRoots"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/util/projectWizard/importSources/JavaSourceRootDetector", "detectRoots"));
        }
        String fileExtension = this.getFileExtension();
        for (File child : children2) {
            if (!child.isFile() || !FileUtilRt.extensionEquals((String)child.getName(), (String)fileExtension)) continue;
            Pair<File, String> root = CommonSourceRootDetectionUtil.IO_FILE.suggestRootForFileWithPackageStatement(child, base, this.getPackageNameFetcher(), true);
            if (root != null) {
                JavaModuleSourceRoot sourceRoot = new JavaModuleSourceRoot((File)root.getFirst(), (String)root.getSecond(), this.getLanguageName());
                result2.add(sourceRoot);
                if (JavaSourceRootDetector.areLastRootsTheSame(result2, sourceRoot, 20)) {
                    ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.skipChildrenAndParentsUpTo((File)root.getFirst());
                    if (directoryProcessingResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/importSources/JavaSourceRootDetector", "detectRoots"));
                    }
                    return directoryProcessingResult;
                }
            }
            ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
            if (directoryProcessingResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/importSources/JavaSourceRootDetector", "detectRoots"));
            }
            return directoryProcessingResult;
        }
        ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
        if (directoryProcessingResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/importSources/JavaSourceRootDetector", "detectRoots"));
        }
        return directoryProcessingResult;
    }

    private static boolean areLastRootsTheSame(List<DetectedProjectRoot> result2, JavaModuleSourceRoot root, int threshold) {
        if (result2.size() < threshold) {
            return false;
        }
        List<DetectedProjectRoot> lastItems = result2.subList(result2.size() - threshold, result2.size());
        for (DetectedProjectRoot item : lastItems) {
            if (!(item instanceof JavaModuleSourceRoot)) {
                return false;
            }
            JavaModuleSourceRoot oldRoot = (JavaModuleSourceRoot)item;
            if (FileUtil.filesEqual((File)oldRoot.getDirectory(), (File)root.getDirectory()) && oldRoot.getPackagePrefix().equals(root.getPackagePrefix()) && oldRoot.getRootTypeName().equals(root.getRootTypeName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDetectorId() {
        return "Java";
    }

    @NotNull
    protected abstract String getLanguageName();

    @NotNull
    protected abstract String getFileExtension();

    @NotNull
    protected abstract NullableFunction<CharSequence, String> getPackageNameFetcher();
}

