/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.ApplicationInfoProvider;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.DebugUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class IdeaLogger
extends Log4jBasedLogger {
    private static ApplicationInfoProvider ourApplicationInfoProvider = IdeaLogger.getIdeaInfoProvider();
    public static String ourLastActionId = "";
    public static Exception ourErrorsOccurred;
    private static String ourCompilationTimestamp;
    @NonNls
    private static final String COMPILATION_TIMESTAMP_RESOURCE_NAME = "/.compilation-timestamp";

    public static String getOurCompilationTimestamp() {
        return ourCompilationTimestamp;
    }

    IdeaLogger(Logger logger) {
        super(logger);
    }

    public void error(Object message) {
        if (message instanceof IdeaLoggingEvent) {
            this.myLogger.error(message);
        } else {
            super.error(message);
        }
    }

    public void error(@NonNls String message, Attachment ... attachments) {
        this.myLogger.error((Object)LogMessageEx.createEvent(message, DebugUtil.currentStackTrace(), attachments));
    }

    public void error(String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/idea/IdeaLogger", "error"));
        }
        if (t instanceof ControlFlowException) {
            this.myLogger.error((Object)message, new Throwable("Control-flow exceptions should never be logged", t));
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        String detailString = StringUtil.join((String[])details, (String)"\n");
        if (ourErrorsOccurred == null) {
            String s = message != null && !message.isEmpty() ? "Error message is '" + message + "'" : "";
            String mess = "Logger errors occurred. See IDEA logs for details. " + s;
            ourErrorsOccurred = new Exception(mess + (!detailString.isEmpty() ? "\nDetails: " + detailString : ""), t);
        }
        this.myLogger.error((Object)(message + (!detailString.isEmpty() ? "\nDetails: " + detailString : "")), t);
        this.logErrorHeader();
    }

    private void logErrorHeader() {
        String info = ourApplicationInfoProvider.getInfo();
        if (info != null) {
            this.myLogger.error((Object)info);
        }
        if (ourCompilationTimestamp != null) {
            this.myLogger.error((Object)("Internal version. Compiled " + ourCompilationTimestamp));
        }
        this.myLogger.error((Object)("JDK: " + System.getProperties().getProperty("java.version", "unknown")));
        this.myLogger.error((Object)("VM: " + System.getProperties().getProperty("java.vm.name", "unknown")));
        this.myLogger.error((Object)("Vendor: " + System.getProperties().getProperty("java.vendor", "unknown")));
        this.myLogger.error((Object)("OS: " + System.getProperties().getProperty("os.name", "unknown")));
        ApplicationImpl application = (ApplicationImpl)ApplicationManager.getApplication();
        if (application != null && application.isComponentsCreated() && !application.isDisposed()) {
            String currentCommandName;
            CommandProcessor commandProcessor;
            String lastPreformedActionId = ourLastActionId;
            if (lastPreformedActionId != null) {
                this.myLogger.error((Object)("Last Action: " + lastPreformedActionId));
            }
            if ((commandProcessor = CommandProcessor.getInstance()) != null && (currentCommandName = commandProcessor.getCurrentCommandName()) != null) {
                this.myLogger.error((Object)("Current Command: " + currentCommandName));
            }
        }
    }

    public static void setApplicationInfoProvider(ApplicationInfoProvider aProvider) {
        ourApplicationInfoProvider = aProvider;
    }

    private static ApplicationInfoProvider getIdeaInfoProvider() {
        return new ApplicationInfoProvider(){

            public String getInfo() {
                ApplicationInfoEx info = ApplicationInfoImpl.getShadowInstance();
                return info.getFullApplicationName() + "  " + "Build #" + info.getBuild().asStringWithAllDetails();
            }
        };
    }

    static {
        InputStream stream = com.intellij.openapi.diagnostic.Logger.class.getResourceAsStream(COMPILATION_TIMESTAMP_RESOURCE_NAME);
        if (stream != null) {
            try {
                LineNumberReader reader = new LineNumberReader(new InputStreamReader(stream));
                try {
                    String s = reader.readLine();
                    if (s != null) {
                        ourCompilationTimestamp = s.trim();
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

