/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.moduleDependencies;

import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.moduleDependencies.DependenciesAnalyzeManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.NavigatableWithText;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesDependenciesPanel
extends JPanel
implements Disposable {
    private static final String HELP_ID = "module.dependencies.tool.window";
    private static final Comparator<DefaultMutableTreeNode> NODE_COMPARATOR = new Comparator<DefaultMutableTreeNode>(){

        @Override
        public int compare(DefaultMutableTreeNode o1, DefaultMutableTreeNode o2) {
            if (!(o1.getUserObject() instanceof MyUserObject)) {
                return 1;
            }
            if (!(o2.getUserObject() instanceof MyUserObject)) {
                return -1;
            }
            return o1.getUserObject().toString().compareToIgnoreCase(o2.getUserObject().toString());
        }
    };
    private static final ColoredTreeCellRenderer NODE_RENDERER = new ColoredTreeCellRenderer(){

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/moduleDependencies/ModulesDependenciesPanel$2", "customizeCellRenderer"));
            }
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof MyUserObject) {
                MyUserObject node = (MyUserObject)userObject;
                this.setIcon(ModuleType.get((Module)node.myModule).getIcon());
                this.append(node.myModule.getName(), node.myInCycle ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else if (userObject != null) {
                this.append(userObject.toString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        }
    };
    private final Project myProject;
    private final Module[] myModules;
    private final DependenciesAnalyzeManager.State myState;
    private final Tree myLeftTree;
    private final Tree myRightTree;
    private final Splitter mySplitter;
    private final JTextComponent myPathField;
    private Content myContent;
    private Graph<Module> myModuleGraph;
    private final Map<Module, Boolean> myCycleMap;

    public ModulesDependenciesPanel(@NotNull Project project, @Nullable Module[] modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/moduleDependencies/ModulesDependenciesPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myCycleMap = ContainerUtil.newHashMap();
        this.myProject = project;
        this.myModules = modules != null ? modules : ModuleManager.getInstance((Project)project).getModules();
        this.myState = DependenciesAnalyzeManager.getInstance(project).getState();
        this.updateModuleGraph();
        this.myLeftTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode("Root")));
        this.installLeftTreeListeners();
        ModulesDependenciesPanel.installTreeActions(this.myLeftTree, false);
        this.myRightTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode("Root")));
        ModulesDependenciesPanel.installTreeActions(this.myRightTree, true);
        this.mySplitter = new Splitter();
        this.mySplitter.setFirstComponent((JComponent)new MyTreePanel(this.myLeftTree, this.myProject));
        this.mySplitter.setSecondComponent((JComponent)new MyTreePanel(this.myRightTree, this.myProject));
        this.add((Component)this.mySplitter, "Center");
        this.myPathField = new JTextField();
        this.myPathField.setEditable(false);
        this.add((Component)this.createNorthPanel(), "North");
        project.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                ModulesDependenciesPanel.this.updateModuleGraph();
                ModulesDependenciesPanel.this.updateSplitterProportion();
                ModulesDependenciesPanel.this.updateLeftTree();
            }
        });
        this.updateSplitterProportion();
        this.updateLeftTree();
    }

    private void updateModuleGraph() {
        this.myModuleGraph = ModuleManager.getInstance((Project)this.myProject).moduleGraph(this.myState.includeTests);
        this.myCycleMap.clear();
    }

    private Iterable<Module> getModuleDependencies(Module module) {
        final Iterator iterator = this.myState.forwardDirection ? this.myModuleGraph.getIn((Object)module) : this.myModuleGraph.getOut((Object)module);
        return new Iterable<Module>(){

            @Override
            public Iterator<Module> iterator() {
                return iterator;
            }
        };
    }

    private boolean isInCycle(Module module) {
        Boolean inCycle = this.myCycleMap.get(module);
        if (inCycle == null) {
            Set cycles = GraphAlgorithms.getInstance().findCycles(this.myModuleGraph, (Object)module);
            inCycle = !cycles.isEmpty();
            this.myCycleMap.put(module, inCycle);
            for (List cycle : cycles) {
                for (Module moduleInCycle : cycle) {
                    this.myCycleMap.put(moduleInCycle, true);
                }
            }
        }
        return inCycle;
    }

    private void installLeftTreeListeners() {
        this.myLeftTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                DefaultMutableTreeNode expandedNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                for (int i = 0; i < expandedNode.getChildCount(); ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)expandedNode.getChildAt(i);
                    if (child.getChildCount() != 0 || this.isLooped(event.getPath(), child)) continue;
                    Module module = ((MyUserObject)child.getUserObject()).myModule;
                    for (Module dependency : ModulesDependenciesPanel.this.getModuleDependencies(module)) {
                        child.add(new DefaultMutableTreeNode(new MyUserObject(ModulesDependenciesPanel.this.isInCycle(dependency), dependency)));
                    }
                    TreeUtil.sort((DefaultMutableTreeNode)child, (Comparator)NODE_COMPARATOR);
                }
            }

            private boolean isLooped(TreePath path, DefaultMutableTreeNode child) {
                for (Object o : path.getPath()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
                    if (node == child || !Comparing.equal((Object)node.getUserObject(), (Object)child.getUserObject())) continue;
                    return true;
                }
                return false;
            }
        });
        this.myLeftTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath selectionPath = ModulesDependenciesPanel.this.myLeftTree.getSelectionPath();
                if (selectionPath != null) {
                    ModulesDependenciesPanel.this.myPathField.setText(StringUtil.join((Object[])selectionPath.getPath(), (Function)new Function<Object, String>(){

                        public String fun(Object o) {
                            Object userObject = ((DefaultMutableTreeNode)o).getUserObject();
                            return userObject instanceof MyUserObject ? ((MyUserObject)userObject).myModule.getName() : "";
                        }
                    }, (String)" : "));
                    DefaultMutableTreeNode selection = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                    if (selection != null) {
                        ModulesDependenciesPanel.this.updateRightTree(((MyUserObject)selection.getUserObject()).myModule);
                    }
                }
            }
        });
    }

    private static void installTreeActions(Tree tree, boolean enableExpandAll) {
        tree.getSelectionModel().setSelectionMode(1);
        tree.setCellRenderer((TreeCellRenderer)NODE_RENDERER);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)tree);
        TreeUtil.installActions((JTree)tree);
        new TreeSpeedSearch(tree, new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                return o.getLastPathComponent().toString();
            }
        }, true);
        DefaultActionGroup group = new DefaultActionGroup();
        CommonActionsManager commonActionManager = CommonActionsManager.getInstance();
        ActionManager globalActionManager = ActionManager.getInstance();
        MyTreeExpander treeExpander = new MyTreeExpander(tree, enableExpandAll);
        group.add(commonActionManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)tree));
        group.add(commonActionManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)tree));
        group.add(globalActionManager.getAction("EditSource"));
        group.add((AnAction)Separator.getInstance());
        group.add(globalActionManager.getAction("ShowPackageDeps"));
        group.add(globalActionManager.getAction("ShowBackwardPackageDeps"));
        group.add(globalActionManager.getAction("ShowPackageCycles"));
        group.add(globalActionManager.getAction("ShowModulesDependencies"));
        PopupHandler.installUnknownPopupHandler((JComponent)tree, (ActionGroup)group, (ActionManager)ActionManager.getInstance());
    }

    private void updateSplitterProportion() {
        DFSTBuilder builder = new DFSTBuilder(this.myModuleGraph);
        this.mySplitter.setProportion(builder.isAcyclic() ? 1.0f : 0.6f);
    }

    private JComponent createNorthPanel() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(new AnAction(CommonBundle.message((String)"action.close", (Object[])new Object[0]), null, AllIcons.Actions.Cancel){

            public void actionPerformed(AnActionEvent e) {
                DependenciesAnalyzeManager.getInstance(ModulesDependenciesPanel.this.myProject).closeContent(ModulesDependenciesPanel.this.myContent);
            }
        });
        final AnAction analyzeDepsAction = ActionManager.getInstance().getAction("ShowPackageDeps");
        group.add(new AnAction(analyzeDepsAction.getTemplatePresentation().getText(), null, AllIcons.Toolwindows.ToolWindowInspection){

            public void actionPerformed(AnActionEvent e) {
                analyzeDepsAction.actionPerformed(e);
            }

            public void update(AnActionEvent e) {
                analyzeDepsAction.update(e);
            }
        });
        group.add((AnAction)new ToggleAction(AnalysisScopeBundle.message((String)"action.module.dependencies.direction", (Object[])new Object[0])){

            public boolean isSelected(AnActionEvent e) {
                return !((ModulesDependenciesPanel)ModulesDependenciesPanel.this).myState.forwardDirection;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                ((ModulesDependenciesPanel)ModulesDependenciesPanel.this).myState.forwardDirection = !state;
                ModulesDependenciesPanel.this.updateLeftTree();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/moduleDependencies/ModulesDependenciesPanel$10", "update"));
                }
                e.getPresentation().setIcon(((ModulesDependenciesPanel)ModulesDependenciesPanel.this).myState.forwardDirection ? AllIcons.Hierarchy.Subtypes : AllIcons.Hierarchy.Supertypes);
                super.update(e);
            }
        });
        group.add((AnAction)new ToggleAction(AnalysisScopeBundle.message((String)"action.module.dependencies.tests", (Object[])new Object[0]), null, AllIcons.Modules.TestSourceFolder){

            public boolean isSelected(AnActionEvent e) {
                return ((ModulesDependenciesPanel)ModulesDependenciesPanel.this).myState.includeTests;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                ((ModulesDependenciesPanel)ModulesDependenciesPanel.this).myState.includeTests = state;
                ModulesDependenciesPanel.this.updateModuleGraph();
                ModulesDependenciesPanel.this.updateLeftTree();
            }
        });
        group.add((AnAction)new ContextHelpAction(HELP_ID));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)toolbar.getComponent(), "West");
        panel.add((Component)this.myPathField, "Center");
        return panel;
    }

    private void updateLeftTree() {
        final DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myLeftTree.getModel().getRoot();
        root.removeAllChildren();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                for (Module module : ModulesDependenciesPanel.this.myModules) {
                    if (module.isDisposed()) continue;
                    ProgressManager.progress((String)AnalysisScopeBundle.message((String)"update.module.tree.progress.text", (Object[])new Object[]{module.getName()}));
                    DefaultMutableTreeNode moduleNode = new DefaultMutableTreeNode(new MyUserObject(ModulesDependenciesPanel.this.isInCycle(module), module));
                    root.add(moduleNode);
                    for (Module dependency : ModulesDependenciesPanel.this.getModuleDependencies(module)) {
                        moduleNode.add(new DefaultMutableTreeNode(new MyUserObject(ModulesDependenciesPanel.this.isInCycle(dependency), dependency)));
                    }
                }
            }
        }, AnalysisScopeBundle.message((String)"update.module.tree.progress.title", (Object[])new Object[0]), true, this.myProject);
        TreeUtil.sort((DefaultMutableTreeNode)root, NODE_COMPARATOR);
        ((DefaultTreeModel)this.myLeftTree.getModel()).reload();
        TreeUtil.selectFirstNode((JTree)this.myLeftTree);
    }

    private void updateRightTree(Module module) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myRightTree.getModel().getRoot();
        root.removeAllChildren();
        Set cycles = GraphAlgorithms.getInstance().findCycles(this.myModuleGraph, (Object)module);
        int index = 1;
        for (List modules : cycles) {
            DefaultMutableTreeNode cycle = new DefaultMutableTreeNode(AnalysisScopeBundle.message((String)"module.dependencies.cycle.node.text", (Object[])new Object[]{index++}));
            root.add(cycle);
            cycle.add(new DefaultMutableTreeNode(new MyUserObject(false, module)));
            for (Module moduleInCycle : modules) {
                cycle.add(new DefaultMutableTreeNode(new MyUserObject(false, moduleInCycle)));
            }
        }
        ((DefaultTreeModel)this.myRightTree.getModel()).reload();
        TreeUtil.expandAll((JTree)this.myRightTree);
    }

    public void setContent(Content content) {
        this.myContent = content;
    }

    public void dispose() {
    }

    private static class MyTreeExpander
    implements TreeExpander {
        private final Tree myTree;
        private final boolean myEnableExpandAll;

        public MyTreeExpander(Tree tree, boolean enableExpandAll) {
            this.myTree = tree;
            this.myEnableExpandAll = enableExpandAll;
        }

        public void expandAll() {
            TreeUtil.expandAll((JTree)this.myTree);
        }

        public boolean canExpand() {
            return this.myEnableExpandAll;
        }

        public void collapseAll() {
            TreeUtil.collapseAll((JTree)this.myTree, (int)3);
        }

        public boolean canCollapse() {
            return true;
        }
    }

    private static class MyTreePanel
    extends JPanel
    implements DataProvider {
        private final Tree myTree;
        private final Project myProject;

        public MyTreePanel(Tree tree, Project project) {
            super(new BorderLayout());
            this.myTree = tree;
            this.myProject = project;
            this.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree), "Center");
        }

        public Object getData(String dataId) {
            DefaultMutableTreeNode node;
            TreePath selectionPath;
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myProject;
            }
            if (LangDataKeys.MODULE_CONTEXT.is(dataId) && (selectionPath = this.myTree.getLeadSelectionPath()) != null && selectionPath.getLastPathComponent() instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject() instanceof MyUserObject) {
                return ((MyUserObject)node.getUserObject()).myModule;
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return ModulesDependenciesPanel.HELP_ID;
            }
            if (CommonDataKeys.NAVIGATABLE.is(dataId) && (selectionPath = this.myTree.getLeadSelectionPath()) != null && selectionPath.getLastPathComponent() instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject() instanceof MyUserObject) {
                return node.getUserObject();
            }
            return null;
        }
    }

    private static class MyUserObject
    implements NavigatableWithText {
        private final Module myModule;
        private final boolean myInCycle;

        public MyUserObject(boolean inCycle, Module module) {
            this.myInCycle = inCycle;
            this.myModule = module;
        }

        public void navigate(boolean requestFocus) {
            ProjectSettingsService.getInstance(this.myModule.getProject()).openModuleSettings(this.myModule);
        }

        public boolean canNavigate() {
            return !this.myModule.isDisposed();
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public String getNavigateActionText(boolean focusEditor) {
            return ActionsBundle.message((String)"action.ModuleSettings.navigate", (Object[])new Object[0]);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof MyUserObject && this.myModule.equals(((MyUserObject)o).myModule);
        }

        public int hashCode() {
            return this.myModule.hashCode();
        }

        public String toString() {
            return this.myModule.getName();
        }
    }
}

