/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.impl.view.EditorCoordinateMapper;
import com.intellij.openapi.editor.impl.view.EditorPainter;
import com.intellij.openapi.editor.impl.view.EditorSizeManager;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.editor.impl.view.LineLayout;
import com.intellij.openapi.editor.impl.view.LogicalPositionCache;
import com.intellij.openapi.editor.impl.view.TabFragment;
import com.intellij.openapi.editor.impl.view.TextLayoutCache;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import org.jetbrains.annotations.NotNull;

public class EditorView
implements TextDrawingCallback,
Disposable,
Dumpable {
    private static Key<LineLayout> FOLD_REGION_TEXT_LAYOUT = Key.create((String)"text.layout");
    private final EditorImpl myEditor;
    private final DocumentEx myDocument;
    private final FontRenderContext myFontRenderContext;
    private final EditorPainter myPainter;
    private final EditorCoordinateMapper myMapper;
    private final EditorSizeManager mySizeManager;
    private final TextLayoutCache myTextLayoutCache;
    private final LogicalPositionCache myLogicalPositionCache;
    private final TabFragment myTabFragment;
    private String myPrefixText;
    private LineLayout myPrefixLayout;
    private TextAttributes myPrefixAttributes;
    private int myPlainSpaceWidth;
    private int myLineHeight;
    private int myDescent;
    private int myCharHeight;
    private int myMaxCharWidth;
    private int myTabSize;
    private final Object myLock = new Object();

    public EditorView(EditorImpl editor) {
        this.myFontRenderContext = EditorView.createFontRenderContext();
        this.myEditor = editor;
        this.myDocument = editor.getDocument();
        this.myPainter = new EditorPainter(this);
        this.myMapper = new EditorCoordinateMapper(this);
        this.mySizeManager = new EditorSizeManager(this);
        this.myTextLayoutCache = new TextLayoutCache(this);
        this.myLogicalPositionCache = new LogicalPositionCache(this);
        this.myTabFragment = new TabFragment(this);
        Disposer.register((Disposable)this, (Disposable)this.myLogicalPositionCache);
        Disposer.register((Disposable)this, (Disposable)this.myTextLayoutCache);
        Disposer.register((Disposable)this, (Disposable)this.mySizeManager);
    }

    EditorImpl getEditor() {
        return this.myEditor;
    }

    FontRenderContext getFontRenderContext() {
        return this.myFontRenderContext;
    }

    EditorSizeManager getSizeManager() {
        return this.mySizeManager;
    }

    TextLayoutCache getTextLayoutCache() {
        return this.myTextLayoutCache;
    }

    EditorPainter getPainter() {
        return this.myPainter;
    }

    TabFragment getTabFragment() {
        return this.myTabFragment;
    }

    LogicalPositionCache getLogicalPositionCache() {
        return this.myLogicalPositionCache;
    }

    public void dispose() {
    }

    public int yToVisualLine(int y) {
        return this.myMapper.yToVisualLine(y);
    }

    public int visualLineToY(int line) {
        return this.myMapper.visualLineToY(line);
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        EditorView.assertIsReadAccess();
        LogicalPosition logicalPosition = this.myMapper.offsetToLogicalPosition(offset);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorView", "offsetToLogicalPosition"));
        }
        return logicalPosition;
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/view/EditorView", "logicalPositionToOffset"));
        }
        EditorView.assertIsReadAccess();
        return this.myMapper.logicalPositionToOffset(pos);
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition pos, boolean beforeSoftWrap) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/view/EditorView", "logicalToVisualPosition"));
        }
        EditorView.assertIsDispatchThread();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        VisualPosition visualPosition = this.myMapper.logicalToVisualPosition(pos, beforeSoftWrap);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorView", "logicalToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/view/EditorView", "visualToLogicalPosition"));
        }
        EditorView.assertIsDispatchThread();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        LogicalPosition logicalPosition = this.myMapper.visualToLogicalPosition(pos);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorView", "visualToLogicalPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        EditorView.assertIsDispatchThread();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        VisualPosition visualPosition = this.myMapper.offsetToVisualPosition(offset, leanTowardsLargerOffsets, beforeSoftWrap);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorView", "offsetToVisualPosition"));
        }
        return visualPosition;
    }

    public int visualPositionToOffset(VisualPosition visualPosition) {
        EditorView.assertIsDispatchThread();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.visualPositionToOffset(visualPosition);
    }

    public int offsetToVisualLine(int offset, boolean beforeSoftWrap) {
        EditorView.assertIsDispatchThread();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.offsetToVisualLine(offset, beforeSoftWrap);
    }

    public int visualLineToOffset(int visualLine) {
        EditorView.assertIsDispatchThread();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.visualLineToOffset(visualLine);
    }

    public int visualLineStartOffset(int visualLine) {
        EditorView.assertIsDispatchThread();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.visualLineToOffset(visualLine);
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/openapi/editor/impl/view/EditorView", "xyToVisualPosition"));
        }
        EditorView.assertIsDispatchThread();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        VisualPosition visualPosition = this.myMapper.xyToVisualPosition(p);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorView", "xyToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/view/EditorView", "visualPositionToXY"));
        }
        EditorView.assertIsDispatchThread();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        Point point = this.myMapper.visualPositionToXY(pos);
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorView", "visualPositionToXY"));
        }
        return point;
    }

    @NotNull
    public Point offsetToXY(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        EditorView.assertIsDispatchThread();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        Point point = this.myMapper.offsetToXY(offset, leanTowardsLargerOffsets, beforeSoftWrap);
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorView", "offsetToXY"));
        }
        return point;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrefix(String prefixText, TextAttributes attributes) {
        EditorView.assertIsDispatchThread();
        this.myPrefixText = prefixText;
        Object object = this.myLock;
        synchronized (object) {
            this.myPrefixLayout = prefixText == null || prefixText.isEmpty() ? null : LineLayout.create(this, prefixText, attributes.getFontType());
        }
        this.myPrefixAttributes = attributes;
        this.mySizeManager.invalidateRange(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getPrefixTextWidthInPixels() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myPrefixLayout == null ? 0.0f : this.myPrefixLayout.getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LineLayout getPrefixLayout() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myPrefixLayout;
        }
    }

    TextAttributes getPrefixAttributes() {
        return this.myPrefixAttributes;
    }

    public void paint(Graphics2D g) {
        EditorView.assertIsDispatchThread();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        this.myPainter.paint(g);
    }

    public void repaintCarets() {
        EditorView.assertIsDispatchThread();
        this.myPainter.repaintCarets();
    }

    public Dimension getPreferredSize() {
        EditorView.assertIsDispatchThread();
        assert (!this.myEditor.isPurePaintingMode());
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.mySizeManager.getPreferredSize();
    }

    public int getMaxWidthInRange(int startOffset, int endOffset) {
        EditorView.assertIsDispatchThread();
        return this.getMaxWidthInLineRange(this.offsetToVisualLine(startOffset, false), this.offsetToVisualLine(endOffset, true));
    }

    int getMaxWidthInLineRange(int startVisualLine, int endVisualLine) {
        this.myEditor.getSoftWrapModel().prepareToMapping();
        int maxWidth = 0;
        VisualLinesIterator iterator = new VisualLinesIterator(this, startVisualLine);
        while (!iterator.atEnd() && iterator.getVisualLine() <= endVisualLine) {
            int width = this.mySizeManager.getVisualLineWidth(iterator, null);
            maxWidth = Math.max(maxWidth, width);
            iterator.advance();
        }
        return maxWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitSettings() {
        EditorView.assertIsDispatchThread();
        this.myPlainSpaceWidth = -1;
        Object object = this.myLock;
        synchronized (object) {
            this.myLineHeight = -1;
            this.myDescent = -1;
            this.myCharHeight = -1;
            this.myMaxCharWidth = -1;
            this.myTabSize = -1;
        }
        this.myLogicalPositionCache.reset(false);
        this.myTextLayoutCache.resetToDocumentSize(false);
        this.invalidateFoldRegionLayouts();
        this.setPrefix(this.myPrefixText, this.myPrefixAttributes);
        this.mySizeManager.reset();
    }

    public void invalidateRange(int startOffset, int endOffset) {
        EditorView.assertIsDispatchThread();
        int textLength = this.myDocument.getTextLength();
        if (startOffset > endOffset || startOffset >= textLength || endOffset < 0) {
            return;
        }
        int startLine = this.myDocument.getLineNumber(Math.max(0, startOffset));
        int endLine = this.myDocument.getLineNumber(Math.min(textLength, endOffset));
        this.myTextLayoutCache.invalidateLines(startLine, endLine);
        this.mySizeManager.invalidateRange(startOffset, endOffset);
    }

    public void reset() {
        EditorView.assertIsDispatchThread();
        this.myLogicalPositionCache.reset(true);
        this.myTextLayoutCache.resetToDocumentSize(true);
        this.mySizeManager.reset();
    }

    public boolean isRtlLocation(@NotNull VisualPosition visualPosition) {
        if (visualPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visualPosition", "com/intellij/openapi/editor/impl/view/EditorView", "isRtlLocation"));
        }
        EditorView.assertIsDispatchThread();
        if (this.myDocument.getTextLength() == 0) {
            return false;
        }
        LogicalPosition logicalPosition = this.visualToLogicalPosition(visualPosition);
        int offset = this.logicalPositionToOffset(logicalPosition);
        if (this.myEditor.getSoftWrapModel().getSoftWrap(offset) != null) {
            VisualPosition beforeWrapPosition = this.offsetToVisualPosition(offset, true, true);
            if (visualPosition.line == beforeWrapPosition.line && (visualPosition.column > beforeWrapPosition.column || visualPosition.column == beforeWrapPosition.column && visualPosition.leansRight)) {
                return false;
            }
            VisualPosition afterWrapPosition = this.offsetToVisualPosition(offset, false, false);
            if (visualPosition.line == afterWrapPosition.line && (visualPosition.column < afterWrapPosition.column || visualPosition.column == afterWrapPosition.column && !visualPosition.leansRight)) {
                return false;
            }
        }
        int line = this.myDocument.getLineNumber(offset);
        LineLayout layout = this.myTextLayoutCache.getLineLayout(line);
        return layout.isRtlLocation(offset - this.myDocument.getLineStartOffset(line), logicalPosition.leansForward);
    }

    public boolean isAtBidiRunBoundary(@NotNull VisualPosition visualPosition) {
        if (visualPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visualPosition", "com/intellij/openapi/editor/impl/view/EditorView", "isAtBidiRunBoundary"));
        }
        EditorView.assertIsDispatchThread();
        int offset = this.visualPositionToOffset(visualPosition);
        int otherSideOffset = this.visualPositionToOffset(visualPosition.leanRight(!visualPosition.leansRight));
        return offset != otherSideOffset;
    }

    public int findNearestDirectionBoundary(int offset, boolean lookForward) {
        int lineStartOffset;
        EditorView.assertIsDispatchThread();
        int textLength = this.myDocument.getTextLength();
        if (textLength == 0 || offset < 0 || offset > textLength) {
            return -1;
        }
        int line = this.myDocument.getLineNumber(offset);
        LineLayout layout = this.myTextLayoutCache.getLineLayout(line);
        int relativeOffset = layout.findNearestDirectionBoundary(offset - (lineStartOffset = this.myDocument.getLineStartOffset(line)), lookForward);
        return relativeOffset < 0 ? -1 : lineStartOffset + relativeOffset;
    }

    int getPlainSpaceWidth() {
        if (this.myPlainSpaceWidth < 0) {
            FontMetrics fm = this.myEditor.getContentComponent().getFontMetrics(this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
            int width = FontLayoutService.getInstance().charWidth(fm, ' ');
            this.myPlainSpaceWidth = width > 0 ? width : 1;
        }
        return this.myPlainSpaceWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineHeight() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLineHeight < 0) {
                EditorColorsScheme colorsScheme = this.myEditor.getColorsScheme();
                FontMetrics fm = this.myEditor.getContentComponent().getFontMetrics(colorsScheme.getFont(EditorFontType.PLAIN));
                int fontMetricsHeight = FontLayoutService.getInstance().getHeight(fm);
                this.myLineHeight = (int)((float)fontMetricsHeight * (this.myEditor.isOneLineMode() ? 1.0f : colorsScheme.getLineSpacing()));
                if (this.myLineHeight <= 0) {
                    this.myLineHeight = fontMetricsHeight;
                    if (this.myLineHeight <= 0) {
                        this.myLineHeight = 12;
                    }
                }
            }
            return this.myLineHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAscent() {
        Object object = this.myLock;
        synchronized (object) {
            return this.getLineHeight() - this.getDescent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCharHeight() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myCharHeight < 0) {
                FontMetrics fm = this.myEditor.getContentComponent().getFontMetrics(this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
                this.myCharHeight = FontLayoutService.getInstance().charWidth(fm, 'a');
            }
            return this.myCharHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMaxCharWidth() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myMaxCharWidth < 0) {
                FontMetrics fm = this.myEditor.getContentComponent().getFontMetrics(this.myEditor.getColorsScheme().getFont(EditorFontType.BOLD_ITALIC));
                this.myMaxCharWidth = FontLayoutService.getInstance().charWidth(fm, 'W');
            }
            return this.myMaxCharWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDescent() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDescent < 0) {
                FontMetrics fm = this.myEditor.getContentComponent().getFontMetrics(this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
                this.myDescent = FontLayoutService.getInstance().getDescent(fm);
            }
            return this.myDescent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTabSize() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myTabSize < 0) {
                this.myTabSize = EditorUtil.getTabSize(this.myEditor);
            }
            return this.myTabSize;
        }
    }

    private static FontRenderContext createFontRenderContext() {
        Graphics2D g = FontInfo.createReferenceGraphics();
        try {
            FontRenderContext fontRenderContext = g.getFontRenderContext();
            return fontRenderContext;
        }
        finally {
            g.dispose();
        }
    }

    LineLayout getFoldRegionLayout(FoldRegion foldRegion) {
        LineLayout layout = (LineLayout)foldRegion.getUserData(FOLD_REGION_TEXT_LAYOUT);
        if (layout == null) {
            TextAttributes placeholderAttributes = this.myEditor.getFoldingModel().getPlaceholderAttributes();
            layout = LineLayout.create(this, foldRegion.getPlaceholderText(), placeholderAttributes == null ? 0 : placeholderAttributes.getFontType());
            foldRegion.putUserData(FOLD_REGION_TEXT_LAYOUT, (Object)layout);
        }
        return layout;
    }

    void invalidateFoldRegionLayouts() {
        for (FoldRegion region : this.myEditor.getFoldingModel().getAllFoldRegions()) {
            region.putUserData(FOLD_REGION_TEXT_LAYOUT, null);
        }
    }

    private static void assertIsDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    private static void assertIsReadAccess() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    @Override
    public void drawChars(@NotNull Graphics g, @NotNull char[] data, int start, int end, int x, int y, Color color, FontInfo fontInfo) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/view/EditorView", "drawChars"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/editor/impl/view/EditorView", "drawChars"));
        }
        this.myPainter.drawChars(g, data, start, end, x, y, color, fontInfo);
    }

    @NotNull
    public String dumpState() {
        String string = "[prefix text: " + this.myPrefixText + ", prefix attributes: " + this.myPrefixAttributes + ", space width: " + this.myPlainSpaceWidth + ", line height: " + this.myLineHeight + ", descent: " + this.myDescent + ", char height: " + this.myCharHeight + ", max char width: " + this.myMaxCharWidth + ", tab size: " + this.myTabSize + " ,size manager: " + this.mySizeManager.dumpState() + "]";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorView", "dumpState"));
        }
        return string;
    }
}

