/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

class LogicalPositionCache
implements PrioritizedDocumentListener,
Disposable {
    private final Document myDocument;
    private final EditorView myView;
    private ArrayList<LineData> myLines = new ArrayList();
    private int myTabSize = -1;
    private int myDocumentChangeOldEndLine;

    LogicalPositionCache(EditorView view) {
        this.myView = view;
        this.myDocument = view.getEditor().getDocument();
        this.myDocument.addDocumentListener((DocumentListener)this, (Disposable)this);
    }

    @Override
    public int getPriority() {
        return 65;
    }

    public void beforeDocumentChange(DocumentEvent event) {
        this.myDocumentChangeOldEndLine = this.getAdjustedLineNumber(event.getOffset() + event.getOldLength());
    }

    public void documentChanged(DocumentEvent event) {
        int startLine = this.myDocument.getLineNumber(event.getOffset());
        int newEndLine = this.getAdjustedLineNumber(event.getOffset() + event.getNewLength());
        this.invalidateLines(startLine, this.myDocumentChangeOldEndLine, newEndLine, CharArrayUtil.indexOf((CharSequence)event.getNewFragment(), (CharSequence)"\t", (int)0) == -1);
    }

    synchronized void reset(boolean force) {
        this.checkDisposed();
        int oldTabSize = this.myTabSize;
        this.myTabSize = this.myView.getTabSize();
        if (force || oldTabSize != this.myTabSize) {
            this.invalidateLines(0, this.myLines.size() - 1, this.myDocument.getLineCount() - 1, true);
        }
    }

    @NotNull
    synchronized LogicalPosition offsetToLogicalPosition(int offset) {
        int textLength = this.myDocument.getTextLength();
        if (offset <= 0 || textLength == 0) {
            LogicalPosition logicalPosition = new LogicalPosition(0, 0);
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/LogicalPositionCache", "offsetToLogicalPosition"));
            }
            return logicalPosition;
        }
        offset = Math.min(offset, textLength);
        int line = this.myDocument.getLineNumber(offset);
        LineData lineData = this.getLineInfo(line);
        LogicalPosition logicalPosition = new LogicalPosition(line, lineData.offsetToLogicalColumn(this.myDocument, line, this.myTabSize, offset));
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/LogicalPositionCache", "offsetToLogicalPosition"));
        }
        return logicalPosition;
    }

    synchronized int offsetToLogicalColumn(int line, int intraLineOffset) {
        if (line < 0 || line >= this.myDocument.getLineCount()) {
            return 0;
        }
        LineData lineData = this.getLineInfo(line);
        return lineData.offsetToLogicalColumn(this.myDocument, line, this.myTabSize, this.myDocument.getLineStartOffset(line) + intraLineOffset);
    }

    synchronized int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/view/LogicalPositionCache", "logicalPositionToOffset"));
        }
        int line = pos.line;
        if (line >= this.myDocument.getLineCount()) {
            return this.myDocument.getTextLength();
        }
        LineData lineData = this.getLineInfo(line);
        return lineData.logicalColumnToOffset(this.myDocument, line, this.myTabSize, pos.column);
    }

    private int getAdjustedLineNumber(int offset) {
        return this.myDocument.getTextLength() == 0 ? -1 : this.myDocument.getLineNumber(offset);
    }

    private synchronized void invalidateLines(int startLine, int oldEndLine, int newEndLine, boolean preserveTrivialLines) {
        this.checkDisposed();
        int endLine = Math.min(oldEndLine, newEndLine);
        for (int line = startLine; line <= endLine; ++line) {
            LineData data = this.myLines.get(line);
            if (data == null || preserveTrivialLines && data.columnCache == null) continue;
            this.myLines.set(line, null);
        }
        if (oldEndLine < newEndLine) {
            this.myLines.addAll(oldEndLine + 1, Collections.nCopies(newEndLine - oldEndLine, null));
        } else if (oldEndLine > newEndLine) {
            this.myLines.subList(newEndLine + 1, oldEndLine + 1).clear();
        }
    }

    @NotNull
    private LineData getLineInfo(int line) {
        this.checkDisposed();
        LineData result2 = this.myLines.get(line);
        if (result2 == null) {
            result2 = new LineData(this.myDocument, line, this.myTabSize);
            this.myLines.set(line, result2);
        }
        LineData lineData = result2;
        if (lineData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/LogicalPositionCache", "getLineInfo"));
        }
        return lineData;
    }

    public synchronized void dispose() {
        this.myLines = null;
    }

    private void checkDisposed() {
        if (this.myLines == null) {
            this.myView.getEditor().throwDisposalError("Editor is already disposed");
        }
    }

    private static class LineData {
        private static final int CACHE_FREQUENCY = 1024;
        private final int[] columnCache;

        private LineData(@NotNull Document document, int line, int tabSize) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/view/LogicalPositionCache$LineData", "<init>"));
            }
            int start = document.getLineStartOffset(line);
            int end = document.getLineEndOffset(line);
            int cacheSize = (end - start) / 1024;
            int[] cache = new int[cacheSize];
            CharSequence text = document.getImmutableCharSequence();
            int column = 0;
            boolean hasTabs = false;
            for (int i = start; i < end; ++i) {
                if (i > start && (i - start) % 1024 == 0) {
                    cache[(i - start) / 1024 - 1] = column;
                }
                if (text.charAt(i) == '\t') {
                    column = (column / tabSize + 1) * tabSize;
                    hasTabs = true;
                    continue;
                }
                ++column;
            }
            this.columnCache = (int[])(hasTabs ? cache : null);
        }

        private int offsetToLogicalColumn(@NotNull Document document, int line, int tabSize, int offset) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/view/LogicalPositionCache$LineData", "offsetToLogicalColumn"));
            }
            offset = Math.min(offset, document.getLineEndOffset(line));
            int lineStartOffset = document.getLineStartOffset(line);
            int relOffset = offset - lineStartOffset;
            if (this.columnCache == null) {
                return relOffset;
            }
            int cacheIndex = relOffset / 1024;
            int startOffset = lineStartOffset + cacheIndex * 1024;
            int column = cacheIndex == 0 ? 0 : this.columnCache[cacheIndex - 1];
            CharSequence text = document.getImmutableCharSequence();
            for (int i = startOffset; i < offset; ++i) {
                if (text.charAt(i) == '\t') {
                    column = (column / tabSize + 1) * tabSize;
                    continue;
                }
                ++column;
            }
            return column;
        }

        private int logicalColumnToOffset(@NotNull Document document, int line, int tabSize, int logicalColumn) {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/view/LogicalPositionCache$LineData", "logicalColumnToOffset"));
            }
            int lineStartOffset = document.getLineStartOffset(line);
            int lineEndOffset = document.getLineEndOffset(line);
            if (this.columnCache == null) {
                int result2 = lineStartOffset + logicalColumn;
                return result2 < 0 || result2 > lineEndOffset ? lineEndOffset : result2;
            }
            int pos = Arrays.binarySearch(this.columnCache, logicalColumn);
            if (pos >= 0) {
                return lineStartOffset + (pos + 1) * 1024;
            }
            int startOffset = lineStartOffset + (-pos - 1) * 1024;
            int column = pos == -1 ? 0 : this.columnCache[-pos - 2];
            CharSequence text = document.getImmutableCharSequence();
            for (int i = startOffset; i < lineEndOffset; ++i) {
                column = text.charAt(i) == '\t' ? (column / tabSize + 1) * tabSize : ++column;
                if (logicalColumn >= column) continue;
                return i;
            }
            return lineEndOffset;
        }
    }
}

