/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.view.LineFragment;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;

abstract class TextFragment
implements LineFragment {
    @NotNull
    final float[] myCharPositions;

    TextFragment(int charCount) {
        assert (charCount > 0);
        this.myCharPositions = new float[charCount];
    }

    @Override
    public int getLength() {
        return this.myCharPositions.length;
    }

    @Override
    public int getLogicalColumnCount(int startColumn) {
        return this.myCharPositions.length;
    }

    @Override
    public int getVisualColumnCount(float startX) {
        return this.myCharPositions.length;
    }

    abstract boolean isRtl();

    @Override
    @NotNull
    public LineFragment subFragment(int startOffset, int endOffset) {
        assert (startOffset >= 0);
        assert (endOffset <= this.myCharPositions.length);
        assert (startOffset < endOffset);
        if (startOffset == 0 && endOffset == this.myCharPositions.length) {
            TextFragment textFragment = this;
            if (textFragment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/TextFragment", "subFragment"));
            }
            return textFragment;
        }
        TextFragmentWindow textFragmentWindow = new TextFragmentWindow(startOffset, endOffset);
        if (textFragmentWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/TextFragment", "subFragment"));
        }
        return textFragmentWindow;
    }

    @Override
    public float offsetToX(float startX, int startOffset, int offset) {
        return startX + this.getX(offset) - this.getX(startOffset);
    }

    float getX(int offset) {
        return offset <= 0 ? 0.0f : this.myCharPositions[Math.min(this.myCharPositions.length, offset) - 1];
    }

    @Override
    public int logicalToVisualColumn(float startX, int startColumn, int column) {
        return column;
    }

    @Override
    public int visualToLogicalColumn(float startX, int startColumn, int column) {
        return column;
    }

    @Override
    public int[] xToVisualColumn(float startX, float x) {
        float relX = x - startX;
        float prevPos = 0.0f;
        for (int i = 0; i < this.myCharPositions.length; ++i) {
            float newPos = this.myCharPositions[i];
            if (relX < (newPos + prevPos) / 2.0f) {
                return new int[]{i, relX <= prevPos ? 0 : 1};
            }
            prevPos = newPos;
        }
        return new int[]{this.myCharPositions.length, relX <= this.myCharPositions[this.myCharPositions.length - 1] ? 0 : 1};
    }

    @Override
    public float visualColumnToX(float startX, int column) {
        return startX + this.getX(column);
    }

    private class TextFragmentWindow
    implements LineFragment {
        private final int myStartOffset;
        private final int myEndOffset;

        private TextFragmentWindow(int startOffset, int endOffset) {
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
        }

        @Override
        public int getLength() {
            return this.myEndOffset - this.myStartOffset;
        }

        @Override
        public int getLogicalColumnCount(int startColumn) {
            return this.getLength();
        }

        @Override
        public int getVisualColumnCount(float startX) {
            return this.getLength();
        }

        @Override
        public int logicalToVisualColumn(float startX, int startColumn, int column) {
            return column;
        }

        @Override
        public int visualToLogicalColumn(float startX, int startColumn, int column) {
            return column;
        }

        @Override
        public float offsetToX(float startX, int startOffset, int offset) {
            return TextFragment.this.offsetToX(startX, this.visualColumnToParent(startOffset), this.visualColumnToParent(offset));
        }

        @Override
        public float visualColumnToX(float startX, int column) {
            return startX + TextFragment.this.getX(this.visualColumnToParent(column)) - TextFragment.this.getX(this.visualColumnToParent(0));
        }

        @Override
        public int[] xToVisualColumn(float startX, float x) {
            int[] nArray;
            int startColumnInParent = this.visualColumnToParent(0);
            float parentStartX = startX - TextFragment.this.getX(startColumnInParent);
            int[] parentColumn = TextFragment.this.xToVisualColumn(parentStartX, x);
            int column = parentColumn[0] - startColumnInParent;
            int length = this.getLength();
            if (column < 0) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 0;
            } else if (column > length) {
                int[] nArray3 = new int[2];
                nArray3[0] = length;
                nArray = nArray3;
                nArray3[1] = 1;
            } else {
                int[] nArray4 = new int[2];
                nArray4[0] = column;
                nArray = nArray4;
                nArray4[1] = parentColumn[1];
            }
            return nArray;
        }

        private int visualColumnToParent(int column) {
            return column + (TextFragment.this.isRtl() ? TextFragment.this.myCharPositions.length - this.myEndOffset : this.myStartOffset);
        }

        @Override
        public void draw(Graphics2D g, float x, float y, int startColumn, int endColumn) {
            TextFragment.this.draw(g, x, y, this.visualColumnToParent(startColumn), this.visualColumnToParent(endColumn));
        }

        @Override
        @NotNull
        public LineFragment subFragment(int startOffset, int endOffset) {
            TextFragmentWindow textFragmentWindow = new TextFragmentWindow(startOffset + this.myStartOffset, endOffset + this.myStartOffset);
            if (textFragmentWindow == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/TextFragment$TextFragmentWindow", "subFragment"));
            }
            return textFragmentWindow;
        }
    }
}

