/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.PsiLocation;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskLocation
extends PsiLocation<PsiElement> {
    @NotNull
    private final ExternalTaskExecutionInfo myTaskInfo;

    public ExternalSystemTaskLocation(@NotNull Project project, @NotNull PsiElement psiElement, @NotNull ExternalTaskExecutionInfo taskInfo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskLocation", "<init>"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskLocation", "<init>"));
        }
        if (taskInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskInfo", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskLocation", "<init>"));
        }
        super(project, psiElement);
        this.myTaskInfo = taskInfo;
    }

    @NotNull
    public ExternalTaskExecutionInfo getTaskInfo() {
        ExternalTaskExecutionInfo externalTaskExecutionInfo = this.myTaskInfo;
        if (externalTaskExecutionInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskLocation", "getTaskInfo"));
        }
        return externalTaskExecutionInfo;
    }

    public static ExternalSystemTaskLocation create(@NotNull Project project, @NotNull ProjectSystemId systemId, @Nullable String projectPath, @NotNull ExternalTaskExecutionInfo taskInfo) {
        PsiDirectory psiFile;
        VirtualFile file2;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskLocation", "create"));
        }
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskLocation", "create"));
        }
        if (taskInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskInfo", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskLocation", "create"));
        }
        if (projectPath != null && (file2 = VfsUtil.findFileByIoFile((File)new File(projectPath), (boolean)false)) != null && (psiFile = PsiManager.getInstance((Project)project).findDirectory(file2)) != null) {
            return new ExternalSystemTaskLocation(project, (PsiElement)psiFile, taskInfo);
        }
        String name = systemId.getReadableName() + projectPath + StringUtil.join((Collection)taskInfo.getSettings().getTaskNames(), (String)" ");
        psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(name, (FileType)PlainTextFileType.INSTANCE, (CharSequence)"");
        return new ExternalSystemTaskLocation(project, (PsiElement)psiFile, taskInfo);
    }
}

