/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessDialog;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessExtension;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonProjectFileWritingAccessProvider
extends WritingAccessProvider {
    private static final Key<Boolean> ENABLE_IN_TESTS = Key.create((String)"NON_PROJECT_FILE_ACCESS_ENABLE_IN_TESTS");
    private static final Key<Boolean> ALL_ACCESS_ALLOWED = Key.create((String)"NON_PROJECT_FILE_ALL_ACCESS_STATUS");
    private static final NotNullLazyKey<Map<VirtualFile, AccessStatus>, Project> ACCESS_STATUS = NotNullLazyKey.create((String)"NON_PROJECT_FILE_ACCESS_STATUS", (NotNullFunction)new NotNullFunction<Project, Map<VirtualFile, AccessStatus>>(){

        @NotNull
        public Map<VirtualFile, AccessStatus> fun(Project project) {
            HashMap<VirtualFile, AccessStatus> hashMap = new HashMap<VirtualFile, AccessStatus>();
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider$1", "fun"));
            }
            return hashMap;
        }
    });
    @NotNull
    private final Project myProject;
    @Nullable
    private static NullableFunction<List<VirtualFile>, UnlockOption> ourCustomUnlocker;

    public static void setCustomUnlocker(@Nullable NullableFunction<List<VirtualFile>, UnlockOption> unlocker) {
        ourCustomUnlocker = unlocker;
    }

    public NonProjectFileWritingAccessProvider(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "<init>"));
        }
        this.myProject = project;
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider$2", "fileDeleted"));
                }
                NonProjectFileWritingAccessProvider.getRegisteredFiles(project).remove(event.getFile());
            }
        }, (Disposable)project);
        this.myProject.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                Map files = NonProjectFileWritingAccessProvider.getRegisteredFiles(project);
                for (VirtualFile each : new ArrayList(files.keySet())) {
                    if (!NonProjectFileWritingAccessProvider.isProjectFile(each, project)) continue;
                    files.remove(each);
                }
            }
        });
    }

    public boolean isPotentiallyWritable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "isPotentiallyWritable"));
        }
        return true;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(VirtualFile ... files) {
        if (NonProjectFileWritingAccessProvider.allAccessAllowed(this.myProject)) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "requestWriting"));
            }
            return list;
        }
        SmartList deniedFiles = new SmartList();
        Map<VirtualFile, AccessStatus> statuses = NonProjectFileWritingAccessProvider.getRegisteredFiles(this.myProject);
        for (VirtualFile each : files) {
            if (statuses.get(each) == AccessStatus.ALLOWED || !(each.getFileSystem() instanceof LocalFileSystem)) continue;
            if (NonProjectFileWritingAccessProvider.isProjectFile(each, this.myProject)) {
                statuses.remove(each);
                continue;
            }
            statuses.put(each, AccessStatus.REQUESTED);
            deniedFiles.add(each);
        }
        if (deniedFiles.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "requestWriting"));
            }
            return list;
        }
        UnlockOption unlockOption = this.askToUnlock((List<VirtualFile>)deniedFiles);
        if (unlockOption == null) {
            SmartList smartList = deniedFiles;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "requestWriting"));
            }
            return smartList;
        }
        switch (unlockOption) {
            case UNLOCK: {
                for (VirtualFile eachAllowed : deniedFiles) {
                    statuses.put(eachAllowed, AccessStatus.ALLOWED);
                }
                break;
            }
            case UNLOCK_ALL: {
                this.myProject.putUserData(ALL_ACCESS_ALLOWED, (Object)Boolean.TRUE);
            }
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "requestWriting"));
        }
        return list;
    }

    @Nullable
    private UnlockOption askToUnlock(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "askToUnlock"));
        }
        if (ourCustomUnlocker != null) {
            return (UnlockOption)((Object)ourCustomUnlocker.fun(files));
        }
        NonProjectFileWritingAccessDialog dialog = new NonProjectFileWritingAccessDialog(this.myProject, files);
        if (!dialog.showAndGet()) {
            return null;
        }
        return dialog.getUnlockOption();
    }

    public static boolean isWriteAccessAllowedExplicitly(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "isWriteAccessAllowedExplicitly"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "isWriteAccessAllowedExplicitly"));
        }
        if (!(file2.getFileSystem() instanceof LocalFileSystem)) {
            return false;
        }
        Map<VirtualFile, AccessStatus> statuses = NonProjectFileWritingAccessProvider.getRegisteredFiles(project);
        return statuses.get(file2) == AccessStatus.ALLOWED || NonProjectFileWritingAccessProvider.isProjectFile(file2, project);
    }

    private static boolean isProjectFile(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "isProjectFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "isProjectFile"));
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        if (fileIndex.isInContent(file2)) {
            return true;
        }
        if (!Registry.is((String)"ide.hide.excluded.files") && fileIndex.isExcluded(file2) && !fileIndex.isUnderIgnored(file2)) {
            return true;
        }
        if (project instanceof ProjectEx && !project.isDefault()) {
            if (ProjectUtil.isDirectoryBased(project)) {
                VirtualFile dotIdea;
                VirtualFile baseDir = project.getBaseDir();
                VirtualFile virtualFile = dotIdea = baseDir == null ? null : baseDir.findChild(".idea");
                if (dotIdea != null && VfsUtilCore.isAncestor((VirtualFile)dotIdea, (VirtualFile)file2, (boolean)false)) {
                    return true;
                }
            }
            IProjectStore store = (IProjectStore)ServiceKt.getStateStore((ComponentManager)project);
            String filePath = file2.getPath();
            if (FileUtil.namesEqual((String)filePath, (String)store.getWorkspaceFilePath()) || FileUtil.namesEqual((String)filePath, (String)store.getProjectFilePath())) {
                return true;
            }
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                if (!FileUtil.namesEqual((String)filePath, (String)module.getModuleFilePath())) continue;
                return true;
            }
        }
        for (NonProjectFileWritingAccessExtension each : (NonProjectFileWritingAccessExtension[])Extensions.getExtensions(NonProjectFileWritingAccessExtension.EP_NAME, (AreaInstance)project)) {
            if (!each.isWritable(file2)) continue;
            return true;
        }
        return false;
    }

    public static void enableChecksInTests(@NotNull Project project, boolean enable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "enableChecksInTests"));
        }
        project.putUserData(ENABLE_IN_TESTS, (Object)(enable ? Boolean.TRUE : null));
    }

    private static boolean allAccessAllowed(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "allAccessAllowed"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && project.getUserData(ENABLE_IN_TESTS) != Boolean.TRUE) {
            return true;
        }
        return project.getUserData(ALL_ACCESS_ALLOWED) == Boolean.TRUE;
    }

    @Nullable
    public static AccessStatus getAccessStatus(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "getAccessStatus"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "getAccessStatus"));
        }
        return NonProjectFileWritingAccessProvider.allAccessAllowed(project) ? AccessStatus.ALLOWED : NonProjectFileWritingAccessProvider.getRegisteredFiles(project).get(file2);
    }

    @NotNull
    private static Map<VirtualFile, AccessStatus> getRegisteredFiles(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "getRegisteredFiles"));
        }
        Map map = (Map)ACCESS_STATUS.getValue((UserDataHolder)project);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider", "getRegisteredFiles"));
        }
        return map;
    }

    public static enum UnlockOption {
        UNLOCK,
        UNLOCK_ALL;

    }

    public static enum AccessStatus {
        REQUESTED,
        ALLOWED;

    }
}

