/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.BlockingProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.Semaphore;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class SmoothProgressAdapter
extends AbstractProgressIndicatorExBase
implements BlockingProgressIndicator,
WrappedProgressIndicator,
StandardProgressIndicator {
    private static final int SHOW_DELAY = 500;
    private final Alarm myStartupAlarm;
    private final ProgressIndicator myOriginal;
    private final Project myProject;
    private volatile boolean myOriginalStarted;
    private DialogWrapper myDialog;
    private final Runnable myShowRequest;

    public SmoothProgressAdapter(@NotNull ProgressIndicator original, @NotNull Project project) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/progress/util/SmoothProgressAdapter", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/progress/util/SmoothProgressAdapter", "<init>"));
        }
        this.myStartupAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        this.myShowRequest = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SmoothProgressAdapter smoothProgressAdapter = SmoothProgressAdapter.this;
                synchronized (smoothProgressAdapter) {
                    if (!SmoothProgressAdapter.this.isRunning()) {
                        return;
                    }
                    SmoothProgressAdapter.this.myOriginal.start();
                    SmoothProgressAdapter.this.myOriginalStarted = true;
                    SmoothProgressAdapter.this.myOriginal.setText(SmoothProgressAdapter.this.getText());
                    SmoothProgressAdapter.this.myOriginal.setFraction(SmoothProgressAdapter.this.getFraction());
                    SmoothProgressAdapter.this.myOriginal.setText2(SmoothProgressAdapter.this.getText2());
                }
            }
        };
        this.myOriginal = original;
        this.myProject = project;
        if (this.myOriginal.isModal()) {
            this.myOriginal.setModalityProgress((ProgressIndicator)this);
            this.setModalityProgress(this);
        }
        ProgressManager.assertNotCircular((ProgressIndicator)original);
    }

    @NotNull
    public ProgressIndicator getOriginalProgressIndicator() {
        ProgressIndicator progressIndicator = this.myOriginal;
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/SmoothProgressAdapter", "getOriginalProgressIndicator"));
        }
        return progressIndicator;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.myOriginal.setIndeterminate(indeterminate);
    }

    @Override
    public boolean isIndeterminate() {
        return this.myOriginal.isIndeterminate();
    }

    @Override
    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        super.start();
        this.myOriginalStarted = false;
        this.myStartupAlarm.addRequest(this.myShowRequest, 500);
    }

    @Override
    public void startBlocking() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.start();
        if (this.isModal()) {
            this.showDialog();
        }
    }

    private void showDialog() {
        if (this.myDialog == null) {
            this.myDialog = new DialogWrapper(this.myProject, false){
                {
                    this.getWindow().setBounds(0, 0, 1, 1);
                    this.setResizable(false);
                }

                protected boolean isProgressDialog() {
                    return true;
                }

                protected JComponent createCenterPanel() {
                    return null;
                }
            };
            this.myDialog.setModal(true);
            this.myDialog.setUndecorated(true);
            this.myDialog.show();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.myOriginal.isRunning()) {
            this.myOriginal.stop();
        } else {
            this.myStartupAlarm.cancelAllRequests();
            if (!this.myOriginalStarted && this.myOriginal instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)this.myOriginal));
            }
        }
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                semaphore.waitFor();
                if (SmoothProgressAdapter.this.myDialog != null) {
                    SmoothProgressAdapter.this.myDialog.close(0);
                    SmoothProgressAdapter.this.myDialog = null;
                }
            }
        });
        try {
            super.stop();
        }
        finally {
            semaphore.up();
        }
    }

    @Override
    public synchronized void setText(String text) {
        super.setText(text);
        if (this.myOriginal.isRunning()) {
            this.myOriginal.setText(text);
        }
    }

    @Override
    public synchronized void setFraction(double fraction) {
        super.setFraction(fraction);
        if (this.myOriginal.isRunning()) {
            this.myOriginal.setFraction(fraction);
        }
    }

    @Override
    public synchronized void setText2(String text) {
        super.setText2(text);
        if (this.myOriginal.isRunning()) {
            this.myOriginal.setText2(text);
        }
    }

    @Override
    public final void cancel() {
        super.cancel();
        this.myOriginal.cancel();
    }

    @Override
    public final boolean isCanceled() {
        return super.isCanceled() || this.myOriginalStarted && this.myOriginal.isCanceled();
    }
}

