/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.core.JavaCoreBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.impl.LanguageLevelProjectExtensionImpl;
import com.intellij.openapi.roots.ui.configuration.GeneralProjectSettingsElement;
import com.intellij.openapi.roots.ui.configuration.LanguageLevelCombo;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectJdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.InsertPathAction;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ProjectConfigurable
extends ProjectStructureElementConfigurable<Project>
implements DetailsComponent.Facade {
    private final Project myProject;
    private LanguageLevelCombo myLanguageLevelCombo;
    private ProjectJdkConfigurable myProjectJdkConfigurable;
    private FieldPanel myProjectCompilerOutput;
    private JTextField myProjectName;
    private JPanel myPanel;
    private final StructureConfigurableContext myContext;
    private final ModulesConfigurator myModulesConfigurator;
    private JPanel myWholePanel;
    private boolean myFreeze = false;
    private DetailsComponent myDetailsComponent;
    private final GeneralProjectSettingsElement mySettingsElement;

    public ProjectConfigurable(Project project, StructureConfigurableContext context, ModulesConfigurator configurator, ProjectSdksModel model) {
        this.myProject = project;
        this.myContext = context;
        this.myModulesConfigurator = configurator;
        this.$$$setupUI$$$();
        this.mySettingsElement = new GeneralProjectSettingsElement(context);
        final ProjectStructureDaemonAnalyzer daemonAnalyzer = context.getDaemonAnalyzer();
        this.myModulesConfigurator.addAllModuleChangeListener(new ModuleEditor.ChangeListener(){

            @Override
            public void moduleStateChanged(ModifiableRootModel moduleRootModel) {
                daemonAnalyzer.queueUpdate(ProjectConfigurable.this.mySettingsElement);
            }
        });
        this.init(model);
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.mySettingsElement;
    }

    public DetailsComponent getDetailsComponent() {
        return this.myDetailsComponent;
    }

    public JComponent createOptionsPanel() {
        this.myDetailsComponent = new DetailsComponent(!Registry.is((String)"ide.new.project.settings"), !Registry.is((String)"ide.new.project.settings"));
        this.myDetailsComponent.setContent((JComponent)this.myPanel);
        this.myDetailsComponent.setText(new String[]{this.getBannerSlogan()});
        this.myProjectJdkConfigurable.createComponent();
        return this.myDetailsComponent.getComponent();
    }

    private void init(ProjectSdksModel model) {
        this.myPanel = new JPanel(new GridBagLayout());
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)700, (int)500));
        if (ProjectUtil.isDirectoryBased(this.myProject)) {
            JPanel namePanel = new JPanel(new BorderLayout());
            JLabel label = new JLabel("<html><body><b>Project name:</b></body></html>", 2);
            namePanel.add((Component)label, "North");
            this.myProjectName = new JTextField();
            this.myProjectName.setColumns(40);
            JPanel nameFieldPanel = new JPanel();
            nameFieldPanel.setLayout(new BoxLayout(nameFieldPanel, 0));
            nameFieldPanel.add(Box.createHorizontalStrut(4));
            nameFieldPanel.add(this.myProjectName);
            namePanel.add((Component)nameFieldPanel, "Center");
            JPanel wrapper = new JPanel(new FlowLayout(0, 0, 0));
            wrapper.add(namePanel);
            wrapper.setAlignmentX(0.0f);
            this.myPanel.add((Component)wrapper, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 0, 10, 0), 0, 0));
        }
        this.myProjectJdkConfigurable = new ProjectJdkConfigurable(this.myProject, model);
        this.myPanel.add((Component)this.myProjectJdkConfigurable.createComponent(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 0, 0, 0), 0, 0));
        this.myPanel.add((Component)this.myWholePanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, new Insets(4, 0, 0, 0), 0, 0));
        this.myPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.myProjectCompilerOutput.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (ProjectConfigurable.this.myFreeze) {
                    return;
                }
                ProjectConfigurable.this.myModulesConfigurator.processModuleCompilerOutputChanged(ProjectConfigurable.this.getCompilerOutputUrl());
            }
        });
        this.myProjectJdkConfigurable.addChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectConfigurable.this.myLanguageLevelCombo.sdkUpdated(ProjectConfigurable.this.myProjectJdkConfigurable.getSelectedProjectJdk(), ProjectConfigurable.this.myProject.isDefault());
                LanguageLevelProjectExtensionImpl.getInstanceImpl(ProjectConfigurable.this.myProject).setCurrentLevel(ProjectConfigurable.this.myLanguageLevelCombo.getSelectedLevel());
            }
        });
        this.myLanguageLevelCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LanguageLevelProjectExtensionImpl.getInstanceImpl(ProjectConfigurable.this.myProject).setCurrentLevel(ProjectConfigurable.this.myLanguageLevelCombo.getSelectedLevel());
            }
        });
    }

    public void disposeUIResources() {
        if (this.myProjectJdkConfigurable != null) {
            this.myProjectJdkConfigurable.disposeUIResources();
        }
    }

    public void reset() {
        this.myFreeze = true;
        try {
            this.myProjectJdkConfigurable.reset();
            String compilerOutput = this.getOriginalCompilerOutputUrl();
            if (compilerOutput != null) {
                this.myProjectCompilerOutput.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)compilerOutput)));
            }
            this.myLanguageLevelCombo.reset(this.myProject);
            if (this.myProjectName != null) {
                this.myProjectName.setText(this.myProject.getName());
            }
        }
        finally {
            this.myFreeze = false;
        }
        this.myContext.getDaemonAnalyzer().queueUpdate(this.mySettingsElement);
    }

    public void apply() throws ConfigurationException {
        final CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)this.myProject);
        assert (compilerProjectExtension != null) : this.myProject;
        if (this.myProjectName != null && StringUtil.isEmptyOrSpaces((String)this.myProjectName.getText())) {
            throw new ConfigurationException("Please, specify project name!");
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                String canonicalPath = ProjectConfigurable.this.myProjectCompilerOutput.getText();
                if (canonicalPath != null && canonicalPath.length() > 0) {
                    try {
                        canonicalPath = FileUtil.resolveShortWindowsName((String)canonicalPath);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    canonicalPath = FileUtil.toSystemIndependentName((String)canonicalPath);
                    compilerProjectExtension.setCompilerOutputUrl(VfsUtilCore.pathToUrl((String)canonicalPath));
                } else {
                    compilerProjectExtension.setCompilerOutputPointer(null);
                }
                LanguageLevelProjectExtension extension = LanguageLevelProjectExtension.getInstance((Project)ProjectConfigurable.this.myProject);
                LanguageLevel level = ProjectConfigurable.this.myLanguageLevelCombo.getSelectedLevel();
                if (level != null) {
                    extension.setLanguageLevel(level);
                }
                extension.setDefault(Boolean.valueOf(ProjectConfigurable.this.myLanguageLevelCombo.isDefault()));
                ProjectConfigurable.this.myProjectJdkConfigurable.apply();
                if (ProjectConfigurable.this.myProjectName != null) {
                    ((ProjectEx)ProjectConfigurable.this.myProject).setProjectName(ProjectConfigurable.this.myProjectName.getText().trim());
                    if (ProjectConfigurable.this.myDetailsComponent != null) {
                        ProjectConfigurable.this.myDetailsComponent.setText(new String[]{ProjectConfigurable.this.getBannerSlogan()});
                    }
                }
            }
        });
    }

    public void setDisplayName(String name) {
    }

    public Project getEditableObject() {
        return this.myProject;
    }

    public String getBannerSlogan() {
        return ProjectBundle.message((String)"project.roots.project.banner.text", (Object[])new Object[]{this.myProject.getName()});
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"project.roots.project.display.name", (Object[])new Object[0]);
    }

    @Override
    public Icon getIcon(boolean open2) {
        return AllIcons.Nodes.Project;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure.general";
    }

    public boolean isModified() {
        LanguageLevelProjectExtension extension = LanguageLevelProjectExtension.getInstance((Project)this.myProject);
        if (extension.isDefault() != this.myLanguageLevelCombo.isDefault() || !extension.isDefault() && !extension.getLanguageLevel().equals((Object)this.myLanguageLevelCombo.getSelectedLevel())) {
            return true;
        }
        String compilerOutput = this.getOriginalCompilerOutputUrl();
        if (!Comparing.strEqual((String)FileUtil.toSystemIndependentName((String)VfsUtilCore.urlToPath((String)compilerOutput)), (String)FileUtil.toSystemIndependentName((String)this.myProjectCompilerOutput.getText()))) {
            return true;
        }
        if (this.myProjectJdkConfigurable.isModified()) {
            return true;
        }
        return this.myProjectName != null && !this.myProjectName.getText().trim().equals(this.myProject.getName());
    }

    @Nullable
    private String getOriginalCompilerOutputUrl() {
        CompilerProjectExtension extension = CompilerProjectExtension.getInstance((Project)this.myProject);
        return extension != null ? extension.getCompilerOutputUrl() : null;
    }

    private void createUIComponents() {
        this.myLanguageLevelCombo = new LanguageLevelCombo(JavaCoreBundle.message((String)"default.language.level.description", (Object[])new Object[0])){

            @Override
            protected LanguageLevel getDefaultLevel() {
                Sdk sdk = ProjectConfigurable.this.myProjectJdkConfigurable.getSelectedProjectJdk();
                if (sdk == null) {
                    return null;
                }
                JavaSdkVersion version = JavaSdk.getInstance().getVersion(sdk);
                return version == null ? null : version.getMaxLanguageLevel();
            }
        };
        JTextField textField = new JTextField();
        FileChooserDescriptor outputPathsChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        InsertPathAction.addTo((JTextComponent)textField, (FileChooserDescriptor)outputPathsChooserDescriptor);
        outputPathsChooserDescriptor.setHideIgnored(false);
        BrowseFilesListener listener = new BrowseFilesListener(textField, "", ProjectBundle.message((String)"project.compiler.output", (Object[])new Object[0]), outputPathsChooserDescriptor);
        this.myProjectCompilerOutput = new FieldPanel(textField, null, null, (ActionListener)listener, EmptyRunnable.getInstance());
        FileChooserFactory.getInstance().installFileCompletion(this.myProjectCompilerOutput.getTextField(), outputPathsChooserDescriptor, true, null);
    }

    public String getCompilerOutputUrl() {
        return VfsUtilCore.pathToUrl((String)this.myProjectCompilerOutput.getText().trim());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, 5, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.language.level"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        LanguageLevelCombo languageLevelCombo = this.myLanguageLevelCombo;
        jPanel2.add((Component)((Object)languageLevelCombo), new GridConstraints(0, 0, 1, 1, 8, 0, 7, 3, new Dimension(310, 28), null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.compiler.output"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 6, 0, null, null, null));
        FieldPanel fieldPanel = this.myProjectCompilerOutput;
        jPanel3.add((Component)fieldPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

