/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsConfigurable;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Alarm;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class UpdateCheckerComponent
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance(UpdateCheckerComponent.class);
    private static final long CHECK_INTERVAL = 86400000L;
    private final Alarm myCheckForUpdatesAlarm;
    private final Runnable myCheckRunnable;
    private final UpdateSettings mySettings;

    public UpdateCheckerComponent(@NotNull Application app, @NotNull UpdateSettings settings) {
        if (app == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "app", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent", "<init>"));
        }
        this.myCheckForUpdatesAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        this.myCheckRunnable = new Runnable(){

            @Override
            public void run() {
                UpdateChecker.updateAndShowResult().doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        UpdateCheckerComponent.this.queueNextCheck(86400000L);
                    }
                });
            }
        };
        this.mySettings = settings;
        this.updateDefaultChannel(app);
        this.checkSecureConnection(app);
        this.scheduleOnStartCheck(app);
    }

    private void updateDefaultChannel(Application app) {
        ChannelStatus current = this.mySettings.getSelectedChannelStatus();
        LOG.info("channel: " + current.getCode());
        boolean eap = ApplicationInfoEx.getInstanceEx().isEAP();
        if (eap && current != ChannelStatus.EAP && UpdateStrategyCustomization.getInstance().forceEapUpdateChannelForEapBuilds()) {
            this.mySettings.setSelectedChannelStatus(ChannelStatus.EAP);
            LOG.info("channel forced to 'eap'");
            String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
            String message = IdeBundle.message((String)"update.channel.enforced", (Object[])new Object[]{ChannelStatus.EAP});
            UpdateCheckerComponent.notify(app, UpdateChecker.NOTIFICATIONS.createNotification(title, message, NotificationType.INFORMATION, null));
        }
        if (!eap && current == ChannelStatus.EAP && Boolean.getBoolean("intellij.config.imported.in.current.session")) {
            this.mySettings.setSelectedChannelStatus(ChannelStatus.RELEASE);
            LOG.info("channel set to 'release'");
        }
    }

    private void checkSecureConnection(final Application app) {
        if (this.mySettings.isSecureConnection() && !this.mySettings.canUseSecureConnection()) {
            this.mySettings.setSecureConnection(false);
            boolean tooOld = !SystemInfo.isJavaVersionAtLeast((String)"1.7");
            String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
            String message = IdeBundle.message((String)(tooOld ? "update.sni.not.available.message" : "update.sni.disabled.message"), (Object[])new Object[0]);
            UpdateCheckerComponent.notify(app, UpdateChecker.NOTIFICATIONS.createNotification(title, message, NotificationType.WARNING, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification1, @NotNull HyperlinkEvent e) {
                    if (notification1 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification1", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent$2", "hyperlinkActivated"));
                    }
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent$2", "hyperlinkActivated"));
                    }
                    notification1.expire();
                    app.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ShowSettingsUtil.getInstance().showSettingsDialog(null, UpdateSettingsConfigurable.class);
                        }
                    }, ModalityState.NON_MODAL);
                }
            }));
        }
    }

    private void scheduleOnStartCheck(Application app) {
        if (!this.mySettings.isCheckNeeded()) {
            return;
        }
        app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

            @Override
            public void appFrameCreated(String[] commandLineArgs, @NotNull Ref<Boolean> willOpenProject) {
                if (willOpenProject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "willOpenProject", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent$3", "appFrameCreated"));
                }
                BuildNumber currentBuild = ApplicationInfo.getInstance().getBuild();
                BuildNumber lastBuildChecked = BuildNumber.fromString((String)UpdateCheckerComponent.this.mySettings.getLasBuildChecked());
                long timeToNextCheck = UpdateCheckerComponent.this.mySettings.getLastTimeChecked() + 86400000L - System.currentTimeMillis();
                if (lastBuildChecked == null || currentBuild.compareTo(lastBuildChecked) > 0 || timeToNextCheck <= 0L) {
                    UpdateCheckerComponent.this.myCheckRunnable.run();
                } else {
                    UpdateCheckerComponent.this.queueNextCheck(timeToNextCheck);
                }
            }
        });
    }

    private void queueNextCheck(long interval) {
        this.myCheckForUpdatesAlarm.addRequest(this.myCheckRunnable, interval);
    }

    private static void notify(Application app, final Notification notification) {
        app.invokeLater(new Runnable(){

            @Override
            public void run() {
                notification.notify(null);
            }
        }, ModalityState.NON_MODAL);
    }

    public void initComponent() {
        PluginsAdvertiser.ensureDeleted();
    }

    public void disposeComponent() {
        Disposer.dispose((Disposable)this.myCheckForUpdatesAlarm);
    }

    @NotNull
    public String getComponentName() {
        if ("UpdateCheckerComponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent", "getComponentName"));
        }
        return "UpdateCheckerComponent";
    }

    public void queueNextCheck() {
        this.queueNextCheck(86400000L);
    }

    public void cancelChecks() {
        this.myCheckForUpdatesAlarm.cancelAllRequests();
    }
}

